// content/services/auction_worklet/public/mojom/seller_worklet.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-test-utils.h"


namespace auction_worklet::mojom {
ComponentAuctionModifiedBidParams::ComponentAuctionModifiedBidParams()
    : ad(),
      bid(),
      bid_currency() {}

ComponentAuctionModifiedBidParams::ComponentAuctionModifiedBidParams(
    const std::string& ad_in,
    std::optional<double> bid_in,
    const std::optional<::blink::AdCurrency>& bid_currency_in)
    : ad(std::move(ad_in)),
      bid(std::move(bid_in)),
      bid_currency(std::move(bid_currency_in)) {}

ComponentAuctionModifiedBidParams::~ComponentAuctionModifiedBidParams() = default;

void ComponentAuctionModifiedBidParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad"), this->ad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid"), this->bid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_currency"), this->bid_currency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AdCurrency>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComponentAuctionModifiedBidParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ComponentAuctionReportResultParams::ComponentAuctionReportResultParams()
    : top_level_seller_signals(),
      modified_bid() {}

ComponentAuctionReportResultParams::ComponentAuctionReportResultParams(
    const std::string& top_level_seller_signals_in,
    std::optional<double> modified_bid_in)
    : top_level_seller_signals(std::move(top_level_seller_signals_in)),
      modified_bid(std::move(modified_bid_in)) {}

ComponentAuctionReportResultParams::~ComponentAuctionReportResultParams() = default;

void ComponentAuctionReportResultParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_seller_signals"), this->top_level_seller_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modified_bid"), this->modified_bid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ComponentAuctionReportResultParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScoreAdDependencyLatencies::ScoreAdDependencyLatencies()
    : code_ready_latency(),
      direct_from_seller_signals_latency(),
      trusted_scoring_signals_latency(),
      deps_wait_start_time(),
      score_ad_start_time(),
      score_ad_finish_time() {}

ScoreAdDependencyLatencies::ScoreAdDependencyLatencies(
    std::optional<::base::TimeDelta> code_ready_latency_in,
    std::optional<::base::TimeDelta> direct_from_seller_signals_latency_in,
    std::optional<::base::TimeDelta> trusted_scoring_signals_latency_in,
    ::base::TimeTicks deps_wait_start_time_in,
    ::base::TimeTicks score_ad_start_time_in,
    ::base::TimeTicks score_ad_finish_time_in)
    : code_ready_latency(std::move(code_ready_latency_in)),
      direct_from_seller_signals_latency(std::move(direct_from_seller_signals_latency_in)),
      trusted_scoring_signals_latency(std::move(trusted_scoring_signals_latency_in)),
      deps_wait_start_time(std::move(deps_wait_start_time_in)),
      score_ad_start_time(std::move(score_ad_start_time_in)),
      score_ad_finish_time(std::move(score_ad_finish_time_in)) {}

ScoreAdDependencyLatencies::~ScoreAdDependencyLatencies() = default;

void ScoreAdDependencyLatencies::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code_ready_latency"), this->code_ready_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direct_from_seller_signals_latency"), this->direct_from_seller_signals_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_scoring_signals_latency"), this->trusted_scoring_signals_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deps_wait_start_time"), this->deps_wait_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "score_ad_start_time"), this->score_ad_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "score_ad_finish_time"), this->score_ad_finish_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScoreAdDependencyLatencies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SellerTimingMetrics::SellerTimingMetrics()
    : js_fetch_latency(),
      script_latency(),
      script_timed_out() {}

SellerTimingMetrics::SellerTimingMetrics(
    std::optional<::base::TimeDelta> js_fetch_latency_in,
    ::base::TimeDelta script_latency_in,
    bool script_timed_out_in)
    : js_fetch_latency(std::move(js_fetch_latency_in)),
      script_latency(std::move(script_latency_in)),
      script_timed_out(std::move(script_timed_out_in)) {}

SellerTimingMetrics::~SellerTimingMetrics() = default;

void SellerTimingMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "js_fetch_latency"), this->js_fetch_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_latency"), this->script_latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_timed_out"), this->script_timed_out,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SellerTimingMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreativeInfoWithoutOwner::CreativeInfoWithoutOwner()
    : ad_descriptor(),
      creative_scanning_metadata() {}

CreativeInfoWithoutOwner::CreativeInfoWithoutOwner(
    const ::blink::AdDescriptor& ad_descriptor_in,
    const std::optional<std::string>& creative_scanning_metadata_in)
    : ad_descriptor(std::move(ad_descriptor_in)),
      creative_scanning_metadata(std::move(creative_scanning_metadata_in)) {}

CreativeInfoWithoutOwner::~CreativeInfoWithoutOwner() = default;

void CreativeInfoWithoutOwner::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_descriptor"), this->ad_descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AdDescriptor&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creative_scanning_metadata"), this->creative_scanning_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreativeInfoWithoutOwner::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ComponentAuctionOtherSellerPtr
ComponentAuctionOtherSeller::NewTopLevelSeller(
    const ::url::Origin& value) {
  return ComponentAuctionOtherSellerPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTopLevelSeller)>,
      std::move(value));
}

ComponentAuctionOtherSellerPtr
ComponentAuctionOtherSeller::NewComponentSeller(
    const ::url::Origin& value) {
  return ComponentAuctionOtherSellerPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kComponentSeller)>,
      std::move(value));
}

ComponentAuctionOtherSeller::ComponentAuctionOtherSeller(
    std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelSeller)>,
    const ::url::Origin& value)
    : tag_(Tag::kTopLevelSeller),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTopLevelSeller)>,
            std::move(value)) {}

ComponentAuctionOtherSeller::ComponentAuctionOtherSeller(
    std::in_place_index_t<static_cast<size_t>(Tag::kComponentSeller)>,
    const ::url::Origin& value)
    : tag_(Tag::kComponentSeller),
      data_(std::in_place_index<static_cast<size_t>(Tag::kComponentSeller)>,
            std::move(value)) {}
ComponentAuctionOtherSeller::~ComponentAuctionOtherSeller() {
  DestroyActive();
}

void ComponentAuctionOtherSeller::set_top_level_seller(const ::url::Origin& top_level_seller) {
  if (tag_ == Tag::kTopLevelSeller) {
    data_.top_level_seller = std::move(top_level_seller);
  } else {
    DestroyActive();
    tag_ = Tag::kTopLevelSeller;
    new (&data_.top_level_seller) ::url::Origin(
        std::move(top_level_seller));
  }
}

void ComponentAuctionOtherSeller::set_component_seller(const ::url::Origin& component_seller) {
  if (tag_ == Tag::kComponentSeller) {
    data_.component_seller = std::move(component_seller);
  } else {
    DestroyActive();
    tag_ = Tag::kComponentSeller;
    new (&data_.component_seller) ::url::Origin(
        std::move(component_seller));
  }
}


ComponentAuctionOtherSeller::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelSeller)>,
    const ::url::Origin& value)
    : top_level_seller(std::move(value)) {}

ComponentAuctionOtherSeller::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kComponentSeller)>,
    const ::url::Origin& value)
    : component_seller(std::move(value)) {}

void ComponentAuctionOtherSeller::DestroyActive() {
  switch (tag_) {

    case Tag::kTopLevelSeller:
      std::destroy_at(&data_.top_level_seller);
      break;
    case Tag::kComponentSeller:
      std::destroy_at(&data_.component_seller);
      break;
  }
}

bool ComponentAuctionOtherSeller::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ScoreAdClient::IPCStableHashFunction ScoreAdClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScoreAdClient>(message.name())) {
    case messages::ScoreAdClient::kOnScoreAdComplete: {
      return &ScoreAdClient::OnScoreAdComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScoreAdClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScoreAdClient>(message.name())) {
      case messages::ScoreAdClient::kOnScoreAdComplete:
            return "Receive auction_worklet::mojom::ScoreAdClient::OnScoreAdComplete";
    }
  } else {
    switch (static_cast<messages::ScoreAdClient>(message.name())) {
      case messages::ScoreAdClient::kOnScoreAdComplete:
            return "Receive reply auction_worklet::mojom::ScoreAdClient::OnScoreAdComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScoreAdClient::OnScoreAdComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe40f241f;  // IPCStableHash for auction_worklet::mojom::ScoreAdClient::OnScoreAdComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ScoreAdClientProxy::ScoreAdClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScoreAdClientProxy::OnScoreAdComplete(
    double in_score, ::auction_worklet::mojom::RejectReason in_reject_reason, ComponentAuctionModifiedBidParamsPtr in_component_auction_modified_bid_params, std::optional<double> in_bid_in_seller_currency, std::optional<uint32_t> in_scoring_signals_data_version, const std::optional<::GURL>& in_debug_loss_report_url, const std::optional<::GURL>& in_debug_win_report_url, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> in_real_time_contributions, SellerTimingMetricsPtr in_score_ad_timing_metrics, ScoreAdDependencyLatenciesPtr in_score_ad_dependency_latencies, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::ScoreAdClient::OnScoreAdComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score"), in_score,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reject_reason"), in_reject_reason,
                        "<value of type ::auction_worklet::mojom::RejectReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component_auction_modified_bid_params"), in_component_auction_modified_bid_params,
                        "<value of type ComponentAuctionModifiedBidParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid_in_seller_currency"), in_bid_in_seller_currency,
                        "<value of type std::optional<double>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scoring_signals_data_version"), in_scoring_signals_data_version,
                        "<value of type std::optional<uint32_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_loss_report_url"), in_debug_loss_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_win_report_url"), in_debug_win_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_requests"), in_pa_requests,
                        "<value of type std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("real_time_contributions"), in_real_time_contributions,
                        "<value of type std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score_ad_timing_metrics"), in_score_ad_timing_metrics,
                        "<value of type SellerTimingMetricsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score_ad_dependency_latencies"), in_score_ad_dependency_latencies,
                        "<value of type ScoreAdDependencyLatenciesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScoreAdClient::kOnScoreAdComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::ScoreAdClient_OnScoreAdComplete_Params_Data> params(
          message);
  params.Allocate();

  params->score = in_score;

  
  mojo::internal::Serialize<::auction_worklet::mojom::RejectReason>(
    in_reject_reason,
    &params->reject_reason);
  mojo::internal::MessageFragment<
      typename decltype(params->component_auction_modified_bid_params)::BaseType> component_auction_modified_bid_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView>(
    in_component_auction_modified_bid_params,
    component_auction_modified_bid_params_fragment);

  params->component_auction_modified_bid_params.Set(
      component_auction_modified_bid_params_fragment.is_null() ? nullptr : component_auction_modified_bid_params_fragment.data());
  params->bid_in_seller_currency_$flag = in_bid_in_seller_currency.has_value();
  if (in_bid_in_seller_currency.has_value()) {
    params->bid_in_seller_currency_$value = in_bid_in_seller_currency.value();
  }
  params->scoring_signals_data_version_$flag = in_scoring_signals_data_version.has_value();
  if (in_scoring_signals_data_version.has_value()) {
    params->scoring_signals_data_version_$value = in_scoring_signals_data_version.value();
  }
  mojo::internal::MessageFragment<
      typename decltype(params->debug_loss_report_url)::BaseType> debug_loss_report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_debug_loss_report_url,
    debug_loss_report_url_fragment);

  params->debug_loss_report_url.Set(
      debug_loss_report_url_fragment.is_null() ? nullptr : debug_loss_report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->debug_win_report_url)::BaseType> debug_win_report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_debug_win_report_url,
    debug_win_report_url_fragment);

  params->debug_win_report_url.Set(
      debug_win_report_url_fragment.is_null() ? nullptr : debug_win_report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->pa_requests)::BaseType>
      pa_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
    in_pa_requests,
    pa_requests_fragment,
    &pa_requests_validate_params);

  params->pa_requests.Set(
      pa_requests_fragment.is_null() ? nullptr : pa_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pa_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pa_requests in ScoreAdClient.OnScoreAdComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->real_time_contributions)::BaseType>
      real_time_contributions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& real_time_contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>>(
    in_real_time_contributions,
    real_time_contributions_fragment,
    &real_time_contributions_validate_params);

  params->real_time_contributions.Set(
      real_time_contributions_fragment.is_null() ? nullptr : real_time_contributions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->real_time_contributions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null real_time_contributions in ScoreAdClient.OnScoreAdComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->score_ad_timing_metrics)::BaseType> score_ad_timing_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::SellerTimingMetricsDataView>(
    in_score_ad_timing_metrics,
    score_ad_timing_metrics_fragment);

  params->score_ad_timing_metrics.Set(
      score_ad_timing_metrics_fragment.is_null() ? nullptr : score_ad_timing_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->score_ad_timing_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null score_ad_timing_metrics in ScoreAdClient.OnScoreAdComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->score_ad_dependency_latencies)::BaseType> score_ad_dependency_latencies_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView>(
    in_score_ad_dependency_latencies,
    score_ad_dependency_latencies_fragment);

  params->score_ad_dependency_latencies.Set(
      score_ad_dependency_latencies_fragment.is_null() ? nullptr : score_ad_dependency_latencies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->score_ad_dependency_latencies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null score_ad_dependency_latencies in ScoreAdClient.OnScoreAdComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_errors,
    errors_fragment,
    &errors_validate_params);

  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->errors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null errors in ScoreAdClient.OnScoreAdComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScoreAdClient::Name_);
  message.set_method_name("OnScoreAdComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ScoreAdClientStubDispatch::Accept(
    ScoreAdClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScoreAdClient>(message->header()->name)) {
    case messages::ScoreAdClient::kOnScoreAdComplete: {
      DCHECK(message->is_serialized());
      internal::ScoreAdClient_OnScoreAdComplete_Params_Data* params =
          reinterpret_cast<internal::ScoreAdClient_OnScoreAdComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ScoreAdClient.0
      bool success = true;
      double p_score{};
      ::auction_worklet::mojom::RejectReason p_reject_reason{};
      ComponentAuctionModifiedBidParamsPtr p_component_auction_modified_bid_params{};
      std::optional<double> p_bid_in_seller_currency{};
      std::optional<uint32_t> p_scoring_signals_data_version{};
      std::optional<::GURL> p_debug_loss_report_url{};
      std::optional<::GURL> p_debug_win_report_url{};
      std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> p_pa_requests{};
      std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> p_real_time_contributions{};
      SellerTimingMetricsPtr p_score_ad_timing_metrics{};
      ScoreAdDependencyLatenciesPtr p_score_ad_dependency_latencies{};
      std::vector<std::string> p_errors{};
      ScoreAdClient_OnScoreAdComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_score = input_data_view.score();
      if (success && !input_data_view.ReadRejectReason(&p_reject_reason))
        success = false;
      if (success && !input_data_view.ReadComponentAuctionModifiedBidParams(&p_component_auction_modified_bid_params))
        success = false;
      if (success) {
        p_bid_in_seller_currency = input_data_view.bid_in_seller_currency();
      }
      if (success) {
        p_scoring_signals_data_version = input_data_view.scoring_signals_data_version();
      }
      if (success && !input_data_view.ReadDebugLossReportUrl(&p_debug_loss_report_url))
        success = false;
      if (success && !input_data_view.ReadDebugWinReportUrl(&p_debug_win_report_url))
        success = false;
      if (success && !input_data_view.ReadPaRequests(&p_pa_requests))
        success = false;
      if (success && !input_data_view.ReadRealTimeContributions(&p_real_time_contributions))
        success = false;
      if (success && !input_data_view.ReadScoreAdTimingMetrics(&p_score_ad_timing_metrics))
        success = false;
      if (success && !input_data_view.ReadScoreAdDependencyLatencies(&p_score_ad_dependency_latencies))
        success = false;
      if (success && !input_data_view.ReadErrors(&p_errors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScoreAdClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScoreAdComplete(        
        std::move(p_score), 
        std::move(p_reject_reason), 
        std::move(p_component_auction_modified_bid_params), 
        std::move(p_bid_in_seller_currency), 
        std::move(p_scoring_signals_data_version), 
        std::move(p_debug_loss_report_url), 
        std::move(p_debug_win_report_url), 
        std::move(p_pa_requests), 
        std::move(p_real_time_contributions), 
        std::move(p_score_ad_timing_metrics), 
        std::move(p_score_ad_dependency_latencies), 
        std::move(p_errors));
      return true;
    }
  }
  return false;
}

// static
bool ScoreAdClientStubDispatch::AcceptWithResponder(
    ScoreAdClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScoreAdClient>(message->header()->name)) {
    case messages::ScoreAdClient::kOnScoreAdComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kScoreAdClientValidationInfo[] = {
    { &internal::ScoreAdClient_OnScoreAdComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool ScoreAdClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::ScoreAdClient::Name_,
    kScoreAdClientValidationInfo);
}

// The declaration includes the definition on other builds.

SellerWorklet::IPCStableHashFunction SellerWorklet::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SellerWorklet>(message.name())) {
    case messages::SellerWorklet::kScoreAd: {
      return &SellerWorklet::ScoreAd_Sym::IPCStableHash;
    }
    case messages::SellerWorklet::kSendPendingSignalsRequests: {
      return &SellerWorklet::SendPendingSignalsRequests_Sym::IPCStableHash;
    }
    case messages::SellerWorklet::kReportResult: {
      return &SellerWorklet::ReportResult_Sym::IPCStableHash;
    }
    case messages::SellerWorklet::kConnectDevToolsAgent: {
      return &SellerWorklet::ConnectDevToolsAgent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SellerWorklet::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SellerWorklet>(message.name())) {
      case messages::SellerWorklet::kScoreAd:
            return "Receive auction_worklet::mojom::SellerWorklet::ScoreAd";
      case messages::SellerWorklet::kSendPendingSignalsRequests:
            return "Receive auction_worklet::mojom::SellerWorklet::SendPendingSignalsRequests";
      case messages::SellerWorklet::kReportResult:
            return "Receive auction_worklet::mojom::SellerWorklet::ReportResult";
      case messages::SellerWorklet::kConnectDevToolsAgent:
            return "Receive auction_worklet::mojom::SellerWorklet::ConnectDevToolsAgent";
    }
  } else {
    switch (static_cast<messages::SellerWorklet>(message.name())) {
      case messages::SellerWorklet::kScoreAd:
            return "Receive reply auction_worklet::mojom::SellerWorklet::ScoreAd";
      case messages::SellerWorklet::kSendPendingSignalsRequests:
            return "Receive reply auction_worklet::mojom::SellerWorklet::SendPendingSignalsRequests";
      case messages::SellerWorklet::kReportResult:
            return "Receive reply auction_worklet::mojom::SellerWorklet::ReportResult";
      case messages::SellerWorklet::kConnectDevToolsAgent:
            return "Receive reply auction_worklet::mojom::SellerWorklet::ConnectDevToolsAgent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SellerWorklet::ScoreAd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24e1505c;  // IPCStableHash for auction_worklet::mojom::SellerWorklet::ScoreAd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SellerWorklet::SendPendingSignalsRequests_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce8744d7;  // IPCStableHash for auction_worklet::mojom::SellerWorklet::SendPendingSignalsRequests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SellerWorklet::ReportResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe85b3c0a;  // IPCStableHash for auction_worklet::mojom::SellerWorklet::ReportResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SellerWorklet::ConnectDevToolsAgent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba5c4401;  // IPCStableHash for auction_worklet::mojom::SellerWorklet::ConnectDevToolsAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SellerWorklet_ReportResult_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SellerWorklet_ReportResult_ForwardToCallback(
      SellerWorklet::ReportResultCallback callback
      ) : callback_(std::move(callback)) {
  }

  SellerWorklet_ReportResult_ForwardToCallback(const SellerWorklet_ReportResult_ForwardToCallback&) = delete;
  SellerWorklet_ReportResult_ForwardToCallback& operator=(const SellerWorklet_ReportResult_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SellerWorklet::ReportResultCallback callback_;
};

SellerWorkletProxy::SellerWorkletProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SellerWorkletProxy::ScoreAd(
    const std::string& in_ad_metadata_json, double in_bid, const std::optional<::blink::AdCurrency>& in_bid_currency, const ::blink::AuctionConfig::NonSharedParams& in_auction_ad_config_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr in_key_value_signals_cache_key, CreativeInfoWithoutOwnerPtr in_ad, std::vector<CreativeInfoWithoutOwnerPtr> in_ad_components, const std::optional<::GURL>& in_direct_from_seller_seller_signals, const std::optional<std::string>& in_direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& in_direct_from_seller_auction_signals, const std::optional<std::string>& in_direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr in_browser_signals_other_seller, const std::optional<::blink::AdCurrency>& in_component_expect_bid_currency, const ::url::Origin& in_browser_signal_interest_group_owner, const std::optional<std::string>& in_browser_signal_selected_buyer_and_seller_reporting_id, const std::optional<std::string>& in_browser_signal_buyer_and_seller_reporting_id, uint32_t in_browser_signal_bidding_duration_msecs, bool in_browser_signal_for_debugging_only_in_cooldown_or_lockout, bool in_browser_signal_for_debugging_only_sampling, std::optional<::base::TimeDelta> in_seller_timeout, uint64_t in_group_by_origin_id, bool in_allow_group_by_origin_mode, uint64_t in_trace_id, const ::url::Origin& in_bidder_joining_origin, ::mojo::PendingRemote<ScoreAdClient> in_score_ad_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::SellerWorklet::ScoreAd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_metadata_json"), in_ad_metadata_json,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid"), in_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid_currency"), in_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_ad_config_non_shared_params"), in_auction_ad_config_non_shared_params,
                        "<value of type const ::blink::AuctionConfig::NonSharedParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_value_signals_cache_key"), in_key_value_signals_cache_key,
                        "<value of type ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad"), in_ad,
                        "<value of type CreativeInfoWithoutOwnerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_components"), in_ad_components,
                        "<value of type std::vector<CreativeInfoWithoutOwnerPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_seller_signals"), in_direct_from_seller_seller_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_seller_signals_header_ad_slot"), in_direct_from_seller_seller_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals"), in_direct_from_seller_auction_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals_header_ad_slot"), in_direct_from_seller_auction_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signals_other_seller"), in_browser_signals_other_seller,
                        "<value of type ComponentAuctionOtherSellerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("component_expect_bid_currency"), in_component_expect_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_interest_group_owner"), in_browser_signal_interest_group_owner,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_selected_buyer_and_seller_reporting_id"), in_browser_signal_selected_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_buyer_and_seller_reporting_id"), in_browser_signal_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bidding_duration_msecs"), in_browser_signal_bidding_duration_msecs,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_for_debugging_only_in_cooldown_or_lockout"), in_browser_signal_for_debugging_only_in_cooldown_or_lockout,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_for_debugging_only_sampling"), in_browser_signal_for_debugging_only_sampling,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seller_timeout"), in_seller_timeout,
                        "<value of type std::optional<::base::TimeDelta>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_by_origin_id"), in_group_by_origin_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_group_by_origin_mode"), in_allow_group_by_origin_mode,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidder_joining_origin"), in_bidder_joining_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score_ad_client"), in_score_ad_client,
                        "<value of type ::mojo::PendingRemote<ScoreAdClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SellerWorklet::kScoreAd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ScoreAd_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ad_metadata_json)::BaseType> ad_metadata_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ad_metadata_json,
    ad_metadata_json_fragment);

  params->ad_metadata_json.Set(
      ad_metadata_json_fragment.is_null() ? nullptr : ad_metadata_json_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_metadata_json.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_metadata_json in SellerWorklet.ScoreAd request");

  params->bid = in_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->bid_currency)::BaseType> bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_bid_currency,
    bid_currency_fragment);

  params->bid_currency.Set(
      bid_currency_fragment.is_null() ? nullptr : bid_currency_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->auction_ad_config_non_shared_params)::BaseType> auction_ad_config_non_shared_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
    in_auction_ad_config_non_shared_params,
    auction_ad_config_non_shared_params_fragment);

  params->auction_ad_config_non_shared_params.Set(
      auction_ad_config_non_shared_params_fragment.is_null() ? nullptr : auction_ad_config_non_shared_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction_ad_config_non_shared_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction_ad_config_non_shared_params in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->key_value_signals_cache_key)::BaseType> key_value_signals_cache_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::TrustedSignalsCacheKeyDataView>(
    in_key_value_signals_cache_key,
    key_value_signals_cache_key_fragment);

  params->key_value_signals_cache_key.Set(
      key_value_signals_cache_key_fragment.is_null() ? nullptr : key_value_signals_cache_key_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->ad)::BaseType> ad_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView>(
    in_ad,
    ad_fragment);

  params->ad.Set(
      ad_fragment.is_null() ? nullptr : ad_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->ad_components)::BaseType>
      ad_components_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView>>(
    in_ad_components,
    ad_components_fragment,
    &ad_components_validate_params);

  params->ad_components.Set(
      ad_components_fragment.is_null() ? nullptr : ad_components_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_components.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_components in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_seller_signals)::BaseType> direct_from_seller_seller_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_seller_signals,
    direct_from_seller_seller_signals_fragment);

  params->direct_from_seller_seller_signals.Set(
      direct_from_seller_seller_signals_fragment.is_null() ? nullptr : direct_from_seller_seller_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_seller_signals_header_ad_slot)::BaseType> direct_from_seller_seller_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_seller_signals_header_ad_slot,
    direct_from_seller_seller_signals_header_ad_slot_fragment);

  params->direct_from_seller_seller_signals_header_ad_slot.Set(
      direct_from_seller_seller_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_seller_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals)::BaseType> direct_from_seller_auction_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_auction_signals,
    direct_from_seller_auction_signals_fragment);

  params->direct_from_seller_auction_signals.Set(
      direct_from_seller_auction_signals_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals_header_ad_slot)::BaseType> direct_from_seller_auction_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_auction_signals_header_ad_slot,
    direct_from_seller_auction_signals_header_ad_slot_fragment);

  params->direct_from_seller_auction_signals_header_ad_slot.Set(
      direct_from_seller_auction_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<decltype(params->browser_signals_other_seller)>
      browser_signals_other_seller_fragment(params.message());
  browser_signals_other_seller_fragment.Claim(&params->browser_signals_other_seller);
  
  mojo::internal::Serialize<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView>(
    in_browser_signals_other_seller,
    browser_signals_other_seller_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->component_expect_bid_currency)::BaseType> component_expect_bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_component_expect_bid_currency,
    component_expect_bid_currency_fragment);

  params->component_expect_bid_currency.Set(
      component_expect_bid_currency_fragment.is_null() ? nullptr : component_expect_bid_currency_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_interest_group_owner)::BaseType> browser_signal_interest_group_owner_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_interest_group_owner,
    browser_signal_interest_group_owner_fragment);

  params->browser_signal_interest_group_owner.Set(
      browser_signal_interest_group_owner_fragment.is_null() ? nullptr : browser_signal_interest_group_owner_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_interest_group_owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_interest_group_owner in SellerWorklet.ScoreAd request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_selected_buyer_and_seller_reporting_id)::BaseType> browser_signal_selected_buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_browser_signal_selected_buyer_and_seller_reporting_id,
    browser_signal_selected_buyer_and_seller_reporting_id_fragment);

  params->browser_signal_selected_buyer_and_seller_reporting_id.Set(
      browser_signal_selected_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : browser_signal_selected_buyer_and_seller_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_buyer_and_seller_reporting_id)::BaseType> browser_signal_buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_browser_signal_buyer_and_seller_reporting_id,
    browser_signal_buyer_and_seller_reporting_id_fragment);

  params->browser_signal_buyer_and_seller_reporting_id.Set(
      browser_signal_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : browser_signal_buyer_and_seller_reporting_id_fragment.data());

  params->browser_signal_bidding_duration_msecs = in_browser_signal_bidding_duration_msecs;

  params->browser_signal_for_debugging_only_in_cooldown_or_lockout = in_browser_signal_for_debugging_only_in_cooldown_or_lockout;

  params->browser_signal_for_debugging_only_sampling = in_browser_signal_for_debugging_only_sampling;
  mojo::internal::MessageFragment<
      typename decltype(params->seller_timeout)::BaseType> seller_timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seller_timeout,
    seller_timeout_fragment);

  params->seller_timeout.Set(
      seller_timeout_fragment.is_null() ? nullptr : seller_timeout_fragment.data());

  params->group_by_origin_id = in_group_by_origin_id;

  params->allow_group_by_origin_mode = in_allow_group_by_origin_mode;

  params->trace_id = in_trace_id;
  mojo::internal::MessageFragment<
      typename decltype(params->bidder_joining_origin)::BaseType> bidder_joining_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_bidder_joining_origin,
    bidder_joining_origin_fragment);

  params->bidder_joining_origin.Set(
      bidder_joining_origin_fragment.is_null() ? nullptr : bidder_joining_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bidder_joining_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bidder_joining_origin in SellerWorklet.ScoreAd request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::ScoreAdClientInterfaceBase>>(
    in_score_ad_client,
    &params->score_ad_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->score_ad_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid score_ad_client in SellerWorklet.ScoreAd request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ScoreAd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SellerWorkletProxy::SendPendingSignalsRequests(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send auction_worklet::mojom::SellerWorklet::SendPendingSignalsRequests");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SellerWorklet::kSendPendingSignalsRequests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_SendPendingSignalsRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("SendPendingSignalsRequests");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SellerWorkletProxy::ReportResult(
    const ::blink::AuctionConfig::NonSharedParams& in_auction_ad_config_non_shared_params, const std::optional<::GURL>& in_direct_from_seller_seller_signals, const std::optional<std::string>& in_direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& in_direct_from_seller_auction_signals, const std::optional<std::string>& in_direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr in_browser_signals_other_seller, const ::url::Origin& in_browser_signal_interest_group_owner, const std::optional<std::string>& in_browser_signal_buyer_and_seller_reporting_id, const std::optional<std::string>& in_browser_signal_selected_buyer_and_seller_reporting_id, const ::GURL& in_browser_signal_render_url, double in_browser_signal_bid, const std::optional<::blink::AdCurrency>& in_browser_signal_bid_currency, double in_browser_signal_desirability, double in_browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& in_browser_signal_highest_scoring_other_bid_currency, ComponentAuctionReportResultParamsPtr in_browser_signals_component_auction_report_result_params, std::optional<uint32_t> in_scoring_signals_data_version, uint64_t in_trace_id, ReportResultCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::SellerWorklet::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_ad_config_non_shared_params"), in_auction_ad_config_non_shared_params,
                        "<value of type const ::blink::AuctionConfig::NonSharedParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_seller_signals"), in_direct_from_seller_seller_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_seller_signals_header_ad_slot"), in_direct_from_seller_seller_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals"), in_direct_from_seller_auction_signals,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direct_from_seller_auction_signals_header_ad_slot"), in_direct_from_seller_auction_signals_header_ad_slot,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signals_other_seller"), in_browser_signals_other_seller,
                        "<value of type ComponentAuctionOtherSellerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_interest_group_owner"), in_browser_signal_interest_group_owner,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_buyer_and_seller_reporting_id"), in_browser_signal_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_selected_buyer_and_seller_reporting_id"), in_browser_signal_selected_buyer_and_seller_reporting_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_render_url"), in_browser_signal_render_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid"), in_browser_signal_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_bid_currency"), in_browser_signal_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_desirability"), in_browser_signal_desirability,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_highest_scoring_other_bid"), in_browser_signal_highest_scoring_other_bid,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_highest_scoring_other_bid_currency"), in_browser_signal_highest_scoring_other_bid_currency,
                        "<value of type const std::optional<::blink::AdCurrency>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signals_component_auction_report_result_params"), in_browser_signals_component_auction_report_result_params,
                        "<value of type ComponentAuctionReportResultParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scoring_signals_data_version"), in_scoring_signals_data_version,
                        "<value of type std::optional<uint32_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trace_id"), in_trace_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SellerWorklet::kReportResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->auction_ad_config_non_shared_params)::BaseType> auction_ad_config_non_shared_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
    in_auction_ad_config_non_shared_params,
    auction_ad_config_non_shared_params_fragment);

  params->auction_ad_config_non_shared_params.Set(
      auction_ad_config_non_shared_params_fragment.is_null() ? nullptr : auction_ad_config_non_shared_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->auction_ad_config_non_shared_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null auction_ad_config_non_shared_params in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_seller_signals)::BaseType> direct_from_seller_seller_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_seller_signals,
    direct_from_seller_seller_signals_fragment);

  params->direct_from_seller_seller_signals.Set(
      direct_from_seller_seller_signals_fragment.is_null() ? nullptr : direct_from_seller_seller_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_seller_signals_header_ad_slot)::BaseType> direct_from_seller_seller_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_seller_signals_header_ad_slot,
    direct_from_seller_seller_signals_header_ad_slot_fragment);

  params->direct_from_seller_seller_signals_header_ad_slot.Set(
      direct_from_seller_seller_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_seller_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals)::BaseType> direct_from_seller_auction_signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_direct_from_seller_auction_signals,
    direct_from_seller_auction_signals_fragment);

  params->direct_from_seller_auction_signals.Set(
      direct_from_seller_auction_signals_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->direct_from_seller_auction_signals_header_ad_slot)::BaseType> direct_from_seller_auction_signals_header_ad_slot_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_direct_from_seller_auction_signals_header_ad_slot,
    direct_from_seller_auction_signals_header_ad_slot_fragment);

  params->direct_from_seller_auction_signals_header_ad_slot.Set(
      direct_from_seller_auction_signals_header_ad_slot_fragment.is_null() ? nullptr : direct_from_seller_auction_signals_header_ad_slot_fragment.data());
  mojo::internal::MessageFragment<decltype(params->browser_signals_other_seller)>
      browser_signals_other_seller_fragment(params.message());
  browser_signals_other_seller_fragment.Claim(&params->browser_signals_other_seller);
  
  mojo::internal::Serialize<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView>(
    in_browser_signals_other_seller,
    browser_signals_other_seller_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_interest_group_owner)::BaseType> browser_signal_interest_group_owner_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_browser_signal_interest_group_owner,
    browser_signal_interest_group_owner_fragment);

  params->browser_signal_interest_group_owner.Set(
      browser_signal_interest_group_owner_fragment.is_null() ? nullptr : browser_signal_interest_group_owner_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_interest_group_owner.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_interest_group_owner in SellerWorklet.ReportResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_buyer_and_seller_reporting_id)::BaseType> browser_signal_buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_browser_signal_buyer_and_seller_reporting_id,
    browser_signal_buyer_and_seller_reporting_id_fragment);

  params->browser_signal_buyer_and_seller_reporting_id.Set(
      browser_signal_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : browser_signal_buyer_and_seller_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_selected_buyer_and_seller_reporting_id)::BaseType> browser_signal_selected_buyer_and_seller_reporting_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_browser_signal_selected_buyer_and_seller_reporting_id,
    browser_signal_selected_buyer_and_seller_reporting_id_fragment);

  params->browser_signal_selected_buyer_and_seller_reporting_id.Set(
      browser_signal_selected_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : browser_signal_selected_buyer_and_seller_reporting_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_render_url)::BaseType> browser_signal_render_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_browser_signal_render_url,
    browser_signal_render_url_fragment);

  params->browser_signal_render_url.Set(
      browser_signal_render_url_fragment.is_null() ? nullptr : browser_signal_render_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_signal_render_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_signal_render_url in SellerWorklet.ReportResult request");

  params->browser_signal_bid = in_browser_signal_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_bid_currency)::BaseType> browser_signal_bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_browser_signal_bid_currency,
    browser_signal_bid_currency_fragment);

  params->browser_signal_bid_currency.Set(
      browser_signal_bid_currency_fragment.is_null() ? nullptr : browser_signal_bid_currency_fragment.data());

  params->browser_signal_desirability = in_browser_signal_desirability;

  params->browser_signal_highest_scoring_other_bid = in_browser_signal_highest_scoring_other_bid;
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_highest_scoring_other_bid_currency)::BaseType> browser_signal_highest_scoring_other_bid_currency_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
    in_browser_signal_highest_scoring_other_bid_currency,
    browser_signal_highest_scoring_other_bid_currency_fragment);

  params->browser_signal_highest_scoring_other_bid_currency.Set(
      browser_signal_highest_scoring_other_bid_currency_fragment.is_null() ? nullptr : browser_signal_highest_scoring_other_bid_currency_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signals_component_auction_report_result_params)::BaseType> browser_signals_component_auction_report_result_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView>(
    in_browser_signals_component_auction_report_result_params,
    browser_signals_component_auction_report_result_params_fragment);

  params->browser_signals_component_auction_report_result_params.Set(
      browser_signals_component_auction_report_result_params_fragment.is_null() ? nullptr : browser_signals_component_auction_report_result_params_fragment.data());
  params->scoring_signals_data_version_$flag = in_scoring_signals_data_version.has_value();
  if (in_scoring_signals_data_version.has_value()) {
    params->scoring_signals_data_version_$value = in_scoring_signals_data_version.value();
  }

  params->trace_id = in_trace_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ReportResult");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SellerWorklet_ReportResult_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SellerWorkletProxy::ConnectDevToolsAgent(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> in_agent, uint32_t in_thread_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::SellerWorklet::ConnectDevToolsAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_index"), in_thread_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SellerWorklet::kConnectDevToolsAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ConnectDevToolsAgent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid agent in SellerWorklet.ConnectDevToolsAgent request");

  params->thread_index = in_thread_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ConnectDevToolsAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SellerWorklet_ReportResult_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SellerWorklet::ReportResultCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SellerWorklet_ReportResult_ProxyToResponder> proxy(
        new SellerWorklet_ReportResult_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SellerWorklet_ReportResult_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SellerWorklet_ReportResult_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SellerWorklet_ReportResult_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SellerWorklet::ReportResultCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_signals_for_winner, const std::optional<::GURL>& in_report_url, const base::flat_map<std::string, ::GURL>& in_ad_beacon_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, SellerTimingMetricsPtr in_time_metrics, const std::vector<std::string>& in_error_msgs);
};

bool SellerWorklet_ReportResult_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SellerWorklet_ReportResult_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SellerWorklet_ReportResult_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SellerWorklet.2
  bool success = true;
  std::optional<std::string> p_signals_for_winner{};
  std::optional<::GURL> p_report_url{};
  base::flat_map<std::string, ::GURL> p_ad_beacon_map{};
  std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> p_pa_requests{};
  SellerTimingMetricsPtr p_time_metrics{};
  std::vector<std::string> p_error_msgs{};
  SellerWorklet_ReportResult_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSignalsForWinner(&p_signals_for_winner))
    success = false;
  if (success && !input_data_view.ReadReportUrl(&p_report_url))
    success = false;
  if (success && !input_data_view.ReadAdBeaconMap(&p_ad_beacon_map))
    success = false;
  if (success && !input_data_view.ReadPaRequests(&p_pa_requests))
    success = false;
  if (success && !input_data_view.ReadTimeMetrics(&p_time_metrics))
    success = false;
  if (success && !input_data_view.ReadErrorMsgs(&p_error_msgs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SellerWorklet::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_signals_for_winner), 
std::move(p_report_url), 
std::move(p_ad_beacon_map), 
std::move(p_pa_requests), 
std::move(p_time_metrics), 
std::move(p_error_msgs));
  }
  return true;
}

void SellerWorklet_ReportResult_ProxyToResponder::Run(
    const std::optional<std::string>& in_signals_for_winner, const std::optional<::GURL>& in_report_url, const base::flat_map<std::string, ::GURL>& in_ad_beacon_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> in_pa_requests, SellerTimingMetricsPtr in_time_metrics, const std::vector<std::string>& in_error_msgs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply auction_worklet::mojom::SellerWorklet::ReportResult", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signals_for_winner"), in_signals_for_winner,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_url"), in_report_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_beacon_map"), in_ad_beacon_map,
                        "<value of type const base::flat_map<std::string, ::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_requests"), in_pa_requests,
                        "<value of type std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_metrics"), in_time_metrics,
                        "<value of type SellerTimingMetricsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_msgs"), in_error_msgs,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SellerWorklet::kReportResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::SellerWorklet_ReportResult_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->signals_for_winner)::BaseType> signals_for_winner_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_signals_for_winner,
    signals_for_winner_fragment);

  params->signals_for_winner.Set(
      signals_for_winner_fragment.is_null() ? nullptr : signals_for_winner_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->report_url)::BaseType> report_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_report_url,
    report_url_fragment);

  params->report_url.Set(
      report_url_fragment.is_null() ? nullptr : report_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->ad_beacon_map)::BaseType>
      ad_beacon_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ad_beacon_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
    in_ad_beacon_map,
    ad_beacon_map_fragment,
    &ad_beacon_map_validate_params);

  params->ad_beacon_map.Set(
      ad_beacon_map_fragment.is_null() ? nullptr : ad_beacon_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ad_beacon_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ad_beacon_map in ");
  mojo::internal::MessageFragment<
      typename decltype(params->pa_requests)::BaseType>
      pa_requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
    in_pa_requests,
    pa_requests_fragment,
    &pa_requests_validate_params);

  params->pa_requests.Set(
      pa_requests_fragment.is_null() ? nullptr : pa_requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pa_requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pa_requests in ");
  mojo::internal::MessageFragment<
      typename decltype(params->time_metrics)::BaseType> time_metrics_fragment(
          params.message());
  
  mojo::internal::Serialize<::auction_worklet::mojom::SellerTimingMetricsDataView>(
    in_time_metrics,
    time_metrics_fragment);

  params->time_metrics.Set(
      time_metrics_fragment.is_null() ? nullptr : time_metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time_metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time_metrics in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error_msgs)::BaseType>
      error_msgs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& error_msgs_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_error_msgs,
    error_msgs_fragment,
    &error_msgs_validate_params);

  params->error_msgs.Set(
      error_msgs_fragment.is_null() ? nullptr : error_msgs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_msgs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_msgs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SellerWorklet::Name_);
  message.set_method_name("ReportResult");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SellerWorkletStubDispatch::Accept(
    SellerWorklet* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SellerWorklet>(message->header()->name)) {
    case messages::SellerWorklet::kScoreAd: {
      DCHECK(message->is_serialized());
      internal::SellerWorklet_ScoreAd_Params_Data* params =
          reinterpret_cast<internal::SellerWorklet_ScoreAd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SellerWorklet.0
      bool success = true;
      std::string p_ad_metadata_json{};
      double p_bid{};
      std::optional<::blink::AdCurrency> p_bid_currency{};
      ::blink::AuctionConfig::NonSharedParams p_auction_ad_config_non_shared_params{};
      ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr p_key_value_signals_cache_key{};
      CreativeInfoWithoutOwnerPtr p_ad{};
      std::vector<CreativeInfoWithoutOwnerPtr> p_ad_components{};
      std::optional<::GURL> p_direct_from_seller_seller_signals{};
      std::optional<std::string> p_direct_from_seller_seller_signals_header_ad_slot{};
      std::optional<::GURL> p_direct_from_seller_auction_signals{};
      std::optional<std::string> p_direct_from_seller_auction_signals_header_ad_slot{};
      ComponentAuctionOtherSellerPtr p_browser_signals_other_seller{};
      std::optional<::blink::AdCurrency> p_component_expect_bid_currency{};
      ::url::Origin p_browser_signal_interest_group_owner{};
      std::optional<std::string> p_browser_signal_selected_buyer_and_seller_reporting_id{};
      std::optional<std::string> p_browser_signal_buyer_and_seller_reporting_id{};
      uint32_t p_browser_signal_bidding_duration_msecs{};
      bool p_browser_signal_for_debugging_only_in_cooldown_or_lockout{};
      bool p_browser_signal_for_debugging_only_sampling{};
      std::optional<::base::TimeDelta> p_seller_timeout{};
      uint64_t p_group_by_origin_id{};
      bool p_allow_group_by_origin_mode{};
      uint64_t p_trace_id{};
      ::url::Origin p_bidder_joining_origin{};
      ::mojo::PendingRemote<ScoreAdClient> p_score_ad_client{};
      SellerWorklet_ScoreAd_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAdMetadataJson(&p_ad_metadata_json))
        success = false;
      if (success)
        p_bid = input_data_view.bid();
      if (success && !input_data_view.ReadBidCurrency(&p_bid_currency))
        success = false;
      if (success && !input_data_view.ReadAuctionAdConfigNonSharedParams(&p_auction_ad_config_non_shared_params))
        success = false;
      if (success && !input_data_view.ReadKeyValueSignalsCacheKey(&p_key_value_signals_cache_key))
        success = false;
      if (success && !input_data_view.ReadAd(&p_ad))
        success = false;
      if (success && !input_data_view.ReadAdComponents(&p_ad_components))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSellerSignals(&p_direct_from_seller_seller_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSellerSignalsHeaderAdSlot(&p_direct_from_seller_seller_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignals(&p_direct_from_seller_auction_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignalsHeaderAdSlot(&p_direct_from_seller_auction_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalsOtherSeller(&p_browser_signals_other_seller))
        success = false;
      if (success && !input_data_view.ReadComponentExpectBidCurrency(&p_component_expect_bid_currency))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalInterestGroupOwner(&p_browser_signal_interest_group_owner))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalSelectedBuyerAndSellerReportingId(&p_browser_signal_selected_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalBuyerAndSellerReportingId(&p_browser_signal_buyer_and_seller_reporting_id))
        success = false;
      if (success)
        p_browser_signal_bidding_duration_msecs = input_data_view.browser_signal_bidding_duration_msecs();
      if (success)
        p_browser_signal_for_debugging_only_in_cooldown_or_lockout = input_data_view.browser_signal_for_debugging_only_in_cooldown_or_lockout();
      if (success)
        p_browser_signal_for_debugging_only_sampling = input_data_view.browser_signal_for_debugging_only_sampling();
      if (success && !input_data_view.ReadSellerTimeout(&p_seller_timeout))
        success = false;
      if (success)
        p_group_by_origin_id = input_data_view.group_by_origin_id();
      if (success)
        p_allow_group_by_origin_mode = input_data_view.allow_group_by_origin_mode();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (success && !input_data_view.ReadBidderJoiningOrigin(&p_bidder_joining_origin))
        success = false;
      if (success) {
        p_score_ad_client =
            input_data_view.TakeScoreAdClient<decltype(p_score_ad_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScoreAd(        
        std::move(p_ad_metadata_json), 
        std::move(p_bid), 
        std::move(p_bid_currency), 
        std::move(p_auction_ad_config_non_shared_params), 
        std::move(p_key_value_signals_cache_key), 
        std::move(p_ad), 
        std::move(p_ad_components), 
        std::move(p_direct_from_seller_seller_signals), 
        std::move(p_direct_from_seller_seller_signals_header_ad_slot), 
        std::move(p_direct_from_seller_auction_signals), 
        std::move(p_direct_from_seller_auction_signals_header_ad_slot), 
        std::move(p_browser_signals_other_seller), 
        std::move(p_component_expect_bid_currency), 
        std::move(p_browser_signal_interest_group_owner), 
        std::move(p_browser_signal_selected_buyer_and_seller_reporting_id), 
        std::move(p_browser_signal_buyer_and_seller_reporting_id), 
        std::move(p_browser_signal_bidding_duration_msecs), 
        std::move(p_browser_signal_for_debugging_only_in_cooldown_or_lockout), 
        std::move(p_browser_signal_for_debugging_only_sampling), 
        std::move(p_seller_timeout), 
        std::move(p_group_by_origin_id), 
        std::move(p_allow_group_by_origin_mode), 
        std::move(p_trace_id), 
        std::move(p_bidder_joining_origin), 
        std::move(p_score_ad_client));
      return true;
    }
    case messages::SellerWorklet::kSendPendingSignalsRequests: {
      DCHECK(message->is_serialized());
      internal::SellerWorklet_SendPendingSignalsRequests_Params_Data* params =
          reinterpret_cast<internal::SellerWorklet_SendPendingSignalsRequests_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SellerWorklet.1
      bool success = true;
      SellerWorklet_SendPendingSignalsRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendPendingSignalsRequests(        );
      return true;
    }
    case messages::SellerWorklet::kReportResult: {
      break;
    }
    case messages::SellerWorklet::kConnectDevToolsAgent: {
      DCHECK(message->is_serialized());
      internal::SellerWorklet_ConnectDevToolsAgent_Params_Data* params =
          reinterpret_cast<internal::SellerWorklet_ConnectDevToolsAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SellerWorklet.3
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> p_agent{};
      uint32_t p_thread_index{};
      SellerWorklet_ConnectDevToolsAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success)
        p_thread_index = input_data_view.thread_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectDevToolsAgent(        
        std::move(p_agent), 
        std::move(p_thread_index));
      return true;
    }
  }
  return false;
}

// static
bool SellerWorkletStubDispatch::AcceptWithResponder(
    SellerWorklet* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SellerWorklet>(message->header()->name)) {
    case messages::SellerWorklet::kScoreAd: {
      break;
    }
    case messages::SellerWorklet::kSendPendingSignalsRequests: {
      break;
    }
    case messages::SellerWorklet::kReportResult: {
      internal::SellerWorklet_ReportResult_Params_Data* params =
          reinterpret_cast<
              internal::SellerWorklet_ReportResult_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SellerWorklet.2
      bool success = true;
      ::blink::AuctionConfig::NonSharedParams p_auction_ad_config_non_shared_params{};
      std::optional<::GURL> p_direct_from_seller_seller_signals{};
      std::optional<std::string> p_direct_from_seller_seller_signals_header_ad_slot{};
      std::optional<::GURL> p_direct_from_seller_auction_signals{};
      std::optional<std::string> p_direct_from_seller_auction_signals_header_ad_slot{};
      ComponentAuctionOtherSellerPtr p_browser_signals_other_seller{};
      ::url::Origin p_browser_signal_interest_group_owner{};
      std::optional<std::string> p_browser_signal_buyer_and_seller_reporting_id{};
      std::optional<std::string> p_browser_signal_selected_buyer_and_seller_reporting_id{};
      ::GURL p_browser_signal_render_url{};
      double p_browser_signal_bid{};
      std::optional<::blink::AdCurrency> p_browser_signal_bid_currency{};
      double p_browser_signal_desirability{};
      double p_browser_signal_highest_scoring_other_bid{};
      std::optional<::blink::AdCurrency> p_browser_signal_highest_scoring_other_bid_currency{};
      ComponentAuctionReportResultParamsPtr p_browser_signals_component_auction_report_result_params{};
      std::optional<uint32_t> p_scoring_signals_data_version{};
      uint64_t p_trace_id{};
      SellerWorklet_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAuctionAdConfigNonSharedParams(&p_auction_ad_config_non_shared_params))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSellerSignals(&p_direct_from_seller_seller_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerSellerSignalsHeaderAdSlot(&p_direct_from_seller_seller_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignals(&p_direct_from_seller_auction_signals))
        success = false;
      if (success && !input_data_view.ReadDirectFromSellerAuctionSignalsHeaderAdSlot(&p_direct_from_seller_auction_signals_header_ad_slot))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalsOtherSeller(&p_browser_signals_other_seller))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalInterestGroupOwner(&p_browser_signal_interest_group_owner))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalBuyerAndSellerReportingId(&p_browser_signal_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalSelectedBuyerAndSellerReportingId(&p_browser_signal_selected_buyer_and_seller_reporting_id))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalRenderUrl(&p_browser_signal_render_url))
        success = false;
      if (success)
        p_browser_signal_bid = input_data_view.browser_signal_bid();
      if (success && !input_data_view.ReadBrowserSignalBidCurrency(&p_browser_signal_bid_currency))
        success = false;
      if (success)
        p_browser_signal_desirability = input_data_view.browser_signal_desirability();
      if (success)
        p_browser_signal_highest_scoring_other_bid = input_data_view.browser_signal_highest_scoring_other_bid();
      if (success && !input_data_view.ReadBrowserSignalHighestScoringOtherBidCurrency(&p_browser_signal_highest_scoring_other_bid_currency))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalsComponentAuctionReportResultParams(&p_browser_signals_component_auction_report_result_params))
        success = false;
      if (success) {
        p_scoring_signals_data_version = input_data_view.scoring_signals_data_version();
      }
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SellerWorklet::Name_, 2, false);
        return false;
      }
      auto callback =
          SellerWorklet_ReportResult_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(        
        std::move(p_auction_ad_config_non_shared_params), 
        std::move(p_direct_from_seller_seller_signals), 
        std::move(p_direct_from_seller_seller_signals_header_ad_slot), 
        std::move(p_direct_from_seller_auction_signals), 
        std::move(p_direct_from_seller_auction_signals_header_ad_slot), 
        std::move(p_browser_signals_other_seller), 
        std::move(p_browser_signal_interest_group_owner), 
        std::move(p_browser_signal_buyer_and_seller_reporting_id), 
        std::move(p_browser_signal_selected_buyer_and_seller_reporting_id), 
        std::move(p_browser_signal_render_url), 
        std::move(p_browser_signal_bid), 
        std::move(p_browser_signal_bid_currency), 
        std::move(p_browser_signal_desirability), 
        std::move(p_browser_signal_highest_scoring_other_bid), 
        std::move(p_browser_signal_highest_scoring_other_bid_currency), 
        std::move(p_browser_signals_component_auction_report_result_params), 
        std::move(p_scoring_signals_data_version), 
        std::move(p_trace_id), std::move(callback));
      return true;
    }
    case messages::SellerWorklet::kConnectDevToolsAgent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSellerWorkletValidationInfo[] = {
    { &internal::SellerWorklet_ScoreAd_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SellerWorklet_SendPendingSignalsRequests_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SellerWorklet_ReportResult_Params_Data::Validate,
     &internal::SellerWorklet_ReportResult_ResponseParams_Data::Validate},
    { &internal::SellerWorklet_ConnectDevToolsAgent_Params_Data::Validate,
     nullptr /* no response */},
};

bool SellerWorkletRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::SellerWorklet::Name_,
    kSellerWorkletValidationInfo);
}

bool SellerWorkletResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::auction_worklet::mojom::SellerWorklet::Name_,
    kSellerWorkletValidationInfo);
}


}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::ComponentAuctionModifiedBidParams::DataView, ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr>::Read(
    ::auction_worklet::mojom::ComponentAuctionModifiedBidParams::DataView input,
    ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsPtr result(::auction_worklet::mojom::ComponentAuctionModifiedBidParams::New());
  
      if (success && !input.ReadAd(&result->ad))
        success = false;
      if (success) {
        result->bid = input.bid();
      }
      if (success && !input.ReadBidCurrency(&result->bid_currency))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::ComponentAuctionReportResultParams::DataView, ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr>::Read(
    ::auction_worklet::mojom::ComponentAuctionReportResultParams::DataView input,
    ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::ComponentAuctionReportResultParamsPtr result(::auction_worklet::mojom::ComponentAuctionReportResultParams::New());
  
      if (success && !input.ReadTopLevelSellerSignals(&result->top_level_seller_signals))
        success = false;
      if (success) {
        result->modified_bid = input.modified_bid();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::ScoreAdDependencyLatencies::DataView, ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr>::Read(
    ::auction_worklet::mojom::ScoreAdDependencyLatencies::DataView input,
    ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::ScoreAdDependencyLatenciesPtr result(::auction_worklet::mojom::ScoreAdDependencyLatencies::New());
  
      if (success && !input.ReadCodeReadyLatency(&result->code_ready_latency))
        success = false;
      if (success && !input.ReadDirectFromSellerSignalsLatency(&result->direct_from_seller_signals_latency))
        success = false;
      if (success && !input.ReadTrustedScoringSignalsLatency(&result->trusted_scoring_signals_latency))
        success = false;
      if (success && !input.ReadDepsWaitStartTime(&result->deps_wait_start_time))
        success = false;
      if (success && !input.ReadScoreAdStartTime(&result->score_ad_start_time))
        success = false;
      if (success && !input.ReadScoreAdFinishTime(&result->score_ad_finish_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::SellerTimingMetrics::DataView, ::auction_worklet::mojom::SellerTimingMetricsPtr>::Read(
    ::auction_worklet::mojom::SellerTimingMetrics::DataView input,
    ::auction_worklet::mojom::SellerTimingMetricsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::SellerTimingMetricsPtr result(::auction_worklet::mojom::SellerTimingMetrics::New());
  
      if (success && !input.ReadJsFetchLatency(&result->js_fetch_latency))
        success = false;
      if (success && !input.ReadScriptLatency(&result->script_latency))
        success = false;
      if (success)
        result->script_timed_out = input.script_timed_out();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::CreativeInfoWithoutOwner::DataView, ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr>::Read(
    ::auction_worklet::mojom::CreativeInfoWithoutOwner::DataView input,
    ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::CreativeInfoWithoutOwnerPtr result(::auction_worklet::mojom::CreativeInfoWithoutOwner::New());
  
      if (success && !input.ReadAdDescriptor(&result->ad_descriptor))
        success = false;
      if (success && !input.ReadCreativeScanningMetadata(&result->creative_scanning_metadata))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::auction_worklet::mojom::ComponentAuctionOtherSeller::DataView, ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr>::Read(
    ::auction_worklet::mojom::ComponentAuctionOtherSeller::DataView input,
    ::auction_worklet::mojom::ComponentAuctionOtherSellerPtr* output) {
  using UnionType = ::auction_worklet::mojom::ComponentAuctionOtherSeller;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTopLevelSeller: {
      ::url::Origin result_top_level_seller{};
      if (!input.ReadTopLevelSeller(&result_top_level_seller))
        return false;

      *output = UnionType::NewTopLevelSeller(
          std::move(result_top_level_seller));
      break;
    }
    case Tag::kComponentSeller: {
      ::url::Origin result_component_seller{};
      if (!input.ReadComponentSeller(&result_component_seller))
        return false;

      *output = UnionType::NewComponentSeller(
          std::move(result_component_seller));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void ScoreAdClientInterceptorForTesting::OnScoreAdComplete(double score, ::auction_worklet::mojom::RejectReason reject_reason, ComponentAuctionModifiedBidParamsPtr component_auction_modified_bid_params, std::optional<double> bid_in_seller_currency, std::optional<uint32_t> scoring_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, SellerTimingMetricsPtr score_ad_timing_metrics, ScoreAdDependencyLatenciesPtr score_ad_dependency_latencies, const std::vector<std::string>& errors) {
  GetForwardingInterface()->OnScoreAdComplete(
    std::move(score)
    , 
    std::move(reject_reason)
    , 
    std::move(component_auction_modified_bid_params)
    , 
    std::move(bid_in_seller_currency)
    , 
    std::move(scoring_signals_data_version)
    , 
    std::move(debug_loss_report_url)
    , 
    std::move(debug_win_report_url)
    , 
    std::move(pa_requests)
    , 
    std::move(real_time_contributions)
    , 
    std::move(score_ad_timing_metrics)
    , 
    std::move(score_ad_dependency_latencies)
    , 
    std::move(errors)
    );
}
ScoreAdClientAsyncWaiter::ScoreAdClientAsyncWaiter(
    ScoreAdClient* proxy) : proxy_(proxy) {}

ScoreAdClientAsyncWaiter::~ScoreAdClientAsyncWaiter() = default;





void SellerWorkletInterceptorForTesting::ScoreAd(const std::string& ad_metadata_json, double bid, const std::optional<::blink::AdCurrency>& bid_currency, const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, CreativeInfoWithoutOwnerPtr ad, std::vector<CreativeInfoWithoutOwnerPtr> ad_components, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const std::optional<::blink::AdCurrency>& component_expect_bid_currency, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, uint32_t browser_signal_bidding_duration_msecs, bool browser_signal_for_debugging_only_in_cooldown_or_lockout, bool browser_signal_for_debugging_only_sampling, std::optional<::base::TimeDelta> seller_timeout, uint64_t group_by_origin_id, bool allow_group_by_origin_mode, uint64_t trace_id, const ::url::Origin& bidder_joining_origin, ::mojo::PendingRemote<ScoreAdClient> score_ad_client) {
  GetForwardingInterface()->ScoreAd(
    std::move(ad_metadata_json)
    , 
    std::move(bid)
    , 
    std::move(bid_currency)
    , 
    std::move(auction_ad_config_non_shared_params)
    , 
    std::move(key_value_signals_cache_key)
    , 
    std::move(ad)
    , 
    std::move(ad_components)
    , 
    std::move(direct_from_seller_seller_signals)
    , 
    std::move(direct_from_seller_seller_signals_header_ad_slot)
    , 
    std::move(direct_from_seller_auction_signals)
    , 
    std::move(direct_from_seller_auction_signals_header_ad_slot)
    , 
    std::move(browser_signals_other_seller)
    , 
    std::move(component_expect_bid_currency)
    , 
    std::move(browser_signal_interest_group_owner)
    , 
    std::move(browser_signal_selected_buyer_and_seller_reporting_id)
    , 
    std::move(browser_signal_buyer_and_seller_reporting_id)
    , 
    std::move(browser_signal_bidding_duration_msecs)
    , 
    std::move(browser_signal_for_debugging_only_in_cooldown_or_lockout)
    , 
    std::move(browser_signal_for_debugging_only_sampling)
    , 
    std::move(seller_timeout)
    , 
    std::move(group_by_origin_id)
    , 
    std::move(allow_group_by_origin_mode)
    , 
    std::move(trace_id)
    , 
    std::move(bidder_joining_origin)
    , 
    std::move(score_ad_client)
    );
}
void SellerWorkletInterceptorForTesting::SendPendingSignalsRequests() {
  GetForwardingInterface()->SendPendingSignalsRequests();
}
void SellerWorkletInterceptorForTesting::ReportResult(const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_desirability, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, ComponentAuctionReportResultParamsPtr browser_signals_component_auction_report_result_params, std::optional<uint32_t> scoring_signals_data_version, uint64_t trace_id, ReportResultCallback callback) {
  GetForwardingInterface()->ReportResult(
    std::move(auction_ad_config_non_shared_params)
    , 
    std::move(direct_from_seller_seller_signals)
    , 
    std::move(direct_from_seller_seller_signals_header_ad_slot)
    , 
    std::move(direct_from_seller_auction_signals)
    , 
    std::move(direct_from_seller_auction_signals_header_ad_slot)
    , 
    std::move(browser_signals_other_seller)
    , 
    std::move(browser_signal_interest_group_owner)
    , 
    std::move(browser_signal_buyer_and_seller_reporting_id)
    , 
    std::move(browser_signal_selected_buyer_and_seller_reporting_id)
    , 
    std::move(browser_signal_render_url)
    , 
    std::move(browser_signal_bid)
    , 
    std::move(browser_signal_bid_currency)
    , 
    std::move(browser_signal_desirability)
    , 
    std::move(browser_signal_highest_scoring_other_bid)
    , 
    std::move(browser_signal_highest_scoring_other_bid_currency)
    , 
    std::move(browser_signals_component_auction_report_result_params)
    , 
    std::move(scoring_signals_data_version)
    , 
    std::move(trace_id)
    , std::move(callback));
}
void SellerWorkletInterceptorForTesting::ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) {
  GetForwardingInterface()->ConnectDevToolsAgent(
    std::move(agent)
    , 
    std::move(thread_index)
    );
}
SellerWorkletAsyncWaiter::SellerWorkletAsyncWaiter(
    SellerWorklet* proxy) : proxy_(proxy) {}

SellerWorkletAsyncWaiter::~SellerWorkletAsyncWaiter() = default;


void SellerWorkletAsyncWaiter::ReportResult(
    const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params, const std::optional<::GURL>& direct_from_seller_seller_signals, const std::optional<std::string>& direct_from_seller_seller_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, ComponentAuctionOtherSellerPtr browser_signals_other_seller, const ::url::Origin& browser_signal_interest_group_owner, const std::optional<std::string>& browser_signal_buyer_and_seller_reporting_id, const std::optional<std::string>& browser_signal_selected_buyer_and_seller_reporting_id, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_desirability, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, ComponentAuctionReportResultParamsPtr browser_signals_component_auction_report_result_params, std::optional<uint32_t> scoring_signals_data_version, uint64_t trace_id, std::optional<std::string>* out_signals_for_winner, std::optional<::GURL>* out_report_url, base::flat_map<std::string, ::GURL>* out_ad_beacon_map, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>* out_pa_requests, SellerTimingMetricsPtr* out_time_metrics, std::vector<std::string>* out_error_msgs) {
  base::RunLoop loop;
  proxy_->ReportResult(
      std::move(auction_ad_config_non_shared_params),
      std::move(direct_from_seller_seller_signals),
      std::move(direct_from_seller_seller_signals_header_ad_slot),
      std::move(direct_from_seller_auction_signals),
      std::move(direct_from_seller_auction_signals_header_ad_slot),
      std::move(browser_signals_other_seller),
      std::move(browser_signal_interest_group_owner),
      std::move(browser_signal_buyer_and_seller_reporting_id),
      std::move(browser_signal_selected_buyer_and_seller_reporting_id),
      std::move(browser_signal_render_url),
      std::move(browser_signal_bid),
      std::move(browser_signal_bid_currency),
      std::move(browser_signal_desirability),
      std::move(browser_signal_highest_scoring_other_bid),
      std::move(browser_signal_highest_scoring_other_bid_currency),
      std::move(browser_signals_component_auction_report_result_params),
      std::move(scoring_signals_data_version),
      std::move(trace_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_signals_for_winner
,
             std::optional<::GURL>* out_report_url
,
             base::flat_map<std::string, ::GURL>* out_ad_beacon_map
,
             std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>* out_pa_requests
,
             SellerTimingMetricsPtr* out_time_metrics
,
             std::vector<std::string>* out_error_msgs
,
             const std::optional<std::string>& signals_for_winner,
             const std::optional<::GURL>& report_url,
             const base::flat_map<std::string, ::GURL>& ad_beacon_map,
             std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests,
             SellerTimingMetricsPtr time_metrics,
             const std::vector<std::string>& error_msgs) {*out_signals_for_winner = std::move(signals_for_winner);*out_report_url = std::move(report_url);*out_ad_beacon_map = std::move(ad_beacon_map);*out_pa_requests = std::move(pa_requests);*out_time_metrics = std::move(time_metrics);*out_error_msgs = std::move(error_msgs);
            loop->Quit();
          },
          &loop,
          out_signals_for_winner,
          out_report_url,
          out_ad_beacon_map,
          out_pa_requests,
          out_time_metrics,
          out_error_msgs));
  loop.Run();
}








}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif