// content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::ComponentAuctionModifiedBidParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ad(input)) in_ad = Traits::ad(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad)::BaseType> ad_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_ad,
      ad_fragment);

    fragment->ad.Set(
        ad_fragment.is_null() ? nullptr : ad_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ad.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad in ComponentAuctionModifiedBidParams struct");
    fragment->bid_$flag = Traits::bid(input).has_value();
    if (Traits::bid(input).has_value()) {
      fragment->bid_$value = Traits::bid(input).value();
    }

    decltype(Traits::bid_currency(input)) in_bid_currency = Traits::bid_currency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bid_currency)::BaseType> bid_currency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
      in_bid_currency,
      bid_currency_fragment);

    fragment->bid_currency.Set(
        bid_currency_fragment.is_null() ? nullptr : bid_currency_fragment.data());
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ComponentAuctionModifiedBidParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::ComponentAuctionReportResultParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_level_seller_signals(input)) in_top_level_seller_signals = Traits::top_level_seller_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_level_seller_signals)::BaseType> top_level_seller_signals_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_top_level_seller_signals,
      top_level_seller_signals_fragment);

    fragment->top_level_seller_signals.Set(
        top_level_seller_signals_fragment.is_null() ? nullptr : top_level_seller_signals_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_level_seller_signals.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_level_seller_signals in ComponentAuctionReportResultParams struct");
    fragment->modified_bid_$flag = Traits::modified_bid(input).has_value();
    if (Traits::modified_bid(input).has_value()) {
      fragment->modified_bid_$value = Traits::modified_bid(input).value();
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ComponentAuctionReportResultParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::ScoreAdDependencyLatencies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code_ready_latency(input)) in_code_ready_latency = Traits::code_ready_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code_ready_latency)::BaseType> code_ready_latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_code_ready_latency,
      code_ready_latency_fragment);

    fragment->code_ready_latency.Set(
        code_ready_latency_fragment.is_null() ? nullptr : code_ready_latency_fragment.data());

    decltype(Traits::direct_from_seller_signals_latency(input)) in_direct_from_seller_signals_latency = Traits::direct_from_seller_signals_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->direct_from_seller_signals_latency)::BaseType> direct_from_seller_signals_latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_direct_from_seller_signals_latency,
      direct_from_seller_signals_latency_fragment);

    fragment->direct_from_seller_signals_latency.Set(
        direct_from_seller_signals_latency_fragment.is_null() ? nullptr : direct_from_seller_signals_latency_fragment.data());

    decltype(Traits::trusted_scoring_signals_latency(input)) in_trusted_scoring_signals_latency = Traits::trusted_scoring_signals_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_scoring_signals_latency)::BaseType> trusted_scoring_signals_latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_trusted_scoring_signals_latency,
      trusted_scoring_signals_latency_fragment);

    fragment->trusted_scoring_signals_latency.Set(
        trusted_scoring_signals_latency_fragment.is_null() ? nullptr : trusted_scoring_signals_latency_fragment.data());

    decltype(Traits::deps_wait_start_time(input)) in_deps_wait_start_time = Traits::deps_wait_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deps_wait_start_time)::BaseType> deps_wait_start_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_deps_wait_start_time,
      deps_wait_start_time_fragment);

    fragment->deps_wait_start_time.Set(
        deps_wait_start_time_fragment.is_null() ? nullptr : deps_wait_start_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->deps_wait_start_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deps_wait_start_time in ScoreAdDependencyLatencies struct");

    decltype(Traits::score_ad_start_time(input)) in_score_ad_start_time = Traits::score_ad_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->score_ad_start_time)::BaseType> score_ad_start_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_score_ad_start_time,
      score_ad_start_time_fragment);

    fragment->score_ad_start_time.Set(
        score_ad_start_time_fragment.is_null() ? nullptr : score_ad_start_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->score_ad_start_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null score_ad_start_time in ScoreAdDependencyLatencies struct");

    decltype(Traits::score_ad_finish_time(input)) in_score_ad_finish_time = Traits::score_ad_finish_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->score_ad_finish_time)::BaseType> score_ad_finish_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_score_ad_finish_time,
      score_ad_finish_time_fragment);

    fragment->score_ad_finish_time.Set(
        score_ad_finish_time_fragment.is_null() ? nullptr : score_ad_finish_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->score_ad_finish_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null score_ad_finish_time in ScoreAdDependencyLatencies struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ScoreAdDependencyLatencies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::SellerTimingMetricsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::SellerTimingMetricsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::SellerTimingMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::js_fetch_latency(input)) in_js_fetch_latency = Traits::js_fetch_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->js_fetch_latency)::BaseType> js_fetch_latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_js_fetch_latency,
      js_fetch_latency_fragment);

    fragment->js_fetch_latency.Set(
        js_fetch_latency_fragment.is_null() ? nullptr : js_fetch_latency_fragment.data());

    decltype(Traits::script_latency(input)) in_script_latency = Traits::script_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_latency)::BaseType> script_latency_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_script_latency,
      script_latency_fragment);

    fragment->script_latency.Set(
        script_latency_fragment.is_null() ? nullptr : script_latency_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->script_latency.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_latency in SellerTimingMetrics struct");

    fragment->script_timed_out = Traits::script_timed_out(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::SellerTimingMetrics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::SellerTimingMetricsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::CreativeInfoWithoutOwner_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ad_descriptor(input)) in_ad_descriptor = Traits::ad_descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_descriptor)::BaseType> ad_descriptor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AdDescriptorDataView>(
      in_ad_descriptor,
      ad_descriptor_fragment);

    fragment->ad_descriptor.Set(
        ad_descriptor_fragment.is_null() ? nullptr : ad_descriptor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ad_descriptor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ad_descriptor in CreativeInfoWithoutOwner struct");

    decltype(Traits::creative_scanning_metadata(input)) in_creative_scanning_metadata = Traits::creative_scanning_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creative_scanning_metadata)::BaseType> creative_scanning_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_creative_scanning_metadata,
      creative_scanning_metadata_fragment);

    fragment->creative_scanning_metadata.Set(
        creative_scanning_metadata_fragment.is_null() ? nullptr : creative_scanning_metadata_fragment.data());
  }

  static bool Deserialize(::auction_worklet::mojom::internal::CreativeInfoWithoutOwner_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::ComponentAuctionOtherSeller_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::auction_worklet::mojom::ComponentAuctionOtherSellerDataView::Tag::kTopLevelSeller: {
    decltype(Traits::top_level_seller(input))
    in_top_level_seller = Traits::top_level_seller(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_top_level_seller)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView>(
  in_top_level_seller,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null top_level_seller in ComponentAuctionOtherSeller union");
    fragment->data.f_top_level_seller.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::auction_worklet::mojom::ComponentAuctionOtherSellerDataView::Tag::kComponentSeller: {
    decltype(Traits::component_seller(input))
    in_component_seller = Traits::component_seller(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_component_seller)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView>(
  in_component_seller,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null component_seller in ComponentAuctionOtherSeller union");
    fragment->data.f_component_seller.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ComponentAuctionOtherSeller_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ComponentAuctionOtherSellerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void ComponentAuctionModifiedBidParamsDataView::GetAdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ComponentAuctionModifiedBidParamsDataView::GetBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}


inline void ComponentAuctionReportResultParamsDataView::GetTopLevelSellerSignalsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->top_level_seller_signals.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ScoreAdDependencyLatenciesDataView::GetCodeReadyLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->code_ready_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ScoreAdDependencyLatenciesDataView::GetDirectFromSellerSignalsLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->direct_from_seller_signals_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ScoreAdDependencyLatenciesDataView::GetTrustedScoringSignalsLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->trusted_scoring_signals_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ScoreAdDependencyLatenciesDataView::GetDepsWaitStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->deps_wait_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ScoreAdDependencyLatenciesDataView::GetScoreAdStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->score_ad_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ScoreAdDependencyLatenciesDataView::GetScoreAdFinishTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->score_ad_finish_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void SellerTimingMetricsDataView::GetJsFetchLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->js_fetch_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SellerTimingMetricsDataView::GetScriptLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->script_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void CreativeInfoWithoutOwnerDataView::GetAdDescriptorDataView(
    ::blink::mojom::AdDescriptorDataView* output) {
  auto pointer = data_->ad_descriptor.Get();
  *output = ::blink::mojom::AdDescriptorDataView(pointer, message_);
}
inline void CreativeInfoWithoutOwnerDataView::GetCreativeScanningMetadataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->creative_scanning_metadata.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ComponentAuctionOtherSellerDataView::GetTopLevelSellerDataView(
    ::url::mojom::OriginDataView* output) const {
  CHECK(is_top_level_seller());
  *output = ::url::mojom::OriginDataView(data_->data.f_top_level_seller.Get(), message_);
}
inline void ComponentAuctionOtherSellerDataView::GetComponentSellerDataView(
    ::url::mojom::OriginDataView* output) const {
  CHECK(is_component_seller());
  *output = ::url::mojom::OriginDataView(data_->data.f_component_seller.Get(), message_);
}


}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_SHARED_H_