// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-test-utils.h"


namespace auction_worklet::mojom {
BucketOffset::BucketOffset()
    : value(),
      is_negative() {}

BucketOffset::BucketOffset(
    const ::absl::uint128& value_in,
    bool is_negative_in)
    : value(std::move(value_in)),
      is_negative(std::move(is_negative_in)) {}

BucketOffset::~BucketOffset() = default;

void BucketOffset::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_negative"), this->is_negative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BucketOffset::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignalBucket::SignalBucket()
    : base_value(),
      scale(1.0),
      offset() {}

SignalBucket::SignalBucket(
    BaseValue base_value_in,
    double scale_in,
    BucketOffsetPtr offset_in)
    : base_value(std::move(base_value_in)),
      scale(std::move(scale_in)),
      offset(std::move(offset_in)) {}

SignalBucket::~SignalBucket() = default;

void SignalBucket::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_value"), this->base_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BucketOffsetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignalBucket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignalValue::SignalValue()
    : base_value(),
      scale(1.0),
      offset(0) {}

SignalValue::SignalValue(
    BaseValue base_value_in,
    double scale_in,
    int32_t offset_in)
    : base_value(std::move(base_value_in)),
      scale(std::move(scale_in)),
      offset(std::move(offset_in)) {}

SignalValue::~SignalValue() = default;
size_t SignalValue::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->base_value);
  seed = mojo::internal::Hash(seed, this->scale);
  seed = mojo::internal::Hash(seed, this->offset);
  return seed;
}

void SignalValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_value"), this->base_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignalValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableReportForEventContribution::AggregatableReportForEventContribution()
    : bucket(),
      value(),
      filtering_id(),
      event_type() {}

AggregatableReportForEventContribution::AggregatableReportForEventContribution(
    ForEventSignalBucketPtr bucket_in,
    ForEventSignalValuePtr value_in,
    std::optional<uint64_t> filtering_id_in,
    EventTypePtr event_type_in)
    : bucket(std::move(bucket_in)),
      value(std::move(value_in)),
      filtering_id(std::move(filtering_id_in)),
      event_type(std::move(event_type_in)) {}

AggregatableReportForEventContribution::~AggregatableReportForEventContribution() = default;

void AggregatableReportForEventContribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket"), this->bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ForEventSignalBucketPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ForEventSignalValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id"), this->filtering_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_type"), this->event_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EventTypePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableReportForEventContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrivateAggregationRequest::PrivateAggregationRequest()
    : contribution(),
      debug_mode_details() {}

PrivateAggregationRequest::PrivateAggregationRequest(
    AggregatableReportContributionPtr contribution_in,
    ::blink::mojom::DebugModeDetailsPtr debug_mode_details_in)
    : contribution(std::move(contribution_in)),
      debug_mode_details(std::move(debug_mode_details_in)) {}

PrivateAggregationRequest::~PrivateAggregationRequest() = default;

void PrivateAggregationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contribution"), this->contribution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AggregatableReportContributionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_mode_details"), this->debug_mode_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DebugModeDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateAggregationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FinalizedPrivateAggregationRequest::FinalizedPrivateAggregationRequest()
    : contribution(),
      debug_mode_details(),
      error_event() {}

FinalizedPrivateAggregationRequest::FinalizedPrivateAggregationRequest(
    ::blink::mojom::AggregatableReportHistogramContributionPtr contribution_in,
    ::blink::mojom::DebugModeDetailsPtr debug_mode_details_in,
    std::optional<::blink::mojom::PrivateAggregationErrorEvent> error_event_in)
    : contribution(std::move(contribution_in)),
      debug_mode_details(std::move(debug_mode_details_in)),
      error_event(std::move(error_event_in)) {}

FinalizedPrivateAggregationRequest::~FinalizedPrivateAggregationRequest() = default;

void FinalizedPrivateAggregationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contribution"), this->contribution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AggregatableReportHistogramContributionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_mode_details"), this->debug_mode_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DebugModeDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_event"), this->error_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::mojom::PrivateAggregationErrorEvent>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FinalizedPrivateAggregationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ForEventSignalBucketPtr
ForEventSignalBucket::NewIdBucket(
    const ::absl::uint128& value) {
  return ForEventSignalBucketPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIdBucket)>,
      std::move(value));
}

ForEventSignalBucketPtr
ForEventSignalBucket::NewSignalBucket(
    SignalBucketPtr value) {
  return ForEventSignalBucketPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSignalBucket)>,
      std::move(value));
}

ForEventSignalBucket::ForEventSignalBucket(
    std::in_place_index_t<static_cast<size_t>(Tag::kIdBucket)>,
    const ::absl::uint128& value)
    : tag_(Tag::kIdBucket),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIdBucket)>,
            std::move(value)) {}

ForEventSignalBucket::ForEventSignalBucket(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignalBucket)>,
    SignalBucketPtr value)
    : tag_(Tag::kSignalBucket),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSignalBucket)>,
            std::move(value)) {}
ForEventSignalBucket::~ForEventSignalBucket() {
  DestroyActive();
}

void ForEventSignalBucket::set_id_bucket(const ::absl::uint128& id_bucket) {
  if (tag_ == Tag::kIdBucket) {
    data_.id_bucket = std::move(id_bucket);
  } else {
    DestroyActive();
    tag_ = Tag::kIdBucket;
    new (&data_.id_bucket) ::absl::uint128(
        std::move(id_bucket));
  }
}

void ForEventSignalBucket::set_signal_bucket(SignalBucketPtr signal_bucket) {
  if (tag_ == Tag::kSignalBucket) {
    data_.signal_bucket = std::move(signal_bucket);
  } else {
    DestroyActive();
    tag_ = Tag::kSignalBucket;
    new (&data_.signal_bucket) SignalBucketPtr(
        std::move(signal_bucket));
  }
}


ForEventSignalBucket::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIdBucket)>,
    const ::absl::uint128& value)
    : id_bucket(std::move(value)) {}

ForEventSignalBucket::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignalBucket)>,
    SignalBucketPtr value)
    : signal_bucket(std::move(value)) {}

void ForEventSignalBucket::DestroyActive() {
  switch (tag_) {

    case Tag::kIdBucket:
      std::destroy_at(&data_.id_bucket);
      break;
    case Tag::kSignalBucket:
      std::destroy_at(&data_.signal_bucket);
      break;
  }
}

bool ForEventSignalBucket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ForEventSignalValuePtr
ForEventSignalValue::NewIntValue(
    int32_t value) {
  return ForEventSignalValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
      std::move(value));
}

ForEventSignalValuePtr
ForEventSignalValue::NewSignalValue(
    SignalValuePtr value) {
  return ForEventSignalValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSignalValue)>,
      std::move(value));
}

ForEventSignalValue::ForEventSignalValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : tag_(Tag::kIntValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIntValue)>,
            std::move(value)) {}

ForEventSignalValue::ForEventSignalValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignalValue)>,
    SignalValuePtr value)
    : tag_(Tag::kSignalValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSignalValue)>,
            std::move(value)) {}
ForEventSignalValue::~ForEventSignalValue() {
  DestroyActive();
}

void ForEventSignalValue::set_int_value(int32_t int_value) {
  if (tag_ != Tag::kIntValue) {
    DestroyActive();
    tag_ = Tag::kIntValue;
  }
  data_.int_value = int_value;
}

void ForEventSignalValue::set_signal_value(SignalValuePtr signal_value) {
  if (tag_ == Tag::kSignalValue) {
    data_.signal_value = std::move(signal_value);
  } else {
    DestroyActive();
    tag_ = Tag::kSignalValue;
    new (&data_.signal_value) SignalValuePtr(
        std::move(signal_value));
  }
}


ForEventSignalValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
    int32_t value)
    : int_value(std::move(value)) {}

ForEventSignalValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignalValue)>,
    SignalValuePtr value)
    : signal_value(std::move(value)) {}

void ForEventSignalValue::DestroyActive() {
  switch (tag_) {

    case Tag::kIntValue:
      std::destroy_at(&data_.int_value);
      break;
    case Tag::kSignalValue:
      std::destroy_at(&data_.signal_value);
      break;
  }
}
size_t ForEventSignalValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kIntValue:
      return mojo::internal::Hash(seed, data_.int_value);
    case Tag::kSignalValue:
      return mojo::internal::Hash(seed, data_.signal_value);
    default:
      NOTREACHED();
  }
}

bool ForEventSignalValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
EventTypePtr
EventType::NewReservedNonError(
    ReservedNonErrorEventType value) {
  return EventTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReservedNonError)>,
      std::move(value));
}

EventTypePtr
EventType::NewReservedError(
    ReservedErrorEventType value) {
  return EventTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReservedError)>,
      std::move(value));
}

EventTypePtr
EventType::NewNonReserved(
    const std::string& value) {
  return EventTypePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNonReserved)>,
      std::move(value));
}

EventType::EventType(
    std::in_place_index_t<static_cast<size_t>(Tag::kReservedNonError)>,
    ReservedNonErrorEventType value)
    : tag_(Tag::kReservedNonError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReservedNonError)>,
            std::move(value)) {}

EventType::EventType(
    std::in_place_index_t<static_cast<size_t>(Tag::kReservedError)>,
    ReservedErrorEventType value)
    : tag_(Tag::kReservedError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReservedError)>,
            std::move(value)) {}

EventType::EventType(
    std::in_place_index_t<static_cast<size_t>(Tag::kNonReserved)>,
    const std::string& value)
    : tag_(Tag::kNonReserved),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNonReserved)>,
            std::move(value)) {}
EventType::~EventType() {
  DestroyActive();
}

void EventType::set_reserved_non_error(ReservedNonErrorEventType reserved_non_error) {
  if (tag_ != Tag::kReservedNonError) {
    DestroyActive();
    tag_ = Tag::kReservedNonError;
  }
  data_.reserved_non_error = reserved_non_error;
}

void EventType::set_reserved_error(ReservedErrorEventType reserved_error) {
  if (tag_ != Tag::kReservedError) {
    DestroyActive();
    tag_ = Tag::kReservedError;
  }
  data_.reserved_error = reserved_error;
}

void EventType::set_non_reserved(const std::string& non_reserved) {
  if (tag_ == Tag::kNonReserved) {
    data_.non_reserved = std::move(non_reserved);
  } else {
    DestroyActive();
    tag_ = Tag::kNonReserved;
    new (&data_.non_reserved) std::string(
        std::move(non_reserved));
  }
}


EventType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReservedNonError)>,
    ReservedNonErrorEventType value)
    : reserved_non_error(std::move(value)) {}

EventType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReservedError)>,
    ReservedErrorEventType value)
    : reserved_error(std::move(value)) {}

EventType::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNonReserved)>,
    const std::string& value)
    : non_reserved(std::move(value)) {}

void EventType::DestroyActive() {
  switch (tag_) {

    case Tag::kReservedNonError:
      std::destroy_at(&data_.reserved_non_error);
      break;
    case Tag::kReservedError:
      std::destroy_at(&data_.reserved_error);
      break;
    case Tag::kNonReserved:
      std::destroy_at(&data_.non_reserved);
      break;
  }
}
size_t EventType::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kReservedNonError:
      return mojo::internal::Hash(seed, data_.reserved_non_error);
    case Tag::kReservedError:
      return mojo::internal::Hash(seed, data_.reserved_error);
    case Tag::kNonReserved:
      return mojo::internal::Hash(seed, data_.non_reserved);
    default:
      NOTREACHED();
  }
}

bool EventType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AggregatableReportContributionPtr
AggregatableReportContribution::NewHistogramContribution(
    ::blink::mojom::AggregatableReportHistogramContributionPtr value) {
  return AggregatableReportContributionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHistogramContribution)>,
      std::move(value));
}

AggregatableReportContributionPtr
AggregatableReportContribution::NewForEventContribution(
    AggregatableReportForEventContributionPtr value) {
  return AggregatableReportContributionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kForEventContribution)>,
      std::move(value));
}

AggregatableReportContribution::AggregatableReportContribution(
    std::in_place_index_t<static_cast<size_t>(Tag::kHistogramContribution)>,
    ::blink::mojom::AggregatableReportHistogramContributionPtr value)
    : tag_(Tag::kHistogramContribution),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHistogramContribution)>,
            std::move(value)) {}

AggregatableReportContribution::AggregatableReportContribution(
    std::in_place_index_t<static_cast<size_t>(Tag::kForEventContribution)>,
    AggregatableReportForEventContributionPtr value)
    : tag_(Tag::kForEventContribution),
      data_(std::in_place_index<static_cast<size_t>(Tag::kForEventContribution)>,
            std::move(value)) {}
AggregatableReportContribution::~AggregatableReportContribution() {
  DestroyActive();
}

void AggregatableReportContribution::set_histogram_contribution(::blink::mojom::AggregatableReportHistogramContributionPtr histogram_contribution) {
  if (tag_ == Tag::kHistogramContribution) {
    data_.histogram_contribution = std::move(histogram_contribution);
  } else {
    DestroyActive();
    tag_ = Tag::kHistogramContribution;
    new (&data_.histogram_contribution) ::blink::mojom::AggregatableReportHistogramContributionPtr(
        std::move(histogram_contribution));
  }
}

void AggregatableReportContribution::set_for_event_contribution(AggregatableReportForEventContributionPtr for_event_contribution) {
  if (tag_ == Tag::kForEventContribution) {
    data_.for_event_contribution = std::move(for_event_contribution);
  } else {
    DestroyActive();
    tag_ = Tag::kForEventContribution;
    new (&data_.for_event_contribution) AggregatableReportForEventContributionPtr(
        std::move(for_event_contribution));
  }
}


AggregatableReportContribution::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHistogramContribution)>,
    ::blink::mojom::AggregatableReportHistogramContributionPtr value)
    : histogram_contribution(std::move(value)) {}

AggregatableReportContribution::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kForEventContribution)>,
    AggregatableReportForEventContributionPtr value)
    : for_event_contribution(std::move(value)) {}

void AggregatableReportContribution::DestroyActive() {
  switch (tag_) {

    case Tag::kHistogramContribution:
      std::destroy_at(&data_.histogram_contribution);
      break;
    case Tag::kForEventContribution:
      std::destroy_at(&data_.for_event_contribution);
      break;
  }
}

bool AggregatableReportContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::BucketOffset::DataView, ::auction_worklet::mojom::BucketOffsetPtr>::Read(
    ::auction_worklet::mojom::BucketOffset::DataView input,
    ::auction_worklet::mojom::BucketOffsetPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BucketOffsetPtr result(::auction_worklet::mojom::BucketOffset::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success)
        result->is_negative = input.is_negative();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::SignalBucket::DataView, ::auction_worklet::mojom::SignalBucketPtr>::Read(
    ::auction_worklet::mojom::SignalBucket::DataView input,
    ::auction_worklet::mojom::SignalBucketPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::SignalBucketPtr result(::auction_worklet::mojom::SignalBucket::New());
  
      if (success && !input.ReadBaseValue(&result->base_value))
        success = false;
      if (success)
        result->scale = input.scale();
      if (success && !input.ReadOffset(&result->offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::SignalValue::DataView, ::auction_worklet::mojom::SignalValuePtr>::Read(
    ::auction_worklet::mojom::SignalValue::DataView input,
    ::auction_worklet::mojom::SignalValuePtr* output) {
  bool success = true;
  ::auction_worklet::mojom::SignalValuePtr result(::auction_worklet::mojom::SignalValue::New());
  
      if (success && !input.ReadBaseValue(&result->base_value))
        success = false;
      if (success)
        result->scale = input.scale();
      if (success)
        result->offset = input.offset();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::AggregatableReportForEventContribution::DataView, ::auction_worklet::mojom::AggregatableReportForEventContributionPtr>::Read(
    ::auction_worklet::mojom::AggregatableReportForEventContribution::DataView input,
    ::auction_worklet::mojom::AggregatableReportForEventContributionPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::AggregatableReportForEventContributionPtr result(::auction_worklet::mojom::AggregatableReportForEventContribution::New());
  
      if (success && !input.ReadBucket(&result->bucket))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success) {
        result->filtering_id = input.filtering_id();
      }
      if (success && !input.ReadEventType(&result->event_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::PrivateAggregationRequest::DataView, ::auction_worklet::mojom::PrivateAggregationRequestPtr>::Read(
    ::auction_worklet::mojom::PrivateAggregationRequest::DataView input,
    ::auction_worklet::mojom::PrivateAggregationRequestPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::PrivateAggregationRequestPtr result(::auction_worklet::mojom::PrivateAggregationRequest::New());
  
      if (success && !input.ReadContribution(&result->contribution))
        success = false;
      if (success && !input.ReadDebugModeDetails(&result->debug_mode_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::FinalizedPrivateAggregationRequest::DataView, ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr>::Read(
    ::auction_worklet::mojom::FinalizedPrivateAggregationRequest::DataView input,
    ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::FinalizedPrivateAggregationRequestPtr result(::auction_worklet::mojom::FinalizedPrivateAggregationRequest::New());
  
      if (success && !input.ReadContribution(&result->contribution))
        success = false;
      if (success && !input.ReadDebugModeDetails(&result->debug_mode_details))
        success = false;
      if (success && !input.ReadErrorEvent(&result->error_event)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::auction_worklet::mojom::ForEventSignalBucket::DataView, ::auction_worklet::mojom::ForEventSignalBucketPtr>::Read(
    ::auction_worklet::mojom::ForEventSignalBucket::DataView input,
    ::auction_worklet::mojom::ForEventSignalBucketPtr* output) {
  using UnionType = ::auction_worklet::mojom::ForEventSignalBucket;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIdBucket: {
      ::absl::uint128 result_id_bucket{};
      if (!input.ReadIdBucket(&result_id_bucket))
        return false;

      *output = UnionType::NewIdBucket(
          std::move(result_id_bucket));
      break;
    }
    case Tag::kSignalBucket: {
      ::auction_worklet::mojom::SignalBucketPtr result_signal_bucket{};
      if (!input.ReadSignalBucket(&result_signal_bucket))
        return false;

      *output = UnionType::NewSignalBucket(
          std::move(result_signal_bucket));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::ForEventSignalValue::DataView, ::auction_worklet::mojom::ForEventSignalValuePtr>::Read(
    ::auction_worklet::mojom::ForEventSignalValue::DataView input,
    ::auction_worklet::mojom::ForEventSignalValuePtr* output) {
  using UnionType = ::auction_worklet::mojom::ForEventSignalValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIntValue: {
      *output = UnionType::NewIntValue(input.int_value());
      break;
    }
    case Tag::kSignalValue: {
      ::auction_worklet::mojom::SignalValuePtr result_signal_value{};
      if (!input.ReadSignalValue(&result_signal_value))
        return false;

      *output = UnionType::NewSignalValue(
          std::move(result_signal_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::EventType::DataView, ::auction_worklet::mojom::EventTypePtr>::Read(
    ::auction_worklet::mojom::EventType::DataView input,
    ::auction_worklet::mojom::EventTypePtr* output) {
  using UnionType = ::auction_worklet::mojom::EventType;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kReservedNonError: {
      ::auction_worklet::mojom::ReservedNonErrorEventType result_reserved_non_error;
      if (!input.ReadReservedNonError(&result_reserved_non_error))
        return false;

      *output = UnionType::NewReservedNonError(result_reserved_non_error);
      break;
    }
    case Tag::kReservedError: {
      ::auction_worklet::mojom::ReservedErrorEventType result_reserved_error;
      if (!input.ReadReservedError(&result_reserved_error))
        return false;

      *output = UnionType::NewReservedError(result_reserved_error);
      break;
    }
    case Tag::kNonReserved: {
      std::string result_non_reserved{};
      if (!input.ReadNonReserved(&result_non_reserved))
        return false;

      *output = UnionType::NewNonReserved(
          std::move(result_non_reserved));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::AggregatableReportContribution::DataView, ::auction_worklet::mojom::AggregatableReportContributionPtr>::Read(
    ::auction_worklet::mojom::AggregatableReportContribution::DataView input,
    ::auction_worklet::mojom::AggregatableReportContributionPtr* output) {
  using UnionType = ::auction_worklet::mojom::AggregatableReportContribution;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kHistogramContribution: {
      ::blink::mojom::AggregatableReportHistogramContributionPtr result_histogram_contribution{};
      if (!input.ReadHistogramContribution(&result_histogram_contribution))
        return false;

      *output = UnionType::NewHistogramContribution(
          std::move(result_histogram_contribution));
      break;
    }
    case Tag::kForEventContribution: {
      ::auction_worklet::mojom::AggregatableReportForEventContributionPtr result_for_event_contribution{};
      if (!input.ReadForEventContribution(&result_for_event_contribution))
        return false;

      *output = UnionType::NewForEventContribution(
          std::move(result_for_event_contribution));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {




}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif