// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_DATA_VIEW_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace auction_worklet::mojom {
class BrowserSignalsDataView;

class AuctionWorkletPermissionsPolicyStateDataView;

class TrustedSignalsPublicKeyDataView;



}  // auction_worklet::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BrowserSignalsDataView> {
  using Data = ::auction_worklet::mojom::internal::BrowserSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView> {
  using Data = ::auction_worklet::mojom::internal::AuctionWorkletPermissionsPolicyState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView> {
  using Data = ::auction_worklet::mojom::internal::TrustedSignalsPublicKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {
// Interface base classes. They are used for type safety check.
class LoadSellerWorkletClientInterfaceBase {};

using LoadSellerWorkletClientPtrDataView =
    mojo::InterfacePtrDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientRequestDataView =
    mojo::InterfaceRequestDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LoadSellerWorkletClientInterfaceBase>;
class AuctionWorkletServiceInterfaceBase {};

using AuctionWorkletServicePtrDataView =
    mojo::InterfacePtrDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceRequestDataView =
    mojo::InterfaceRequestDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AuctionWorkletServiceInterfaceBase>;


class BrowserSignalsDataView {
 public:
  BrowserSignalsDataView() = default;

  BrowserSignalsDataView(
      internal::BrowserSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::BrowserSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionWorkletPermissionsPolicyStateDataView {
 public:
  AuctionWorkletPermissionsPolicyStateDataView() = default;

  AuctionWorkletPermissionsPolicyStateDataView(
      internal::AuctionWorkletPermissionsPolicyState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool private_aggregation_allowed() const {
    return data_->private_aggregation_allowed;
  }
  bool shared_storage_allowed() const {
    return data_->shared_storage_allowed;
  }
 private:
  internal::AuctionWorkletPermissionsPolicyState_Data* data_ = nullptr;
};


class TrustedSignalsPublicKeyDataView {
 public:
  TrustedSignalsPublicKeyDataView() = default;

  TrustedSignalsPublicKeyDataView(
      internal::TrustedSignalsPublicKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint8_t id() const {
    return data_->id;
  }
 private:
  internal::TrustedSignalsPublicKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // auction_worklet::mojom

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_DATA_VIEW_H_