// content/public/common/resource_usage_reporter.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ResourceUsageReporterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.ResourceUsageReporter', scope);
  }
}

/** @interface */
export class ResourceUsageReporterInterface {
  
  /**
   * @return {!Promise<{
        data: !ResourceUsageData,
   *  }>}
   */

  getUsageData() {}
}

/**
 * @implements { ResourceUsageReporterInterface }
 */
export class ResourceUsageReporterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ResourceUsageReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ResourceUsageReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ResourceUsageReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        data: !ResourceUsageData,
   *  }>}
   */

  getUsageData() {
    return this.proxy.sendMessage(
        0,
        ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ResourceUsageReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ResourceUsageReporterReceiver {
  /**
   * @param {!ResourceUsageReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ResourceUsageReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ResourceUsageReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResourceUsageReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        impl.getUsageData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ResourceUsageReporter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.ResourceUsageReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ResourceUsageReporterRemote}
   */
  static getRemote() {
    let remote = new ResourceUsageReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ResourceUsageReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ResourceUsageReporterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ResourceUsageReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResourceUsageReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUsageData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        this.getUsageData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceTypeStatSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceTypeStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceUsageDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceUsageReporter_GetUsageData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceUsageReporter_GetUsageData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ResourceTypeStatSpec.$,
    'ResourceTypeStat',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'liveSize', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decodedSize', 24,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ResourceTypeStat {
  constructor() {
    /** @type { !bigint } */
    this.count;
    /** @type { !bigint } */
    this.size;
    /** @type { !bigint } */
    this.liveSize;
    /** @type { !bigint } */
    this.decodedSize;
  }
}



mojo.internal.Struct(
    ResourceTypeStatsSpec.$,
    'ResourceTypeStats',
    [
      mojo.internal.StructField(
        'images', 0,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cssStyleSheets', 8,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scripts', 16,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'xslStyleSheets', 24,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fonts', 32,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'other', 40,
        0,
        ResourceTypeStatSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ResourceTypeStats {
  constructor() {
    /** @type { !ResourceTypeStat } */
    this.images;
    /** @type { !ResourceTypeStat } */
    this.cssStyleSheets;
    /** @type { !ResourceTypeStat } */
    this.scripts;
    /** @type { !ResourceTypeStat } */
    this.xslStyleSheets;
    /** @type { !ResourceTypeStat } */
    this.fonts;
    /** @type { !ResourceTypeStat } */
    this.other;
  }
}



mojo.internal.Struct(
    ResourceUsageDataSpec.$,
    'ResourceUsageData',
    [
      mojo.internal.StructField(
        'reportsV8Stats', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'v8BytesAllocated', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'v8BytesUsed', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'webCacheStats', 24,
        0,
        ResourceTypeStatsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ResourceUsageData {
  constructor() {
    /** @type { !boolean } */
    this.reportsV8Stats;
    /** @type { !bigint } */
    this.v8BytesAllocated;
    /** @type { !bigint } */
    this.v8BytesUsed;
    /** @type { (ResourceTypeStats|undefined) } */
    this.webCacheStats;
  }
}



mojo.internal.Struct(
    ResourceUsageReporter_GetUsageData_ParamsSpec.$,
    'ResourceUsageReporter_GetUsageData_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ResourceUsageReporter_GetUsageData_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
    'ResourceUsageReporter_GetUsageData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        ResourceUsageDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResourceUsageReporter_GetUsageData_ResponseParams {
  constructor() {
    /** @type { !ResourceUsageData } */
    this.data;
  }
}

