// content/common/sandbox_support.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/sandbox_support.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/sandbox_support.mojom-params-data.h"
#include "content/common/sandbox_support.mojom-shared-message-ids.h"

#include "content/common/sandbox_support.mojom-import-headers.h"
#include "content/common/sandbox_support.mojom-test-utils.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

SandboxSupport::IPCStableHashFunction SandboxSupport::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SandboxSupport>(message.name())) {
    case messages::SandboxSupport::kGetSystemColors: {
      return &SandboxSupport::GetSystemColors_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SandboxSupport::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SandboxSupport>(message.name())) {
      case messages::SandboxSupport::kGetSystemColors:
            return "Receive content::mojom::SandboxSupport::GetSystemColors";
    }
  } else {
    switch (static_cast<messages::SandboxSupport>(message.name())) {
      case messages::SandboxSupport::kGetSystemColors:
            return "Receive reply content::mojom::SandboxSupport::GetSystemColors";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SandboxSupport::GetSystemColors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xddd24d7a;  // IPCStableHash for content::mojom::SandboxSupport::GetSystemColors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SandboxSupport_GetSystemColors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SandboxSupport_GetSystemColors_ForwardToCallback(
      SandboxSupport::GetSystemColorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SandboxSupport_GetSystemColors_ForwardToCallback(const SandboxSupport_GetSystemColors_ForwardToCallback&) = delete;
  SandboxSupport_GetSystemColors_ForwardToCallback& operator=(const SandboxSupport_GetSystemColors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SandboxSupport::GetSystemColorsCallback callback_;
};

SandboxSupportProxy::SandboxSupportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SandboxSupportProxy::GetSystemColors(
    GetSystemColorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::SandboxSupport::GetSystemColors");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SandboxSupport::kGetSystemColors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::SandboxSupport_GetSystemColors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SandboxSupport::Name_);
  message.set_method_name("GetSystemColors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SandboxSupport_GetSystemColors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SandboxSupport_GetSystemColors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SandboxSupport::GetSystemColorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SandboxSupport_GetSystemColors_ProxyToResponder> proxy(
        new SandboxSupport_GetSystemColors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SandboxSupport_GetSystemColors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SandboxSupport_GetSystemColors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SandboxSupport_GetSystemColors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SandboxSupport::GetSystemColorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_region);
};

bool SandboxSupport_GetSystemColors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SandboxSupport_GetSystemColors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SandboxSupport_GetSystemColors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SandboxSupport.0
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_region{};
  SandboxSupport_GetSystemColors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRegion(&p_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SandboxSupport::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_region));
  }
  return true;
}

void SandboxSupport_GetSystemColors_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply content::mojom::SandboxSupport::GetSystemColors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SandboxSupport::kGetSystemColors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::SandboxSupport_GetSystemColors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SandboxSupport::Name_);
  message.set_method_name("GetSystemColors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SandboxSupportStubDispatch::Accept(
    SandboxSupport* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SandboxSupport>(message->header()->name)) {
    case messages::SandboxSupport::kGetSystemColors: {
      break;
    }
  }
  return false;
}

// static
bool SandboxSupportStubDispatch::AcceptWithResponder(
    SandboxSupport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SandboxSupport>(message->header()->name)) {
    case messages::SandboxSupport::kGetSystemColors: {
      internal::SandboxSupport_GetSystemColors_Params_Data* params =
          reinterpret_cast<
              internal::SandboxSupport_GetSystemColors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SandboxSupport.0
      bool success = true;
      SandboxSupport_GetSystemColors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SandboxSupport::Name_, 0, false);
        return false;
      }
      auto callback =
          SandboxSupport_GetSystemColors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSystemColors(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSandboxSupportValidationInfo[] = {
    { &internal::SandboxSupport_GetSystemColors_Params_Data::Validate,
     &internal::SandboxSupport_GetSystemColors_ResponseParams_Data::Validate},
};

bool SandboxSupportRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::SandboxSupport::Name_,
    kSandboxSupportValidationInfo);
}

bool SandboxSupportResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::content::mojom::SandboxSupport::Name_,
    kSandboxSupportValidationInfo);
}


}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void SandboxSupportInterceptorForTesting::GetSystemColors(GetSystemColorsCallback callback) {
  GetForwardingInterface()->GetSystemColors(std::move(callback));
}
SandboxSupportAsyncWaiter::SandboxSupportAsyncWaiter(
    SandboxSupport* proxy) : proxy_(proxy) {}

SandboxSupportAsyncWaiter::~SandboxSupportAsyncWaiter() = default;


void SandboxSupportAsyncWaiter::GetSystemColors(
    ::base::ReadOnlySharedMemoryRegion* out_region) {
  base::RunLoop loop;
  proxy_->GetSystemColors(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_region
,
             ::base::ReadOnlySharedMemoryRegion region) {*out_region = std::move(region);
            loop->Quit();
          },
          &loop,
          out_region));
  loop.Run();
}

::base::ReadOnlySharedMemoryRegion SandboxSupportAsyncWaiter::GetSystemColors(
    ) {
  ::base::ReadOnlySharedMemoryRegion async_wait_result;
  GetSystemColors(&async_wait_result);
  return async_wait_result;
}






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif