// content/common/renderer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_SEND_VALIDATION_H_
#define CONTENT_COMMON_RENDERER_MOJOM_SEND_VALIDATION_H_

#include "content/common/renderer.mojom-shared-internal.h"
#include "content/common/agent_scheduling_group.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "ipc/ipc.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h"
#include "mojo/public/mojom/base/process_priority.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "content/common/renderer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::RenderProcessVisibleState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::UpdateScrollbarThemeParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateScrollbarThemeParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::UpdateScrollbarThemeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_initial_button_delay = Traits::has_initial_button_delay(input);

      fragment->initial_button_delay = Traits::initial_button_delay(input);

      fragment->has_autoscroll_button_delay = Traits::has_autoscroll_button_delay(input);

      fragment->autoscroll_button_delay = Traits::autoscroll_button_delay(input);

      fragment->jump_on_track_click = Traits::jump_on_track_click(input);

      
      mojo::internal::Serialize<::content::mojom::ScrollerStyle>(
        Traits::preferred_scroller_style(input),
        &fragment->preferred_scroller_style);

      fragment->redraw = Traits::redraw(input);

      fragment->scroll_view_rubber_banding = Traits::scroll_view_rubber_banding(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::UpdateSystemColorInfoParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateSystemColorInfoParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::UpdateSystemColorInfoParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
      fragment->accent_color_$flag = Traits::accent_color(input).has_value();
      if (Traits::accent_color(input).has_value()) {
        fragment->accent_color_$value = Traits::accent_color(input).value();
      }
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_COMMON_RENDERER_MOJOM_SEND_VALIDATION_H_