// content/common/input/input_injector.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SEND_VALIDATION_H_
#define CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SEND_VALIDATION_H_

#include "content/common/input/input_injector.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "content/common/input/input_injector.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::GestureSourceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::PointerActionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::SyntheticButton, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::content::mojom::InputEventPattern, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticSmoothDragDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticSmoothDragDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticSmoothDrag_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::content::mojom::GestureSourceType>(
        Traits::gesture_source_type(input),
        &fragment->gesture_source_type);

      decltype(Traits::start_point(input)) in_start_point = Traits::start_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_point)::BaseType> start_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_start_point,
        start_point_fragment);

      fragment->start_point.Set(
          start_point_fragment.is_null() ? nullptr : start_point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_point in SyntheticSmoothDrag struct");

      decltype(Traits::distances(input)) in_distances = Traits::distances(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->distances)::BaseType>
          distances_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& distances_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>, send_validation>(
        in_distances,
        distances_fragment,
        &distances_validate_params);

      fragment->distances.Set(
          distances_fragment.is_null() ? nullptr : distances_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->distances.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null distances in SyntheticSmoothDrag struct");

      fragment->speed_in_pixels_s = Traits::speed_in_pixels_s(input);

      fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

      
      mojo::internal::Serialize<::content::mojom::InputEventPattern>(
        Traits::input_event_pattern(input),
        &fragment->input_event_pattern);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticSmoothScrollDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticSmoothScrollDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticSmoothScroll_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::content::mojom::GestureSourceType>(
        Traits::gesture_source_type(input),
        &fragment->gesture_source_type);

      decltype(Traits::anchor(input)) in_anchor = Traits::anchor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->anchor)::BaseType> anchor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_anchor,
        anchor_fragment);

      fragment->anchor.Set(
          anchor_fragment.is_null() ? nullptr : anchor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->anchor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null anchor in SyntheticSmoothScroll struct");

      decltype(Traits::distances(input)) in_distances = Traits::distances(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->distances)::BaseType>
          distances_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& distances_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>, send_validation>(
        in_distances,
        distances_fragment,
        &distances_validate_params);

      fragment->distances.Set(
          distances_fragment.is_null() ? nullptr : distances_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->distances.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null distances in SyntheticSmoothScroll struct");

      fragment->prevent_fling = Traits::prevent_fling(input);

      fragment->speed_in_pixels_s = Traits::speed_in_pixels_s(input);

      fragment->fling_velocity_x = Traits::fling_velocity_x(input);

      fragment->fling_velocity_y = Traits::fling_velocity_y(input);

      
      mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
        Traits::granularity(input),
        &fragment->granularity);

      fragment->modifiers = Traits::modifiers(input);

      fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

      
      mojo::internal::Serialize<::content::mojom::InputEventPattern>(
        Traits::input_event_pattern(input),
        &fragment->input_event_pattern);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticPinchDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPinchDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPinch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->scale_factor = Traits::scale_factor(input);

      decltype(Traits::anchor(input)) in_anchor = Traits::anchor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->anchor)::BaseType> anchor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_anchor,
        anchor_fragment);

      fragment->anchor.Set(
          anchor_fragment.is_null() ? nullptr : anchor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->anchor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null anchor in SyntheticPinch struct");

      fragment->relative_pointer_speed_in_pixels_s = Traits::relative_pointer_speed_in_pixels_s(input);

      fragment->vsync_offset_ms = Traits::vsync_offset_ms(input);

      
      mojo::internal::Serialize<::content::mojom::InputEventPattern>(
        Traits::input_event_pattern(input),
        &fragment->input_event_pattern);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticTapDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticTapDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticTap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::content::mojom::GestureSourceType>(
        Traits::gesture_source_type(input),
        &fragment->gesture_source_type);

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in SyntheticTap struct");

      fragment->duration_ms = Traits::duration_ms(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticPointerActionParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPointerActionParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPointerActionParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::content::mojom::PointerActionType>(
        Traits::pointer_action_type(input),
        &fragment->pointer_action_type);

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in SyntheticPointerActionParams struct");

      fragment->pointer_id = Traits::pointer_id(input);

      
      mojo::internal::Serialize<::content::mojom::SyntheticButton>(
        Traits::button(input),
        &fragment->button);

      fragment->key_modifiers = Traits::key_modifiers(input);

      fragment->width = Traits::width(input);

      fragment->height = Traits::height(input);

      fragment->rotation_angle = Traits::rotation_angle(input);

      fragment->force = Traits::force(input);

      fragment->tangential_pressure = Traits::tangential_pressure(input);

      fragment->tilt_x = Traits::tilt_x(input);

      fragment->tilt_y = Traits::tilt_y(input);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in SyntheticPointerActionParams struct");

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in SyntheticPointerActionParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::content::mojom::SyntheticPointerActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SyntheticPointerActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SyntheticPointerAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::content::mojom::GestureSourceType>(
        Traits::gesture_source_type(input),
        &fragment->gesture_source_type);

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType>
          params_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::content::mojom::SyntheticPointerActionParamsDataView>>, send_validation>(
        in_params,
        params_fragment,
        &params_validate_params);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in SyntheticPointerAction struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_SEND_VALIDATION_H_