// content/common/field_trial_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/field_trial_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/field_trial_recorder.mojom-params-data.h"
#include "content/common/field_trial_recorder.mojom-shared-message-ids.h"

#include "content/common/field_trial_recorder.mojom-import-headers.h"
#include "content/common/field_trial_recorder.mojom-test-utils.h"


namespace content::mojom {
// The declaration includes the definition on other builds.

FieldTrialRecorder::IPCStableHashFunction FieldTrialRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FieldTrialRecorder>(message.name())) {
    case messages::FieldTrialRecorder::kFieldTrialActivated: {
      return &FieldTrialRecorder::FieldTrialActivated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FieldTrialRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FieldTrialRecorder>(message.name())) {
      case messages::FieldTrialRecorder::kFieldTrialActivated:
            return "Receive content::mojom::FieldTrialRecorder::FieldTrialActivated";
    }
  } else {
    switch (static_cast<messages::FieldTrialRecorder>(message.name())) {
      case messages::FieldTrialRecorder::kFieldTrialActivated:
            return "Receive reply content::mojom::FieldTrialRecorder::FieldTrialActivated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FieldTrialRecorder::FieldTrialActivated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b8903b7;  // IPCStableHash for content::mojom::FieldTrialRecorder::FieldTrialActivated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FieldTrialRecorderProxy::FieldTrialRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FieldTrialRecorderProxy::FieldTrialActivated(
    const std::string& in_trial_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::FieldTrialRecorder::FieldTrialActivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trial_name"), in_trial_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FieldTrialRecorder::kFieldTrialActivated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::FieldTrialRecorder_FieldTrialActivated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trial_name)::BaseType> trial_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_trial_name,
    trial_name_fragment);

  params->trial_name.Set(
      trial_name_fragment.is_null() ? nullptr : trial_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->trial_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null trial_name in FieldTrialRecorder.FieldTrialActivated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FieldTrialRecorder::Name_);
  message.set_method_name("FieldTrialActivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FieldTrialRecorderStubDispatch::Accept(
    FieldTrialRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FieldTrialRecorder>(message->header()->name)) {
    case messages::FieldTrialRecorder::kFieldTrialActivated: {
      DCHECK(message->is_serialized());
      internal::FieldTrialRecorder_FieldTrialActivated_Params_Data* params =
          reinterpret_cast<internal::FieldTrialRecorder_FieldTrialActivated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FieldTrialRecorder.0
      bool success = true;
      std::string p_trial_name{};
      FieldTrialRecorder_FieldTrialActivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTrialName(&p_trial_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FieldTrialRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FieldTrialActivated(        
        std::move(p_trial_name));
      return true;
    }
  }
  return false;
}

// static
bool FieldTrialRecorderStubDispatch::AcceptWithResponder(
    FieldTrialRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FieldTrialRecorder>(message->header()->name)) {
    case messages::FieldTrialRecorder::kFieldTrialActivated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFieldTrialRecorderValidationInfo[] = {
    { &internal::FieldTrialRecorder_FieldTrialActivated_Params_Data::Validate,
     nullptr /* no response */},
};

bool FieldTrialRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::content::mojom::FieldTrialRecorder::Name_,
    kFieldTrialRecorderValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void FieldTrialRecorderInterceptorForTesting::FieldTrialActivated(const std::string& trial_name) {
  GetForwardingInterface()->FieldTrialActivated(
    std::move(trial_name)
    );
}
FieldTrialRecorderAsyncWaiter::FieldTrialRecorderAsyncWaiter(
    FieldTrialRecorder* proxy) : proxy_(proxy) {}

FieldTrialRecorderAsyncWaiter::~FieldTrialRecorderAsyncWaiter() = default;







}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif