// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import{generateStatsLabel}from"./stats_helper.js";export class StatsTable{constructor(){}addStatsReport(peerConnectionElement,report){const statsTable=this.ensureStatsTable_(peerConnectionElement,report);statsTable.parentElement.firstElementChild.innerText=generateStatsLabel(report);this.addStatsToTable_(statsTable,report.timestamp,report)}clearStatsLists(peerConnectionElement){const containerId=peerConnectionElement.id+"-table-container";const container=document.getElementById(containerId);if(container){peerConnectionElement.removeChild(container);this.ensureStatsTableContainer_(peerConnectionElement)}}ensureStatsTableContainer_(peerConnectionElement){const containerId=peerConnectionElement.id+"-table-container";let container=document.getElementById(containerId);if(!container){container=document.createElement("div");container.id=containerId;container.className="stats-table-container";const head=document.createElement("div");head.textContent="Stats Tables";container.appendChild(head);const label=document.createElement("label");label.innerText="Filter statistics by type including ";container.appendChild(label);const input=document.createElement("input");input.placeholder="separate multiple values by `,`";input.size=25;input.oninput=e=>this.filterStats(e,container);container.appendChild(input);peerConnectionElement.appendChild(container)}return container}ensureStatsTable_(peerConnectionElement,report){const detailsId=peerConnectionElement.id+"-details-"+report.id;const tableId=peerConnectionElement.id+"-table-"+report.id;let table=document.getElementById(tableId);if(!table){const container=this.ensureStatsTableContainer_(peerConnectionElement);const details=document.createElement("details");details.id=detailsId;details.attributes["data-statsType"]=report.type;container.appendChild(details);const summary=document.createElement("summary");summary.textContent=generateStatsLabel(report);details.appendChild(summary);table=document.createElement("table");details.appendChild(table);table.id=tableId;table.border=1;table.appendChild($("trth-template").content.cloneNode(true));table.rows[0].cells[0].textContent="Statistics "+report.id;table["data-peerconnection-id"]=peerConnectionElement.id}return table}addStatsToTable_(statsTable,time,report){const definedMetrics=new Set(Object.keys(report));const metricsContainer=statsTable.firstChild;for(let i=0;i<metricsContainer.children.length;++i){const metricElement=metricsContainer.children[i];let metricName=metricElement.id.substring(metricElement.id.lastIndexOf("-")+1);if(metricName.endsWith("]")){metricName=metricElement.id.substring(metricElement.id.indexOf("["))}if(metricName&&metricName!="timestamp"&&!definedMetrics.has(metricName)){this.updateStatsTableRow_(statsTable,metricName,"(removed)")}}const date=new Date(time);this.updateStatsTableRow_(statsTable,"timestamp",date.toLocaleString());Object.keys(report).forEach((property=>{if(["timestamp","id"].includes(property))return;this.updateStatsTableRow_(statsTable,property,report[property])}))}updateStatsTableRow_(statsTable,rowName,value){const trId=statsTable.id+"-"+rowName;let trElement=document.getElementById(trId);const activeConnectionClass="stats-table-active-connection";if(!trElement){trElement=document.createElement("tr");trElement.id=trId;statsTable.firstChild.appendChild(trElement);const item=$("statsrow-template").content.cloneNode(true);item.querySelector("td").textContent=rowName;trElement.appendChild(item)}trElement.cells[1].textContent=value;if(rowName.endsWith("Id")){trElement.cells[2].children[0].textContent=" 🔗";trElement.cells[2].children[0].href="#"+statsTable["data-peerconnection-id"]+"-table-"+value}}filterStats(event,container){const filter=event.target.value;const filters=filter.split(",");container.childNodes.forEach((node=>{if(node.nodeName!=="DETAILS"){return}const statsType=node.attributes["data-statsType"];if(!filter||filters.includes(statsType)||filters.find((f=>statsType.includes(f)))){node.style.display="block"}else{node.style.display="none"}}))}}