// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import{TimelineDataSeries}from"./data_series.js";import{peerConnectionDataStore}from"./dump_creator.js";import{generateStatsLabel}from"./stats_helper.js";import{TimelineGraphView}from"./timeline_graph_view.js";const STATS_GRAPH_CONTAINER_HEADING_CLASS="stats-graph-container-heading";function isReportBlocklisted(report){if(report.type==="codec"){return true}if(report.type==="data-channel"&&report.state==="connecting"){return true}if(report.type==="transport"&&report.dtlsState==="new"){return true}if(report.type==="local-candidate"||report.type==="remote-candidate"){return true}return false}function isStatBlocklisted(report,statName){if(report.type==="candidate-pair"&&statName==="priority"){return true}if(["inbound-rtp","outbound-rtp","remote-inbound-rtp","remote-outbound-rtp"].includes(report.type)&&["mid","rid","ssrc","rtxSsrc","fecSsrc"].includes(statName)){return true}if(["candidate-pair","inbound-rtp"].includes(report.type)&&["lastPacketSentTimestamp","lastPacketReceivedTimestamp"].includes(statName)){return true}return false}const graphViews={};window.graphViews=graphViews;const graphElementsByPeerConnectionId=new Map;function getNumberFromValue(name,value){if(isNaN(value)){return NaN}return parseFloat(value)}export function drawSingleReport(peerConnectionElement,report){const reportType=report.type;const reportId=report.id;const childrenBefore=peerConnectionElement.hasChildNodes()?Array.from(peerConnectionElement.childNodes):[];Object.keys(report).forEach((property=>{if(["timestamp","id"].includes(property))return;const rawLabel=property;const rawDataSeriesId=reportId+"-"+rawLabel;const rawValue=getNumberFromValue(rawLabel,report[property]);if(isNaN(rawValue)){addDataSeriesPoints(peerConnectionElement,reportType,rawDataSeriesId,rawLabel,[report.timestamp],[report[property]]);return}let finalDataSeriesId=rawDataSeriesId;let finalLabel=rawLabel;let finalValue=rawValue;addDataSeriesPoints(peerConnectionElement,reportType,finalDataSeriesId,finalLabel,[report.timestamp],[finalValue]);if(isReportBlocklisted(report)||isStatBlocklisted(report,rawLabel)){return}const graphType=finalLabel;const graphViewId=peerConnectionElement.id+"-"+reportId+"-"+graphType;if(!graphViews[graphViewId]){graphViews[graphViewId]=createStatsGraphView(peerConnectionElement,report,graphType);const searchParameters=new URLSearchParams(window.location.search);if(searchParameters.has("statsInterval")){const statsInterval=Math.max(parseInt(searchParameters.get("statsInterval"),10),100);if(isFinite(statsInterval)){graphViews[graphViewId].setScale(statsInterval)}}const date=new Date(report.timestamp);graphViews[graphViewId].setDateRange(date,date)}ensureStatsGraphContainer(peerConnectionElement,report);const dataSeries=peerConnectionDataStore[peerConnectionElement.id].getDataSeries(finalDataSeriesId);if(!graphViews[graphViewId].hasDataSeries(dataSeries)){graphViews[graphViewId].addDataSeries(dataSeries)}graphViews[graphViewId].updateEndDate()}));addDataSeriesPoints(peerConnectionElement,reportType,reportId+"-timestamp",reportId+"-timestamp",[report.timestamp],[report.timestamp]);const childrenAfter=peerConnectionElement.hasChildNodes()?Array.from(peerConnectionElement.childNodes):[];for(let i=0;i<childrenAfter.length;++i){if(!childrenBefore.includes(childrenAfter[i])){let graphElements=graphElementsByPeerConnectionId.get(peerConnectionElement.id);if(!graphElements){graphElements=[];graphElementsByPeerConnectionId.set(peerConnectionElement.id,graphElements)}graphElements.push(childrenAfter[i])}}}export function removeStatsReportGraphs(peerConnectionElement){const graphElements=graphElementsByPeerConnectionId.get(peerConnectionElement.id);if(graphElements){for(let i=0;i<graphElements.length;++i){peerConnectionElement.removeChild(graphElements[i])}graphElementsByPeerConnectionId.delete(peerConnectionElement.id)}Object.keys(graphViews).forEach((key=>{if(key.startsWith(peerConnectionElement.id)){delete graphViews[key]}}))}function addDataSeriesPoints(peerConnectionElement,reportType,dataSeriesId,label,times,values){let dataSeries=peerConnectionDataStore[peerConnectionElement.id].getDataSeries(dataSeriesId);if(!dataSeries){dataSeries=new TimelineDataSeries(reportType);peerConnectionDataStore[peerConnectionElement.id].setDataSeries(dataSeriesId,dataSeries)}for(let i=0;i<times.length;++i){dataSeries.addPoint(times[i],values[i])}}function ensureStatsGraphTopContainer(peerConnectionElement){const containerId=peerConnectionElement.id+"-graph-container";let container=document.getElementById(containerId);if(!container){container=document.createElement("div");container.id=containerId;container.className="stats-graph-container";const label=document.createElement("label");label.innerText="Filter statistics graphs by type including ";container.appendChild(label);const input=document.createElement("input");input.placeholder="separate multiple values by `,`";input.size=25;input.oninput=e=>filterStats(e,container);container.appendChild(input);peerConnectionElement.appendChild(container)}return container}function ensureStatsGraphContainer(peerConnectionElement,report){const topContainer=ensureStatsGraphTopContainer(peerConnectionElement);const containerId=peerConnectionElement.id+"-"+report.type+"-"+report.id+"-graph-container";let container=document.getElementById(containerId);if(!container){container=document.createElement("details");container.id=containerId;container.className="stats-graph-container";container.attributes["data-statsType"]=report.type;peerConnectionElement.appendChild(container);container.appendChild($("summary-span-template").content.cloneNode(true));container.firstChild.firstChild.className=STATS_GRAPH_CONTAINER_HEADING_CLASS;topContainer.appendChild(container)}container.firstChild.firstChild.textContent="Stats graphs for "+generateStatsLabel(report);return container}function createStatsGraphView(peerConnectionElement,report,statsName){const topContainer=ensureStatsGraphContainer(peerConnectionElement,report);const graphViewId=peerConnectionElement.id+"-"+report.id+"-"+statsName;const divId=graphViewId+"-div";const canvasId=graphViewId+"-canvas";const container=document.createElement("div");container.className="stats-graph-sub-container";topContainer.appendChild(container);const canvasDiv=$("container-template").content.cloneNode(true);canvasDiv.querySelectorAll("div")[0].textContent=statsName;canvasDiv.querySelectorAll("div")[1].id=divId;canvasDiv.querySelector("canvas").id=canvasId;container.appendChild(canvasDiv);return new TimelineGraphView(divId,canvasId)}function filterStats(event,container){const filter=event.target.value;const filters=filter.split(",");container.childNodes.forEach((node=>{if(node.nodeName!=="DETAILS"){return}const statsType=node.attributes["data-statsType"];if(!filter||filters.includes(statsType)||filters.find((f=>statsType.includes(f)))){node.style.display="block"}else{node.style.display="none"}}))}