// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";export const userMediaRequests=[];export const peerConnectionDataStore={};window.userMediaRequests=userMediaRequests;window.peerConnectionDataStore=peerConnectionDataStore;export class DumpCreator{constructor(ignoredContainerElement){document.getElementById("dump-click-target").addEventListener("click",this.onDownloadData_.bind(this));document.getElementById("audio-recording-click-target").addEventListener("click",this.onAudioDebugRecordingsChanged_.bind(this));document.getElementById("packet-recording-click-target").addEventListener("click",this.onEventLogRecordingsChanged_.bind(this));document.getElementById("datachannel-recording-click-target").addEventListener("click",this.onDataChannelRecordingsChanged_.bind(this))}setAudioDebugRecordingsCheckbox(){document.getElementById("audio-recording-checkbox").checked=true}clearAudioDebugRecordingsCheckbox(){document.getElementById("audio-recording-checkbox").checked=false}setEventLogRecordingsCheckbox(){document.getElementById("packet-recording-checkbox").checked=true}clearEventLogRecordingsCheckbox(){document.getElementById("packet-recording-checkbox").checked=false}setEventLogRecordingsCheckboxMutability(mutable){document.getElementById("packet-recording-checkbox").disabled=!mutable;if(!mutable){const label=document.getElementById("packet-recording-label");label.style="color:red;";label.textContent=" WebRTC event logging's state was set by a command line flag."}}setDataChannelRecordingsCheckbox(){document.getElementById("datachannel-recording-checkbox").checked=true}clearDataChannelRecordingsCheckbox(){document.getElementById("datachannel-recording-checkbox").checked=false}async onDownloadData_(event){const useCompression=document.getElementById("dump-checkbox").checked;const uaData=await navigator.userAgentData.getHighEntropyValues(["fullVersionList"]);const dumpObject={getUserMedia:userMediaRequests,PeerConnections:peerConnectionDataStore,UserAgent:navigator.userAgent,UserAgentData:uaData.fullVersionList};const textBlob=new Blob([JSON.stringify(dumpObject,null,1)],{type:"octet/stream"});let url;if(useCompression){const compressionStream=new CompressionStream("gzip");const binaryStream=textBlob.stream().pipeThrough(compressionStream);const binaryBlob=await new Response(binaryStream).blob();url=URL.createObjectURL(binaryBlob);const anchor=document.createElement("a");anchor.download="webrtc_internals_dump.gz";anchor.href=url;anchor.click();return}url=URL.createObjectURL(textBlob);const anchor=document.createElement("a");anchor.download="webrtc_internals_dump.txt";anchor.href=url;anchor.click()}onAudioDebugRecordingsChanged_(){const checkbox=document.getElementById("audio-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableAudioDebugRecordings")}onEventLogRecordingsChanged_(){const checkbox=document.getElementById("packet-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableEventLogRecordings")}onDataChannelRecordingsChanged_(){const checkbox=document.getElementById("datachannel-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableDataChannelRecordings")}}