// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html, nothing } from 'chrome://resources/lit/v3_0/lit.rollup.js';
function getReportHtml() {
    // clang-format off
    if (!this.hasTraces_()) {
        return html `
    <div class="empty-message">
      <cr-icon icon="cr:warning"></cr-icon>
      <h1>Could not find any traces saved locally.</h1>
    </div>`;
    }
    return html `
      <trace-report .isHeader="${true}"></trace-report>
    ${this.traces_.map((traceReport) => html `
      <trace-report
          .trace="${traceReport}"
          @show-toast="${this.showToastHandler_}"
          @refresh-traces-request="${this.onRefreshTracesClick_}">
      </trace-report>`)}`;
    // clang-format on
}
export function getHtml() {
    // clang-format off
    return html `
  <div class="header">
    <h1>Traces
      <span class="trace-counter" ?hidden="${!this.hasTraces_()}">
        ${this.traces_.length}
      </span>
    </h1>
    <div class="utility-bar">
      <cr-button class="tonal-button"
          @click="${this.onRefreshTracesClick_}">
        <cr-icon icon="cr:sync" slot="prefix-icon"></cr-icon>
        Refresh
      </cr-button>
    ${this.hasTraces_() ? html `
      <cr-button class="tonal-button" ?disabled="${!this.hasTraces_()}"
          @click="${this.onDeleteAllTracesClick_}">
        <cr-icon icon="cr:delete" slot="prefix-icon"></cr-icon>
        Delete All Traces
      </cr-button>` : nothing}
    </div>
  </div>
  ${this.isLoading_ ? html `
  <div class="loading-spinner"><div class="spinner"></div></div>` :
        html `
  <div class="report-list-container">
    ${getReportHtml.bind(this)()}
  </div>`}
  <cr-toast id="toast" duration="5000" ?hidden="${!this.notification_}">
    <div id="notification-card">
      <div class="icon-container ${this.getNotificationStyling_()}">
        <cr-icon icon="${this.getNotificationIcon_()}"></cr-icon>
      </div>
      <div class="notification-message">
        <h4 class="notification-type ${this.getNotificationStyling_()}">
          ${this.getNotificationType_()}
        </h4>
        <span class="notification-label">${this.getNotificationLabel_()}</span>
      </div>
    </div>
  </cr-toast>`;
    // clang-format on
}
