/* Copyright 2017 The Chromium Authors
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file. */
import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import{assert}from"chrome://resources/js/assert.js";import{addWebUiListener,sendWithPromise}from"chrome://resources/js/cr.js";import{$}from"chrome://resources/js/util.js";function initialize(){sendWithPromise("getExperiments",[]).then((experiments=>addExperiments(experiments)));sendWithPromise("getPrefs",[]).then((prefs=>addPrefs(prefs)));sendWithPromise("getPolicies",[]).then((policies=>addPolicies(policies)));sendWithPromise("getCookie",[]).then((cookie=>addCookie(cookie)));sendWithPromise("getSavedPasswords",[]).then((passwords=>addSavedPasswords(passwords)));sendWithPromise("getDatabaseManagerInfo",[]).then((function(databaseState){const fullHashCacheState=databaseState.splice(-1,1);addDatabaseManagerInfo(databaseState);addFullHashCacheInfo(fullHashCacheState)}));sendWithPromise("getDownloadUrlsChecked",[]).then((urlsChecked=>{urlsChecked.forEach((function(urlAndResult){addDownloadUrlChecked(urlAndResult)}))}));addWebUiListener("download-url-checked-update",(function(urlAndResult){addDownloadUrlChecked(urlAndResult)}));sendWithPromise("getSentClientDownloadRequests",[]).then((sentClientDownloadRequests=>{sentClientDownloadRequests.forEach((function(cdr){addSentClientDownloadRequestsInfo(cdr)}))}));addWebUiListener("sent-client-download-requests-update",(function(result){addSentClientDownloadRequestsInfo(result)}));sendWithPromise("getReceivedClientDownloadResponses",[]).then((receivedClientDownloadResponses=>{receivedClientDownloadResponses.forEach((function(cdr){addReceivedClientDownloadResponseInfo(cdr)}))}));addWebUiListener("received-client-download-responses-update",(function(result){addReceivedClientDownloadResponseInfo(result)}));sendWithPromise("getSentClientPhishingRequests",[]).then((sentClientPhishingRequests=>{sentClientPhishingRequests.forEach((function(cpr){addSentClientPhishingRequestsInfo(cpr)}))}));addWebUiListener("sent-client-phishing-requests-update",(function(result){addSentClientPhishingRequestsInfo(result)}));sendWithPromise("getReceivedClientPhishingResponses",[]).then((receivedClientPhishingResponses=>{receivedClientPhishingResponses.forEach((function(cpr){addReceivedClientPhishingResponseInfo(cpr)}))}));addWebUiListener("received-client-phishing-responses-update",(function(result){addReceivedClientPhishingResponseInfo(result)}));sendWithPromise("getSentCSBRRs",[]).then((sentCSBRRs=>{sentCSBRRs.forEach((function(csbrr){addSentCSBRRsInfo(csbrr)}))}));addWebUiListener("sent-csbrr-update",(function(result){addSentCSBRRsInfo(result)}));sendWithPromise("getSentHitReports",[]).then((sentHitReports=>{sentHitReports.forEach((function(hitReports){addSentHitReportsInfo(hitReports)}))}));addWebUiListener("sent-hit-report-list",(function(result){addSentHitReportsInfo(result)}));sendWithPromise("getPGEvents",[]).then((pgEvents=>{pgEvents.forEach((function(pgEvent){addPGEvent(pgEvent)}))}));addWebUiListener("sent-pg-event",(function(result){addPGEvent(result)}));sendWithPromise("getSecurityEvents",[]).then((securityEvents=>{securityEvents.forEach((function(securityEvent){addSecurityEvent(securityEvent)}))}));addWebUiListener("sent-security-event",(function(result){addSecurityEvent(result)}));sendWithPromise("getPGPings",[]).then((pgPings=>{pgPings.forEach((function(pgPing){addPGPing(pgPing)}))}));addWebUiListener("pg-pings-update",(function(result){addPGPing(result)}));sendWithPromise("getPGResponses",[]).then((pgResponses=>{pgResponses.forEach((function(pgResponse){addPGResponse(pgResponse)}))}));addWebUiListener("pg-responses-update",(function(result){addPGResponse(result)}));sendWithPromise("getURTLookupPings",[]).then((urtLookupPings=>{urtLookupPings.forEach((function(urtLookupPing){addURTLookupPing(urtLookupPing)}))}));addWebUiListener("urt-lookup-pings-update",(function(result){addURTLookupPing(result)}));sendWithPromise("getURTLookupResponses",[]).then((urtLookupResponses=>{urtLookupResponses.forEach((function(urtLookupResponse){addURTLookupResponse(urtLookupResponse)}))}));addWebUiListener("urt-lookup-responses-update",(function(result){addURTLookupResponse(result)}));sendWithPromise("getHPRTLookupPings",[]).then((hprtLookupPings=>{hprtLookupPings.forEach((function(hprtLookupPing){addHPRTLookupPing(hprtLookupPing)}))}));addWebUiListener("hprt-lookup-pings-update",(function(result){addHPRTLookupPing(result)}));sendWithPromise("getHPRTLookupResponses",[]).then((hprtLookupResponses=>{hprtLookupResponses.forEach((function(hprtLookupResponse){addHPRTLookupResponse(hprtLookupResponse)}))}));addWebUiListener("hprt-lookup-responses-update",(function(result){addHPRTLookupResponse(result)}));sendWithPromise("getLogMessages",[]).then((logMessages=>{logMessages.forEach((function(message){addLogMessage(message)}))}));addWebUiListener("log-messages-update",(function(message){addLogMessage(message)}));sendWithPromise("getReportingEvents",[]).then((reportingEvents=>{reportingEvents.forEach((function(reportingEvent){addReportingEvent(reportingEvent)}))}));addWebUiListener("reporting-events-update",(function(reportingEvent){addReportingEvent(reportingEvent)}));sendWithPromise("getDeepScans",[]).then((requests=>{requests.forEach((function(request){addDeepScan(request)}))}));addWebUiListener("deep-scan-request-update",(function(result){addDeepScan(result)}));const referrerChangeForm=$("get-referrer-chain-form");assert(referrerChangeForm);referrerChangeForm.addEventListener("submit",addReferrerChain);sendWithPromise("getTailoredVerdictOverride",[]).then(displayTailoredVerdictOverride);addWebUiListener("tailored-verdict-override-update",displayTailoredVerdictOverride);const overrideForm=$("tailored-verdict-override-form");assert(overrideForm);overrideForm.addEventListener("submit",setTailoredVerdictOverride);const overrideClear=$("tailored-verdict-override-clear");assert(overrideClear);overrideClear.addEventListener("click",clearTailoredVerdictOverride);showTab(window.location.hash.substr(5));window.onhashchange=function(){showTab(window.location.hash.substr(5))};const tabbox=$("tabbox");assert(tabbox);tabbox.addEventListener("selected-index-change",(e=>{const tabs=document.querySelectorAll("div[slot='tab']");const selectedTab=tabs[e.detail];assert(selectedTab);window.location.hash="tab-"+selectedTab.id}),true)}function addExperiments(result){addContentHelper(result,"result-template","experiments-list","span")}function addPrefs(result){addContentHelper(result,"result-template","preferences-list","span")}function addPolicies(result){addContentHelper(result,"result-template","policies-list","span")}function addCookie(result){const cookiePanel=$("cookie-panel");const cookieTemplate=$("cookie-template");assert(cookieTemplate);const cookieFormatted=cookieTemplate.content.cloneNode(true);const selectedElements=cookieFormatted.querySelectorAll(".result");assert(selectedElements);const firstElement=selectedElements[0];const secondElement=selectedElements[1];const firstResult=result[0];const secondResult=result[1];assert(cookiePanel);assert(firstElement);assert(secondElement);assert(firstResult);assert(secondResult);firstElement.textContent=firstResult;secondElement.textContent=new Date(secondResult).toLocaleString();cookiePanel.appendChild(cookieFormatted)}function addSavedPasswords(result){const resLength=result.length;for(let i=0;i<resLength;i+=2){const savedPasswordFormatted=document.createElement("div");const suffix=result[i+1]?"GAIA password":"Enterprise password";savedPasswordFormatted.textContent=`${result[i]} (${suffix})`;const savedPasswordsList=$("saved-passwords");assert(savedPasswordsList);savedPasswordsList.appendChild(savedPasswordFormatted)}}function addDatabaseManagerInfo(result){const resLength=result.length;for(let i=0;i<resLength;i+=2){const preferenceListTemplate=$("result-template");assert(preferenceListTemplate);const preferencesListFormatted=preferenceListTemplate.content.cloneNode(true);const selectedElements=preferencesListFormatted.querySelectorAll("span");assert(selectedElements);const firstElement=selectedElements[0];const secondElement=selectedElements[1];assert(firstElement);assert(secondElement);firstElement.textContent=result[i]+": ";const value=result[i+1];assert(value);if(Array.isArray(value)){const blockQuote=document.createElement("blockquote");value.forEach((item=>{const div=document.createElement("div");div.textContent=item;blockQuote.appendChild(div)}));secondElement.appendChild(blockQuote)}else{secondElement.textContent=value}const databaseInfoList=$("database-info-list");assert(databaseInfoList);databaseInfoList.appendChild(preferencesListFormatted)}}function addContentHelper(result,templateName,parentListName,elementSelector){const resLength=result.length;for(let i=0;i<resLength;i+=2){const listTemplate=$(templateName);assert(listTemplate);const formattedTemplate=listTemplate.content.cloneNode(true);const firstResult=result[i];const secondResult=result[i+1];const selectedElements=formattedTemplate.querySelectorAll(elementSelector);const firstElement=selectedElements[0];const secondElement=selectedElements[1];const parentList=$(parentListName);assert(firstResult!==null&&firstResult!==undefined);assert(secondResult);assert(firstElement);assert(secondElement);assert(parentList);firstElement.textContent=secondResult+": ";secondElement.textContent=firstResult;parentList.appendChild(formattedTemplate)}}function addFullHashCacheInfo(result){const cacheInfo=$("full-hash-cache-info");assert(cacheInfo);cacheInfo.textContent=result}function addDownloadUrlChecked(urlAndResult){const logDiv=$("download-urls-checked-list");appendChildWithInnerText(logDiv,urlAndResult)}function addSentClientDownloadRequestsInfo(result){const logDiv=$("sent-client-download-requests-list");appendChildWithInnerText(logDiv,result)}function addReceivedClientDownloadResponseInfo(result){const logDiv=$("received-client-download-response-list");appendChildWithInnerText(logDiv,result)}function addSentClientPhishingRequestsInfo(result){const logDiv=$("sent-client-phishing-requests-list");appendChildWithInnerText(logDiv,result)}function addReceivedClientPhishingResponseInfo(result){const logDiv=$("received-client-phishing-response-list");appendChildWithInnerText(logDiv,result)}function addSentCSBRRsInfo(result){const logDiv=$("sent-csbrrs-list");appendChildWithInnerText(logDiv,result)}function addSentHitReportsInfo(result){const logDiv=$("sent-hit-report-list");appendChildWithInnerText(logDiv,result)}function addPGEvent(result){const logDiv=$("pg-event-log");const eventFormatted="["+new Date(result.time).toLocaleString()+"] "+result.message;appendChildWithInnerText(logDiv,eventFormatted)}function addSecurityEvent(result){const logDiv=$("security-event-log");const eventFormatted="["+new Date(result.time).toLocaleString()+"] "+result.message;appendChildWithInnerText(logDiv,eventFormatted)}function insertTokenToTable(tableId,token){const table=$(tableId);assert(table);const row=table.insertRow();row.className="content";row.id=tableId+"-"+token;row.insertCell().className="content";row.insertCell().className="content"}function addResultToTable(tableId,token,result,position){let table=$(`${tableId}-${token}`);if(table===null){insertTokenToTable(tableId,token);table=$(`${tableId}-${token}`)}assert(table);const cell=table.cells[position];assert(cell);cell.innerText=result}function addPGPing(result){addResultToTableHelper("pg-ping-list",result,0)}function addPGResponse(result){addResultToTableHelper("pg-ping-list",result,1)}function addURTLookupPing(result){addResultToTableHelper("urt-lookup-ping-list",result,0)}function addURTLookupResponse(result){addResultToTableHelper("urt-lookup-ping-list",result,1)}function addHPRTLookupPing(result){addResultToTableHelper("hprt-lookup-ping-list",result,0)}function addHPRTLookupResponse(result){addResultToTableHelper("hprt-lookup-ping-list",result,1)}function addResultToTableHelper(listName,result,position){const tableId=typeof result[0]==="number"?result[0].toString():result[0];const token=result[1];assert(tableId!==undefined&&tableId!==null);assert(token!==undefined&&token!==null);addResultToTable(listName,tableId,token,position)}function addDeepScan(result){if(result.request_time!==null){const requestFormatted="["+new Date(result.request_time).toLocaleString()+"]\n"+result.request;addResultToTable("deep-scan-list",result.token,requestFormatted,0)}if(result.response_time!=null){if(result.response_status==="SUCCESS"){const resultFormatted="["+new Date(result.response_time).toLocaleString()+"]\n"+result.response;addResultToTable("deep-scan-list",result.token,resultFormatted,1)}else{const resultFormatted="["+new Date(result.response_time).toLocaleString()+"]\n"+result.response_status;addResultToTable("deep-scan-list",result.token,resultFormatted,1)}}}function addLogMessage(result){const logDiv=$("log-messages");const eventFormatted="["+new Date(result.time).toLocaleString()+"] "+result.message;appendChildWithInnerText(logDiv,eventFormatted)}function addReportingEvent(result){const logDiv=$("reporting-events");const eventFormatted=result.message;appendChildWithInnerText(logDiv,eventFormatted)}function appendChildWithInnerText(logDiv,text){if(!logDiv){return}const textDiv=document.createElement("div");textDiv.innerText=text;logDiv.appendChild(textDiv)}function addReferrerChain(ev){ev.preventDefault();const referrerChainURL=$("referrer-chain-url");assert(referrerChainURL);sendWithPromise("getReferrerChain",referrerChainURL.value).then((response=>{const referrerChainContent=$("referrer-chain-content");assert(referrerChainContent);if(window.trustedTypes){referrerChainContent.innerHTML=window.trustedTypes.emptyHTML}else{referrerChainContent.innerHTML=""}referrerChainContent.textContent=response}))}function displayTailoredVerdictOverride(response){let displayString=`Status: ${response.status}`;if(response.override_value){displayString+=`\nOverride value: ${JSON.stringify(response.override_value)}`}const overrideContent=$("tailored-verdict-override-content");assert(overrideContent);if(window.trustedTypes){overrideContent.innerHTML=window.trustedTypes.emptyHTML}else{overrideContent.innerHTML=""}overrideContent.textContent=displayString}function setTailoredVerdictOverride(e){e.preventDefault();const form=$("tailored-verdict-override-form");assert(form);const inputs=form.elements;const inputValue={tailored_verdict_type:inputs.tailored_verdict_type.value};sendWithPromise("setTailoredVerdictOverride",inputValue).then(displayTailoredVerdictOverride)}function clearTailoredVerdictOverride(e){e.preventDefault();const form=$("tailored-verdict-override-form");assert(form);form.reset();sendWithPromise("clearTailoredVerdictOverride").then(displayTailoredVerdictOverride)}function showTab(tabId){const tabs=document.querySelectorAll("div[slot='tab']");const index=Array.from(tabs).findIndex((t=>t.id===tabId));if(index!==-1){const tabbox=document.querySelector("cr-tab-box");assert(tabbox);tabbox.setAttribute("selected-index",index.toString())}}document.addEventListener("DOMContentLoaded",initialize);