// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_tabs/cr_tabs.js";import"/strings.m.js";import"./experiment.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{FocusOutlineManager}from"chrome://resources/js/focus_outline_manager.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{PromiseResolver}from"chrome://resources/js/promise_resolver.js";import{getDeepActiveElement}from"chrome://resources/js/util.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{FlagsBrowserProxyImpl}from"./flags_browser_proxy.js";async function highlightAllMatches(experiments,searchTerm){let matches=0;await Promise.all(Array.from(experiments).map((async experiment=>{const hasMatch=await experiment.match(searchTerm);matches+=hasMatch?1:0;experiment.hidden=!hasMatch})));return matches}class FlagSearch{flagsAppElement;searchIntervalId=null;searchDebounceDelayMs=150;constructor(el){this.flagsAppElement=el}async doSearch(){await this.flagsAppElement.search();this.searchIntervalId=null}debounceSearch(){if(this.searchIntervalId){clearTimeout(this.searchIntervalId)}this.searchIntervalId=setTimeout(this.doSearch.bind(this),this.searchDebounceDelayMs)}setSearchDebounceDelayMsForTesting(delay){this.searchDebounceDelayMs=delay}}export class FlagsAppElement extends CrLitElement{static get is(){return"flags-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{data:{type:Object},defaultFeatures:{type:Array},nonDefaultFeatures:{type:Array},searching:{type:Boolean,reflect:true},needsRestart:{type:Boolean},tabNames_:{type:Array},selectedTabIndex_:{type:Number}}}#tabNames__accessor_storage=[loadTimeData.getString("available"),loadTimeData.getString("unavailable")];get tabNames_(){return this.#tabNames__accessor_storage}set tabNames_(value){this.#tabNames__accessor_storage=value}#selectedTabIndex__accessor_storage=0;get selectedTabIndex_(){return this.#selectedTabIndex__accessor_storage}set selectedTabIndex_(value){this.#selectedTabIndex__accessor_storage=value}#data_accessor_storage={supportedFeatures:[],unsupportedFeatures:[],needsRestart:false,showBetaChannelPromotion:false,showDevChannelPromotion:false};get data(){return this.#data_accessor_storage}set data(value){this.#data_accessor_storage=value}#defaultFeatures_accessor_storage=[];get defaultFeatures(){return this.#defaultFeatures_accessor_storage}set defaultFeatures(value){this.#defaultFeatures_accessor_storage=value}#nonDefaultFeatures_accessor_storage=[];get nonDefaultFeatures(){return this.#nonDefaultFeatures_accessor_storage}set nonDefaultFeatures(value){this.#nonDefaultFeatures_accessor_storage=value}#searching_accessor_storage=false;get searching(){return this.#searching_accessor_storage}set searching(value){this.#searching_accessor_storage=value}#needsRestart_accessor_storage=false;get needsRestart(){return this.#needsRestart_accessor_storage}set needsRestart(value){this.#needsRestart_accessor_storage=value}announceStatusDelayMs=100;featuresResolver=new PromiseResolver;flagSearch=null;lastChanged=null;lastFocused=null;isFlagsDeprecatedUrl_=false;eventTracker_=null;getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("data")){const defaultFeatures=[];const nonDefaultFeatures=[];this.data.supportedFeatures.forEach((f=>(f.is_default?defaultFeatures:nonDefaultFeatures).push(f)));this.defaultFeatures=defaultFeatures;this.nonDefaultFeatures=nonDefaultFeatures;this.needsRestart=this.needsRestart||this.data.needsRestart}}firstUpdated(changedProperties){super.firstUpdated(changedProperties);this.flagSearch=new FlagSearch(this);this.$.search.focus()}async updated(changedProperties){super.updated(changedProperties);if(this.defaultFeatures.length===0&&this.data.unsupportedFeatures.length===0&&this.nonDefaultFeatures.length===0){return}await this.highlightReferencedFlag();this.featuresResolver.resolve()}getRestartButton(){return this.getRequiredElement("#experiment-restart-button")}connectedCallback(){super.connectedCallback();const pathname=new URL(window.location.href).pathname;this.isFlagsDeprecatedUrl_=["/deprecated","/deprecated/test_loader.html"].includes(pathname);this.requestExperimentalFeaturesData();FocusOutlineManager.forDocument(document);if(this.isFlagsDeprecatedUrl_){document.title=loadTimeData.getString("deprecatedTitle");this.getRequiredElement(".section-header-title").textContent=loadTimeData.getString("deprecatedHeading");this.getRequiredElement(".blurb-warning").textContent="";this.getRequiredElement(".blurb-warning + span").textContent=loadTimeData.getString("deprecatedPageWarningExplanation");this.$.search.placeholder=loadTimeData.getString("deprecatedSearchPlaceholder");for(const element of this.shadowRoot.querySelectorAll(".no-match")){element.textContent=loadTimeData.getString("deprecatedNoResults")}}this.eventTracker_=new EventTracker;this.eventTracker_.add(window,"hashchange",(()=>this.highlightReferencedFlag()));this.eventTracker_.add(window,"keyup",(e=>{const activeElement=getDeepActiveElement();if(activeElement&&activeElement.nodeName==="TEXTAREA"){return}switch(e.key){case"/":this.$.search.focus();break;case"Escape":this.$.search.blur();break}}))}disconnectedCallback(){super.disconnectedCallback();assert(this.eventTracker_);this.eventTracker_.removeAll();this.eventTracker_=null}setAnnounceStatusDelayMsForTesting(delay){this.announceStatusDelayMs=delay}setSearchDebounceDelayMsForTesting(delay){assert(this.flagSearch);this.flagSearch.setSearchDebounceDelayMsForTesting(delay)}experimentalFeaturesReadyForTesting(){return this.featuresResolver.promise}announceStatus(text){return new Promise((resolve=>{this.getRequiredElement("#screen-reader-status-message").textContent="";setTimeout((()=>{this.getRequiredElement("#screen-reader-status-message").textContent=text;resolve()}),this.announceStatusDelayMs)}))}async search(){const searchTerm=this.$.search.value.trim().toLowerCase();this.searching=Boolean(searchTerm);const availableExperiments=this.shadowRoot.querySelectorAll("#tab-content-available flags-experiment");const availableExperimentsHits=await highlightAllMatches(availableExperiments,searchTerm);let noMatchMsg=this.getRequiredElement("#tab-content-available .no-match");noMatchMsg.toggleAttribute("hidden",availableExperimentsHits>0);const unavailableExperiments=this.shadowRoot.querySelectorAll("#tab-content-unavailable flags-experiment");const unavailableExperimentsHits=await highlightAllMatches(unavailableExperiments,searchTerm);noMatchMsg=this.getRequiredElement("#tab-content-unavailable .no-match");noMatchMsg.toggleAttribute("hidden",unavailableExperimentsHits>0);if(this.searching){const hits=this.selectedTabIndex_===0?availableExperimentsHits:unavailableExperimentsHits;await this.announceSearchResults(searchTerm,hits)}await this.updateComplete;this.dispatchEvent(new Event("search-finished-for-testing",{bubbles:true,composed:true}))}announceSearchResults(searchTerm,total){if(total){return this.announceStatus(total===1?loadTimeData.getStringF("searchResultsSingular",searchTerm):loadTimeData.getStringF("searchResultsPlural",total,searchTerm))}return Promise.resolve()}onResetAllKeydown_(e){if(this.lastChanged&&e.key==="Tab"&&!e.shiftKey){e.preventDefault();this.lastFocused=this.lastChanged;this.getRestartButton().focus()}}onResetAllBlur_(){this.lastChanged=null}async highlightReferencedFlag(){if(!window.location.hash){return}let experiment=null;try{experiment=this.shadowRoot.querySelector(window.location.hash)}catch{window.history.replaceState(null,"",window.location.origin);return}if(!experiment||experiment.classList.contains("referenced")){return}const previous=this.shadowRoot.querySelector(".referenced");if(previous){previous.classList.remove("referenced")}experiment.classList.add("referenced");if(this.getRequiredElement("#tab-content-unavailable").contains(experiment)){this.selectedTabIndex_=1;await this.updateComplete;await this.getRequiredElement("cr-tabs").updateComplete}experiment.scrollIntoView()}async requestExperimentalFeaturesData(){const data=this.isFlagsDeprecatedUrl_?await FlagsBrowserProxyImpl.getInstance().requestDeprecatedFeatures():await FlagsBrowserProxyImpl.getInstance().requestExperimentalFeatures();this.data=data}clearSearch(){this.$.search.value="";assert(this.flagSearch);this.flagSearch.doSearch();this.$.search.focus()}async onResetAllClick_(e){this.lastChanged=e.target;FlagsBrowserProxyImpl.getInstance().resetAllFlags();this.announceStatus(loadTimeData.getString("reset-acknowledged"));this.needsRestart=true;await this.requestExperimentalFeaturesData();await this.updateComplete;this.clearSearch()}onSearchInput_(){assert(this.flagSearch);this.flagSearch.debounceSearch()}onClearSearchClick_(){this.clearSearch()}onSelectChange_(e){const select=e.composedPath()[0];assert(select instanceof HTMLSelectElement);this.needsRestart=true;if(this.lastChanged===select){return}this.lastChanged=select;const eventTracker=new EventTracker;eventTracker.add(select,"keydown",(e=>{if(e.key==="Tab"&&!e.shiftKey){assert(this.lastChanged===select);e.preventDefault();this.lastFocused=this.lastChanged;this.getRestartButton().focus()}}));eventTracker.add(select,"blur",(()=>{assert(this.lastChanged===select);this.lastChanged=null;eventTracker.removeAll()}))}onTextareaChange_(){this.needsRestart=true}onInputChange_(){this.needsRestart=true}onRestartButtonClick_(){FlagsBrowserProxyImpl.getInstance().restartBrowser()}getNeedsRestartRole_(){return this.needsRestart?"alert":"none"}shouldShowPromos_(){return this.data.showBetaChannelPromotion||this.data.showDevChannelPromotion}onSelectedTabIndexChanged_(e){this.selectedTabIndex_=e.detail.value}isTabSelected_(index){return index===this.selectedTabIndex_}onRestartButtonKeydown_(e){if(e.shiftKey&&e.key==="Tab"&&this.lastFocused){e.preventDefault();this.lastFocused.focus()}}onRestartButtonBlur_(){this.lastFocused=null}}customElements.define(FlagsAppElement.is,FlagsAppElement);