// components/webui/chrome_urls/mojom/chrome_urls.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SEND_VALIDATION_H_

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/webui/chrome_urls/mojom/chrome_urls.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome_urls::mojom::WebuiUrlInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome_urls::mojom::WebuiUrlInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome_urls::mojom::internal::WebuiUrlInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebuiUrlInfo struct");

      fragment->enabled = Traits::enabled(input);

      fragment->internal = Traits::internal(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome_urls::mojom::ChromeUrlsDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome_urls::mojom::ChromeUrlsDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome_urls::mojom::internal::ChromeUrlsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::webui_urls(input)) in_webui_urls = Traits::webui_urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webui_urls)::BaseType>
          webui_urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& webui_urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::chrome_urls::mojom::WebuiUrlInfoDataView>, send_validation>(
        in_webui_urls,
        webui_urls_fragment,
        &webui_urls_validate_params);

      fragment->webui_urls.Set(
          webui_urls_fragment.is_null() ? nullptr : webui_urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->webui_urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webui_urls in ChromeUrlsData struct");

      decltype(Traits::command_urls(input)) in_command_urls = Traits::command_urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->command_urls)::BaseType>
          command_urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& command_urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_command_urls,
        command_urls_fragment,
        &command_urls_validate_params);

      fragment->command_urls.Set(
          command_urls_fragment.is_null() ? nullptr : command_urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->command_urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null command_urls in ChromeUrlsData struct");

      fragment->internal_debugging_uis_enabled = Traits::internal_debugging_uis_enabled(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_WEBUI_CHROME_URLS_MOJOM_CHROME_URLS_MOJOM_SEND_VALIDATION_H_