// components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_SERVICES_WEB_APP_ORIGIN_ASSOCIATION_PUBLIC_MOJOM_WEB_APP_ORIGIN_ASSOCIATION_PARSER_MOJOM_H_
#define COMPONENTS_WEBAPPS_SERVICES_WEB_APP_ORIGIN_ASSOCIATION_PUBLIC_MOJOM_WEB_APP_ORIGIN_ASSOCIATION_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-features.h"  // IWYU pragma: export
#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-shared.h"  // IWYU pragma: export
#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace webapps::mojom {

class WebAppOriginAssociationParserProxy;

template <typename ImplRefTraits>
class WebAppOriginAssociationParserStub;

class WebAppOriginAssociationParserRequestValidator;
class WebAppOriginAssociationParserResponseValidator;


class WebAppOriginAssociationParser
    : public WebAppOriginAssociationParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webapps.mojom.WebAppOriginAssociationParser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebAppOriginAssociationParserInterfaceBase;
  using Proxy_ = WebAppOriginAssociationParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebAppOriginAssociationParserStub<ImplRefTraits>;

  using RequestValidator_ = WebAppOriginAssociationParserRequestValidator;
  using ResponseValidator_ = WebAppOriginAssociationParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseWebAppOriginAssociationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ParseWebAppOriginAssociation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebAppOriginAssociationParser() = default;

  using ParseWebAppOriginAssociationCallback = base::OnceCallback<void(WebAppOriginAssociationPtr, std::vector<WebAppOriginAssociationErrorPtr>)>;
  using ParseWebAppOriginAssociationMojoCallback = base::OnceCallback<void(WebAppOriginAssociationPtr, std::vector<WebAppOriginAssociationErrorPtr>)>;

  virtual void ParseWebAppOriginAssociation(const std::string& raw_json, const ::url::Origin& associate_origin, ParseWebAppOriginAssociationCallback callback) = 0;
};



class  WebAppOriginAssociationParserProxy
    : public WebAppOriginAssociationParser {
 public:
  using InterfaceType = WebAppOriginAssociationParser;

  explicit WebAppOriginAssociationParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ParseWebAppOriginAssociation(const std::string& raw_json, const ::url::Origin& associate_origin, ParseWebAppOriginAssociationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebAppOriginAssociationParserStubDispatch {
 public:
  static bool Accept(WebAppOriginAssociationParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebAppOriginAssociationParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebAppOriginAssociationParser>>
class WebAppOriginAssociationParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebAppOriginAssociationParserStub() = default;
  ~WebAppOriginAssociationParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebAppOriginAssociationParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebAppOriginAssociationParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebAppOriginAssociationParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebAppOriginAssociationParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  WebAppOriginAssociationError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebAppOriginAssociationError, T>::value>;
  using DataView = WebAppOriginAssociationErrorDataView;
  using Data_ = internal::WebAppOriginAssociationError_Data;

  template <typename... Args>
  static WebAppOriginAssociationErrorPtr New(Args&&... args) {
    return WebAppOriginAssociationErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebAppOriginAssociationErrorPtr From(const U& u) {
    return mojo::TypeConverter<WebAppOriginAssociationErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebAppOriginAssociationError>::Convert(*this);
  }


  WebAppOriginAssociationError();

  WebAppOriginAssociationError(
      const std::string& message,
      int32_t line,
      int32_t column);


  ~WebAppOriginAssociationError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebAppOriginAssociationErrorPtr>
  WebAppOriginAssociationErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAppOriginAssociationError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAppOriginAssociationError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebAppOriginAssociationError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebAppOriginAssociationError_UnserializedMessageContext<
            UserType, WebAppOriginAssociationError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebAppOriginAssociationError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebAppOriginAssociationError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebAppOriginAssociationError_UnserializedMessageContext<
            UserType, WebAppOriginAssociationError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebAppOriginAssociationError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string message;
  
  int32_t line;
  
  int32_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebAppOriginAssociationError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  WebAppOriginAssociation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebAppOriginAssociation, T>::value>;
  using DataView = WebAppOriginAssociationDataView;
  using Data_ = internal::WebAppOriginAssociation_Data;

  template <typename... Args>
  static WebAppOriginAssociationPtr New(Args&&... args) {
    return WebAppOriginAssociationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebAppOriginAssociationPtr From(const U& u) {
    return mojo::TypeConverter<WebAppOriginAssociationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebAppOriginAssociation>::Convert(*this);
  }


  WebAppOriginAssociation();

  explicit WebAppOriginAssociation(
      std::vector<AssociatedWebAppPtr> apps);

WebAppOriginAssociation(const WebAppOriginAssociation&) = delete;
WebAppOriginAssociation& operator=(const WebAppOriginAssociation&) = delete;

  ~WebAppOriginAssociation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebAppOriginAssociationPtr>
  WebAppOriginAssociationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAppOriginAssociation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebAppOriginAssociation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebAppOriginAssociation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebAppOriginAssociation_UnserializedMessageContext<
            UserType, WebAppOriginAssociation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebAppOriginAssociation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebAppOriginAssociation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebAppOriginAssociation_UnserializedMessageContext<
            UserType, WebAppOriginAssociation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebAppOriginAssociation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<AssociatedWebAppPtr> apps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebAppOriginAssociation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AssociatedWebApp {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AssociatedWebApp, T>::value>;
  using DataView = AssociatedWebAppDataView;
  using Data_ = internal::AssociatedWebApp_Data;

  template <typename... Args>
  static AssociatedWebAppPtr New(Args&&... args) {
    return AssociatedWebAppPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AssociatedWebAppPtr From(const U& u) {
    return mojo::TypeConverter<AssociatedWebAppPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AssociatedWebApp>::Convert(*this);
  }


  AssociatedWebApp();

  AssociatedWebApp(
      const ::GURL& web_app_identity,
      const ::GURL& scope);


  ~AssociatedWebApp();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AssociatedWebAppPtr>
  AssociatedWebAppPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AssociatedWebApp::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AssociatedWebApp::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AssociatedWebApp::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AssociatedWebApp_UnserializedMessageContext<
            UserType, AssociatedWebApp::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AssociatedWebApp::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AssociatedWebApp::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AssociatedWebApp_UnserializedMessageContext<
            UserType, AssociatedWebApp::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AssociatedWebApp::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL web_app_identity;
  
  ::GURL scope;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AssociatedWebApp::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
WebAppOriginAssociationPtr WebAppOriginAssociation::Clone() const {
  return New(
      mojo::Clone(apps)
  );
}

template <typename T, WebAppOriginAssociation::EnableIfSame<T>*>
bool WebAppOriginAssociation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->apps, other_struct.apps))
    return false;
  return true;
}

template <typename T, WebAppOriginAssociation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.apps < rhs.apps)
    return true;
  if (rhs.apps < lhs.apps)
    return false;
  return false;
}
template <typename StructPtrType>
AssociatedWebAppPtr AssociatedWebApp::Clone() const {
  return New(
      mojo::Clone(web_app_identity),
      mojo::Clone(scope)
  );
}

template <typename T, AssociatedWebApp::EnableIfSame<T>*>
bool AssociatedWebApp::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_app_identity, other_struct.web_app_identity))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  return true;
}

template <typename T, AssociatedWebApp::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_app_identity < rhs.web_app_identity)
    return true;
  if (rhs.web_app_identity < lhs.web_app_identity)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  return false;
}
template <typename StructPtrType>
WebAppOriginAssociationErrorPtr WebAppOriginAssociationError::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, WebAppOriginAssociationError::EnableIfSame<T>*>
bool WebAppOriginAssociationError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, WebAppOriginAssociationError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}


}  // webapps::mojom

namespace mojo {


template <>
struct  StructTraits<::webapps::mojom::WebAppOriginAssociation::DataView,
                                         ::webapps::mojom::WebAppOriginAssociationPtr> {
  static bool IsNull(const ::webapps::mojom::WebAppOriginAssociationPtr& input) { return !input; }
  static void SetToNull(::webapps::mojom::WebAppOriginAssociationPtr* output) { output->reset(); }

  static const decltype(::webapps::mojom::WebAppOriginAssociation::apps)& apps(
      const ::webapps::mojom::WebAppOriginAssociationPtr& input) {
    return input->apps;
  }

  static bool Read(::webapps::mojom::WebAppOriginAssociation::DataView input, ::webapps::mojom::WebAppOriginAssociationPtr* output);
};


template <>
struct  StructTraits<::webapps::mojom::AssociatedWebApp::DataView,
                                         ::webapps::mojom::AssociatedWebAppPtr> {
  static bool IsNull(const ::webapps::mojom::AssociatedWebAppPtr& input) { return !input; }
  static void SetToNull(::webapps::mojom::AssociatedWebAppPtr* output) { output->reset(); }

  static const decltype(::webapps::mojom::AssociatedWebApp::web_app_identity)& web_app_identity(
      const ::webapps::mojom::AssociatedWebAppPtr& input) {
    return input->web_app_identity;
  }

  static const decltype(::webapps::mojom::AssociatedWebApp::scope)& scope(
      const ::webapps::mojom::AssociatedWebAppPtr& input) {
    return input->scope;
  }

  static bool Read(::webapps::mojom::AssociatedWebApp::DataView input, ::webapps::mojom::AssociatedWebAppPtr* output);
};


template <>
struct  StructTraits<::webapps::mojom::WebAppOriginAssociationError::DataView,
                                         ::webapps::mojom::WebAppOriginAssociationErrorPtr> {
  static bool IsNull(const ::webapps::mojom::WebAppOriginAssociationErrorPtr& input) { return !input; }
  static void SetToNull(::webapps::mojom::WebAppOriginAssociationErrorPtr* output) { output->reset(); }

  static const decltype(::webapps::mojom::WebAppOriginAssociationError::message)& message(
      const ::webapps::mojom::WebAppOriginAssociationErrorPtr& input) {
    return input->message;
  }

  static decltype(::webapps::mojom::WebAppOriginAssociationError::line) line(
      const ::webapps::mojom::WebAppOriginAssociationErrorPtr& input) {
    return input->line;
  }

  static decltype(::webapps::mojom::WebAppOriginAssociationError::column) column(
      const ::webapps::mojom::WebAppOriginAssociationErrorPtr& input) {
    return input->column;
  }

  static bool Read(::webapps::mojom::WebAppOriginAssociationError::DataView input, ::webapps::mojom::WebAppOriginAssociationErrorPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_WEBAPPS_SERVICES_WEB_APP_ORIGIN_ASSOCIATION_PUBLIC_MOJOM_WEB_APP_ORIGIN_ASSOCIATION_PARSER_MOJOM_H_