// components/webapps/common/web_page_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_H_
#define COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webapps/common/web_page_metadata.mojom-features.h"  // IWYU pragma: export
#include "components/webapps/common/web_page_metadata.mojom-shared.h"  // IWYU pragma: export
#include "components/webapps/common/web_page_metadata.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace webapps::mojom {









class  WebPageIconInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPageIconInfo, T>::value>;
  using DataView = WebPageIconInfoDataView;
  using Data_ = internal::WebPageIconInfo_Data;

  template <typename... Args>
  static WebPageIconInfoPtr New(Args&&... args) {
    return WebPageIconInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPageIconInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebPageIconInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPageIconInfo>::Convert(*this);
  }


  WebPageIconInfo();

  WebPageIconInfo(
      const ::GURL& url,
      int32_t square_size_px);


  ~WebPageIconInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPageIconInfoPtr>
  WebPageIconInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageIconInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageIconInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPageIconInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPageIconInfo_UnserializedMessageContext<
            UserType, WebPageIconInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPageIconInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPageIconInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPageIconInfo_UnserializedMessageContext<
            UserType, WebPageIconInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPageIconInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  int32_t square_size_px;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPageIconInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebPageMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPageMetadata, T>::value>;
  using DataView = WebPageMetadataDataView;
  using Data_ = internal::WebPageMetadata_Data;

  template <typename... Args>
  static WebPageMetadataPtr New(Args&&... args) {
    return WebPageMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPageMetadataPtr From(const U& u) {
    return mojo::TypeConverter<WebPageMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPageMetadata>::Convert(*this);
  }


  WebPageMetadata();

  WebPageMetadata(
      const ::std::u16string& application_name,
      const ::std::u16string& description,
      const ::GURL& application_url,
      const ::std::u16string& title,
      std::vector<WebPageIconInfoPtr> icons,
      WebPageMobileCapable mobile_capable);

WebPageMetadata(const WebPageMetadata&) = delete;
WebPageMetadata& operator=(const WebPageMetadata&) = delete;

  ~WebPageMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPageMetadataPtr>
  WebPageMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPageMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPageMetadata_UnserializedMessageContext<
            UserType, WebPageMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPageMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPageMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPageMetadata_UnserializedMessageContext<
            UserType, WebPageMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPageMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string application_name;
  
  ::std::u16string description;
  
  ::GURL application_url;
  
  ::std::u16string title;
  
  std::vector<WebPageIconInfoPtr> icons;
  
  WebPageMobileCapable mobile_capable;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPageMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebPageIconInfoPtr WebPageIconInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(square_size_px)
  );
}

template <typename T, WebPageIconInfo::EnableIfSame<T>*>
bool WebPageIconInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->square_size_px, other_struct.square_size_px))
    return false;
  return true;
}

template <typename T, WebPageIconInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.square_size_px < rhs.square_size_px)
    return true;
  if (rhs.square_size_px < lhs.square_size_px)
    return false;
  return false;
}
template <typename StructPtrType>
WebPageMetadataPtr WebPageMetadata::Clone() const {
  return New(
      mojo::Clone(application_name),
      mojo::Clone(description),
      mojo::Clone(application_url),
      mojo::Clone(title),
      mojo::Clone(icons),
      mojo::Clone(mobile_capable)
  );
}

template <typename T, WebPageMetadata::EnableIfSame<T>*>
bool WebPageMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->application_name, other_struct.application_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->application_url, other_struct.application_url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->mobile_capable, other_struct.mobile_capable))
    return false;
  return true;
}

template <typename T, WebPageMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.application_name < rhs.application_name)
    return true;
  if (rhs.application_name < lhs.application_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.application_url < rhs.application_url)
    return true;
  if (rhs.application_url < lhs.application_url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.mobile_capable < rhs.mobile_capable)
    return true;
  if (rhs.mobile_capable < lhs.mobile_capable)
    return false;
  return false;
}


}  // webapps::mojom

namespace mojo {


template <>
struct  StructTraits<::webapps::mojom::WebPageIconInfo::DataView,
                                         ::webapps::mojom::WebPageIconInfoPtr> {
  static bool IsNull(const ::webapps::mojom::WebPageIconInfoPtr& input) { return !input; }
  static void SetToNull(::webapps::mojom::WebPageIconInfoPtr* output) { output->reset(); }

  static const decltype(::webapps::mojom::WebPageIconInfo::url)& url(
      const ::webapps::mojom::WebPageIconInfoPtr& input) {
    return input->url;
  }

  static decltype(::webapps::mojom::WebPageIconInfo::square_size_px) square_size_px(
      const ::webapps::mojom::WebPageIconInfoPtr& input) {
    return input->square_size_px;
  }

  static bool Read(::webapps::mojom::WebPageIconInfo::DataView input, ::webapps::mojom::WebPageIconInfoPtr* output);
};


template <>
struct  StructTraits<::webapps::mojom::WebPageMetadata::DataView,
                                         ::webapps::mojom::WebPageMetadataPtr> {
  static bool IsNull(const ::webapps::mojom::WebPageMetadataPtr& input) { return !input; }
  static void SetToNull(::webapps::mojom::WebPageMetadataPtr* output) { output->reset(); }

  static const decltype(::webapps::mojom::WebPageMetadata::application_name)& application_name(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->application_name;
  }

  static const decltype(::webapps::mojom::WebPageMetadata::description)& description(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->description;
  }

  static const decltype(::webapps::mojom::WebPageMetadata::application_url)& application_url(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->application_url;
  }

  static const decltype(::webapps::mojom::WebPageMetadata::title)& title(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->title;
  }

  static const decltype(::webapps::mojom::WebPageMetadata::icons)& icons(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->icons;
  }

  static decltype(::webapps::mojom::WebPageMetadata::mobile_capable) mobile_capable(
      const ::webapps::mojom::WebPageMetadataPtr& input) {
    return input->mobile_capable;
  }

  static bool Read(::webapps::mojom::WebPageMetadata::DataView input, ::webapps::mojom::WebPageMetadataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_H_