// components/user_data_importer/mojom/bookmark_html_parser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/user_data_importer/mojom/bookmark_html_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace user_data_importer::mojom {
class ImportedBookmarkEntryDataView;

class SearchEngineInfoDataView;

class FaviconUsageDataDataView;

class ParsedBookmarksDataView;



}  // user_data_importer::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::user_data_importer::mojom::ImportedBookmarkEntryDataView> {
  using Data = ::user_data_importer::mojom::internal::ImportedBookmarkEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::user_data_importer::mojom::SearchEngineInfoDataView> {
  using Data = ::user_data_importer::mojom::internal::SearchEngineInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::user_data_importer::mojom::FaviconUsageDataDataView> {
  using Data = ::user_data_importer::mojom::internal::FaviconUsageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::user_data_importer::mojom::ParsedBookmarksDataView> {
  using Data = ::user_data_importer::mojom::internal::ParsedBookmarks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace user_data_importer::mojom {
// Interface base classes. They are used for type safety check.
class BookmarkHtmlParserInterfaceBase {};

using BookmarkHtmlParserPtrDataView =
    mojo::InterfacePtrDataView<BookmarkHtmlParserInterfaceBase>;
using BookmarkHtmlParserRequestDataView =
    mojo::InterfaceRequestDataView<BookmarkHtmlParserInterfaceBase>;
using BookmarkHtmlParserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarkHtmlParserInterfaceBase>;
using BookmarkHtmlParserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarkHtmlParserInterfaceBase>;


class ImportedBookmarkEntryDataView {
 public:
  ImportedBookmarkEntryDataView() = default;

  ImportedBookmarkEntryDataView(
      internal::ImportedBookmarkEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_folder() const {
    return data_->is_folder;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastVisitTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastVisitTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_visit_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastVisitTime` instead "
    "of `ReadLastVisitTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_visit_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  bool in_toolbar() const {
    return data_->in_toolbar;
  }
 private:
  internal::ImportedBookmarkEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SearchEngineInfoDataView {
 public:
  SearchEngineInfoDataView() = default;

  SearchEngineInfoDataView(
      internal::SearchEngineInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetKeywordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyword(UserType* output) {
    
    auto* pointer = data_->keyword.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SearchEngineInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FaviconUsageDataDataView {
 public:
  FaviconUsageDataDataView() = default;

  FaviconUsageDataDataView(
      internal::FaviconUsageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPngDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPngData(UserType* output) {
    
    auto* pointer = data_->png_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FaviconUsageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParsedBookmarksDataView {
 public:
  ParsedBookmarksDataView() = default;

  ParsedBookmarksDataView(
      internal::ParsedBookmarks_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBookmarksDataView(
      mojo::ArrayDataView<ImportedBookmarkEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBookmarks(UserType* output) {
    
    auto* pointer = data_->bookmarks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::user_data_importer::mojom::ImportedBookmarkEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetReadingListDataView(
      mojo::ArrayDataView<ImportedBookmarkEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadingList(UserType* output) {
    
    auto* pointer = data_->reading_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::user_data_importer::mojom::ImportedBookmarkEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetSearchEnginesDataView(
      mojo::ArrayDataView<SearchEngineInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchEngines(UserType* output) {
    
    auto* pointer = data_->search_engines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::user_data_importer::mojom::SearchEngineInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetFaviconsDataView(
      mojo::ArrayDataView<FaviconUsageDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFavicons(UserType* output) {
    
    auto* pointer = data_->favicons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::user_data_importer::mojom::FaviconUsageDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ParsedBookmarks_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // user_data_importer::mojom

#endif  // COMPONENTS_USER_DATA_IMPORTER_MOJOM_BOOKMARK_HTML_PARSER_MOJOM_DATA_VIEW_H_