// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ui_devtools_protocol_Overlay_h
#define ui_devtools_protocol_Overlay_h

#include "components/ui_devtools/devtools_export.h"
#include "components/ui_devtools/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "components/ui_devtools/dom.h"
#include "components/ui_devtools/page.h"

namespace ui_devtools {
namespace protocol {
namespace Overlay {
class HighlightConfig;
using InspectMode = String;

// ------------- Forward and enum declarations.

namespace InspectModeEnum {
UI_DEVTOOLS_EXPORT extern const char SearchForNode[];
UI_DEVTOOLS_EXPORT extern const char SearchForUAShadowDOM[];
UI_DEVTOOLS_EXPORT extern const char None[];
} // namespace InspectModeEnum

// ------------- Type and builder declarations.

class UI_DEVTOOLS_EXPORT HighlightConfig : public ::crdtp::ProtocolObject<HighlightConfig> {
public:
    ~HighlightConfig() override { }

    bool hasShowInfo() { return !!m_showInfo; }
    bool getShowInfo(bool defaultValue) const {
       return m_showInfo.value_or(defaultValue);
    }
    const std::optional<bool>& getShowInfo() const {
       return m_showInfo;
    }
    void setShowInfo(bool value) { m_showInfo = value; }

    bool hasShowRulers() { return !!m_showRulers; }
    bool getShowRulers(bool defaultValue) const {
       return m_showRulers.value_or(defaultValue);
    }
    const std::optional<bool>& getShowRulers() const {
       return m_showRulers;
    }
    void setShowRulers(bool value) { m_showRulers = value; }

    bool hasShowExtensionLines() { return !!m_showExtensionLines; }
    bool getShowExtensionLines(bool defaultValue) const {
       return m_showExtensionLines.value_or(defaultValue);
    }
    const std::optional<bool>& getShowExtensionLines() const {
       return m_showExtensionLines;
    }
    void setShowExtensionLines(bool value) { m_showExtensionLines = value; }

    bool hasDisplayAsMaterial() { return !!m_displayAsMaterial; }
    bool getDisplayAsMaterial(bool defaultValue) const {
       return m_displayAsMaterial.value_or(defaultValue);
    }
    const std::optional<bool>& getDisplayAsMaterial() const {
       return m_displayAsMaterial;
    }
    void setDisplayAsMaterial(bool value) { m_displayAsMaterial = value; }

    bool hasContentColor() { return !!m_contentColor; }
    protocol::DOM::RGBA* getContentColor(protocol::DOM::RGBA* defaultValue) {
       return m_contentColor ? m_contentColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getContentColor() const {
       return m_contentColor;
    }
    void setContentColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_contentColor = std::move(value); }

    bool hasPaddingColor() { return !!m_paddingColor; }
    protocol::DOM::RGBA* getPaddingColor(protocol::DOM::RGBA* defaultValue) {
       return m_paddingColor ? m_paddingColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getPaddingColor() const {
       return m_paddingColor;
    }
    void setPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_paddingColor = std::move(value); }

    bool hasBorderColor() { return !!m_borderColor; }
    protocol::DOM::RGBA* getBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_borderColor ? m_borderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getBorderColor() const {
       return m_borderColor;
    }
    void setBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_borderColor = std::move(value); }

    bool hasMarginColor() { return !!m_marginColor; }
    protocol::DOM::RGBA* getMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_marginColor ? m_marginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getMarginColor() const {
       return m_marginColor;
    }
    void setMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_marginColor = std::move(value); }

    bool hasEventTargetColor() { return !!m_eventTargetColor; }
    protocol::DOM::RGBA* getEventTargetColor(protocol::DOM::RGBA* defaultValue) {
       return m_eventTargetColor ? m_eventTargetColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getEventTargetColor() const {
       return m_eventTargetColor;
    }
    void setEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_eventTargetColor = std::move(value); }

    bool hasShapeColor() { return !!m_shapeColor; }
    protocol::DOM::RGBA* getShapeColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeColor ? m_shapeColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getShapeColor() const {
       return m_shapeColor;
    }
    void setShapeColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeColor = std::move(value); }

    bool hasShapeMarginColor() { return !!m_shapeMarginColor; }
    protocol::DOM::RGBA* getShapeMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeMarginColor ? m_shapeMarginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getShapeMarginColor() const {
       return m_shapeMarginColor;
    }
    void setShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeMarginColor = std::move(value); }

    bool hasSelectorList() { return !!m_selectorList; }
    String getSelectorList(const String& defaultValue) const {
       return m_selectorList.value_or(defaultValue);
    }
    const std::optional<String>& getSelectorList() const {
       return m_selectorList;
    }
    void setSelectorList(const String& value) { m_selectorList = value; }

    template<int STATE>
    class HighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        HighlightConfigBuilder<STATE>& setShowInfo(bool value)
        {
            m_result->setShowInfo(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowRulers(bool value)
        {
            m_result->setShowRulers(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowExtensionLines(bool value)
        {
            m_result->setShowExtensionLines(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setDisplayAsMaterial(bool value)
        {
            m_result->setDisplayAsMaterial(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setContentColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setContentColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setPaddingColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setBorderColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setEventTargetColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShapeColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setShapeColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setShapeMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setSelectorList(const String& value)
        {
            m_result->setSelectorList(value);
            return *this;
        }

        std::unique_ptr<HighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HighlightConfig;
        HighlightConfigBuilder() : m_result(new HighlightConfig()) { }

        template<int STEP> HighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::HighlightConfig> m_result;
    };

    static HighlightConfigBuilder<0> create()
    {
        return HighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HighlightConfig()
    {
    }

    std::optional<bool> m_showInfo;
    std::optional<bool> m_showRulers;
    std::optional<bool> m_showExtensionLines;
    std::optional<bool> m_displayAsMaterial;
    std::unique_ptr<protocol::DOM::RGBA> m_contentColor;
    std::unique_ptr<protocol::DOM::RGBA> m_paddingColor;
    std::unique_ptr<protocol::DOM::RGBA> m_borderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_marginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_eventTargetColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeMarginColor;
    std::optional<String> m_selectorList;
};


// ------------- Backend interface.

class UI_DEVTOOLS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse hideHighlight() = 0;
    virtual DispatchResponse highlightNode(std::unique_ptr<protocol::Overlay::HighlightConfig> in_highlightConfig, std::optional<int> in_nodeId) = 0;
    virtual DispatchResponse setInspectMode(const String& in_mode, std::unique_ptr<protocol::Overlay::HighlightConfig> in_highlightConfig) = 0;

};

// ------------- Frontend interface.

class UI_DEVTOOLS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void inspectNodeRequested(int backendNodeId);
    void nodeHighlightRequested(int nodeId);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class UI_DEVTOOLS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class UI_DEVTOOLS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Overlay
} // namespace ui_devtools
} // namespace protocol

#endif // !defined(ui_devtools_protocol_Overlay_h)
