// components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-params-data.h"
#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-shared-message-ids.h"

#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-import-headers.h"
#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-test-utils.h"


namespace system_media_controls::mojom {
// The declaration includes the definition on other builds.

SystemMediaControls::IPCStableHashFunction SystemMediaControls::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemMediaControls>(message.name())) {
    case messages::SystemMediaControls::kSetIsNextEnabled: {
      return &SystemMediaControls::SetIsNextEnabled_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetIsPreviousEnabled: {
      return &SystemMediaControls::SetIsPreviousEnabled_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetIsPlayPauseEnabled: {
      return &SystemMediaControls::SetIsPlayPauseEnabled_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetIsStopEnabled: {
      return &SystemMediaControls::SetIsStopEnabled_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetIsSeekToEnabled: {
      return &SystemMediaControls::SetIsSeekToEnabled_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetPlaybackStatus: {
      return &SystemMediaControls::SetPlaybackStatus_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetTitle: {
      return &SystemMediaControls::SetTitle_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetArtist: {
      return &SystemMediaControls::SetArtist_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetAlbum: {
      return &SystemMediaControls::SetAlbum_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetThumbnail: {
      return &SystemMediaControls::SetThumbnail_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kSetPosition: {
      return &SystemMediaControls::SetPosition_Sym::IPCStableHash;
    }
    case messages::SystemMediaControls::kClearMetadata: {
      return &SystemMediaControls::ClearMetadata_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemMediaControls::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemMediaControls>(message.name())) {
      case messages::SystemMediaControls::kSetIsNextEnabled:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetIsNextEnabled";
      case messages::SystemMediaControls::kSetIsPreviousEnabled:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetIsPreviousEnabled";
      case messages::SystemMediaControls::kSetIsPlayPauseEnabled:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetIsPlayPauseEnabled";
      case messages::SystemMediaControls::kSetIsStopEnabled:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetIsStopEnabled";
      case messages::SystemMediaControls::kSetIsSeekToEnabled:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetIsSeekToEnabled";
      case messages::SystemMediaControls::kSetPlaybackStatus:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetPlaybackStatus";
      case messages::SystemMediaControls::kSetTitle:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetTitle";
      case messages::SystemMediaControls::kSetArtist:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetArtist";
      case messages::SystemMediaControls::kSetAlbum:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetAlbum";
      case messages::SystemMediaControls::kSetThumbnail:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetThumbnail";
      case messages::SystemMediaControls::kSetPosition:
            return "Receive system_media_controls::mojom::SystemMediaControls::SetPosition";
      case messages::SystemMediaControls::kClearMetadata:
            return "Receive system_media_controls::mojom::SystemMediaControls::ClearMetadata";
    }
  } else {
    switch (static_cast<messages::SystemMediaControls>(message.name())) {
      case messages::SystemMediaControls::kSetIsNextEnabled:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetIsNextEnabled";
      case messages::SystemMediaControls::kSetIsPreviousEnabled:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetIsPreviousEnabled";
      case messages::SystemMediaControls::kSetIsPlayPauseEnabled:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetIsPlayPauseEnabled";
      case messages::SystemMediaControls::kSetIsStopEnabled:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetIsStopEnabled";
      case messages::SystemMediaControls::kSetIsSeekToEnabled:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetIsSeekToEnabled";
      case messages::SystemMediaControls::kSetPlaybackStatus:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetPlaybackStatus";
      case messages::SystemMediaControls::kSetTitle:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetTitle";
      case messages::SystemMediaControls::kSetArtist:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetArtist";
      case messages::SystemMediaControls::kSetAlbum:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetAlbum";
      case messages::SystemMediaControls::kSetThumbnail:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetThumbnail";
      case messages::SystemMediaControls::kSetPosition:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::SetPosition";
      case messages::SystemMediaControls::kClearMetadata:
            return "Receive reply system_media_controls::mojom::SystemMediaControls::ClearMetadata";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemMediaControls::SetIsNextEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x371549de;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetIsNextEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetIsPreviousEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8c1c919;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetIsPreviousEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetIsPlayPauseEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaeb44cb9;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetIsPlayPauseEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetIsStopEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x514855e2;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetIsStopEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetIsSeekToEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e752ad6;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetIsSeekToEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetPlaybackStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e0584cc;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetPlaybackStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b8ff6c7;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetArtist_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c7893ec;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetArtist
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetAlbum_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96266853;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetAlbum
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetThumbnail_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbccade3;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetThumbnail
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::SetPosition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9d0d018;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::SetPosition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControls::ClearMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ef02472;  // IPCStableHash for system_media_controls::mojom::SystemMediaControls::ClearMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SystemMediaControlsProxy::SystemMediaControlsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemMediaControlsProxy::SetIsNextEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetIsNextEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetIsNextEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetIsNextEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetIsNextEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetIsPreviousEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetIsPreviousEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetIsPreviousEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetIsPreviousEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetIsPreviousEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetIsPlayPauseEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetIsPlayPauseEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetIsPlayPauseEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetIsPlayPauseEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetIsPlayPauseEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetIsStopEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetIsStopEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetIsStopEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetIsStopEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetIsStopEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetIsSeekToEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetIsSeekToEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetIsSeekToEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetIsSeekToEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetIsSeekToEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetPlaybackStatus(
    PlaybackStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetPlaybackStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PlaybackStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetPlaybackStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetPlaybackStatus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::system_media_controls::mojom::PlaybackStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetPlaybackStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetTitle(
    const ::std::u16string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in SystemMediaControls.SetTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetArtist(
    const ::std::u16string& in_artist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetArtist", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("artist"), in_artist,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetArtist), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetArtist_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->artist)::BaseType> artist_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_artist,
    artist_fragment);

  params->artist.Set(
      artist_fragment.is_null() ? nullptr : artist_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->artist.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null artist in SystemMediaControls.SetArtist request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetArtist");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetAlbum(
    const ::std::u16string& in_album) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetAlbum", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("album"), in_album,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetAlbum), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetAlbum_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->album)::BaseType> album_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_album,
    album_fragment);

  params->album.Set(
      album_fragment.is_null() ? nullptr : album_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->album.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null album in SystemMediaControls.SetAlbum request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetAlbum");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetThumbnail(
    const ::SkBitmap& in_thumbnail) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetThumbnail", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thumbnail"), in_thumbnail,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetThumbnail), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetThumbnail_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->thumbnail)::BaseType> thumbnail_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
    in_thumbnail,
    thumbnail_fragment);

  params->thumbnail.Set(
      thumbnail_fragment.is_null() ? nullptr : thumbnail_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->thumbnail.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null thumbnail in SystemMediaControls.SetThumbnail request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetThumbnail");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::SetPosition(
    const ::media_session::MediaPosition& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControls::SetPosition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const ::media_session::MediaPosition&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kSetPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_SetPosition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
    in_position,
    position_fragment);

  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->position.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null position in SystemMediaControls.SetPosition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("SetPosition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsProxy::ClearMetadata(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControls::ClearMetadata");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControls::kClearMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControls_ClearMetadata_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControls::Name_);
  message.set_method_name("ClearMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SystemMediaControlsStubDispatch::Accept(
    SystemMediaControls* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemMediaControls>(message->header()->name)) {
    case messages::SystemMediaControls::kSetIsNextEnabled: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetIsNextEnabled_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetIsNextEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.0
      bool success = true;
      bool p_enabled{};
      SystemMediaControls_SetIsNextEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsNextEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::SystemMediaControls::kSetIsPreviousEnabled: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetIsPreviousEnabled_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetIsPreviousEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.1
      bool success = true;
      bool p_enabled{};
      SystemMediaControls_SetIsPreviousEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsPreviousEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::SystemMediaControls::kSetIsPlayPauseEnabled: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetIsPlayPauseEnabled_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetIsPlayPauseEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.2
      bool success = true;
      bool p_enabled{};
      SystemMediaControls_SetIsPlayPauseEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsPlayPauseEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::SystemMediaControls::kSetIsStopEnabled: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetIsStopEnabled_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetIsStopEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.3
      bool success = true;
      bool p_enabled{};
      SystemMediaControls_SetIsStopEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsStopEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::SystemMediaControls::kSetIsSeekToEnabled: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetIsSeekToEnabled_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetIsSeekToEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.4
      bool success = true;
      bool p_enabled{};
      SystemMediaControls_SetIsSeekToEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsSeekToEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::SystemMediaControls::kSetPlaybackStatus: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetPlaybackStatus_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetPlaybackStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.5
      bool success = true;
      PlaybackStatus p_status{};
      SystemMediaControls_SetPlaybackStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackStatus(        
        std::move(p_status));
      return true;
    }
    case messages::SystemMediaControls::kSetTitle: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetTitle_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.6
      bool success = true;
      ::std::u16string p_title{};
      SystemMediaControls_SetTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTitle(        
        std::move(p_title));
      return true;
    }
    case messages::SystemMediaControls::kSetArtist: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetArtist_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetArtist_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.7
      bool success = true;
      ::std::u16string p_artist{};
      SystemMediaControls_SetArtist_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArtist(&p_artist))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetArtist(        
        std::move(p_artist));
      return true;
    }
    case messages::SystemMediaControls::kSetAlbum: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetAlbum_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetAlbum_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.8
      bool success = true;
      ::std::u16string p_album{};
      SystemMediaControls_SetAlbum_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAlbum(&p_album))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAlbum(        
        std::move(p_album));
      return true;
    }
    case messages::SystemMediaControls::kSetThumbnail: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetThumbnail_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetThumbnail_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.9
      bool success = true;
      ::SkBitmap p_thumbnail{};
      SystemMediaControls_SetThumbnail_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThumbnail(&p_thumbnail))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThumbnail(        
        std::move(p_thumbnail));
      return true;
    }
    case messages::SystemMediaControls::kSetPosition: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_SetPosition_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_SetPosition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.10
      bool success = true;
      ::media_session::MediaPosition p_position{};
      SystemMediaControls_SetPosition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPosition(        
        std::move(p_position));
      return true;
    }
    case messages::SystemMediaControls::kClearMetadata: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControls_ClearMetadata_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControls_ClearMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControls.11
      bool success = true;
      SystemMediaControls_ClearMetadata_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControls::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearMetadata(        );
      return true;
    }
  }
  return false;
}

// static
bool SystemMediaControlsStubDispatch::AcceptWithResponder(
    SystemMediaControls* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemMediaControls>(message->header()->name)) {
    case messages::SystemMediaControls::kSetIsNextEnabled: {
      break;
    }
    case messages::SystemMediaControls::kSetIsPreviousEnabled: {
      break;
    }
    case messages::SystemMediaControls::kSetIsPlayPauseEnabled: {
      break;
    }
    case messages::SystemMediaControls::kSetIsStopEnabled: {
      break;
    }
    case messages::SystemMediaControls::kSetIsSeekToEnabled: {
      break;
    }
    case messages::SystemMediaControls::kSetPlaybackStatus: {
      break;
    }
    case messages::SystemMediaControls::kSetTitle: {
      break;
    }
    case messages::SystemMediaControls::kSetArtist: {
      break;
    }
    case messages::SystemMediaControls::kSetAlbum: {
      break;
    }
    case messages::SystemMediaControls::kSetThumbnail: {
      break;
    }
    case messages::SystemMediaControls::kSetPosition: {
      break;
    }
    case messages::SystemMediaControls::kClearMetadata: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSystemMediaControlsValidationInfo[] = {
    { &internal::SystemMediaControls_SetIsNextEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetIsPreviousEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetIsPlayPauseEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetIsStopEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetIsSeekToEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetPlaybackStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetArtist_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetAlbum_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetThumbnail_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_SetPosition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControls_ClearMetadata_Params_Data::Validate,
     nullptr /* no response */},
};

bool SystemMediaControlsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::system_media_controls::mojom::SystemMediaControls::Name_,
    kSystemMediaControlsValidationInfo);
}

// The declaration includes the definition on other builds.

SystemMediaControlsObserver::IPCStableHashFunction SystemMediaControlsObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemMediaControlsObserver>(message.name())) {
    case messages::SystemMediaControlsObserver::kOnNext: {
      return &SystemMediaControlsObserver::OnNext_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnPrevious: {
      return &SystemMediaControlsObserver::OnPrevious_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnPause: {
      return &SystemMediaControlsObserver::OnPause_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnPlayPause: {
      return &SystemMediaControlsObserver::OnPlayPause_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnStop: {
      return &SystemMediaControlsObserver::OnStop_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnPlay: {
      return &SystemMediaControlsObserver::OnPlay_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnSeekTo: {
      return &SystemMediaControlsObserver::OnSeekTo_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting: {
      return &SystemMediaControlsObserver::OnBridgeCreatedForTesting_Sym::IPCStableHash;
    }
    case messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting: {
      return &SystemMediaControlsObserver::OnMetadataClearedForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemMediaControlsObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemMediaControlsObserver>(message.name())) {
      case messages::SystemMediaControlsObserver::kOnNext:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnNext";
      case messages::SystemMediaControlsObserver::kOnPrevious:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnPrevious";
      case messages::SystemMediaControlsObserver::kOnPause:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnPause";
      case messages::SystemMediaControlsObserver::kOnPlayPause:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnPlayPause";
      case messages::SystemMediaControlsObserver::kOnStop:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnStop";
      case messages::SystemMediaControlsObserver::kOnPlay:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnPlay";
      case messages::SystemMediaControlsObserver::kOnSeekTo:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnSeekTo";
      case messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnBridgeCreatedForTesting";
      case messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting:
            return "Receive system_media_controls::mojom::SystemMediaControlsObserver::OnMetadataClearedForTesting";
    }
  } else {
    switch (static_cast<messages::SystemMediaControlsObserver>(message.name())) {
      case messages::SystemMediaControlsObserver::kOnNext:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnNext";
      case messages::SystemMediaControlsObserver::kOnPrevious:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnPrevious";
      case messages::SystemMediaControlsObserver::kOnPause:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnPause";
      case messages::SystemMediaControlsObserver::kOnPlayPause:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnPlayPause";
      case messages::SystemMediaControlsObserver::kOnStop:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnStop";
      case messages::SystemMediaControlsObserver::kOnPlay:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnPlay";
      case messages::SystemMediaControlsObserver::kOnSeekTo:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnSeekTo";
      case messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnBridgeCreatedForTesting";
      case messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting:
            return "Receive reply system_media_controls::mojom::SystemMediaControlsObserver::OnMetadataClearedForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemMediaControlsObserver::OnNext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64cfcbaf;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnNext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnPrevious_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd505e7e;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnPrevious
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnPause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2addedc7;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnPause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnPlayPause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a83c153;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnPlayPause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnStop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47817c34;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnStop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnPlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff68ae28;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnPlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnSeekTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d0d61f7;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnSeekTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnBridgeCreatedForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcdbe1c9;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnBridgeCreatedForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemMediaControlsObserver::OnMetadataClearedForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc21342c6;  // IPCStableHash for system_media_controls::mojom::SystemMediaControlsObserver::OnMetadataClearedForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SystemMediaControlsObserverProxy::SystemMediaControlsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemMediaControlsObserverProxy::OnNext(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnNext");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnNext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnNext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnNext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnPrevious(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnPrevious");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnPrevious), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnPrevious_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnPrevious");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnPause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnPause");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnPause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnPause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnPlayPause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnPlayPause");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnPlayPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnPlayPause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnPlayPause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnStop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnStop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnStop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnStop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnPlay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnPlay");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnPlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnPlay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnPlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnSeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnSeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnSeekTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnSeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_seek_time,
    seek_time_fragment);

  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seek_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seek_time in SystemMediaControlsObserver.OnSeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnSeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnBridgeCreatedForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnBridgeCreatedForTesting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnBridgeCreatedForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SystemMediaControlsObserverProxy::OnMetadataClearedForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send system_media_controls::mojom::SystemMediaControlsObserver::OnMetadataClearedForTesting");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::system_media_controls::mojom::internal::SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemMediaControlsObserver::Name_);
  message.set_method_name("OnMetadataClearedForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SystemMediaControlsObserverStubDispatch::Accept(
    SystemMediaControlsObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemMediaControlsObserver>(message->header()->name)) {
    case messages::SystemMediaControlsObserver::kOnNext: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnNext_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnNext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.0
      bool success = true;
      SystemMediaControlsObserver_OnNext_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNext(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnPrevious: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnPrevious_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnPrevious_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.1
      bool success = true;
      SystemMediaControlsObserver_OnPrevious_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrevious(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnPause: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnPause_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnPause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.2
      bool success = true;
      SystemMediaControlsObserver_OnPause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPause(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnPlayPause: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnPlayPause_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnPlayPause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.3
      bool success = true;
      SystemMediaControlsObserver_OnPlayPause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPlayPause(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnStop: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnStop_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnStop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.4
      bool success = true;
      SystemMediaControlsObserver_OnStop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStop(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnPlay: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnPlay_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnPlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.5
      bool success = true;
      SystemMediaControlsObserver_OnPlay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPlay(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnSeekTo: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnSeekTo_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnSeekTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.6
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      SystemMediaControlsObserver_OnSeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSeekTo(        
        std::move(p_seek_time));
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.7
      bool success = true;
      SystemMediaControlsObserver_OnBridgeCreatedForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBridgeCreatedForTesting(        );
      return true;
    }
    case messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting: {
      DCHECK(message->is_serialized());
      internal::SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data* params =
          reinterpret_cast<internal::SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SystemMediaControlsObserver.8
      bool success = true;
      SystemMediaControlsObserver_OnMetadataClearedForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemMediaControlsObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMetadataClearedForTesting(        );
      return true;
    }
  }
  return false;
}

// static
bool SystemMediaControlsObserverStubDispatch::AcceptWithResponder(
    SystemMediaControlsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemMediaControlsObserver>(message->header()->name)) {
    case messages::SystemMediaControlsObserver::kOnNext: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnPrevious: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnPause: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnPlayPause: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnStop: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnPlay: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnSeekTo: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnBridgeCreatedForTesting: {
      break;
    }
    case messages::SystemMediaControlsObserver::kOnMetadataClearedForTesting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSystemMediaControlsObserverValidationInfo[] = {
    { &internal::SystemMediaControlsObserver_OnNext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnPrevious_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnPause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnPlayPause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnStop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnPlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnSeekTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnBridgeCreatedForTesting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SystemMediaControlsObserver_OnMetadataClearedForTesting_Params_Data::Validate,
     nullptr /* no response */},
};

bool SystemMediaControlsObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::system_media_controls::mojom::SystemMediaControlsObserver::Name_,
    kSystemMediaControlsObserverValidationInfo);
}



}  // system_media_controls::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace system_media_controls::mojom {


void SystemMediaControlsInterceptorForTesting::SetIsNextEnabled(bool enabled) {
  GetForwardingInterface()->SetIsNextEnabled(
    std::move(enabled)
    );
}
void SystemMediaControlsInterceptorForTesting::SetIsPreviousEnabled(bool enabled) {
  GetForwardingInterface()->SetIsPreviousEnabled(
    std::move(enabled)
    );
}
void SystemMediaControlsInterceptorForTesting::SetIsPlayPauseEnabled(bool enabled) {
  GetForwardingInterface()->SetIsPlayPauseEnabled(
    std::move(enabled)
    );
}
void SystemMediaControlsInterceptorForTesting::SetIsStopEnabled(bool enabled) {
  GetForwardingInterface()->SetIsStopEnabled(
    std::move(enabled)
    );
}
void SystemMediaControlsInterceptorForTesting::SetIsSeekToEnabled(bool enabled) {
  GetForwardingInterface()->SetIsSeekToEnabled(
    std::move(enabled)
    );
}
void SystemMediaControlsInterceptorForTesting::SetPlaybackStatus(PlaybackStatus status) {
  GetForwardingInterface()->SetPlaybackStatus(
    std::move(status)
    );
}
void SystemMediaControlsInterceptorForTesting::SetTitle(const ::std::u16string& title) {
  GetForwardingInterface()->SetTitle(
    std::move(title)
    );
}
void SystemMediaControlsInterceptorForTesting::SetArtist(const ::std::u16string& artist) {
  GetForwardingInterface()->SetArtist(
    std::move(artist)
    );
}
void SystemMediaControlsInterceptorForTesting::SetAlbum(const ::std::u16string& album) {
  GetForwardingInterface()->SetAlbum(
    std::move(album)
    );
}
void SystemMediaControlsInterceptorForTesting::SetThumbnail(const ::SkBitmap& thumbnail) {
  GetForwardingInterface()->SetThumbnail(
    std::move(thumbnail)
    );
}
void SystemMediaControlsInterceptorForTesting::SetPosition(const ::media_session::MediaPosition& position) {
  GetForwardingInterface()->SetPosition(
    std::move(position)
    );
}
void SystemMediaControlsInterceptorForTesting::ClearMetadata() {
  GetForwardingInterface()->ClearMetadata();
}
SystemMediaControlsAsyncWaiter::SystemMediaControlsAsyncWaiter(
    SystemMediaControls* proxy) : proxy_(proxy) {}

SystemMediaControlsAsyncWaiter::~SystemMediaControlsAsyncWaiter() = default;





void SystemMediaControlsObserverInterceptorForTesting::OnNext() {
  GetForwardingInterface()->OnNext();
}
void SystemMediaControlsObserverInterceptorForTesting::OnPrevious() {
  GetForwardingInterface()->OnPrevious();
}
void SystemMediaControlsObserverInterceptorForTesting::OnPause() {
  GetForwardingInterface()->OnPause();
}
void SystemMediaControlsObserverInterceptorForTesting::OnPlayPause() {
  GetForwardingInterface()->OnPlayPause();
}
void SystemMediaControlsObserverInterceptorForTesting::OnStop() {
  GetForwardingInterface()->OnStop();
}
void SystemMediaControlsObserverInterceptorForTesting::OnPlay() {
  GetForwardingInterface()->OnPlay();
}
void SystemMediaControlsObserverInterceptorForTesting::OnSeekTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->OnSeekTo(
    std::move(seek_time)
    );
}
void SystemMediaControlsObserverInterceptorForTesting::OnBridgeCreatedForTesting() {
  GetForwardingInterface()->OnBridgeCreatedForTesting();
}
void SystemMediaControlsObserverInterceptorForTesting::OnMetadataClearedForTesting() {
  GetForwardingInterface()->OnMetadataClearedForTesting();
}
SystemMediaControlsObserverAsyncWaiter::SystemMediaControlsObserverAsyncWaiter(
    SystemMediaControlsObserver* proxy) : proxy_(proxy) {}

SystemMediaControlsObserverAsyncWaiter::~SystemMediaControlsObserverAsyncWaiter() = default;







}  // system_media_controls::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif