// components/subresource_filter/core/mojom/subresource_filter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/subresource_filter/core/mojom/subresource_filter.mojom-data-view.h"




namespace std {

template <>
struct hash<::subresource_filter::mojom::ActivationLevel>
    : public mojo::internal::EnumHashImpl<::subresource_filter::mojom::ActivationLevel> {};

template <>
struct hash<::subresource_filter::mojom::AdsViolation>
    : public mojo::internal::EnumHashImpl<::subresource_filter::mojom::AdsViolation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::subresource_filter::mojom::ActivationLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::subresource_filter::mojom::ActivationLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::subresource_filter::mojom::ActivationLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::subresource_filter::mojom::AdsViolation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::subresource_filter::mojom::AdsViolation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::subresource_filter::mojom::AdsViolation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::subresource_filter::mojom::ActivationStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::subresource_filter::mojom::ActivationStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::subresource_filter::mojom::internal::ActivationState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::subresource_filter::mojom::ActivationLevel>(
      Traits::activation_level(input),
      &fragment->activation_level);

    fragment->filtering_disabled_for_document = Traits::filtering_disabled_for_document(input);

    fragment->generic_blocking_rules_disabled = Traits::generic_blocking_rules_disabled(input);

    fragment->measure_performance = Traits::measure_performance(input);

    fragment->enable_logging = Traits::enable_logging(input);
  }

  static bool Deserialize(::subresource_filter::mojom::internal::ActivationState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::subresource_filter::mojom::ActivationStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::subresource_filter::mojom::DocumentLoadStatisticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::subresource_filter::mojom::DocumentLoadStatisticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::subresource_filter::mojom::internal::DocumentLoadStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->num_loads_total = Traits::num_loads_total(input);

    fragment->num_loads_evaluated = Traits::num_loads_evaluated(input);

    fragment->num_loads_matching_rules = Traits::num_loads_matching_rules(input);

    fragment->num_loads_disallowed = Traits::num_loads_disallowed(input);

    decltype(Traits::evaluation_total_wall_duration(input)) in_evaluation_total_wall_duration = Traits::evaluation_total_wall_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->evaluation_total_wall_duration)::BaseType> evaluation_total_wall_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_evaluation_total_wall_duration,
      evaluation_total_wall_duration_fragment);

    fragment->evaluation_total_wall_duration.Set(
        evaluation_total_wall_duration_fragment.is_null() ? nullptr : evaluation_total_wall_duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->evaluation_total_wall_duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null evaluation_total_wall_duration in DocumentLoadStatistics struct");

    decltype(Traits::evaluation_total_cpu_duration(input)) in_evaluation_total_cpu_duration = Traits::evaluation_total_cpu_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->evaluation_total_cpu_duration)::BaseType> evaluation_total_cpu_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_evaluation_total_cpu_duration,
      evaluation_total_cpu_duration_fragment);

    fragment->evaluation_total_cpu_duration.Set(
        evaluation_total_cpu_duration_fragment.is_null() ? nullptr : evaluation_total_cpu_duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->evaluation_total_cpu_duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null evaluation_total_cpu_duration in DocumentLoadStatistics struct");
  }

  static bool Deserialize(::subresource_filter::mojom::internal::DocumentLoadStatistics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::subresource_filter::mojom::DocumentLoadStatisticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace subresource_filter::mojom {



inline void DocumentLoadStatisticsDataView::GetEvaluationTotalWallDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->evaluation_total_wall_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DocumentLoadStatisticsDataView::GetEvaluationTotalCpuDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->evaluation_total_cpu_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // subresource_filter::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::subresource_filter::mojom::ActivationLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::subresource_filter::mojom::ActivationLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::subresource_filter::mojom::AdsViolation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::subresource_filter::mojom::AdsViolation value);
};

} // namespace perfetto

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SHARED_H_