// components/subresource_filter/core/mojom/subresource_filter.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SEND_VALIDATION_H_

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::subresource_filter::mojom::ActivationLevel, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::subresource_filter::mojom::AdsViolation, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::subresource_filter::mojom::ActivationStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::subresource_filter::mojom::ActivationStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::subresource_filter::mojom::internal::ActivationState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::subresource_filter::mojom::ActivationLevel>(
        Traits::activation_level(input),
        &fragment->activation_level);

      fragment->filtering_disabled_for_document = Traits::filtering_disabled_for_document(input);

      fragment->generic_blocking_rules_disabled = Traits::generic_blocking_rules_disabled(input);

      fragment->measure_performance = Traits::measure_performance(input);

      fragment->enable_logging = Traits::enable_logging(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::subresource_filter::mojom::DocumentLoadStatisticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::subresource_filter::mojom::DocumentLoadStatisticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::subresource_filter::mojom::internal::DocumentLoadStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->num_loads_total = Traits::num_loads_total(input);

      fragment->num_loads_evaluated = Traits::num_loads_evaluated(input);

      fragment->num_loads_matching_rules = Traits::num_loads_matching_rules(input);

      fragment->num_loads_disallowed = Traits::num_loads_disallowed(input);

      decltype(Traits::evaluation_total_wall_duration(input)) in_evaluation_total_wall_duration = Traits::evaluation_total_wall_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->evaluation_total_wall_duration)::BaseType> evaluation_total_wall_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_evaluation_total_wall_duration,
        evaluation_total_wall_duration_fragment);

      fragment->evaluation_total_wall_duration.Set(
          evaluation_total_wall_duration_fragment.is_null() ? nullptr : evaluation_total_wall_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->evaluation_total_wall_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null evaluation_total_wall_duration in DocumentLoadStatistics struct");

      decltype(Traits::evaluation_total_cpu_duration(input)) in_evaluation_total_cpu_duration = Traits::evaluation_total_cpu_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->evaluation_total_cpu_duration)::BaseType> evaluation_total_cpu_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_evaluation_total_cpu_duration,
        evaluation_total_cpu_duration_fragment);

      fragment->evaluation_total_cpu_duration.Set(
          evaluation_total_cpu_duration_fragment.is_null() ? nullptr : evaluation_total_cpu_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->evaluation_total_cpu_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null evaluation_total_cpu_duration in DocumentLoadStatistics struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SUBRESOURCE_FILTER_CORE_MOJOM_SUBRESOURCE_FILTER_MOJOM_SEND_VALIDATION_H_