// components/spellcheck/common/spellcheck.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/spellcheck/common/spellcheck.mojom-features.h"  // IWYU pragma: export
#include "components/spellcheck/common/spellcheck.mojom-shared.h"  // IWYU pragma: export
#include "components/spellcheck/common/spellcheck.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/spellcheck/common/spellcheck_mojom_traits.h"




namespace spellcheck::mojom {

class SpellCheckerProxy;

template <typename ImplRefTraits>
class SpellCheckerStub;

class SpellCheckerRequestValidator;


class SpellChecker
    : public SpellCheckerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "spellcheck.mojom.SpellChecker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpellCheckerInterfaceBase;
  using Proxy_ = SpellCheckerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckerStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kCustomDictionaryChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CustomDictionaryChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpellChecker() = default;

  virtual void Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) = 0;

  virtual void CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) = 0;
};

class SpellCheckInitializationHostProxy;

template <typename ImplRefTraits>
class SpellCheckInitializationHostStub;

class SpellCheckInitializationHostRequestValidator;


class SpellCheckInitializationHost
    : public SpellCheckInitializationHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "spellcheck.mojom.SpellCheckInitializationHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpellCheckInitializationHostInterfaceBase;
  using Proxy_ = SpellCheckInitializationHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckInitializationHostStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckInitializationHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestDictionaryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestDictionary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpellCheckInitializationHost() = default;

  virtual void RequestDictionary() = 0;
};

class SpellCheckHostProxy;

template <typename ImplRefTraits>
class SpellCheckHostStub;

class SpellCheckHostRequestValidator;
class SpellCheckHostResponseValidator;


class SpellCheckHost
    : public SpellCheckHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "spellcheck.mojom.SpellCheckHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    2, 
    3
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpellCheckHostInterfaceBase;
  using Proxy_ = SpellCheckHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpellCheckHostStub<ImplRefTraits>;

  using RequestValidator_ = SpellCheckHostRequestValidator;
  using ResponseValidator_ = SpellCheckHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNotifyCheckedMinVersion = 0,
    kRequestTextCheckMinVersion = 0,
    kCheckSpellingMinVersion = 0,
    kFillSuggestionListMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyChecked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestTextCheck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckSpelling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillSuggestionList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpellCheckHost() = default;

  virtual void NotifyChecked(const ::std::u16string& word, bool misspelled) = 0;

  using RequestTextCheckCallback = base::OnceCallback<void(const std::vector<::SpellCheckResult>&)>;
  using RequestTextCheckMojoCallback = base::OnceCallback<void(const std::vector<::SpellCheckResult>&)>;

  virtual void RequestTextCheck(const ::std::u16string& text, RequestTextCheckCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CheckSpelling(const ::std::u16string& word, bool* out_correct);
  using CheckSpellingCallback = base::OnceCallback<void(bool)>;
  using CheckSpellingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CheckSpelling(const ::std::u16string& word, CheckSpellingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool FillSuggestionList(const ::std::u16string& word, std::vector<::std::u16string>* out_suggestions);
  using FillSuggestionListCallback = base::OnceCallback<void(const std::vector<::std::u16string>&)>;
  using FillSuggestionListMojoCallback = base::OnceCallback<void(const std::vector<::std::u16string>&)>;

  virtual void FillSuggestionList(const ::std::u16string& word, FillSuggestionListCallback callback) = 0;
};



class  SpellCheckerProxy
    : public SpellChecker {
 public:
  using InterfaceType = SpellChecker;

  explicit SpellCheckerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(std::vector<SpellCheckBDictLanguagePtr> dictionaries, const std::vector<std::string>& custom_words, bool enable) final;
  
  void CustomDictionaryChanged(const std::vector<std::string>& words_added, const std::vector<std::string>& words_removed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpellCheckInitializationHostProxy
    : public SpellCheckInitializationHost {
 public:
  using InterfaceType = SpellCheckInitializationHost;

  explicit SpellCheckInitializationHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestDictionary() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpellCheckHostProxy
    : public SpellCheckHost {
 public:
  using InterfaceType = SpellCheckHost;

  explicit SpellCheckHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyChecked(const ::std::u16string& word, bool misspelled) final;
  
  void RequestTextCheck(const ::std::u16string& text, RequestTextCheckCallback callback) final;
  
  bool CheckSpelling(const ::std::u16string& word, bool* out_correct) final;
  
  void CheckSpelling(const ::std::u16string& word, CheckSpellingCallback callback) final;
  
  bool FillSuggestionList(const ::std::u16string& word, std::vector<::std::u16string>* out_suggestions) final;
  
  void FillSuggestionList(const ::std::u16string& word, FillSuggestionListCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpellCheckerStubDispatch {
 public:
  static bool Accept(SpellChecker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellChecker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellChecker>>
class SpellCheckerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckerStub() = default;
  ~SpellCheckerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckInitializationHostStubDispatch {
 public:
  static bool Accept(SpellCheckInitializationHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellCheckInitializationHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellCheckInitializationHost>>
class SpellCheckInitializationHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckInitializationHostStub() = default;
  ~SpellCheckInitializationHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckInitializationHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckInitializationHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckHostStubDispatch {
 public:
  static bool Accept(SpellCheckHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpellCheckHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpellCheckHost>>
class SpellCheckHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpellCheckHostStub() = default;
  ~SpellCheckHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpellCheckHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpellCheckerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckInitializationHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpellCheckHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  SpellCheckBDictLanguage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpellCheckBDictLanguage, T>::value>;
  using DataView = SpellCheckBDictLanguageDataView;
  using Data_ = internal::SpellCheckBDictLanguage_Data;

  template <typename... Args>
  static SpellCheckBDictLanguagePtr New(Args&&... args) {
    return SpellCheckBDictLanguagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpellCheckBDictLanguagePtr From(const U& u) {
    return mojo::TypeConverter<SpellCheckBDictLanguagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpellCheckBDictLanguage>::Convert(*this);
  }


  SpellCheckBDictLanguage();

  SpellCheckBDictLanguage(
      ::base::File file,
      const std::string& language);

SpellCheckBDictLanguage(const SpellCheckBDictLanguage&) = delete;
SpellCheckBDictLanguage& operator=(const SpellCheckBDictLanguage&) = delete;

  ~SpellCheckBDictLanguage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpellCheckBDictLanguagePtr>
  SpellCheckBDictLanguagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpellCheckBDictLanguage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpellCheckBDictLanguage_UnserializedMessageContext<
            UserType, SpellCheckBDictLanguage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpellCheckBDictLanguage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpellCheckBDictLanguage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpellCheckBDictLanguage_UnserializedMessageContext<
            UserType, SpellCheckBDictLanguage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpellCheckBDictLanguage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File file;
  
  std::string language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SpellCheckResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpellCheckResult, T>::value>;
  using DataView = SpellCheckResultDataView;
  using Data_ = internal::SpellCheckResult_Data;

  template <typename... Args>
  static SpellCheckResultPtr New(Args&&... args) {
    return SpellCheckResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpellCheckResultPtr From(const U& u) {
    return mojo::TypeConverter<SpellCheckResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpellCheckResult>::Convert(*this);
  }


  SpellCheckResult();

  SpellCheckResult(
      ::SpellCheckResult::Decoration decoration,
      int32_t location,
      int32_t length,
      std::vector<::std::u16string> replacements,
      bool should_hide_suggestion_menu);


  ~SpellCheckResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpellCheckResultPtr>
  SpellCheckResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpellCheckResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpellCheckResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpellCheckResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpellCheckResult_UnserializedMessageContext<
            UserType, SpellCheckResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpellCheckResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpellCheckResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpellCheckResult_UnserializedMessageContext<
            UserType, SpellCheckResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpellCheckResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SpellCheckResult::Decoration decoration;
  
  int32_t location;
  
  int32_t length;
  
  std::vector<::std::u16string> replacements;
  
  bool should_hide_suggestion_menu;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpellCheckResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpellCheckBDictLanguagePtr SpellCheckBDictLanguage::Clone() const {
  return New(
      mojo::Clone(file),
      mojo::Clone(language)
  );
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>*>
bool SpellCheckBDictLanguage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file, other_struct.file))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  return true;
}

template <typename T, SpellCheckBDictLanguage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file < rhs.file)
    return true;
  if (rhs.file < lhs.file)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  return false;
}
template <typename StructPtrType>
SpellCheckResultPtr SpellCheckResult::Clone() const {
  return New(
      mojo::Clone(decoration),
      mojo::Clone(location),
      mojo::Clone(length),
      mojo::Clone(replacements),
      mojo::Clone(should_hide_suggestion_menu)
  );
}

template <typename T, SpellCheckResult::EnableIfSame<T>*>
bool SpellCheckResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->decoration, other_struct.decoration))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->replacements, other_struct.replacements))
    return false;
  if (!mojo::Equals(this->should_hide_suggestion_menu, other_struct.should_hide_suggestion_menu))
    return false;
  return true;
}

template <typename T, SpellCheckResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.decoration < rhs.decoration)
    return true;
  if (rhs.decoration < lhs.decoration)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.length < rhs.length)
    return true;
  if (rhs.length < lhs.length)
    return false;
  if (lhs.replacements < rhs.replacements)
    return true;
  if (rhs.replacements < lhs.replacements)
    return false;
  if (lhs.should_hide_suggestion_menu < rhs.should_hide_suggestion_menu)
    return true;
  if (rhs.should_hide_suggestion_menu < lhs.should_hide_suggestion_menu)
    return false;
  return false;
}


}  // spellcheck::mojom

namespace mojo {


template <>
struct  StructTraits<::spellcheck::mojom::SpellCheckBDictLanguage::DataView,
                                         ::spellcheck::mojom::SpellCheckBDictLanguagePtr> {
  static bool IsNull(const ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) { return !input; }
  static void SetToNull(::spellcheck::mojom::SpellCheckBDictLanguagePtr* output) { output->reset(); }

  static  decltype(::spellcheck::mojom::SpellCheckBDictLanguage::file)& file(
       ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) {
    return input->file;
  }

  static const decltype(::spellcheck::mojom::SpellCheckBDictLanguage::language)& language(
      const ::spellcheck::mojom::SpellCheckBDictLanguagePtr& input) {
    return input->language;
  }

  static bool Read(::spellcheck::mojom::SpellCheckBDictLanguage::DataView input, ::spellcheck::mojom::SpellCheckBDictLanguagePtr* output);
};


template <>
struct  StructTraits<::spellcheck::mojom::SpellCheckResult::DataView,
                                         ::spellcheck::mojom::SpellCheckResultPtr> {
  static bool IsNull(const ::spellcheck::mojom::SpellCheckResultPtr& input) { return !input; }
  static void SetToNull(::spellcheck::mojom::SpellCheckResultPtr* output) { output->reset(); }

  static decltype(::spellcheck::mojom::SpellCheckResult::decoration) decoration(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->decoration;
  }

  static decltype(::spellcheck::mojom::SpellCheckResult::location) location(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->location;
  }

  static decltype(::spellcheck::mojom::SpellCheckResult::length) length(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->length;
  }

  static const decltype(::spellcheck::mojom::SpellCheckResult::replacements)& replacements(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->replacements;
  }

  static decltype(::spellcheck::mojom::SpellCheckResult::should_hide_suggestion_menu) should_hide_suggestion_menu(
      const ::spellcheck::mojom::SpellCheckResultPtr& input) {
    return input->should_hide_suggestion_menu;
  }

  static bool Read(::spellcheck::mojom::SpellCheckResult::DataView input, ::spellcheck::mojom::SpellCheckResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_H_