// components/services/storage/public/mojom/storage_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/storage_service.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_service.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_service.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/local_storage_control.mojom-forward.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kStorageSandbox = ::sandbox::mojom::Sandbox::kService;


namespace storage::mojom {

class StorageServiceProxy;

template <typename ImplRefTraits>
class StorageServiceStub;

class StorageServiceRequestValidator;


class StorageService
    : public StorageServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.StorageService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StorageServiceInterfaceBase;
  using Proxy_ = StorageServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = StorageServiceStub<ImplRefTraits>;

  using RequestValidator_ = StorageServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEnableAggressiveDomStorageFlushingMinVersion = 0,
    kSetDataDirectoryMinVersion = 0,
    kBindSessionStorageControlMinVersion = 0,
    kBindLocalStorageControlMinVersion = 0,
    kBindTestApiMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnableAggressiveDomStorageFlushing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDataDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSessionStorageControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLocalStorageControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindTestApi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StorageService() = default;

  virtual void EnableAggressiveDomStorageFlushing() = 0;

  virtual void SetDataDirectory(const ::base::FilePath& path, ::mojo::PendingRemote<::storage::mojom::Directory> directory) = 0;

  virtual void BindSessionStorageControl(const std::optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) = 0;

  virtual void BindLocalStorageControl(const std::optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) = 0;

  virtual void BindTestApi(::mojo::ScopedMessagePipeHandle test_api_receiver) = 0;
};



class  StorageServiceProxy
    : public StorageService {
 public:
  using InterfaceType = StorageService;

  explicit StorageServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableAggressiveDomStorageFlushing() final;
  
  void SetDataDirectory(const ::base::FilePath& path, ::mojo::PendingRemote<::storage::mojom::Directory> directory) final;
  
  void BindSessionStorageControl(const std::optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) final;
  
  void BindLocalStorageControl(const std::optional<::base::FilePath>& path, ::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) final;
  
  void BindTestApi(::mojo::ScopedMessagePipeHandle test_api_receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  StorageServiceStubDispatch {
 public:
  static bool Accept(StorageService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StorageService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StorageService>>
class StorageServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StorageServiceStub() = default;
  ~StorageServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StorageServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_H_