// components/services/storage/public/mojom/session_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/session_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-import-headers.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-test-utils.h"


namespace storage::mojom {
SessionStorageUsageInfo::SessionStorageUsageInfo()
    : storage_key(),
      namespace_id() {}

SessionStorageUsageInfo::SessionStorageUsageInfo(
    const ::blink::StorageKey& storage_key_in,
    const std::string& namespace_id_in)
    : storage_key(std::move(storage_key_in)),
      namespace_id(std::move(namespace_id_in)) {}

SessionStorageUsageInfo::~SessionStorageUsageInfo() = default;

void SessionStorageUsageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_key"), this->storage_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::StorageKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "namespace_id"), this->namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SessionStorageUsageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SessionStorageControl::IPCStableHashFunction SessionStorageControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SessionStorageControl>(message.name())) {
    case messages::SessionStorageControl::kBindNamespace: {
      return &SessionStorageControl::BindNamespace_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kBindStorageArea: {
      return &SessionStorageControl::BindStorageArea_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kGetUsage: {
      return &SessionStorageControl::GetUsage_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kDeleteStorage: {
      return &SessionStorageControl::DeleteStorage_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kCleanUpStorage: {
      return &SessionStorageControl::CleanUpStorage_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kScavengeUnusedNamespaces: {
      return &SessionStorageControl::ScavengeUnusedNamespaces_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kFlush: {
      return &SessionStorageControl::Flush_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kPurgeMemory: {
      return &SessionStorageControl::PurgeMemory_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kCreateNamespace: {
      return &SessionStorageControl::CreateNamespace_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kCloneNamespace: {
      return &SessionStorageControl::CloneNamespace_Sym::IPCStableHash;
    }
    case messages::SessionStorageControl::kDeleteNamespace: {
      return &SessionStorageControl::DeleteNamespace_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SessionStorageControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SessionStorageControl>(message.name())) {
      case messages::SessionStorageControl::kBindNamespace:
            return "Receive storage::mojom::SessionStorageControl::BindNamespace";
      case messages::SessionStorageControl::kBindStorageArea:
            return "Receive storage::mojom::SessionStorageControl::BindStorageArea";
      case messages::SessionStorageControl::kGetUsage:
            return "Receive storage::mojom::SessionStorageControl::GetUsage";
      case messages::SessionStorageControl::kDeleteStorage:
            return "Receive storage::mojom::SessionStorageControl::DeleteStorage";
      case messages::SessionStorageControl::kCleanUpStorage:
            return "Receive storage::mojom::SessionStorageControl::CleanUpStorage";
      case messages::SessionStorageControl::kScavengeUnusedNamespaces:
            return "Receive storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces";
      case messages::SessionStorageControl::kFlush:
            return "Receive storage::mojom::SessionStorageControl::Flush";
      case messages::SessionStorageControl::kPurgeMemory:
            return "Receive storage::mojom::SessionStorageControl::PurgeMemory";
      case messages::SessionStorageControl::kCreateNamespace:
            return "Receive storage::mojom::SessionStorageControl::CreateNamespace";
      case messages::SessionStorageControl::kCloneNamespace:
            return "Receive storage::mojom::SessionStorageControl::CloneNamespace";
      case messages::SessionStorageControl::kDeleteNamespace:
            return "Receive storage::mojom::SessionStorageControl::DeleteNamespace";
    }
  } else {
    switch (static_cast<messages::SessionStorageControl>(message.name())) {
      case messages::SessionStorageControl::kBindNamespace:
            return "Receive reply storage::mojom::SessionStorageControl::BindNamespace";
      case messages::SessionStorageControl::kBindStorageArea:
            return "Receive reply storage::mojom::SessionStorageControl::BindStorageArea";
      case messages::SessionStorageControl::kGetUsage:
            return "Receive reply storage::mojom::SessionStorageControl::GetUsage";
      case messages::SessionStorageControl::kDeleteStorage:
            return "Receive reply storage::mojom::SessionStorageControl::DeleteStorage";
      case messages::SessionStorageControl::kCleanUpStorage:
            return "Receive reply storage::mojom::SessionStorageControl::CleanUpStorage";
      case messages::SessionStorageControl::kScavengeUnusedNamespaces:
            return "Receive reply storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces";
      case messages::SessionStorageControl::kFlush:
            return "Receive reply storage::mojom::SessionStorageControl::Flush";
      case messages::SessionStorageControl::kPurgeMemory:
            return "Receive reply storage::mojom::SessionStorageControl::PurgeMemory";
      case messages::SessionStorageControl::kCreateNamespace:
            return "Receive reply storage::mojom::SessionStorageControl::CreateNamespace";
      case messages::SessionStorageControl::kCloneNamespace:
            return "Receive reply storage::mojom::SessionStorageControl::CloneNamespace";
      case messages::SessionStorageControl::kDeleteNamespace:
            return "Receive reply storage::mojom::SessionStorageControl::DeleteNamespace";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SessionStorageControl::BindNamespace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b9211a6;  // IPCStableHash for storage::mojom::SessionStorageControl::BindNamespace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::BindStorageArea_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x395b63e7;  // IPCStableHash for storage::mojom::SessionStorageControl::BindStorageArea
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::GetUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x878470a1;  // IPCStableHash for storage::mojom::SessionStorageControl::GetUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::DeleteStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9af808e7;  // IPCStableHash for storage::mojom::SessionStorageControl::DeleteStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::CleanUpStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a0ea19d;  // IPCStableHash for storage::mojom::SessionStorageControl::CleanUpStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::ScavengeUnusedNamespaces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ec6891b;  // IPCStableHash for storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cedf845;  // IPCStableHash for storage::mojom::SessionStorageControl::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::PurgeMemory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeee57471;  // IPCStableHash for storage::mojom::SessionStorageControl::PurgeMemory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::CreateNamespace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeddd1e72;  // IPCStableHash for storage::mojom::SessionStorageControl::CreateNamespace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::CloneNamespace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3b85244;  // IPCStableHash for storage::mojom::SessionStorageControl::CloneNamespace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SessionStorageControl::DeleteNamespace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0b2ed7d;  // IPCStableHash for storage::mojom::SessionStorageControl::DeleteNamespace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SessionStorageControl_BindNamespace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_BindNamespace_ForwardToCallback(
      SessionStorageControl::BindNamespaceCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_BindNamespace_ForwardToCallback(const SessionStorageControl_BindNamespace_ForwardToCallback&) = delete;
  SessionStorageControl_BindNamespace_ForwardToCallback& operator=(const SessionStorageControl_BindNamespace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::BindNamespaceCallback callback_;
};

class SessionStorageControl_BindStorageArea_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_BindStorageArea_ForwardToCallback(
      SessionStorageControl::BindStorageAreaCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_BindStorageArea_ForwardToCallback(const SessionStorageControl_BindStorageArea_ForwardToCallback&) = delete;
  SessionStorageControl_BindStorageArea_ForwardToCallback& operator=(const SessionStorageControl_BindStorageArea_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::BindStorageAreaCallback callback_;
};

class SessionStorageControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_GetUsage_ForwardToCallback(
      SessionStorageControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_GetUsage_ForwardToCallback(const SessionStorageControl_GetUsage_ForwardToCallback&) = delete;
  SessionStorageControl_GetUsage_ForwardToCallback& operator=(const SessionStorageControl_GetUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::GetUsageCallback callback_;
};

class SessionStorageControl_DeleteStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_DeleteStorage_ForwardToCallback(
      SessionStorageControl::DeleteStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_DeleteStorage_ForwardToCallback(const SessionStorageControl_DeleteStorage_ForwardToCallback&) = delete;
  SessionStorageControl_DeleteStorage_ForwardToCallback& operator=(const SessionStorageControl_DeleteStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::DeleteStorageCallback callback_;
};

class SessionStorageControl_CleanUpStorage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_CleanUpStorage_ForwardToCallback(
      SessionStorageControl::CleanUpStorageCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_CleanUpStorage_ForwardToCallback(const SessionStorageControl_CleanUpStorage_ForwardToCallback&) = delete;
  SessionStorageControl_CleanUpStorage_ForwardToCallback& operator=(const SessionStorageControl_CleanUpStorage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::CleanUpStorageCallback callback_;
};

class SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback(
      SessionStorageControl::ScavengeUnusedNamespacesCallback callback
      ) : callback_(std::move(callback)) {
  }

  SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback(const SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback&) = delete;
  SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback& operator=(const SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SessionStorageControl::ScavengeUnusedNamespacesCallback callback_;
};

SessionStorageControlProxy::SessionStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionStorageControlProxy::BindNamespace(
    const std::string& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> in_receiver, BindNamespaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::BindNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kBindNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in SessionStorageControl.BindNamespace request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SessionStorageNamespaceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SessionStorageControl.BindNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindNamespace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_BindNamespace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::BindStorageArea(
    const ::blink::StorageKey& in_storage_key, const std::string& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> in_receiver, BindStorageAreaCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::BindStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::StorageArea>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kBindStorageArea), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in SessionStorageControl.BindStorageArea request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in SessionStorageControl.BindStorageArea request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SessionStorageControl.BindStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_BindStorageArea_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::SessionStorageControl::GetUsage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kGetUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_GetUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::DeleteStorage(
    const ::blink::StorageKey& in_storage_key, const std::string& in_namespace_id, DeleteStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::DeleteStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kDeleteStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in SessionStorageControl.DeleteStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in SessionStorageControl.DeleteStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_DeleteStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::CleanUpStorage(
    CleanUpStorageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::SessionStorageControl::CleanUpStorage");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kCleanUpStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CleanUpStorage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_CleanUpStorage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::ScavengeUnusedNamespaces(
    ScavengeUnusedNamespacesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kScavengeUnusedNamespaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("ScavengeUnusedNamespaces");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionStorageControlProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::SessionStorageControl::Flush");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("Flush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionStorageControlProxy::PurgeMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::SessionStorageControl::PurgeMemory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kPurgeMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_PurgeMemory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("PurgeMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionStorageControlProxy::CreateNamespace(
    const std::string& in_namespace_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::CreateNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kCreateNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CreateNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in SessionStorageControl.CreateNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CreateNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionStorageControlProxy::CloneNamespace(
    const std::string& in_namespace_id_to_clone, const std::string& in_clone_namespace_id, SessionStorageCloneType in_clone_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::CloneNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id_to_clone"), in_namespace_id_to_clone,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone_namespace_id"), in_clone_namespace_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone_type"), in_clone_type,
                        "<value of type SessionStorageCloneType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kCloneNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CloneNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id_to_clone)::BaseType> namespace_id_to_clone_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id_to_clone,
    namespace_id_to_clone_fragment);

  params->namespace_id_to_clone.Set(
      namespace_id_to_clone_fragment.is_null() ? nullptr : namespace_id_to_clone_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id_to_clone.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id_to_clone in SessionStorageControl.CloneNamespace request");
  mojo::internal::MessageFragment<
      typename decltype(params->clone_namespace_id)::BaseType> clone_namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_clone_namespace_id,
    clone_namespace_id_fragment);

  params->clone_namespace_id.Set(
      clone_namespace_id_fragment.is_null() ? nullptr : clone_namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clone_namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clone_namespace_id in SessionStorageControl.CloneNamespace request");

  
  mojo::internal::Serialize<::storage::mojom::SessionStorageCloneType>(
    in_clone_type,
    &params->clone_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CloneNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionStorageControlProxy::DeleteNamespace(
    const std::string& in_namespace_id, bool in_should_persist) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::SessionStorageControl::DeleteNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_persist"), in_should_persist,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kDeleteNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in SessionStorageControl.DeleteNamespace request");

  params->should_persist = in_should_persist;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SessionStorageControl_BindNamespace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::BindNamespaceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_BindNamespace_ProxyToResponder> proxy(
        new SessionStorageControl_BindNamespace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_BindNamespace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_BindNamespace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_BindNamespace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::BindNamespaceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool SessionStorageControl_BindNamespace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_BindNamespace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_BindNamespace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.0
  bool success = true;
  bool p_success{};
  SessionStorageControl_BindNamespace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void SessionStorageControl_BindNamespace_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::SessionStorageControl::BindNamespace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kBindNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindNamespace_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindNamespace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_BindStorageArea_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::BindStorageAreaCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_BindStorageArea_ProxyToResponder> proxy(
        new SessionStorageControl_BindStorageArea_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_BindStorageArea_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_BindStorageArea_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_BindStorageArea_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::BindStorageAreaCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool SessionStorageControl_BindStorageArea_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_BindStorageArea_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_BindStorageArea_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.1
  bool success = true;
  bool p_success{};
  SessionStorageControl_BindStorageArea_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void SessionStorageControl_BindStorageArea_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::SessionStorageControl::BindStorageArea", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kBindStorageArea), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_BindStorageArea_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("BindStorageArea");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_GetUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::GetUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_GetUsage_ProxyToResponder> proxy(
        new SessionStorageControl_GetUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_GetUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::GetUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SessionStorageUsageInfoPtr> in_info);
};

bool SessionStorageControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.2
  bool success = true;
  std::vector<SessionStorageUsageInfoPtr> p_info{};
  SessionStorageControl_GetUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void SessionStorageControl_GetUsage_ProxyToResponder::Run(
    std::vector<SessionStorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::SessionStorageControl::GetUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type std::vector<SessionStorageUsageInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kGetUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_GetUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::SessionStorageUsageInfoDataView>>(
    in_info,
    info_fragment,
    &info_validate_params);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_DeleteStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::DeleteStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_DeleteStorage_ProxyToResponder> proxy(
        new SessionStorageControl_DeleteStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_DeleteStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_DeleteStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_DeleteStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::DeleteStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SessionStorageControl_DeleteStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_DeleteStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_DeleteStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.3
  bool success = true;
  SessionStorageControl_DeleteStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SessionStorageControl_DeleteStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::SessionStorageControl::DeleteStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kDeleteStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_DeleteStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("DeleteStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_CleanUpStorage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::CleanUpStorageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_CleanUpStorage_ProxyToResponder> proxy(
        new SessionStorageControl_CleanUpStorage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_CleanUpStorage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_CleanUpStorage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_CleanUpStorage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::CleanUpStorageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SessionStorageControl_CleanUpStorage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.4
  bool success = true;
  SessionStorageControl_CleanUpStorage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SessionStorageControl_CleanUpStorage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::SessionStorageControl::CleanUpStorage");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kCleanUpStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("CleanUpStorage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SessionStorageControl::ScavengeUnusedNamespacesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder> proxy(
        new SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SessionStorageControl::ScavengeUnusedNamespacesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SessionStorageControl_ScavengeUnusedNamespaces_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SessionStorageControl.5
  bool success = true;
  SessionStorageControl_ScavengeUnusedNamespaces_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SessionStorageControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::SessionStorageControl::ScavengeUnusedNamespaces");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageControl::kScavengeUnusedNamespaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageControl::Name_);
  message.set_method_name("ScavengeUnusedNamespaces");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SessionStorageControlStubDispatch::Accept(
    SessionStorageControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SessionStorageControl>(message->header()->name)) {
    case messages::SessionStorageControl::kBindNamespace: {
      break;
    }
    case messages::SessionStorageControl::kBindStorageArea: {
      break;
    }
    case messages::SessionStorageControl::kGetUsage: {
      break;
    }
    case messages::SessionStorageControl::kDeleteStorage: {
      break;
    }
    case messages::SessionStorageControl::kCleanUpStorage: {
      break;
    }
    case messages::SessionStorageControl::kScavengeUnusedNamespaces: {
      break;
    }
    case messages::SessionStorageControl::kFlush: {
      DCHECK(message->is_serialized());
      internal::SessionStorageControl_Flush_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_Flush_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageControl.6
      bool success = true;
      SessionStorageControl_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(        );
      return true;
    }
    case messages::SessionStorageControl::kPurgeMemory: {
      DCHECK(message->is_serialized());
      internal::SessionStorageControl_PurgeMemory_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_PurgeMemory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageControl.7
      bool success = true;
      SessionStorageControl_PurgeMemory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PurgeMemory(        );
      return true;
    }
    case messages::SessionStorageControl::kCreateNamespace: {
      DCHECK(message->is_serialized());
      internal::SessionStorageControl_CreateNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_CreateNamespace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageControl.8
      bool success = true;
      std::string p_namespace_id{};
      SessionStorageControl_CreateNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNamespace(        
        std::move(p_namespace_id));
      return true;
    }
    case messages::SessionStorageControl::kCloneNamespace: {
      DCHECK(message->is_serialized());
      internal::SessionStorageControl_CloneNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_CloneNamespace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageControl.9
      bool success = true;
      std::string p_namespace_id_to_clone{};
      std::string p_clone_namespace_id{};
      SessionStorageCloneType p_clone_type{};
      SessionStorageControl_CloneNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceIdToClone(&p_namespace_id_to_clone))
        success = false;
      if (success && !input_data_view.ReadCloneNamespaceId(&p_clone_namespace_id))
        success = false;
      if (success && !input_data_view.ReadCloneType(&p_clone_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneNamespace(        
        std::move(p_namespace_id_to_clone), 
        std::move(p_clone_namespace_id), 
        std::move(p_clone_type));
      return true;
    }
    case messages::SessionStorageControl::kDeleteNamespace: {
      DCHECK(message->is_serialized());
      internal::SessionStorageControl_DeleteNamespace_Params_Data* params =
          reinterpret_cast<internal::SessionStorageControl_DeleteNamespace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageControl.10
      bool success = true;
      std::string p_namespace_id{};
      bool p_should_persist{};
      SessionStorageControl_DeleteNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success)
        p_should_persist = input_data_view.should_persist();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteNamespace(        
        std::move(p_namespace_id), 
        std::move(p_should_persist));
      return true;
    }
  }
  return false;
}

// static
bool SessionStorageControlStubDispatch::AcceptWithResponder(
    SessionStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SessionStorageControl>(message->header()->name)) {
    case messages::SessionStorageControl::kBindNamespace: {
      internal::SessionStorageControl_BindNamespace_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_BindNamespace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.0
      bool success = true;
      std::string p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> p_receiver{};
      SessionStorageControl_BindNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 0, false);
        return false;
      }
      auto callback =
          SessionStorageControl_BindNamespace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindNamespace(        
        std::move(p_namespace_id), 
        std::move(p_receiver), std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kBindStorageArea: {
      internal::SessionStorageControl_BindStorageArea_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_BindStorageArea_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.1
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      std::string p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::StorageArea> p_receiver{};
      SessionStorageControl_BindStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 1, false);
        return false;
      }
      auto callback =
          SessionStorageControl_BindStorageArea_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStorageArea(        
        std::move(p_storage_key), 
        std::move(p_namespace_id), 
        std::move(p_receiver), std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kGetUsage: {
      internal::SessionStorageControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.2
      bool success = true;
      SessionStorageControl_GetUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 2, false);
        return false;
      }
      auto callback =
          SessionStorageControl_GetUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kDeleteStorage: {
      internal::SessionStorageControl_DeleteStorage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_DeleteStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.3
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      std::string p_namespace_id{};
      SessionStorageControl_DeleteStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 3, false);
        return false;
      }
      auto callback =
          SessionStorageControl_DeleteStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStorage(        
        std::move(p_storage_key), 
        std::move(p_namespace_id), std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kCleanUpStorage: {
      internal::SessionStorageControl_CleanUpStorage_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_CleanUpStorage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.4
      bool success = true;
      SessionStorageControl_CleanUpStorage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 4, false);
        return false;
      }
      auto callback =
          SessionStorageControl_CleanUpStorage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CleanUpStorage(std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kScavengeUnusedNamespaces: {
      internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data* params =
          reinterpret_cast<
              internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SessionStorageControl.5
      bool success = true;
      SessionStorageControl_ScavengeUnusedNamespaces_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageControl::Name_, 5, false);
        return false;
      }
      auto callback =
          SessionStorageControl_ScavengeUnusedNamespaces_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScavengeUnusedNamespaces(std::move(callback));
      return true;
    }
    case messages::SessionStorageControl::kFlush: {
      break;
    }
    case messages::SessionStorageControl::kPurgeMemory: {
      break;
    }
    case messages::SessionStorageControl::kCreateNamespace: {
      break;
    }
    case messages::SessionStorageControl::kCloneNamespace: {
      break;
    }
    case messages::SessionStorageControl::kDeleteNamespace: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSessionStorageControlValidationInfo[] = {
    { &internal::SessionStorageControl_BindNamespace_Params_Data::Validate,
     &internal::SessionStorageControl_BindNamespace_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_BindStorageArea_Params_Data::Validate,
     &internal::SessionStorageControl_BindStorageArea_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_GetUsage_Params_Data::Validate,
     &internal::SessionStorageControl_GetUsage_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_DeleteStorage_Params_Data::Validate,
     &internal::SessionStorageControl_DeleteStorage_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_CleanUpStorage_Params_Data::Validate,
     &internal::SessionStorageControl_CleanUpStorage_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_ScavengeUnusedNamespaces_Params_Data::Validate,
     &internal::SessionStorageControl_ScavengeUnusedNamespaces_ResponseParams_Data::Validate},
    { &internal::SessionStorageControl_Flush_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionStorageControl_PurgeMemory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionStorageControl_CreateNamespace_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionStorageControl_CloneNamespace_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SessionStorageControl_DeleteNamespace_Params_Data::Validate,
     nullptr /* no response */},
};

bool SessionStorageControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::SessionStorageControl::Name_,
    kSessionStorageControlValidationInfo);
}

bool SessionStorageControlResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::SessionStorageControl::Name_,
    kSessionStorageControlValidationInfo);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::SessionStorageUsageInfo::DataView, ::storage::mojom::SessionStorageUsageInfoPtr>::Read(
    ::storage::mojom::SessionStorageUsageInfo::DataView input,
    ::storage::mojom::SessionStorageUsageInfoPtr* output) {
  bool success = true;
  ::storage::mojom::SessionStorageUsageInfoPtr result(::storage::mojom::SessionStorageUsageInfo::New());
  
      if (success && !input.ReadStorageKey(&result->storage_key))
        success = false;
      if (success && !input.ReadNamespaceId(&result->namespace_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void SessionStorageControlInterceptorForTesting::BindNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, BindNamespaceCallback callback) {
  GetForwardingInterface()->BindNamespace(
    std::move(namespace_id)
    , 
    std::move(receiver)
    , std::move(callback));
}
void SessionStorageControlInterceptorForTesting::BindStorageArea(const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, BindStorageAreaCallback callback) {
  GetForwardingInterface()->BindStorageArea(
    std::move(storage_key)
    , 
    std::move(namespace_id)
    , 
    std::move(receiver)
    , std::move(callback));
}
void SessionStorageControlInterceptorForTesting::GetUsage(GetUsageCallback callback) {
  GetForwardingInterface()->GetUsage(std::move(callback));
}
void SessionStorageControlInterceptorForTesting::DeleteStorage(const ::blink::StorageKey& storage_key, const std::string& namespace_id, DeleteStorageCallback callback) {
  GetForwardingInterface()->DeleteStorage(
    std::move(storage_key)
    , 
    std::move(namespace_id)
    , std::move(callback));
}
void SessionStorageControlInterceptorForTesting::CleanUpStorage(CleanUpStorageCallback callback) {
  GetForwardingInterface()->CleanUpStorage(std::move(callback));
}
void SessionStorageControlInterceptorForTesting::ScavengeUnusedNamespaces(ScavengeUnusedNamespacesCallback callback) {
  GetForwardingInterface()->ScavengeUnusedNamespaces(std::move(callback));
}
void SessionStorageControlInterceptorForTesting::Flush() {
  GetForwardingInterface()->Flush();
}
void SessionStorageControlInterceptorForTesting::PurgeMemory() {
  GetForwardingInterface()->PurgeMemory();
}
void SessionStorageControlInterceptorForTesting::CreateNamespace(const std::string& namespace_id) {
  GetForwardingInterface()->CreateNamespace(
    std::move(namespace_id)
    );
}
void SessionStorageControlInterceptorForTesting::CloneNamespace(const std::string& namespace_id_to_clone, const std::string& clone_namespace_id, SessionStorageCloneType clone_type) {
  GetForwardingInterface()->CloneNamespace(
    std::move(namespace_id_to_clone)
    , 
    std::move(clone_namespace_id)
    , 
    std::move(clone_type)
    );
}
void SessionStorageControlInterceptorForTesting::DeleteNamespace(const std::string& namespace_id, bool should_persist) {
  GetForwardingInterface()->DeleteNamespace(
    std::move(namespace_id)
    , 
    std::move(should_persist)
    );
}
SessionStorageControlAsyncWaiter::SessionStorageControlAsyncWaiter(
    SessionStorageControl* proxy) : proxy_(proxy) {}

SessionStorageControlAsyncWaiter::~SessionStorageControlAsyncWaiter() = default;


void SessionStorageControlAsyncWaiter::BindNamespace(
    const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, bool* out_success) {
  base::RunLoop loop;
  proxy_->BindNamespace(
      std::move(namespace_id),
      std::move(receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool SessionStorageControlAsyncWaiter::BindNamespace(
    const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver) {
  bool async_wait_result;
  BindNamespace(std::move(namespace_id),std::move(receiver),&async_wait_result);
  return async_wait_result;
}

void SessionStorageControlAsyncWaiter::BindStorageArea(
    const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, bool* out_success) {
  base::RunLoop loop;
  proxy_->BindStorageArea(
      std::move(storage_key),
      std::move(namespace_id),
      std::move(receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool SessionStorageControlAsyncWaiter::BindStorageArea(
    const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) {
  bool async_wait_result;
  BindStorageArea(std::move(storage_key),std::move(namespace_id),std::move(receiver),&async_wait_result);
  return async_wait_result;
}

void SessionStorageControlAsyncWaiter::GetUsage(
    std::vector<SessionStorageUsageInfoPtr>* out_info) {
  base::RunLoop loop;
  proxy_->GetUsage(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SessionStorageUsageInfoPtr>* out_info
,
             std::vector<SessionStorageUsageInfoPtr> info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

std::vector<SessionStorageUsageInfoPtr> SessionStorageControlAsyncWaiter::GetUsage(
    ) {
  std::vector<SessionStorageUsageInfoPtr> async_wait_result;
  GetUsage(&async_wait_result);
  return async_wait_result;
}

void SessionStorageControlAsyncWaiter::DeleteStorage(
    const ::blink::StorageKey& storage_key, const std::string& namespace_id) {
  base::RunLoop loop;
  proxy_->DeleteStorage(
      std::move(storage_key),
      std::move(namespace_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void SessionStorageControlAsyncWaiter::CleanUpStorage(
    ) {
  base::RunLoop loop;
  proxy_->CleanUpStorage(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void SessionStorageControlAsyncWaiter::ScavengeUnusedNamespaces(
    ) {
  base::RunLoop loop;
  proxy_->ScavengeUnusedNamespaces(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif