// components/services/storage/public/mojom/session_storage_control.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_

#include "components/services/storage/public/mojom/session_storage_control.mojom.h"


namespace storage::mojom {


class  SessionStorageControlInterceptorForTesting : public SessionStorageControl {
  virtual SessionStorageControl* GetForwardingInterface() = 0;
  void BindNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, BindNamespaceCallback callback) override;
  void BindStorageArea(const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, BindStorageAreaCallback callback) override;
  void GetUsage(GetUsageCallback callback) override;
  void DeleteStorage(const ::blink::StorageKey& storage_key, const std::string& namespace_id, DeleteStorageCallback callback) override;
  void CleanUpStorage(CleanUpStorageCallback callback) override;
  void ScavengeUnusedNamespaces(ScavengeUnusedNamespacesCallback callback) override;
  void Flush() override;
  void PurgeMemory() override;
  void CreateNamespace(const std::string& namespace_id) override;
  void CloneNamespace(const std::string& namespace_id_to_clone, const std::string& clone_namespace_id, SessionStorageCloneType clone_type) override;
  void DeleteNamespace(const std::string& namespace_id, bool should_persist) override;
};
class  SessionStorageControlAsyncWaiter {
 public:
  explicit SessionStorageControlAsyncWaiter(SessionStorageControl* proxy);

  SessionStorageControlAsyncWaiter(const SessionStorageControlAsyncWaiter&) = delete;
  SessionStorageControlAsyncWaiter& operator=(const SessionStorageControlAsyncWaiter&) = delete;

  ~SessionStorageControlAsyncWaiter();
  void BindNamespace(
      const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, bool* out_success);
  bool BindNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver);
  void BindStorageArea(
      const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, bool* out_success);
  bool BindStorageArea(const ::blink::StorageKey& storage_key, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver);
  void GetUsage(
      std::vector<SessionStorageUsageInfoPtr>* out_info);
  std::vector<SessionStorageUsageInfoPtr> GetUsage();
  void DeleteStorage(
      const ::blink::StorageKey& storage_key, const std::string& namespace_id);
  
  void CleanUpStorage(
      );
  
  void ScavengeUnusedNamespaces(
      );
  

 private:
  SessionStorageControl* const proxy_;
};




}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_