// components/services/storage/public/mojom/file_system_access_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/file_system_access_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/file_system_access_context.mojom-params-data.h"
#include "components/services/storage/public/mojom/file_system_access_context.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/file_system_access_context.mojom-import-headers.h"
#include "components/services/storage/public/mojom/file_system_access_context.mojom-test-utils.h"


namespace storage::mojom {
// The declaration includes the definition on other builds.

FileSystemAccessContext::IPCStableHashFunction FileSystemAccessContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessContext>(message.name())) {
    case messages::FileSystemAccessContext::kSerializeHandle: {
      return &FileSystemAccessContext::SerializeHandle_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessContext::kDeserializeHandle: {
      return &FileSystemAccessContext::DeserializeHandle_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessContext::kClone: {
      return &FileSystemAccessContext::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessContext>(message.name())) {
      case messages::FileSystemAccessContext::kSerializeHandle:
            return "Receive storage::mojom::FileSystemAccessContext::SerializeHandle";
      case messages::FileSystemAccessContext::kDeserializeHandle:
            return "Receive storage::mojom::FileSystemAccessContext::DeserializeHandle";
      case messages::FileSystemAccessContext::kClone:
            return "Receive storage::mojom::FileSystemAccessContext::Clone";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessContext>(message.name())) {
      case messages::FileSystemAccessContext::kSerializeHandle:
            return "Receive reply storage::mojom::FileSystemAccessContext::SerializeHandle";
      case messages::FileSystemAccessContext::kDeserializeHandle:
            return "Receive reply storage::mojom::FileSystemAccessContext::DeserializeHandle";
      case messages::FileSystemAccessContext::kClone:
            return "Receive reply storage::mojom::FileSystemAccessContext::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessContext::SerializeHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6881605;  // IPCStableHash for storage::mojom::FileSystemAccessContext::SerializeHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessContext::DeserializeHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc513cbad;  // IPCStableHash for storage::mojom::FileSystemAccessContext::DeserializeHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessContext::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x691f9909;  // IPCStableHash for storage::mojom::FileSystemAccessContext::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessContext_SerializeHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessContext_SerializeHandle_ForwardToCallback(
      FileSystemAccessContext::SerializeHandleCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessContext_SerializeHandle_ForwardToCallback(const FileSystemAccessContext_SerializeHandle_ForwardToCallback&) = delete;
  FileSystemAccessContext_SerializeHandle_ForwardToCallback& operator=(const FileSystemAccessContext_SerializeHandle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessContext::SerializeHandleCallback callback_;
};

FileSystemAccessContextProxy::FileSystemAccessContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessContextProxy::SerializeHandle(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> in_token, SerializeHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::FileSystemAccessContext::SerializeHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessContext::kSerializeHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_SerializeHandle_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessContext.SerializeHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("SerializeHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessContext_SerializeHandle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessContextProxy::DeserializeHandle(
    const ::blink::StorageKey& in_storage_key, const std::vector<uint8_t>& in_bits, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::FileSystemAccessContext::DeserializeHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bits"), in_bits,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessContext::kDeserializeHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_DeserializeHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in FileSystemAccessContext.DeserializeHandle request");
  mojo::internal::MessageFragment<
      typename decltype(params->bits)::BaseType>
      bits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bits,
    bits_fragment,
    &bits_validate_params);

  params->bits.Set(
      bits_fragment.is_null() ? nullptr : bits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bits in FileSystemAccessContext.DeserializeHandle request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessContext.DeserializeHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("DeserializeHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemAccessContextProxy::Clone(
    ::mojo::PendingReceiver<FileSystemAccessContext> in_receiever) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::FileSystemAccessContext::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiever"), in_receiever,
                        "<value of type ::mojo::PendingReceiver<FileSystemAccessContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessContext::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::FileSystemAccessContextInterfaceBase>>(
    in_receiever,
    &params->receiever,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiever)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiever in FileSystemAccessContext.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FileSystemAccessContext_SerializeHandle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessContext::SerializeHandleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessContext_SerializeHandle_ProxyToResponder> proxy(
        new FileSystemAccessContext_SerializeHandle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessContext_SerializeHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessContext_SerializeHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessContext_SerializeHandle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessContext::SerializeHandleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_bits);
};

bool FileSystemAccessContext_SerializeHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessContext.0
  bool success = true;
  std::vector<uint8_t> p_bits{};
  FileSystemAccessContext_SerializeHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBits(&p_bits))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bits));
  }
  return true;
}

void FileSystemAccessContext_SerializeHandle_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_bits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::FileSystemAccessContext::SerializeHandle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bits"), in_bits,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessContext::kSerializeHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bits)::BaseType>
      bits_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bits,
    bits_fragment,
    &bits_validate_params);

  params->bits.Set(
      bits_fragment.is_null() ? nullptr : bits_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bits.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bits in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessContext::Name_);
  message.set_method_name("SerializeHandle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessContextStubDispatch::Accept(
    FileSystemAccessContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessContext>(message->header()->name)) {
    case messages::FileSystemAccessContext::kSerializeHandle: {
      break;
    }
    case messages::FileSystemAccessContext::kDeserializeHandle: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessContext_DeserializeHandle_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessContext_DeserializeHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessContext.1
      bool success = true;
      ::blink::StorageKey p_storage_key{};
      std::vector<uint8_t> p_bits{};
      ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessContext_DeserializeHandle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadBits(&p_bits))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeserializeHandle(        
        std::move(p_storage_key), 
        std::move(p_bits), 
        std::move(p_token));
      return true;
    }
    case messages::FileSystemAccessContext::kClone: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessContext_Clone_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessContext_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessContext.2
      bool success = true;
      ::mojo::PendingReceiver<FileSystemAccessContext> p_receiever{};
      FileSystemAccessContext_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiever =
            input_data_view.TakeReceiever<decltype(p_receiever)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessContext::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiever));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessContextStubDispatch::AcceptWithResponder(
    FileSystemAccessContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessContext>(message->header()->name)) {
    case messages::FileSystemAccessContext::kSerializeHandle: {
      internal::FileSystemAccessContext_SerializeHandle_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessContext_SerializeHandle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessContext.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessContext_SerializeHandle_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessContext::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessContext_SerializeHandle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SerializeHandle(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessContext::kDeserializeHandle: {
      break;
    }
    case messages::FileSystemAccessContext::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessContextValidationInfo[] = {
    { &internal::FileSystemAccessContext_SerializeHandle_Params_Data::Validate,
     &internal::FileSystemAccessContext_SerializeHandle_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessContext_DeserializeHandle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemAccessContext_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::FileSystemAccessContext::Name_,
    kFileSystemAccessContextValidationInfo);
}

bool FileSystemAccessContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::FileSystemAccessContext::Name_,
    kFileSystemAccessContextValidationInfo);
}


}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void FileSystemAccessContextInterceptorForTesting::SerializeHandle(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, SerializeHandleCallback callback) {
  GetForwardingInterface()->SerializeHandle(
    std::move(token)
    , std::move(callback));
}
void FileSystemAccessContextInterceptorForTesting::DeserializeHandle(const ::blink::StorageKey& storage_key, const std::vector<uint8_t>& bits, ::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) {
  GetForwardingInterface()->DeserializeHandle(
    std::move(storage_key)
    , 
    std::move(bits)
    , 
    std::move(token)
    );
}
void FileSystemAccessContextInterceptorForTesting::Clone(::mojo::PendingReceiver<FileSystemAccessContext> receiever) {
  GetForwardingInterface()->Clone(
    std::move(receiever)
    );
}
FileSystemAccessContextAsyncWaiter::FileSystemAccessContextAsyncWaiter(
    FileSystemAccessContext* proxy) : proxy_(proxy) {}

FileSystemAccessContextAsyncWaiter::~FileSystemAccessContextAsyncWaiter() = default;


void FileSystemAccessContextAsyncWaiter::SerializeHandle(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token, std::vector<uint8_t>* out_bits) {
  base::RunLoop loop;
  proxy_->SerializeHandle(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_bits
,
             const std::vector<uint8_t>& bits) {*out_bits = std::move(bits);
            loop->Quit();
          },
          &loop,
          out_bits));
  loop.Run();
}

std::vector<uint8_t> FileSystemAccessContextAsyncWaiter::SerializeHandle(
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> token) {
  std::vector<uint8_t> async_wait_result;
  SerializeHandle(std::move(token),&async_wait_result);
  return async_wait_result;
}






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif