// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared-internal.h"
#include "components/services/on_device_translation/public/mojom/translator.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"


namespace on_device_translation::mojom {
class OnDeviceTranslationLanguagePackageDataView;

class OnDeviceTranslationServiceConfigDataView;



}  // on_device_translation::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView> {
  using Data = ::on_device_translation::mojom::internal::OnDeviceTranslationLanguagePackage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_translation::mojom::OnDeviceTranslationServiceConfigDataView> {
  using Data = ::on_device_translation::mojom::internal::OnDeviceTranslationServiceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace on_device_translation::mojom {


enum class CreateTranslatorResult : int32_t {
  
  kSuccess = 0,
  
  kErrorInvalidBinary = 1,
  
  kErrorInvalidFunctionPointer = 2,
  
  kErrorFailedToInitialize = 3,
  
  kErrorFailedToCreateTranslator = 4,
  
  kErrorInvalidVersion = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, CreateTranslatorResult value);
inline bool IsKnownEnumValue(CreateTranslatorResult value) {
  return internal::CreateTranslatorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileOperationProxyInterfaceBase {};

using FileOperationProxyPtrDataView =
    mojo::InterfacePtrDataView<FileOperationProxyInterfaceBase>;
using FileOperationProxyRequestDataView =
    mojo::InterfaceRequestDataView<FileOperationProxyInterfaceBase>;
using FileOperationProxyAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileOperationProxyInterfaceBase>;
using FileOperationProxyAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileOperationProxyInterfaceBase>;
class OnDeviceTranslationServiceInterfaceBase {};

using OnDeviceTranslationServicePtrDataView =
    mojo::InterfacePtrDataView<OnDeviceTranslationServiceInterfaceBase>;
using OnDeviceTranslationServiceRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceTranslationServiceInterfaceBase>;
using OnDeviceTranslationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceTranslationServiceInterfaceBase>;
using OnDeviceTranslationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceTranslationServiceInterfaceBase>;


class OnDeviceTranslationLanguagePackageDataView {
 public:
  OnDeviceTranslationLanguagePackageDataView() = default;

  OnDeviceTranslationLanguagePackageDataView(
      internal::OnDeviceTranslationLanguagePackage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLanguage1DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage1(UserType* output) {
    
    auto* pointer = data_->language1.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLanguage2DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage2(UserType* output) {
    
    auto* pointer = data_->language2.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::OnDeviceTranslationLanguagePackage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnDeviceTranslationServiceConfigDataView {
 public:
  OnDeviceTranslationServiceConfigDataView() = default;

  OnDeviceTranslationServiceConfigDataView(
      internal::OnDeviceTranslationServiceConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPackagesDataView(
      mojo::ArrayDataView<OnDeviceTranslationLanguagePackageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackages(UserType* output) {
    
    auto* pointer = data_->packages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFileOperationProxy() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::on_device_translation::mojom::FileOperationProxyInterfaceBase>>(
            &data_->file_operation_proxy, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::OnDeviceTranslationServiceConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // on_device_translation::mojom

#endif  // COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_DATA_VIEW_H_