// components/services/font_data/public/mojom/font_data_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/font_data/public/mojom/font_data_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-params-data.h"
namespace font_data_service {
namespace mojom {

NOINLINE static const char* TypefaceSlantToStringHelper(TypefaceSlant value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TypefaceSlant::kRoman:
      return "kRoman";
    case TypefaceSlant::kItalic:
      return "kItalic";
    case TypefaceSlant::kOblique:
      return "kOblique";
    default:
      return nullptr;
  }
}

std::string TypefaceSlantToString(TypefaceSlant value) {
  const char *str = TypefaceSlantToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TypefaceSlant value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TypefaceSlant value) {
  return os << TypefaceSlantToString(value);
}

namespace internal {
// static
bool TypefaceData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TypefaceData_Data* object = static_cast<const TypefaceData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TypefaceData_Tag::kRegion: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_region, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_region, validation_context))
        return false;
      return true;
    }
    case TypefaceData_Tag::kFontFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_font_file, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_font_file, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TypefaceData");
      return false;
    }
  }
}


// static
bool TypefaceStyle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TypefaceStyle_Data* object =
      static_cast<const TypefaceStyle_Data*>(data);


  if (!::font_data_service::mojom::internal::TypefaceSlant_Data
        ::Validate(object->slant, validation_context))
    return false;

  return true;
}

TypefaceStyle_Data::TypefaceStyle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Coordinate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Coordinate_Data* object =
      static_cast<const Coordinate_Data*>(data);

  return true;
}

Coordinate_Data::Coordinate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VariationPosition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VariationPosition_Data* object =
      static_cast<const VariationPosition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coordinates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& coordinates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->coordinates, validation_context,
                                         &coordinates_validate_params)) {
    return false;
  }

  return true;
}

VariationPosition_Data::VariationPosition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MatchFamilyNameResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MatchFamilyNameResult_Data* object =
      static_cast<const MatchFamilyNameResult_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->typeface_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->typeface_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->variation_position, validation_context))
    return false;

  return true;
}

MatchFamilyNameResult_Data::MatchFamilyNameResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_MatchFamilyName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_MatchFamilyName_Params_Data* object =
      static_cast<const FontDataService_MatchFamilyName_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& family_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  return true;
}

FontDataService_MatchFamilyName_Params_Data::FontDataService_MatchFamilyName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_MatchFamilyName_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_MatchFamilyName_ResponseParams_Data* object =
      static_cast<const FontDataService_MatchFamilyName_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FontDataService_MatchFamilyName_ResponseParams_Data::FontDataService_MatchFamilyName_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_MatchFamilyNameCharacter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_MatchFamilyNameCharacter_Params_Data* object =
      static_cast<const FontDataService_MatchFamilyNameCharacter_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->family_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& family_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bcp47s, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bcp47s_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->bcp47s, validation_context,
                                         &bcp47s_validate_params)) {
    return false;
  }

  return true;
}

FontDataService_MatchFamilyNameCharacter_Params_Data::FontDataService_MatchFamilyNameCharacter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_MatchFamilyNameCharacter_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_MatchFamilyNameCharacter_ResponseParams_Data* object =
      static_cast<const FontDataService_MatchFamilyNameCharacter_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FontDataService_MatchFamilyNameCharacter_ResponseParams_Data::FontDataService_MatchFamilyNameCharacter_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_GetAllFamilyNames_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_GetAllFamilyNames_Params_Data* object =
      static_cast<const FontDataService_GetAllFamilyNames_Params_Data*>(data);

  return true;
}

FontDataService_GetAllFamilyNames_Params_Data::FontDataService_GetAllFamilyNames_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_GetAllFamilyNames_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_GetAllFamilyNames_ResponseParams_Data* object =
      static_cast<const FontDataService_GetAllFamilyNames_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

FontDataService_GetAllFamilyNames_ResponseParams_Data::FontDataService_GetAllFamilyNames_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_LegacyMakeTypeface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_LegacyMakeTypeface_Params_Data* object =
      static_cast<const FontDataService_LegacyMakeTypeface_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& family_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->family_name, validation_context,
                                         &family_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->style, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->style, validation_context))
    return false;

  return true;
}

FontDataService_LegacyMakeTypeface_Params_Data::FontDataService_LegacyMakeTypeface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontDataService_LegacyMakeTypeface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FontDataService_LegacyMakeTypeface_ResponseParams_Data* object =
      static_cast<const FontDataService_LegacyMakeTypeface_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FontDataService_LegacyMakeTypeface_ResponseParams_Data::FontDataService_LegacyMakeTypeface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace font_data_service

namespace perfetto {

// static
void TraceFormatTraits<::font_data_service::mojom::TypefaceSlant>::WriteIntoTrace(
   perfetto::TracedValue context, ::font_data_service::mojom::TypefaceSlant value) {
  return std::move(context).WriteString(::font_data_service::mojom::TypefaceSlantToString(value));
}

} // namespace perfetto