// components/safe_browsing/core/common/safe_browsing_url_checker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-params-data.h"
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-shared-message-ids.h"

#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-import-headers.h"
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-test-utils.h"


namespace safe_browsing::mojom {
// The declaration includes the definition on other builds.

SafeBrowsingUrlChecker::IPCStableHashFunction SafeBrowsingUrlChecker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SafeBrowsingUrlChecker>(message.name())) {
    case messages::SafeBrowsingUrlChecker::kCheckUrl: {
      return &SafeBrowsingUrlChecker::CheckUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SafeBrowsingUrlChecker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SafeBrowsingUrlChecker>(message.name())) {
      case messages::SafeBrowsingUrlChecker::kCheckUrl:
            return "Receive safe_browsing::mojom::SafeBrowsingUrlChecker::CheckUrl";
    }
  } else {
    switch (static_cast<messages::SafeBrowsingUrlChecker>(message.name())) {
      case messages::SafeBrowsingUrlChecker::kCheckUrl:
            return "Receive reply safe_browsing::mojom::SafeBrowsingUrlChecker::CheckUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SafeBrowsingUrlChecker::CheckUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x666609b7;  // IPCStableHash for safe_browsing::mojom::SafeBrowsingUrlChecker::CheckUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback(
      SafeBrowsingUrlChecker::CheckUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback(const SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback&) = delete;
  SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback& operator=(const SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeBrowsingUrlChecker::CheckUrlCallback callback_;
};

SafeBrowsingUrlCheckerProxy::SafeBrowsingUrlCheckerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SafeBrowsingUrlCheckerProxy::CheckUrl(
    const ::GURL& in_url, const std::string& in_method, CheckUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::SafeBrowsingUrlChecker::CheckUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method"), in_method,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingUrlChecker::kCheckUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::SafeBrowsingUrlChecker_CheckUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in SafeBrowsingUrlChecker.CheckUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->method)::BaseType> method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_method,
    method_fragment);

  params->method.Set(
      method_fragment.is_null() ? nullptr : method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method in SafeBrowsingUrlChecker.CheckUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingUrlChecker::Name_);
  message.set_method_name("CheckUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeBrowsingUrlChecker::CheckUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder> proxy(
        new SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeBrowsingUrlChecker::CheckUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, bool in_showed_interstitial);
};

bool SafeBrowsingUrlChecker_CheckUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeBrowsingUrlChecker_CheckUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeBrowsingUrlChecker_CheckUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeBrowsingUrlChecker.0
  bool success = true;
  bool p_proceed{};
  bool p_showed_interstitial{};
  SafeBrowsingUrlChecker_CheckUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success)
    p_showed_interstitial = input_data_view.showed_interstitial();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeBrowsingUrlChecker::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_showed_interstitial));
  }
  return true;
}

void SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder::Run(
    bool in_proceed, bool in_showed_interstitial) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply safe_browsing::mojom::SafeBrowsingUrlChecker::CheckUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proceed"), in_proceed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("showed_interstitial"), in_showed_interstitial,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingUrlChecker::kCheckUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::SafeBrowsingUrlChecker_CheckUrl_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->proceed = in_proceed;

  params->showed_interstitial = in_showed_interstitial;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingUrlChecker::Name_);
  message.set_method_name("CheckUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SafeBrowsingUrlCheckerStubDispatch::Accept(
    SafeBrowsingUrlChecker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SafeBrowsingUrlChecker>(message->header()->name)) {
    case messages::SafeBrowsingUrlChecker::kCheckUrl: {
      break;
    }
  }
  return false;
}

// static
bool SafeBrowsingUrlCheckerStubDispatch::AcceptWithResponder(
    SafeBrowsingUrlChecker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SafeBrowsingUrlChecker>(message->header()->name)) {
    case messages::SafeBrowsingUrlChecker::kCheckUrl: {
      internal::SafeBrowsingUrlChecker_CheckUrl_Params_Data* params =
          reinterpret_cast<
              internal::SafeBrowsingUrlChecker_CheckUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeBrowsingUrlChecker.0
      bool success = true;
      ::GURL p_url{};
      std::string p_method{};
      SafeBrowsingUrlChecker_CheckUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMethod(&p_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsingUrlChecker::Name_, 0, false);
        return false;
      }
      auto callback =
          SafeBrowsingUrlChecker_CheckUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckUrl(        
        std::move(p_url), 
        std::move(p_method), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSafeBrowsingUrlCheckerValidationInfo[] = {
    { &internal::SafeBrowsingUrlChecker_CheckUrl_Params_Data::Validate,
     &internal::SafeBrowsingUrlChecker_CheckUrl_ResponseParams_Data::Validate},
};

bool SafeBrowsingUrlCheckerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::SafeBrowsingUrlChecker::Name_,
    kSafeBrowsingUrlCheckerValidationInfo);
}

bool SafeBrowsingUrlCheckerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::SafeBrowsingUrlChecker::Name_,
    kSafeBrowsingUrlCheckerValidationInfo);
}


}  // safe_browsing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace safe_browsing::mojom {


void SafeBrowsingUrlCheckerInterceptorForTesting::CheckUrl(const ::GURL& url, const std::string& method, CheckUrlCallback callback) {
  GetForwardingInterface()->CheckUrl(
    std::move(url)
    , 
    std::move(method)
    , std::move(callback));
}
SafeBrowsingUrlCheckerAsyncWaiter::SafeBrowsingUrlCheckerAsyncWaiter(
    SafeBrowsingUrlChecker* proxy) : proxy_(proxy) {}

SafeBrowsingUrlCheckerAsyncWaiter::~SafeBrowsingUrlCheckerAsyncWaiter() = default;


void SafeBrowsingUrlCheckerAsyncWaiter::CheckUrl(
    const ::GURL& url, const std::string& method, bool* out_proceed, bool* out_showed_interstitial) {
  base::RunLoop loop;
  proxy_->CheckUrl(
      std::move(url),
      std::move(method),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_proceed
,
             bool* out_showed_interstitial
,
             bool proceed,
             bool showed_interstitial) {*out_proceed = std::move(proceed);*out_showed_interstitial = std::move(showed_interstitial);
            loop->Quit();
          },
          &loop,
          out_proceed,
          out_showed_interstitial));
  loop.Run();
}








}  // safe_browsing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif