// components/remote_cocoa/common/select_file_dialog.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_DATA_VIEW_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/remote_cocoa/common/select_file_dialog.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"


namespace remote_cocoa::mojom {
class SelectFileTypeInfoDataView;



}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::SelectFileTypeInfoDataView> {
  using Data = ::remote_cocoa::mojom::internal::SelectFileTypeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {


enum class SelectFileDialogType : int32_t {
  
  kFolder = 0,
  
  kUploadFolder = 1,
  
  kExistingFolder = 2,
  
  kOpenFile = 3,
  
  kOpenMultiFile = 4,
  
  kSaveAsFile = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SelectFileDialogType value);
inline bool IsKnownEnumValue(SelectFileDialogType value) {
  return internal::SelectFileDialogType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SelectFileDialogInterfaceBase {};

using SelectFileDialogPtrDataView =
    mojo::InterfacePtrDataView<SelectFileDialogInterfaceBase>;
using SelectFileDialogRequestDataView =
    mojo::InterfaceRequestDataView<SelectFileDialogInterfaceBase>;
using SelectFileDialogAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SelectFileDialogInterfaceBase>;
using SelectFileDialogAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SelectFileDialogInterfaceBase>;


class SelectFileTypeInfoDataView {
 public:
  SelectFileTypeInfoDataView() = default;

  SelectFileTypeInfoDataView(
      internal::SelectFileTypeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
  inline void GetExtensionDescriptionOverridesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionDescriptionOverrides(UserType* output) {
    
    auto* pointer = data_->extension_description_overrides.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  bool include_all_files() const {
    return data_->include_all_files;
  }
  bool keep_extension_visible() const {
    return data_->keep_extension_visible;
  }
 private:
  internal::SelectFileTypeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_DATA_VIEW_H_