// components/remote_cocoa/common/native_widget_ns_window.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/native_widget_ns_window.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/native_widget_ns_window.mojom-forward.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/select_file_dialog.mojom-forward.h"
#include "components/remote_cocoa/common/menu.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "ui/base/cursor/mojom/cursor.mojom.h"
#include "ui/base/mojom/color_mode.mojom.h"
#include "ui/base/mojom/ui_base_types.mojom-forward.h"
#include "ui/events/mojom/event_constants.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/ca_layer_params.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class NativeWidgetNSWindowProxy;

template <typename ImplRefTraits>
class NativeWidgetNSWindowStub;

class NativeWidgetNSWindowRequestValidator;
class NativeWidgetNSWindowResponseValidator;


class NativeWidgetNSWindow
    : public NativeWidgetNSWindowInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.NativeWidgetNSWindow";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NativeWidgetNSWindowInterfaceBase;
  using Proxy_ = NativeWidgetNSWindowProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeWidgetNSWindowStub<ImplRefTraits>;

  using RequestValidator_ = NativeWidgetNSWindowRequestValidator;
  using ResponseValidator_ = NativeWidgetNSWindowResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWindowMinVersion = 0,
    kSetParentMinVersion = 0,
    kCreateSelectFileDialogMinVersion = 0,
    kShowCertificateViewerMinVersion = 0,
    kStackAboveMinVersion = 0,
    kStackAtTopMinVersion = 0,
    kShowEmojiPanelMinVersion = 0,
    kInitWindowMinVersion = 0,
    kInitCompositorViewMinVersion = 0,
    kCreateContentViewMinVersion = 0,
    kDestroyContentViewMinVersion = 0,
    kCloseWindowMinVersion = 0,
    kCloseWindowNowMinVersion = 0,
    kSetInitialBoundsMinVersion = 0,
    kSetBoundsMinVersion = 0,
    kSetSizeMinVersion = 0,
    kSetSizeAndCenterMinVersion = 0,
    kSetVisibilityStateMinVersion = 0,
    kSetAnimationEnabledMinVersion = 0,
    kSetTransitionsToAnimateMinVersion = 0,
    kSetVisibleOnAllSpacesMinVersion = 0,
    kEnterFullscreenMinVersion = 0,
    kExitFullscreenMinVersion = 0,
    kSetCanAppearInExistingFullscreenSpacesMinVersion = 0,
    kSetMiniaturizedMinVersion = 0,
    kSetZoomedMinVersion = 0,
    kSetSizeConstraintsMinVersion = 0,
    kSetOpacityMinVersion = 0,
    kSetWindowLevelMinVersion = 0,
    kSetActivationIndependenceMinVersion = 0,
    kSetAspectRatioMinVersion = 0,
    kSetCALayerParamsMinVersion = 0,
    kSetWindowTitleMinVersion = 0,
    kSetIgnoresMouseEventsMinVersion = 0,
    kMakeFirstResponderMinVersion = 0,
    kSortSubviewsMinVersion = 0,
    kClearTouchBarMinVersion = 0,
    kUpdateTooltipMinVersion = 0,
    kAcquireCaptureMinVersion = 0,
    kReleaseCaptureMinVersion = 0,
    kRedispatchKeyEventMinVersion = 0,
    kSetLocalEventMonitorEnabledMinVersion = 0,
    kSetCursorMinVersion = 0,
    kEnableImmersiveFullscreenMinVersion = 0,
    kDisableImmersiveFullscreenMinVersion = 0,
    kUpdateToolbarVisibilityMinVersion = 0,
    kOnTopContainerViewBoundsChangedMinVersion = 0,
    kImmersiveFullscreenRevealLockMinVersion = 0,
    kImmersiveFullscreenRevealUnlockMinVersion = 0,
    kSetCanGoBackMinVersion = 0,
    kSetCanGoForwardMinVersion = 0,
    kDisplayContextMenuMinVersion = 0,
    kSetAllowScreenshotsMinVersion = 0,
    kSetColorModeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetParent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSelectFileDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowCertificateViewer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StackAbove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StackAtTop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowEmojiPanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitCompositorView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateContentView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyContentView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseWindowNow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInitialBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSizeAndCenter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVisibilityState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAnimationEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTransitionsToAnimate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVisibleOnAllSpaces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCanAppearInExistingFullscreenSpaces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMiniaturized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetZoomed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSizeConstraints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOpacity_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowLevel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetActivationIndependence_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAspectRatio_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCALayerParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIgnoresMouseEvents_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeFirstResponder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SortSubviews_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTouchBar_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTooltip_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcquireCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReleaseCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RedispatchKeyEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLocalEventMonitorEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCursor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableImmersiveFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableImmersiveFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateToolbarVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTopContainerViewBoundsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImmersiveFullscreenRevealLock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImmersiveFullscreenRevealUnlock_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCanGoBack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCanGoForward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisplayContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAllowScreenshots_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetColorMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NativeWidgetNSWindow() = default;

  virtual void CreateWindow(CreateWindowParamsPtr params) = 0;

  virtual void SetParent(uint64_t parent_id) = 0;

  virtual void CreateSelectFileDialog(::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog> dialog) = 0;

  virtual void ShowCertificateViewer(const ::scoped_refptr<::net::X509Certificate>& certificate) = 0;

  virtual void StackAbove(uint64_t sibling_id) = 0;

  virtual void StackAtTop() = 0;

  virtual void ShowEmojiPanel() = 0;

  virtual void InitWindow(NativeWidgetNSWindowInitParamsPtr params) = 0;

  using InitCompositorViewCallback = base::OnceCallback<void(uint32_t)>;
  using InitCompositorViewMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void InitCompositorView(InitCompositorViewCallback callback) = 0;

  virtual void CreateContentView(uint64_t ns_view_id, const ::gfx::Rect& bounds, std::optional<int32_t> corner_radius) = 0;

  virtual void DestroyContentView() = 0;

  virtual void CloseWindow() = 0;

  virtual void CloseWindowNow() = 0;

  virtual void SetInitialBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size) = 0;

  virtual void SetBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size, const std::optional<::gfx::Size>& maximum_content_size) = 0;

  virtual void SetSize(const ::gfx::Size& new_size, const ::gfx::Size& minimum_content_size) = 0;

  virtual void SetSizeAndCenter(const ::gfx::Size& content_size, const ::gfx::Size& minimum_content_size) = 0;

  virtual void SetVisibilityState(WindowVisibilityState new_state) = 0;

  virtual void SetAnimationEnabled(bool animation_enabled) = 0;

  virtual void SetTransitionsToAnimate(VisibilityTransition transitions) = 0;

  virtual void SetVisibleOnAllSpaces(bool always_visible) = 0;

  virtual void EnterFullscreen(int64_t target_display_id) = 0;

  virtual void ExitFullscreen() = 0;

  virtual void SetCanAppearInExistingFullscreenSpaces(bool can_appear_in_existing_fullscreen_spaces) = 0;

  virtual void SetMiniaturized(bool miniaturized) = 0;

  virtual void SetZoomed(bool zoomed) = 0;

  virtual void SetSizeConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool is_resizable, bool is_maximizable) = 0;

  virtual void SetOpacity(float opacity) = 0;

  virtual void SetWindowLevel(int32_t level) = 0;

  virtual void SetActivationIndependence(bool independence) = 0;

  virtual void SetAspectRatio(const ::gfx::SizeF& aspect_ratio, const ::gfx::Size& excluded_margin) = 0;

  virtual void SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) = 0;

  virtual void SetWindowTitle(const ::std::u16string& title) = 0;

  virtual void SetIgnoresMouseEvents(bool ignores_mouse_events) = 0;

  virtual void MakeFirstResponder() = 0;

  virtual void SortSubviews(const std::vector<uint64_t>& attached_subview_ids) = 0;

  virtual void ClearTouchBar() = 0;

  virtual void UpdateTooltip() = 0;

  virtual void AcquireCapture() = 0;

  virtual void ReleaseCapture() = 0;

  virtual void RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data) = 0;

  virtual void SetLocalEventMonitorEnabled(bool enabled) = 0;

  virtual void SetCursor(const ::ui::Cursor& cursor) = 0;

  virtual void EnableImmersiveFullscreen(uint64_t fullscreen_overlay_widget_id, uint64_t tab_widget_id) = 0;

  virtual void DisableImmersiveFullscreen() = 0;

  virtual void UpdateToolbarVisibility(ToolbarVisibilityStyle style) = 0;

  virtual void OnTopContainerViewBoundsChanged(const ::gfx::Rect& bounds) = 0;

  virtual void ImmersiveFullscreenRevealLock() = 0;

  virtual void ImmersiveFullscreenRevealUnlock() = 0;

  virtual void SetCanGoBack(bool can_go_back) = 0;

  virtual void SetCanGoForward(bool can_go_forward) = 0;

  virtual void DisplayContextMenu(::remote_cocoa::mojom::ContextMenuPtr menu, ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost> host, ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu> receiver) = 0;

  virtual void SetAllowScreenshots(bool allow) = 0;

  virtual void SetColorMode(::ui::ColorProviderKey::ColorMode color_mode) = 0;
};



class  NativeWidgetNSWindowProxy
    : public NativeWidgetNSWindow {
 public:
  using InterfaceType = NativeWidgetNSWindow;

  explicit NativeWidgetNSWindowProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWindow(CreateWindowParamsPtr params) final;
  
  void SetParent(uint64_t parent_id) final;
  
  void CreateSelectFileDialog(::mojo::PendingReceiver<::remote_cocoa::mojom::SelectFileDialog> dialog) final;
  
  void ShowCertificateViewer(const ::scoped_refptr<::net::X509Certificate>& certificate) final;
  
  void StackAbove(uint64_t sibling_id) final;
  
  void StackAtTop() final;
  
  void ShowEmojiPanel() final;
  
  void InitWindow(NativeWidgetNSWindowInitParamsPtr params) final;
  
  void InitCompositorView(InitCompositorViewCallback callback) final;
  
  void CreateContentView(uint64_t ns_view_id, const ::gfx::Rect& bounds, std::optional<int32_t> corner_radius) final;
  
  void DestroyContentView() final;
  
  void CloseWindow() final;
  
  void CloseWindowNow() final;
  
  void SetInitialBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size) final;
  
  void SetBounds(const ::gfx::Rect& new_bounds, const ::gfx::Size& minimum_content_size, const std::optional<::gfx::Size>& maximum_content_size) final;
  
  void SetSize(const ::gfx::Size& new_size, const ::gfx::Size& minimum_content_size) final;
  
  void SetSizeAndCenter(const ::gfx::Size& content_size, const ::gfx::Size& minimum_content_size) final;
  
  void SetVisibilityState(WindowVisibilityState new_state) final;
  
  void SetAnimationEnabled(bool animation_enabled) final;
  
  void SetTransitionsToAnimate(VisibilityTransition transitions) final;
  
  void SetVisibleOnAllSpaces(bool always_visible) final;
  
  void EnterFullscreen(int64_t target_display_id) final;
  
  void ExitFullscreen() final;
  
  void SetCanAppearInExistingFullscreenSpaces(bool can_appear_in_existing_fullscreen_spaces) final;
  
  void SetMiniaturized(bool miniaturized) final;
  
  void SetZoomed(bool zoomed) final;
  
  void SetSizeConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool is_resizable, bool is_maximizable) final;
  
  void SetOpacity(float opacity) final;
  
  void SetWindowLevel(int32_t level) final;
  
  void SetActivationIndependence(bool independence) final;
  
  void SetAspectRatio(const ::gfx::SizeF& aspect_ratio, const ::gfx::Size& excluded_margin) final;
  
  void SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) final;
  
  void SetWindowTitle(const ::std::u16string& title) final;
  
  void SetIgnoresMouseEvents(bool ignores_mouse_events) final;
  
  void MakeFirstResponder() final;
  
  void SortSubviews(const std::vector<uint64_t>& attached_subview_ids) final;
  
  void ClearTouchBar() final;
  
  void UpdateTooltip() final;
  
  void AcquireCapture() final;
  
  void ReleaseCapture() final;
  
  void RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data) final;
  
  void SetLocalEventMonitorEnabled(bool enabled) final;
  
  void SetCursor(const ::ui::Cursor& cursor) final;
  
  void EnableImmersiveFullscreen(uint64_t fullscreen_overlay_widget_id, uint64_t tab_widget_id) final;
  
  void DisableImmersiveFullscreen() final;
  
  void UpdateToolbarVisibility(ToolbarVisibilityStyle style) final;
  
  void OnTopContainerViewBoundsChanged(const ::gfx::Rect& bounds) final;
  
  void ImmersiveFullscreenRevealLock() final;
  
  void ImmersiveFullscreenRevealUnlock() final;
  
  void SetCanGoBack(bool can_go_back) final;
  
  void SetCanGoForward(bool can_go_forward) final;
  
  void DisplayContextMenu(::remote_cocoa::mojom::ContextMenuPtr menu, ::mojo::PendingRemote<::remote_cocoa::mojom::MenuHost> host, ::mojo::PendingReceiver<::remote_cocoa::mojom::Menu> receiver) final;
  
  void SetAllowScreenshots(bool allow) final;
  
  void SetColorMode(::ui::ColorProviderKey::ColorMode color_mode) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NativeWidgetNSWindowStubDispatch {
 public:
  static bool Accept(NativeWidgetNSWindow* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeWidgetNSWindow* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeWidgetNSWindow>>
class NativeWidgetNSWindowStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeWidgetNSWindowStub() = default;
  ~NativeWidgetNSWindowStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeWidgetNSWindowStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeWidgetNSWindowStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NativeWidgetNSWindowRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NativeWidgetNSWindowResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  CreateWindowParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateWindowParams, T>::value>;
  using DataView = CreateWindowParamsDataView;
  using Data_ = internal::CreateWindowParams_Data;

  template <typename... Args>
  static CreateWindowParamsPtr New(Args&&... args) {
    return CreateWindowParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateWindowParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateWindowParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWindowParams>::Convert(*this);
  }


  CreateWindowParams();

  CreateWindowParams(
      WindowClass window_class,
      uint64_t style_mask,
      bool titlebar_appears_transparent,
      bool window_title_hidden,
      bool animation_enabled);


  ~CreateWindowParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateWindowParamsPtr>
  CreateWindowParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWindowParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWindowParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWindowParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateWindowParams_UnserializedMessageContext<
            UserType, CreateWindowParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateWindowParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateWindowParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateWindowParams_UnserializedMessageContext<
            UserType, CreateWindowParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateWindowParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WindowClass window_class;
  
  uint64_t style_mask;
  
  bool titlebar_appears_transparent;
  
  bool window_title_hidden;
  
  bool animation_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateWindowParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NativeWidgetNSWindowInitParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativeWidgetNSWindowInitParams, T>::value>;
  using DataView = NativeWidgetNSWindowInitParamsDataView;
  using Data_ = internal::NativeWidgetNSWindowInitParams_Data;

  template <typename... Args>
  static NativeWidgetNSWindowInitParamsPtr New(Args&&... args) {
    return NativeWidgetNSWindowInitParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativeWidgetNSWindowInitParamsPtr From(const U& u) {
    return mojo::TypeConverter<NativeWidgetNSWindowInitParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeWidgetNSWindowInitParams>::Convert(*this);
  }


  NativeWidgetNSWindowInitParams();

  NativeWidgetNSWindowInitParams(
      ::ui::mojom::ModalType modal_type,
      bool is_translucent,
      bool has_window_server_shadow,
      bool force_into_collection_cycle,
      std::vector<uint8_t> state_restoration_data,
      bool is_tooltip);


  ~NativeWidgetNSWindowInitParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativeWidgetNSWindowInitParamsPtr>
  NativeWidgetNSWindowInitParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativeWidgetNSWindowInitParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativeWidgetNSWindowInitParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeWidgetNSWindowInitParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativeWidgetNSWindowInitParams_UnserializedMessageContext<
            UserType, NativeWidgetNSWindowInitParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativeWidgetNSWindowInitParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativeWidgetNSWindowInitParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativeWidgetNSWindowInitParams_UnserializedMessageContext<
            UserType, NativeWidgetNSWindowInitParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativeWidgetNSWindowInitParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::mojom::ModalType modal_type;
  
  bool is_translucent;
  
  bool has_window_server_shadow;
  
  bool force_into_collection_cycle;
  
  std::vector<uint8_t> state_restoration_data;
  
  bool is_tooltip;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CreateWindowParamsPtr CreateWindowParams::Clone() const {
  return New(
      mojo::Clone(window_class),
      mojo::Clone(style_mask),
      mojo::Clone(titlebar_appears_transparent),
      mojo::Clone(window_title_hidden),
      mojo::Clone(animation_enabled)
  );
}

template <typename T, CreateWindowParams::EnableIfSame<T>*>
bool CreateWindowParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->window_class, other_struct.window_class))
    return false;
  if (!mojo::Equals(this->style_mask, other_struct.style_mask))
    return false;
  if (!mojo::Equals(this->titlebar_appears_transparent, other_struct.titlebar_appears_transparent))
    return false;
  if (!mojo::Equals(this->window_title_hidden, other_struct.window_title_hidden))
    return false;
  if (!mojo::Equals(this->animation_enabled, other_struct.animation_enabled))
    return false;
  return true;
}

template <typename T, CreateWindowParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.window_class < rhs.window_class)
    return true;
  if (rhs.window_class < lhs.window_class)
    return false;
  if (lhs.style_mask < rhs.style_mask)
    return true;
  if (rhs.style_mask < lhs.style_mask)
    return false;
  if (lhs.titlebar_appears_transparent < rhs.titlebar_appears_transparent)
    return true;
  if (rhs.titlebar_appears_transparent < lhs.titlebar_appears_transparent)
    return false;
  if (lhs.window_title_hidden < rhs.window_title_hidden)
    return true;
  if (rhs.window_title_hidden < lhs.window_title_hidden)
    return false;
  if (lhs.animation_enabled < rhs.animation_enabled)
    return true;
  if (rhs.animation_enabled < lhs.animation_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
NativeWidgetNSWindowInitParamsPtr NativeWidgetNSWindowInitParams::Clone() const {
  return New(
      mojo::Clone(modal_type),
      mojo::Clone(is_translucent),
      mojo::Clone(has_window_server_shadow),
      mojo::Clone(force_into_collection_cycle),
      mojo::Clone(state_restoration_data),
      mojo::Clone(is_tooltip)
  );
}

template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>*>
bool NativeWidgetNSWindowInitParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->modal_type, other_struct.modal_type))
    return false;
  if (!mojo::Equals(this->is_translucent, other_struct.is_translucent))
    return false;
  if (!mojo::Equals(this->has_window_server_shadow, other_struct.has_window_server_shadow))
    return false;
  if (!mojo::Equals(this->force_into_collection_cycle, other_struct.force_into_collection_cycle))
    return false;
  if (!mojo::Equals(this->state_restoration_data, other_struct.state_restoration_data))
    return false;
  if (!mojo::Equals(this->is_tooltip, other_struct.is_tooltip))
    return false;
  return true;
}

template <typename T, NativeWidgetNSWindowInitParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.modal_type < rhs.modal_type)
    return true;
  if (rhs.modal_type < lhs.modal_type)
    return false;
  if (lhs.is_translucent < rhs.is_translucent)
    return true;
  if (rhs.is_translucent < lhs.is_translucent)
    return false;
  if (lhs.has_window_server_shadow < rhs.has_window_server_shadow)
    return true;
  if (rhs.has_window_server_shadow < lhs.has_window_server_shadow)
    return false;
  if (lhs.force_into_collection_cycle < rhs.force_into_collection_cycle)
    return true;
  if (rhs.force_into_collection_cycle < lhs.force_into_collection_cycle)
    return false;
  if (lhs.state_restoration_data < rhs.state_restoration_data)
    return true;
  if (rhs.state_restoration_data < lhs.state_restoration_data)
    return false;
  if (lhs.is_tooltip < rhs.is_tooltip)
    return true;
  if (rhs.is_tooltip < lhs.is_tooltip)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::CreateWindowParams::DataView,
                                         ::remote_cocoa::mojom::CreateWindowParamsPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::CreateWindowParamsPtr* output) { output->reset(); }

  static decltype(::remote_cocoa::mojom::CreateWindowParams::window_class) window_class(
      const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) {
    return input->window_class;
  }

  static decltype(::remote_cocoa::mojom::CreateWindowParams::style_mask) style_mask(
      const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) {
    return input->style_mask;
  }

  static decltype(::remote_cocoa::mojom::CreateWindowParams::titlebar_appears_transparent) titlebar_appears_transparent(
      const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) {
    return input->titlebar_appears_transparent;
  }

  static decltype(::remote_cocoa::mojom::CreateWindowParams::window_title_hidden) window_title_hidden(
      const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) {
    return input->window_title_hidden;
  }

  static decltype(::remote_cocoa::mojom::CreateWindowParams::animation_enabled) animation_enabled(
      const ::remote_cocoa::mojom::CreateWindowParamsPtr& input) {
    return input->animation_enabled;
  }

  static bool Read(::remote_cocoa::mojom::CreateWindowParams::DataView input, ::remote_cocoa::mojom::CreateWindowParamsPtr* output);
};


template <>
struct  StructTraits<::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::DataView,
                                         ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr* output) { output->reset(); }

  static decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::modal_type) modal_type(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->modal_type;
  }

  static decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::is_translucent) is_translucent(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->is_translucent;
  }

  static decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::has_window_server_shadow) has_window_server_shadow(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->has_window_server_shadow;
  }

  static decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::force_into_collection_cycle) force_into_collection_cycle(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->force_into_collection_cycle;
  }

  static const decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::state_restoration_data)& state_restoration_data(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->state_restoration_data;
  }

  static decltype(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::is_tooltip) is_tooltip(
      const ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr& input) {
    return input->is_tooltip;
  }

  static bool Read(::remote_cocoa::mojom::NativeWidgetNSWindowInitParams::DataView input, ::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_H_