// components/remote_cocoa/common/menu.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/menu.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/menu.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

namespace internal {
// static
bool MenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MenuItem_Data* object = static_cast<const MenuItem_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MenuItem_Tag::kSeparator: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_separator, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_separator, validation_context))
        return false;
      return true;
    }
    case MenuItem_Tag::kRegular: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_regular, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_regular, validation_context))
        return false;
      return true;
    }
    case MenuItem_Tag::kSubmenu: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_submenu, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_submenu, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MenuItem");
      return false;
    }
  }
}


// static
bool MenuItemCommonFields_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MenuItemCommonFields_Data* object =
      static_cast<const MenuItemCommonFields_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

MenuItemCommonFields_Data::MenuItemCommonFields_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SubmenuMenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SubmenuMenuItem_Data* object =
      static_cast<const SubmenuMenuItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

SubmenuMenuItem_Data::SubmenuMenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuControllerParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MenuControllerParams_Data* object =
      static_cast<const MenuControllerParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->badge_font, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->badge_font, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->badge_color, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->badge_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->badge_text_color, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->badge_text_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iph_dot_color, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->iph_dot_color, validation_context))
    return false;

  return true;
}

MenuControllerParams_Data::MenuControllerParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextMenu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextMenu_Data* object =
      static_cast<const ContextMenu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->anchor, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ContextMenu_Data::ContextMenu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuHost_CommandActivated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MenuHost_CommandActivated_Params_Data* object =
      static_cast<const MenuHost_CommandActivated_Params_Data*>(data);

  return true;
}

MenuHost_CommandActivated_Params_Data::MenuHost_CommandActivated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuHost_MenuClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MenuHost_MenuClosed_Params_Data* object =
      static_cast<const MenuHost_MenuClosed_Params_Data*>(data);

  return true;
}

MenuHost_MenuClosed_Params_Data::MenuHost_MenuClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Menu_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Menu_Cancel_Params_Data* object =
      static_cast<const Menu_Cancel_Params_Data*>(data);

  return true;
}

Menu_Cancel_Params_Data::Menu_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Menu_UpdateMenuItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Menu_UpdateMenuItem_Params_Data* object =
      static_cast<const Menu_UpdateMenuItem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  return true;
}

Menu_UpdateMenuItem_Params_Data::Menu_UpdateMenuItem_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa