// components/remote_cocoa/common/font.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/font.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/font.mojom-params-data.h"
#include "components/remote_cocoa/common/font.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/font.mojom-import-headers.h"
#include "components/remote_cocoa/common/font.mojom-test-utils.h"


namespace remote_cocoa::mojom {
Font::Font()
    : name(),
      size(),
      style(),
      weight() {}

Font::Font(
    FontNamePtr name_in,
    uint32_t size_in,
    uint32_t style_in,
    gfx::Font::Weight weight_in)
    : name(std::move(name_in)),
      size(std::move(size_in)),
      style(std::move(style_in)),
      weight(std::move(weight_in)) {}

Font::~Font() = default;

void Font::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FontNamePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight"), this->weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type gfx::Font::Weight>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Font::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FontNamePtr
FontName::NewSystemFont(
    gfx::PlatformFontMac::SystemFontType value) {
  return FontNamePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSystemFont)>,
      std::move(value));
}

FontNamePtr
FontName::NewRegularFont(
    const std::string& value) {
  return FontNamePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegularFont)>,
      std::move(value));
}

FontName::FontName(
    std::in_place_index_t<static_cast<size_t>(Tag::kSystemFont)>,
    gfx::PlatformFontMac::SystemFontType value)
    : tag_(Tag::kSystemFont),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSystemFont)>,
            std::move(value)) {}

FontName::FontName(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegularFont)>,
    const std::string& value)
    : tag_(Tag::kRegularFont),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegularFont)>,
            std::move(value)) {}
FontName::~FontName() {
  DestroyActive();
}

void FontName::set_system_font(gfx::PlatformFontMac::SystemFontType system_font) {
  if (tag_ != Tag::kSystemFont) {
    DestroyActive();
    tag_ = Tag::kSystemFont;
  }
  data_.system_font = system_font;
}

void FontName::set_regular_font(const std::string& regular_font) {
  if (tag_ == Tag::kRegularFont) {
    data_.regular_font = std::move(regular_font);
  } else {
    DestroyActive();
    tag_ = Tag::kRegularFont;
    new (&data_.regular_font) std::string(
        std::move(regular_font));
  }
}


FontName::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSystemFont)>,
    gfx::PlatformFontMac::SystemFontType value)
    : system_font(std::move(value)) {}

FontName::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegularFont)>,
    const std::string& value)
    : regular_font(std::move(value)) {}

void FontName::DestroyActive() {
  switch (tag_) {

    case Tag::kSystemFont:
      std::destroy_at(&data_.system_font);
      break;
    case Tag::kRegularFont:
      std::destroy_at(&data_.regular_font);
      break;
  }
}

bool FontName::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::Font::DataView, ::remote_cocoa::mojom::FontPtr>::Read(
    ::remote_cocoa::mojom::Font::DataView input,
    ::remote_cocoa::mojom::FontPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::FontPtr result(::remote_cocoa::mojom::Font::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->style = input.style();
      if (success && !input.ReadWeight(&result->weight))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::remote_cocoa::mojom::FontName::DataView, ::remote_cocoa::mojom::FontNamePtr>::Read(
    ::remote_cocoa::mojom::FontName::DataView input,
    ::remote_cocoa::mojom::FontNamePtr* output) {
  using UnionType = ::remote_cocoa::mojom::FontName;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSystemFont: {
      gfx::PlatformFontMac::SystemFontType result_system_font;
      if (!input.ReadSystemFont(&result_system_font))
        return false;

      *output = UnionType::NewSystemFont(result_system_font);
      break;
    }
    case Tag::kRegularFont: {
      std::string result_regular_font{};
      if (!input.ReadRegularFont(&result_regular_font))
        return false;

      *output = UnionType::NewRegularFont(
          std::move(result_regular_font));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {




}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif