import '/strings.m.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import type { PolicyInfo, PolicySchema } from './policy_test_browser_proxy.js';
export declare class PolicyTestRowElement extends CustomElement {
    private hasAnError_;
    private errorEvents_;
    private inputType_;
    private schema_?;
    static get template(): string | TrustedHTML;
    constructor();
    getErrorState(): boolean;
    setSchema(schema: PolicySchema): void;
    private onPolicyNamespaceChanged_;
    private onPolicyNameChanged_;
    private changeInputType_;
    private changeAttributesFromPreset_;
    private changePreset_;
    private isValidPolicyName_;
    getNamespace(): string;
    private updatePolicyNamespaces_;
    updatePolicyNames(): void;
    private initialize_;
    setInitialValues(initialValues: PolicyInfo): void;
    private resetErrorState_;
    private setInErrorState_;
    getPolicyValue(): string | number | boolean | any[] | object;
    getPolicyNamespace(): string;
    getPolicyName(): string;
    getPolicyAttribute(attributeName: string): string;
    getStringPolicyAttribute(attributeName: string): string | undefined;
}
declare global {
    interface HTMLElementTagNameMap {
        'policy-test-row': PolicyTestRowElement;
    }
}
