import '/strings.m.js';
import './policy_precedence_row.js';
import './policy_row.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import type { Policy } from './policy_row.js';
export interface PolicyTableModel {
    id?: string;
    isExtension?: boolean;
    name: string;
    policies: NonNullable<Array<NonNullable<Policy>>>;
    precedenceOrder?: string[];
}
export declare class PolicyTableElement extends CustomElement {
    static get template(): string | TrustedHTML;
    dataModel: PolicyTableModel;
    filterPattern: string;
    mostRecentSortOrder: number;
    mostRecentSortedColumn: string;
    updateDataModel(dataModel: PolicyTableModel): void;
    addEventListeners(): void;
    update(order?: number, field?: string): void;
    /**
     * Set the filter pattern. Only policies whose name contains |pattern| are
     * shown in the policy table. The filter is case insensitive. It can be
     * disabled by setting |pattern| to an empty string.
     */
    setFilterPattern(pattern: string): void;
    /**
     * Filter policies. Only policies whose name contains the filter pattern are
     * shown in the table. Furthermore, policies whose value is not currently
     * set are only shown if the corresponding checkbox is checked.
     */
    filter(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'policy-table': PolicyTableElement;
    }
}
