// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./policy_test_table.js";import{addWebUiListener}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{LevelNamesToValues,PolicyLevel,PolicyScope,PolicySource,PolicyTestBrowserProxy,ScopeNamesToValues,SourceNamesToValues}from"./policy_test_browser_proxy.js";const policyTestBrowserProxy=PolicyTestBrowserProxy.getInstance();async function initialize(){await initializeTable();getRequiredElement("import-policies-file-input").addEventListener("change",uploadPoliciesFile);getRequiredElement("apply-policies").addEventListener("click",applyPolicies);getRequiredElement("revert-applied-policies").addEventListener("click",resetPolicies);getRequiredElement("clear-policies").addEventListener("click",clearPolicies);getRequiredElement("export-policies-json").addEventListener("click",exportAndDownloadPolicies);getRequiredElement("restart-browser").addEventListener("click",restartBrowser);getRequiredElement("profile-separation-response").placeholder=`Fake profile separation external response:\n  {\n    "policyValue": "ManagedAccountsSigninRestrictions value",\n    "profileSeparationSettings": 1,\n    "profileSeparationDataMigrationSettings": 2\n  }`;addWebUiListener("schema-updated",onSchemaUpdated);policyTestBrowserProxy.listenPoliciesUpdates()}function onSchemaUpdated(schema){getRequiredElement("policy-test-table").setSchema(schema)}function uploadPoliciesFile(){const fileInput=getRequiredElement("import-policies-file-input");const jsonFile=fileInput.files?.length===1?fileInput.files[0]:null;if(jsonFile){applyPoliciesFromFile(jsonFile)}}async function initializeTable(){const policies=await policyTestBrowserProxy.getAppliedTestPolicies();if(policies.length===0){return}const policyTable=getRequiredElement("policy-test-table");policyTable.clearRows();policies.forEach((policy=>{policyTable.addRow(policy)}));getRequiredElement("revert-applied-policies").disabled=false}function applyPoliciesFromFile(jsonFile){const reader=new FileReader;reader.readAsText(jsonFile);reader.addEventListener("load",(()=>{const fileInput=getRequiredElement("import-policies-file-input");try{const policyTable=getRequiredElement("policy-test-table");policyTable.clearRows();const policies=JSON.parse(reader.result);if(policies.constructor===Array){policies.forEach((policy=>{policyTable.addRow({namespace:"chrome",...policy})}))}else{const policiesObj={chrome:policies.policyValues.chrome.policies,...Object.fromEntries(Object.entries(policies.policyValues.extensions).map((([extensionId,{policies:policies}])=>[extensionId,policies])))};for(const[ns,schema]of Object.entries(policiesObj)){for(const[key,value]of Object.entries(schema)){if(key.startsWith("_")){continue}policyTable.addRow(convertToPolicyInfo(ns,key,value))}}}fileInput.value=""}catch{alert("Invalid file format.")}}),false)}function convertToPolicyInfo(policyNamespace,policyName,value){const policy={namespace:policyNamespace,name:policyName,source:Number(SourceNamesToValues[value["source"]])??PolicySource.SOURCE_ENTERPRISE_DEFAULT_VAL,scope:Number(ScopeNamesToValues[value["scope"]])??PolicyScope.SCOPE_USER_VAL,level:Number(LevelNamesToValues[value["level"]])??PolicyLevel.LEVEL_MANDATORY_VAL,value:value["value"]};return policy}async function applyPolicies(){const policies=getRequiredElement("policy-test-table").getTestPoliciesJsonString();const profileSeparationResponse=getRequiredElement("profile-separation-response").value;if(!policies&&!profileSeparationResponse){return}getRequiredElement("apply-policies").disabled=true;const userAffiliation=getRequiredElement("user-affiliated").checked;await policyTestBrowserProxy.setUserAffiliation(userAffiliation);await policyTestBrowserProxy.applyTestPolicies(policies||"[]",profileSeparationResponse);getRequiredElement("revert-applied-policies").disabled=false;getRequiredElement("apply-policies").disabled=false}function clearPolicies(){getRequiredElement("policy-test-table").clearRows();getRequiredElement("profile-separation-response").value="";getRequiredElement("policy-test-table").addEmptyRow()}function resetPolicies(event){policyTestBrowserProxy.revertTestPolicies();event.target.disabled=true}function exportAndDownloadPolicies(){const jsonString=getRequiredElement("policy-test-table").getTestPoliciesJsonString();if(jsonString){const blob=new Blob([jsonString],{type:"application/json"});const blobUrl=URL.createObjectURL(blob);const link=document.createElement("a");link.href=blobUrl;link.download="test_policies.json";document.body.appendChild(link);link.dispatchEvent(new MouseEvent("click",{bubbles:true,cancelable:true,view:window}))}}function restartBrowser(){const jsonString=getRequiredElement("policy-test-table").getTestPoliciesJsonString();if(jsonString){policyTestBrowserProxy.restartWithTestPolicies(jsonString)}}document.addEventListener("DOMContentLoaded",initialize);addWebUiListener("schema-updated",onSchemaUpdated);policyTestBrowserProxy.listenPoliciesUpdates();