//
// DO NOT MODIFY THIS FILE DIRECTLY!
// IT IS GENERATED BY generate_policy_source.py
// FROM gen/chrome/app/policy/policy_templates.json
//

#ifndef COMPONENTS_POLICY_POLICY_CONSTANTS_H_
#define COMPONENTS_POLICY_POLICY_CONSTANTS_H_

#include <cstdint>
#include <string>

#include "components/policy/core/common/policy_details.h"
#include "components/policy/core/common/policy_map.h"

namespace enterprise_management {
class BooleanPolicyProto;
class CloudPolicySettings;
class IntegerPolicyProto;
class StringListPolicyProto;
class StringPolicyProto;
}

namespace em = enterprise_management;

namespace policy {

namespace internal {
struct SchemaData;
}

#if BUILDFLAG(IS_CHROMEOS)
// Sets default profile policies values for enterprise users.
void SetEnterpriseUsersProfileDefaults(PolicyMap* policy_map);
// Sets default system-wide policies values for enterprise users.
void SetEnterpriseUsersSystemWideDefaults(PolicyMap* policy_map);
// Sets all default values for enterprise users.
void SetEnterpriseUsersDefaults(PolicyMap* policy_map);
#endif

// Returns the PolicyDetails for |policy| if |policy| is a known
// Chrome policy, otherwise returns nullptr.
const PolicyDetails* GetChromePolicyDetails(
const std::string& policy);

// Returns the schema data of the Chrome policy schema.
const internal::SchemaData* GetChromeSchemaData();

// Key names for the policy settings.
namespace key {

extern const char kAIModeSettings[];
extern const char kAbusiveExperienceInterventionEnforce[];
extern const char kAccessCodeCastDeviceDuration[];
extern const char kAccessCodeCastEnabled[];
extern const char kAccessControlAllowMethodsInCORSPreflightSpecConformant[];
extern const char kAccessibilityImageLabelsEnabled[];
extern const char kAdHocCodeSigningForPWAsEnabled[];
extern const char kAdditionalDnsQueryTypesEnabled[];
extern const char kAdsSettingForIntrusiveAdsSites[];
extern const char kAdvancedProtectionAllowed[];
extern const char kAllHttpAuthSchemesAllowedForOrigins[];
extern const char kAllowBackForwardCacheForCacheControlNoStorePageEnabled[];
extern const char kAllowCrossOriginAuthPrompt[];
extern const char kAllowDeletingBrowserHistory[];
extern const char kAllowDinosaurEasterEgg[];
extern const char kAllowFileSelectionDialogs[];
extern const char kAllowWebAuthnWithBrokenTlsCerts[];
extern const char kAllowedDomainsForApps[];
extern const char kAllowedDomainsForAppsList[];
extern const char kAlternateErrorPagesEnabled[];
extern const char kAlternativeBrowserParameters[];
extern const char kAlternativeBrowserPath[];
extern const char kAlwaysOpenPdfExternally[];
extern const char kAmbientAuthenticationInPrivateModesEnabled[];
extern const char kAudioCaptureAllowed[];
extern const char kAudioCaptureAllowedUrls[];
extern const char kAudioSandboxEnabled[];
extern const char kAuthNegotiateDelegateAllowlist[];
extern const char kAuthNegotiateDelegateByKdcPolicy[];
extern const char kAuthSchemes[];
extern const char kAuthServerAllowlist[];
extern const char kAutoFillEnabled[];
extern const char kAutoLaunchProtocolsFromOrigins[];
extern const char kAutoOpenAllowedForURLs[];
extern const char kAutoOpenFileTypes[];
extern const char kAutoSelectCertificateForUrls[];
extern const char kAutofillAddressEnabled[];
extern const char kAutofillCreditCardEnabled[];
extern const char kAutofillPredictionSettings[];
extern const char kAutomatedPasswordChangeSettings[];
extern const char kAutomaticFullscreenAllowedForUrls[];
extern const char kAutomaticFullscreenBlockedForUrls[];
extern const char kAutoplayAllowed[];
extern const char kAutoplayAllowlist[];
extern const char kBasicAuthOverHttpEnabled[];
extern const char kBatterySaverModeAvailability[];
extern const char kBlockExternalExtensions[];
extern const char kBlockThirdPartyCookies[];
extern const char kBookmarkBarEnabled[];
extern const char kBrowserAddPersonEnabled[];
extern const char kBrowserContextAwareAccessSignalsAllowlist[];
extern const char kBrowserGuestModeEnabled[];
extern const char kBrowserGuestModeEnforced[];
extern const char kBrowserLabsEnabled[];
extern const char kBrowserNetworkTimeQueriesEnabled[];
extern const char kBrowserSignin[];
extern const char kBrowserSwitcherDelay[];
extern const char kBrowserSwitcherEnabled[];
extern const char kBrowserSwitcherExternalGreylistUrl[];
extern const char kBrowserSwitcherExternalSitelistUrl[];
extern const char kBrowserSwitcherKeepLastChromeTab[];
extern const char kBrowserSwitcherParsingMode[];
extern const char kBrowserSwitcherUrlGreylist[];
extern const char kBrowserSwitcherUrlList[];
extern const char kBrowserThemeColor[];
extern const char kBrowsingDataLifetime[];
extern const char kBuiltInAIAPIsEnabled[];
extern const char kBuiltInDnsClientEnabled[];
extern const char kCACertificateManagementAllowed[];
extern const char kCACertificates[];
extern const char kCACertificatesWithConstraints[];
extern const char kCADistrustedCertificates[];
extern const char kCAHintCertificates[];
extern const char kCAPlatformIntegrationEnabled[];
extern const char kCORSNonWildcardRequestHeadersSupport[];
extern const char kCacheEncryptionEnabled[];
extern const char kCertificateTransparencyEnforcementDisabledForCas[];
extern const char kCertificateTransparencyEnforcementDisabledForUrls[];
extern const char kChromeDataRegionSetting[];
extern const char kChromeForTestingAllowed[];
extern const char kChromeVariations[];
extern const char kClearBrowsingDataOnExitList[];
extern const char kClearWindowNameForNewBrowsingContextGroup[];
extern const char kClickToCallEnabled[];
extern const char kClipboardAllowedForUrls[];
extern const char kClipboardBlockedForUrls[];
extern const char kCloudExtensionRequestEnabled[];
extern const char kCloudManagementEnrollmentMandatory[];
extern const char kCloudManagementEnrollmentToken[];
extern const char kCloudPolicyOverridesPlatformPolicy[];
extern const char kCloudPrintProxyEnabled[];
extern const char kCloudProfileReportingEnabled[];
extern const char kCloudReportingEnabled[];
extern const char kCloudReportingUploadFrequency[];
extern const char kCloudUserPolicyMerge[];
extern const char kCloudUserPolicyOverridesCloudMachinePolicy[];
extern const char kCoalesceH2ConnectionsWithClientCertificatesForHosts[];
extern const char kCommandLineFlagSecurityWarningsEnabled[];
extern const char kComponentUpdatesEnabled[];
extern const char kCompressionDictionaryTransportEnabled[];
extern const char kControlledFrameAllowedForUrls[];
extern const char kControlledFrameBlockedForUrls[];
extern const char kCookiesAllowedForUrls[];
extern const char kCookiesBlockedForUrls[];
extern const char kCookiesSessionOnlyForUrls[];
extern const char kCopyPreventionSettings[];
extern const char kCreatePasskeysInICloudKeychain[];
extern const char kCreateThemesSettings[];
extern const char kDNSInterceptionChecksEnabled[];
extern const char kDataControlsRules[];
extern const char kDataURLWhitespacePreservationEnabled[];
extern const char kDataUrlInSvgUseEnabled[];
extern const char kDefaultBrowserSettingEnabled[];
extern const char kDefaultClipboardSetting[];
extern const char kDefaultControlledFrameSetting[];
extern const char kDefaultCookiesSetting[];
extern const char kDefaultDirectSocketsPrivateNetworkAccessSetting[];
extern const char kDefaultDirectSocketsSetting[];
extern const char kDefaultDownloadDirectory[];
extern const char kDefaultFileSystemReadGuardSetting[];
extern const char kDefaultFileSystemWriteGuardSetting[];
extern const char kDefaultGeolocationSetting[];
extern const char kDefaultImagesSetting[];
extern const char kDefaultInsecureContentSetting[];
extern const char kDefaultJavaScriptJitSetting[];
extern const char kDefaultJavaScriptOptimizerSetting[];
extern const char kDefaultJavaScriptSetting[];
extern const char kDefaultLocalFontsSetting[];
extern const char kDefaultMediaStreamSetting[];
extern const char kDefaultNotificationsSetting[];
extern const char kDefaultPopupsSetting[];
extern const char kDefaultPrinterSelection[];
extern const char kDefaultSearchProviderAlternateURLs[];
extern const char kDefaultSearchProviderContextMenuAccessAllowed[];
extern const char kDefaultSearchProviderEnabled[];
extern const char kDefaultSearchProviderEncodings[];
extern const char kDefaultSearchProviderImageURL[];
extern const char kDefaultSearchProviderImageURLPostParams[];
extern const char kDefaultSearchProviderKeyword[];
extern const char kDefaultSearchProviderName[];
extern const char kDefaultSearchProviderNewTabURL[];
extern const char kDefaultSearchProviderSearchURL[];
extern const char kDefaultSearchProviderSearchURLPostParams[];
extern const char kDefaultSearchProviderSuggestURL[];
extern const char kDefaultSearchProviderSuggestURLPostParams[];
extern const char kDefaultSensorsSetting[];
extern const char kDefaultSerialGuardSetting[];
extern const char kDefaultThirdPartyStoragePartitioningSetting[];
extern const char kDefaultWebBluetoothGuardSetting[];
extern const char kDefaultWebHidGuardSetting[];
extern const char kDefaultWebUsbGuardSetting[];
extern const char kDefaultWindowManagementSetting[];
extern const char kDefaultWindowPlacementSetting[];
extern const char kDeletingUndecryptablePasswordsEnabled[];
extern const char kDesktopSharingHubEnabled[];
extern const char kDevToolsGenAiSettings[];
extern const char kDevToolsGoogleDeveloperProgramProfileAvailability[];
extern const char kDeveloperToolsAvailability[];
extern const char kDeveloperToolsAvailabilityAllowlist[];
extern const char kDeveloperToolsAvailabilityBlocklist[];
extern const char kDeveloperToolsDisabled[];
extern const char kDirectSocketsAllowedForUrls[];
extern const char kDirectSocketsBlockedForUrls[];
extern const char kDirectSocketsPrivateNetworkAccessAllowedForUrls[];
extern const char kDirectSocketsPrivateNetworkAccessBlockedForUrls[];
extern const char kDisable3DAPIs[];
extern const char kDisableAuthNegotiateCnameLookup[];
extern const char kDisablePrintPreview[];
extern const char kDisableSafeBrowsingProceedAnyway[];
extern const char kDisableScreenshots[];
extern const char kDisabledSchemes[];
extern const char kDiskCacheDir[];
extern const char kDiskCacheSize[];
extern const char kDnsOverHttpsMode[];
extern const char kDnsOverHttpsTemplates[];
extern const char kDomainReliabilityAllowed[];
extern const char kDownloadDirectory[];
extern const char kDownloadRestrictions[];
extern const char kEditBookmarksEnabled[];
extern const char kEnableAuthNegotiatePort[];
extern const char kEnableExperimentalPolicies[];
extern const char kEnableMediaRouter[];
extern const char kEnableOnlineRevocationChecks[];
extern const char kEnableUnsafeSwiftShader[];
extern const char kEncryptedClientHelloEnabled[];
extern const char kEnterpriseCustomLabel[];
extern const char kEnterpriseCustomLabelForBrowser[];
extern const char kEnterpriseHardwarePlatformAPIEnabled[];
extern const char kEnterpriseLogoUrl[];
extern const char kEnterpriseLogoUrlForBrowser[];
extern const char kEnterpriseProfileBadgeToolbarSettings[];
extern const char kEnterpriseProfileCreationKeepBrowsingData[];
extern const char kEnterpriseRealTimeUrlCheckMode[];
extern const char kEnterpriseSearchAggregatorSettings[];
extern const char kExemptDomainFileTypePairsFromFileTypeDownloadWarnings[];
extern const char kExplicitlyAllowedNetworkPorts[];
extern const char kExtensibleEnterpriseSSOBlocklist[];
extern const char kExtensionAllowedTypes[];
extern const char kExtensionDeveloperModeSettings[];
extern const char kExtensionExtendedBackgroundLifetimeForPortConnectionsToUrls[];
extern const char kExtensionForceInstallWithNonMalwareViolationsEnabled[];
extern const char kExtensionInstallAllowlist[];
extern const char kExtensionInstallBlocklist[];
extern const char kExtensionInstallCloudPolicyChecksEnabled[];
extern const char kExtensionInstallForcelist[];
extern const char kExtensionInstallSources[];
extern const char kExtensionInstallTypeBlocklist[];
extern const char kExtensionSettings[];
extern const char kExtensionUnpublishedAvailability[];
extern const char kExternalProtocolDialogShowAlwaysOpenCheckbox[];
extern const char kFeedbackSurveysEnabled[];
extern const char kFetchKeepaliveDurationSecondsOnShutdown[];
extern const char kFileOrDirectoryPickerWithoutGestureAllowedForOrigins[];
extern const char kFileSystemReadAskForUrls[];
extern const char kFileSystemReadBlockedForUrls[];
extern const char kFileSystemWriteAskForUrls[];
extern const char kFileSystemWriteBlockedForUrls[];
extern const char kFirstPartySetsEnabled[];
extern const char kFirstPartySetsOverrides[];
extern const char kForceBrowserSignin[];
extern const char kForceEphemeralProfiles[];
extern const char kForceGoogleSafeSearch[];
extern const char kForcePermissionPolicyUnloadDefaultEnabled[];
extern const char kForceSafeSearch[];
extern const char kForceYouTubeRestrict[];
extern const char kForceYouTubeSafetyMode[];
extern const char kForcedLanguages[];
extern const char kGeminiSettings[];
extern const char kGenAILocalFoundationalModelSettings[];
extern const char kGenAiDefaultSettings[];
extern const char kGloballyScopeHTTPAuthCacheEnabled[];
extern const char kGoogleSearchSidePanelEnabled[];
extern const char kHSTSPolicyBypassList[];
extern const char kHappyEyeballsV3Enabled[];
extern const char kHardwareAccelerationModeEnabled[];
extern const char kHeadlessMode[];
extern const char kHelpMeWriteSettings[];
extern const char kHideWebStoreIcon[];
extern const char kHighEfficiencyModeEnabled[];
extern const char kHistoryClustersVisible[];
extern const char kHistorySearchSettings[];
extern const char kHomepageIsNewTabPage[];
extern const char kHomepageLocation[];
extern const char kHttpAllowlist[];
extern const char kHttpsOnlyMode[];
extern const char kHttpsUpgradesEnabled[];
extern const char kIPv6ReachabilityOverrideEnabled[];
extern const char kIdleTimeout[];
extern const char kIdleTimeoutActions[];
extern const char kImagesAllowedForUrls[];
extern const char kImagesBlockedForUrls[];
extern const char kImportAutofillFormData[];
extern const char kImportBookmarks[];
extern const char kImportHistory[];
extern const char kImportHomepage[];
extern const char kImportSavedPasswords[];
extern const char kImportSearchEngine[];
extern const char kIncognitoEnabled[];
extern const char kIncognitoModeAllowlist[];
extern const char kIncognitoModeAvailability[];
extern const char kIncognitoModeBlocklist[];
extern const char kInsecureContentAllowedForUrls[];
extern const char kInsecureContentBlockedForUrls[];
extern const char kInsecureFormsWarningsEnabled[];
extern const char kIntensiveWakeUpThrottlingEnabled[];
extern const char kIntranetRedirectBehavior[];
extern const char kIsolateOrigins[];
extern const char kIsolatedWebAppInstallForceList[];
extern const char kJavaScriptAllowedForUrls[];
extern const char kJavaScriptBlockedForUrls[];
extern const char kJavaScriptJitAllowedForSites[];
extern const char kJavaScriptJitBlockedForSites[];
extern const char kJavaScriptOptimizerAllowedForSites[];
extern const char kJavaScriptOptimizerBlockedForSites[];
extern const char kJavascriptEnabled[];
extern const char kLegacyCookieScopeEnabled[];
extern const char kLegacyCookieScopeEnabledForDomainList[];
extern const char kLegacyTechReportAllowlist[];
extern const char kLensDesktopNTPSearchEnabled[];
extern const char kLensOverlaySettings[];
extern const char kLensRegionSearchEnabled[];
extern const char kLiveCaptionEnabled[];
extern const char kLiveTranslateEnabled[];
extern const char kLocalFontsAllowedForUrls[];
extern const char kLocalFontsBlockedForUrls[];
extern const char kLocalNetworkAccessAllowedForUrls[];
extern const char kLocalNetworkAccessBlockedForUrls[];
extern const char kLocalNetworkAccessRestrictionsEnabled[];
extern const char kLocalNetworkAccessRestrictionsTemporaryOptOut[];
extern const char kLookalikeWarningAllowlistDomains[];
extern const char kManagedAccountsSigninRestriction[];
extern const char kManagedBookmarks[];
extern const char kManagedConfigurationPerOrigin[];
extern const char kMandatoryExtensionsForIncognitoNavigation[];
extern const char kMaxConnectionsPerProxy[];
extern const char kMaxInvalidationFetchDelay[];
extern const char kMediaRecommendationsEnabled[];
extern const char kMediaRouterCastAllowAllIPs[];
extern const char kMemorySaverModeSavings[];
extern const char kMetricsReportingEnabled[];
extern const char kNTPCardsVisible[];
extern const char kNTPCustomBackgroundEnabled[];
extern const char kNTPFooterExtensionAttributionEnabled[];
extern const char kNTPFooterManagementNoticeEnabled[];
extern const char kNTPMiddleSlotAnnouncementVisible[];
extern const char kNTPOutlookCardVisible[];
extern const char kNTPSharepointCardVisible[];
extern const char kNTPShortcuts[];
extern const char kNativeMessagingAllowlist[];
extern const char kNativeMessagingBlocklist[];
extern const char kNativeMessagingUserLevelHosts[];
extern const char kNetworkPredictionOptions[];
extern const char kNewTabPageLocation[];
extern const char kNotificationsAllowedForUrls[];
extern const char kNotificationsBlockedForUrls[];
extern const char kNtlmV2Enabled[];
extern const char kOnBulkDataEntryEnterpriseConnector[];
extern const char kOnFileAttachedEnterpriseConnector[];
extern const char kOnFileDownloadedEnterpriseConnector[];
extern const char kOnPrintEnterpriseConnector[];
extern const char kOnSecurityEventEnterpriseConnector[];
extern const char kOopPrintDriversAllowed[];
extern const char kOriginAgentClusterDefaultEnabled[];
extern const char kOriginKeyedProcessesEnabled[];
extern const char kOverrideSecurityRestrictionsOnInsecureOrigin[];
extern const char kPartitionedBlobUrlUsage[];
extern const char kPasswordDismissCompromisedAlertEnabled[];
extern const char kPasswordLeakDetectionEnabled[];
extern const char kPasswordManagerBlocklist[];
extern const char kPasswordManagerEnabled[];
extern const char kPasswordManagerPasskeysEnabled[];
extern const char kPasswordProtectionChangePasswordURL[];
extern const char kPasswordProtectionLoginURLs[];
extern const char kPasswordProtectionWarningTrigger[];
extern const char kPasswordSharingEnabled[];
extern const char kPaymentMethodQueryEnabled[];
extern const char kPdfAnnotationsEnabled[];
extern const char kPdfLocalFileAccessAllowedForDomains[];
extern const char kPdfUseSkiaRendererEnabled[];
extern const char kPdfViewerOutOfProcessIframeEnabled[];
extern const char kPolicyAtomicGroupsEnabled[];
extern const char kPolicyDictionaryMultipleSourceMergeList[];
extern const char kPolicyListMultipleSourceMergeList[];
extern const char kPolicyRefreshRate[];
extern const char kPolicyTestPageEnabled[];
extern const char kPopupsAllowedForUrls[];
extern const char kPopupsBlockedForUrls[];
extern const char kPostQuantumKeyAgreementEnabled[];
extern const char kPreferSlowCiphers[];
extern const char kPreferSlowKexAlgorithms[];
extern const char kPrefetchWithServiceWorkerEnabled[];
extern const char kPrintHeaderFooter[];
extern const char kPrintPdfAsImageAvailability[];
extern const char kPrintPdfAsImageDefault[];
extern const char kPrintPreviewUseSystemDefaultPrinter[];
extern const char kPrintRasterizePdfDpi[];
extern const char kPrinterTypeDenyList[];
extern const char kPrintingAllowedBackgroundGraphicsModes[];
extern const char kPrintingBackgroundGraphicsDefault[];
extern const char kPrintingEnabled[];
extern const char kPrintingPaperSizeDefault[];
extern const char kPrivacySandboxAdMeasurementEnabled[];
extern const char kPrivacySandboxAdTopicsEnabled[];
extern const char kPrivacySandboxFingerprintingProtectionEnabled[];
extern const char kPrivacySandboxIpProtectionEnabled[];
extern const char kPrivacySandboxPromptEnabled[];
extern const char kPrivacySandboxSiteEnabledAdsEnabled[];
extern const char kProfilePickerOnStartupAvailability[];
extern const char kProfileReauthPrompt[];
extern const char kProfileSeparationDataMigrationSettings[];
extern const char kProfileSeparationDomainExceptionList[];
extern const char kProfileSeparationSettings[];
extern const char kPromotionalTabsEnabled[];
extern const char kPromotionsEnabled[];
extern const char kPromptForDownloadLocation[];
extern const char kPromptOnMultipleMatchingCertificates[];
extern const char kProvisionManagedClientCertificateForBrowser[];
extern const char kProvisionManagedClientCertificateForUser[];
extern const char kProxyBypassList[];
extern const char kProxyMode[];
extern const char kProxyPacUrl[];
extern const char kProxyServer[];
extern const char kProxyServerMode[];
extern const char kProxySettings[];
extern const char kQRCodeGeneratorEnabled[];
extern const char kQuicAllowed[];
extern const char kReduceAcceptLanguageEnabled[];
extern const char kRegisteredProtocolHandlers[];
extern const char kRelatedWebsiteSetsEnabled[];
extern const char kRelatedWebsiteSetsOverrides[];
extern const char kRelaunchFastIfOutdated[];
extern const char kRelaunchNotification[];
extern const char kRelaunchNotificationPeriod[];
extern const char kRelaunchWindow[];
extern const char kRemoteAccessHostAllowClientPairing[];
extern const char kRemoteAccessHostAllowFileTransfer[];
extern const char kRemoteAccessHostAllowGnubbyAuth[];
extern const char kRemoteAccessHostAllowPinAuthentication[];
extern const char kRemoteAccessHostAllowRelayedConnection[];
extern const char kRemoteAccessHostAllowRemoteAccessConnections[];
extern const char kRemoteAccessHostAllowRemoteSupportConnections[];
extern const char kRemoteAccessHostAllowUrlForwarding[];
extern const char kRemoteAccessHostClientDomain[];
extern const char kRemoteAccessHostClientDomainList[];
extern const char kRemoteAccessHostClipboardSizeBytes[];
extern const char kRemoteAccessHostDomain[];
extern const char kRemoteAccessHostDomainList[];
extern const char kRemoteAccessHostEnableUserInterface[];
extern const char kRemoteAccessHostFirewallTraversal[];
extern const char kRemoteAccessHostMatchUsername[];
extern const char kRemoteAccessHostMaximumSessionDurationMinutes[];
extern const char kRemoteAccessHostRequireCurtain[];
extern const char kRemoteAccessHostUdpPortRange[];
extern const char kRemoteDebuggingAllowed[];
extern const char kReportExtensionsAndPluginsData[];
extern const char kReportMachineIDData[];
extern const char kReportPolicyData[];
extern const char kReportUserIDData[];
extern const char kReportVersionData[];
extern const char kReportingEndpoints[];
extern const char kRequireOnlineRevocationChecksForLocalAnchors[];
extern const char kRestoreOnStartup[];
extern const char kRestoreOnStartupURLs[];
extern const char kRestrictSigninToPattern[];
extern const char kRoamingProfileLocation[];
extern const char kRoamingProfileSupportEnabled[];
extern const char kSSLErrorOverrideAllowed[];
extern const char kSSLErrorOverrideAllowedForOrigins[];
extern const char kSafeBrowsingAllowlistDomains[];
extern const char kSafeBrowsingDeepScanningEnabled[];
extern const char kSafeBrowsingEnabled[];
extern const char kSafeBrowsingExtendedReportingEnabled[];
extern const char kSafeBrowsingProtectionLevel[];
extern const char kSafeBrowsingProxiedRealTimeChecksAllowed[];
extern const char kSafeBrowsingSurveysEnabled[];
extern const char kSafeSitesFilterBehavior[];
extern const char kSameOriginTabCaptureAllowedByOrigins[];
extern const char kSandboxExternalProtocolBlocked[];
extern const char kSavingBrowserHistoryDisabled[];
extern const char kScreenCaptureAllowed[];
extern const char kScreenCaptureAllowedByOrigins[];
extern const char kScreenCaptureWithoutGestureAllowedForOrigins[];
extern const char kScrollToTextFragmentEnabled[];
extern const char kSearchSuggestEnabled[];
extern const char kSecurityKeyPermitAttestation[];
extern const char kSensorsAllowedForUrls[];
extern const char kSensorsBlockedForUrls[];
extern const char kSerialAllowAllPortsForUrls[];
extern const char kSerialAllowUsbDevicesForUrls[];
extern const char kSerialAskForUrls[];
extern const char kSerialBlockedForUrls[];
extern const char kServiceWorkerAutoPreloadEnabled[];
extern const char kServiceWorkerToControlSrcdocIframeEnabled[];
extern const char kSharedArrayBufferUnrestrictedAccessAllowed[];
extern const char kSharedClipboardEnabled[];
extern const char kSharedWorkerBlobURLFixEnabled[];
extern const char kShoppingListEnabled[];
extern const char kShowAppsShortcutInBookmarkBar[];
extern const char kShowCastIconInToolbar[];
extern const char kShowCastSessionsStartedByOtherDevices[];
extern const char kShowFullUrlsInAddressBar[];
extern const char kShowHomeButton[];
extern const char kSideSearchEnabled[];
extern const char kSignedHTTPExchangeEnabled[];
extern const char kSigninAllowed[];
extern const char kSigninInterceptionEnabled[];
extern const char kSitePerProcess[];
extern const char kSiteSearchSettings[];
extern const char kSpellCheckServiceEnabled[];
extern const char kSpellcheckEnabled[];
extern const char kStandardizedBrowserZoomEnabled[];
extern const char kStrictMimetypeCheckForWorkerScriptsEnabled[];
extern const char kSuppressDifferentOriginSubframeDialogs[];
extern const char kSuppressUnsupportedOSWarning[];
extern const char kSyncDisabled[];
extern const char kSyncTypesListDisabled[];
extern const char kTLS13EarlyDataEnabled[];
extern const char kTabCaptureAllowedByOrigins[];
extern const char kTabCompareSettings[];
extern const char kTabDiscardingExceptions[];
extern const char kTabGroupSharingSettings[];
extern const char kTaskManagerEndProcessEnabled[];
extern const char kThirdPartyStoragePartitioningBlockedForOrigins[];
extern const char kTotalMemoryLimitMb[];
extern const char kTranslateEnabled[];
extern const char kTranslatorAPIAllowed[];
extern const char kURLAllowlist[];
extern const char kURLBlocklist[];
extern const char kUnmanagedDeviceSignalsConsentFlowEnabled[];
extern const char kUnsafelyTreatInsecureOriginAsSecure[];
extern const char kUrlKeyedAnonymizedDataCollectionEnabled[];
extern const char kUrlKeyedMetricsAllowed[];
extern const char kUserAgentReduction[];
extern const char kUserContextAwareAccessSignalsAllowlist[];
extern const char kUserDataDir[];
extern const char kUserDataSnapshotRetentionLimit[];
extern const char kUserFeedbackAllowed[];
extern const char kUserSecurityAuthenticatedReporting[];
extern const char kUserSecuritySignalsReporting[];
extern const char kVariationsRestrictParameter[];
extern const char kVideoCaptureAllowed[];
extern const char kVideoCaptureAllowedUrls[];
extern const char kWPADQuickCheckEnabled[];
extern const char kWarnBeforeQuittingEnabled[];
extern const char kWatermarkStyle[];
extern const char kWebAppInstallForceList[];
extern const char kWebAppSettings[];
extern const char kWebAudioOutputBufferingEnabled[];
extern const char kWebAuthenticationRemoteDesktopAllowedOrigins[];
extern const char kWebAuthenticationRemoteProxiedRequestsAllowed[];
extern const char kWebHidAllowAllDevicesForUrls[];
extern const char kWebHidAllowDevicesForUrls[];
extern const char kWebHidAllowDevicesWithHidUsagesForUrls[];
extern const char kWebHidAskForUrls[];
extern const char kWebHidBlockedForUrls[];
extern const char kWebRtcEventLogCollectionAllowed[];
extern const char kWebRtcIPHandling[];
extern const char kWebRtcIPHandlingUrl[];
extern const char kWebRtcLocalIpsAllowedUrls[];
extern const char kWebRtcPostQuantumKeyAgreement[];
extern const char kWebRtcTextLogCollectionAllowed[];
extern const char kWebRtcUdpPortRange[];
extern const char kWebUsbAllowDevicesForUrls[];
extern const char kWebUsbAskForUrls[];
extern const char kWebUsbBlockedForUrls[];
extern const char kWindowCaptureAllowedByOrigins[];
extern const char kWindowManagementAllowedForUrls[];
extern const char kWindowManagementBlockedForUrls[];
extern const char kWindowPlacementAllowedForUrls[];
extern const char kWindowPlacementBlockedForUrls[];

}  // namespace key

// Group names for the policy settings.
namespace group {

extern const char kActiveDirectoryManagement[];
extern const char kAttestation[];
extern const char kBrowserEventReporting[];
extern const char kBrowserIdle[];
extern const char kBrowserSwitcher[];
extern const char kCloudReporting[];
extern const char kControlledFrameSettings[];
extern const char kCookiesSettings[];
extern const char kDateAndTime[];
extern const char kDefaultSearchProvider[];
extern const char kDeviceAttributesSettings[];
extern const char kDirectSocketsSettings[];
extern const char kDisplay[];
extern const char kDrive[];
extern const char kExtensions[];
extern const char kFloatingSso[];
extern const char kGoogleCast[];
extern const char kHomepage[];
extern const char kImageSettings[];
extern const char kJavascriptSettings[];
extern const char kKerberosPrefilledConfig[];
extern const char kKeygenSettings[];
extern const char kKiosk[];
extern const char kLegacyCookieScopeSettings[];
extern const char kLegacySameSiteCookieBehaviorSettings[];
extern const char kLocalFontsSettings[];
extern const char kLocalNetworkAccessSettings[];
extern const char kLoginScreenOrigins[];
extern const char kNativeMessaging[];
extern const char kNetworkFileShares[];
extern const char kNotificationsSettings[];
extern const char kPasswordManager[];
extern const char kPasswordProtection[];
extern const char kPinUnlock[];
extern const char kPluginVm[];
extern const char kPluginsSettings[];
extern const char kPopupsSettings[];
extern const char kPrivacySandbox[];
extern const char kPrivateNetworkRequestSettings[];
extern const char kProfileSeparation[];
extern const char kProtectedContent[];
extern const char kProxy[];
extern const char kQuickUnlock[];
extern const char kRemoteAccess[];
extern const char kRestoreOnStartup[];
extern const char kSAML[];
extern const char kSafeBrowsing[];
extern const char kScreenCaptureSettings[];
extern const char kSensorsSettings[];
extern const char kSkyVaultSettings[];
extern const char kSmartCardConnectSettings[];
extern const char kSupervisedUsers[];
extern const char kThirdPartyStoragePartitioningSettings[];
extern const char kUserAndDeviceReporting[];
extern const char kWebPrintingSettings[];
extern const char kWebRtc[];
extern const char kWebUsbSettings[];
extern const char kWiFi[];
extern const char kWindowManagementSettings[];

}  // namespace group

struct AtomicGroup {
  const short id;
  const char* policy_group;
  const char* const* policies;
};

extern const AtomicGroup kPolicyAtomicGroupMappings[];

extern const size_t kPolicyAtomicGroupMappingsLength;

// Arrays of metapolicies.
namespace metapolicy {

extern const char* const kMerge[3];
extern const char* const kPrecedence[2];

}  // namespace metapolicy

// The policies that are considered only if the user is part of an AD
// domain on Windows, managed on Mac, or enrolled in Chrome Enterprise Core.
base::span<const char* const> GetSensitivePolicies();

enum class StringPolicyType {
  STRING,
  JSON,
  EXTERNAL,
};

// Read access to the protobufs of all supported boolean user policies.
struct BooleanPolicyAccess {
  const char* policy_key;
  bool per_profile;
  bool (*has_proto)(const em::CloudPolicySettings& policy);
  const em::BooleanPolicyProto& (*get_proto)(
      const em::CloudPolicySettings& policy);
};
extern const std::array<BooleanPolicyAccess, 233> kBooleanPolicyAccess;

// Read access to the protobufs of all supported integer user policies.
struct IntegerPolicyAccess {
  const char* policy_key;
  bool per_profile;
  bool (*has_proto)(const em::CloudPolicySettings& policy);
  const em::IntegerPolicyProto& (*get_proto)(
      const em::CloudPolicySettings& policy);
};
extern const std::array<IntegerPolicyAccess, 89> kIntegerPolicyAccess;

// Read access to the protobufs of all supported string user policies.
struct StringPolicyAccess {
  const char* policy_key;
  bool per_profile;
  bool (*has_proto)(const em::CloudPolicySettings& policy);
  const em::StringPolicyProto& (*get_proto)(
      const em::CloudPolicySettings& policy);
  const StringPolicyType type;
};
extern const std::array<StringPolicyAccess, 84> kStringPolicyAccess;

// Read access to the protobufs of all supported stringlist user policies.
struct StringListPolicyAccess {
  const char* policy_key;
  bool per_profile;
  bool (*has_proto)(const em::CloudPolicySettings& policy);
  const em::StringListPolicyProto& (*get_proto)(
      const em::CloudPolicySettings& policy);
};
extern const std::array<StringListPolicyAccess, 124> kStringListPolicyAccess;

constexpr int64_t kDevicePolicyExternalDataResourceCacheSize = 0;

}  // namespace policy

#endif  // COMPONENTS_POLICY_POLICY_CONSTANTS_H_
