// components/paint_preview/common/mojom/paint_preview_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SEND_VALIDATION_H_

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::paint_preview::mojom::RecordingPersistence, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::paint_preview::mojom::ClipCoordOverride, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::paint_preview::mojom::SerializedRecordingDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::paint_preview::mojom::SerializedRecordingDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::paint_preview::mojom::internal::SerializedRecording_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::paint_preview::mojom::SerializedRecordingDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in SerializedRecording union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::paint_preview::mojom::SerializedRecordingDataView::Tag::kBuffer: {
    decltype(Traits::buffer(input))
    in_buffer = Traits::buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_buffer)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
  in_buffer,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null buffer in SerializedRecording union");
    fragment->data.f_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SEND_VALIDATION_H_