// components/paint_preview/common/mojom/paint_preview_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"


namespace paint_preview::mojom {
class SerializedRecordingDataView;


}  // paint_preview::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::SerializedRecordingDataView> {
  using Data = ::paint_preview::mojom::internal::SerializedRecording_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview::mojom {


enum class RecordingPersistence : int32_t {
  
  kFileSystem = 0,
  
  kMemoryBuffer = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RecordingPersistence value);
inline bool IsKnownEnumValue(RecordingPersistence value) {
  return internal::RecordingPersistence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ClipCoordOverride : int32_t {
  
  kNone = 0,
  
  kCenterOnScrollOffset = 1,
  
  kScrollOffset = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ClipCoordOverride value);
inline bool IsKnownEnumValue(ClipCoordOverride value) {
  return internal::ClipCoordOverride_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SerializedRecordingDataView {
 public:
  using Tag = internal::SerializedRecording_Data::SerializedRecording_Tag;

  SerializedRecordingDataView() = default;

  SerializedRecordingDataView(
      internal::SerializedRecording_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_buffer() const { return data_->tag == Tag::kBuffer; }
  inline void GetBufferDataView(
      ::mojo_base::mojom::BigBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) const {
    
    CHECK(is_buffer());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        data_->data.f_buffer.Get(), output, message_);
  }

 private:
  internal::SerializedRecording_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // paint_preview::mojom

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_DATA_VIEW_H_