// components/page_load_metrics/common/page_load_metrics.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/javascript_framework_detection.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/use_counter_feature.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace page_load_metrics::mojom {
class DocumentTimingDataView;

class LcpResourceLoadTimingsDataView;

class LargestContentfulPaintTimingDataView;

class PaintTimingDataView;

class ParseTimingDataView;

class InteractiveTimingDataView;

class CustomUserTimingMarkDataView;

class DomainLookupTimingDataView;

class PageLoadTimingDataView;

class FrameMetadataDataView;

class SubresourceLoadMetricsDataView;

class ServiceWorkerSubresourceLoadMetricsDataView;

class ResourceDataUpdateDataView;

class LayoutShiftDataView;

class FrameRenderDataUpdateDataView;

class CpuTimingDataView;

class InputTimingDataView;

class UserInteractionLatencyDataView;

class BackForwardCacheTimingDataView;

class SoftNavigationMetricsDataView;



}  // page_load_metrics::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::DocumentTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::DocumentTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::LcpResourceLoadTimingsDataView> {
  using Data = ::page_load_metrics::mojom::internal::LcpResourceLoadTimings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::LargestContentfulPaintTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::PaintTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::PaintTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::ParseTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::ParseTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::InteractiveTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::InteractiveTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::CustomUserTimingMarkDataView> {
  using Data = ::page_load_metrics::mojom::internal::CustomUserTimingMark_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::DomainLookupTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::DomainLookupTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::PageLoadTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::PageLoadTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::FrameMetadataDataView> {
  using Data = ::page_load_metrics::mojom::internal::FrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::SubresourceLoadMetricsDataView> {
  using Data = ::page_load_metrics::mojom::internal::SubresourceLoadMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView> {
  using Data = ::page_load_metrics::mojom::internal::ServiceWorkerSubresourceLoadMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::ResourceDataUpdateDataView> {
  using Data = ::page_load_metrics::mojom::internal::ResourceDataUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::LayoutShiftDataView> {
  using Data = ::page_load_metrics::mojom::internal::LayoutShift_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::FrameRenderDataUpdateDataView> {
  using Data = ::page_load_metrics::mojom::internal::FrameRenderDataUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::CpuTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::CpuTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::InputTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::InputTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::UserInteractionLatencyDataView> {
  using Data = ::page_load_metrics::mojom::internal::UserInteractionLatency_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::BackForwardCacheTimingDataView> {
  using Data = ::page_load_metrics::mojom::internal::BackForwardCacheTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::page_load_metrics::mojom::SoftNavigationMetricsDataView> {
  using Data = ::page_load_metrics::mojom::internal::SoftNavigationMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace page_load_metrics::mojom {


enum class CacheType : int32_t {
  
  kNotCached = 0,
  
  kHttp = 1,
  
  kMemory = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CacheType value);
inline bool IsKnownEnumValue(CacheType value) {
  return internal::CacheType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageLoadMetricsInterfaceBase {};

using PageLoadMetricsPtrDataView =
    mojo::InterfacePtrDataView<PageLoadMetricsInterfaceBase>;
using PageLoadMetricsRequestDataView =
    mojo::InterfaceRequestDataView<PageLoadMetricsInterfaceBase>;
using PageLoadMetricsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageLoadMetricsInterfaceBase>;
using PageLoadMetricsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageLoadMetricsInterfaceBase>;


class DocumentTimingDataView {
 public:
  DocumentTimingDataView() = default;

  DocumentTimingDataView(
      internal::DocumentTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDomContentLoadedEventStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomContentLoadedEventStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `dom_content_loaded_event_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomContentLoadedEventStart` instead "
    "of `ReadDomContentLoadedEventStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dom_content_loaded_event_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLoadEventStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadEventStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `load_event_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadEventStart` instead "
    "of `ReadLoadEventStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->load_event_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::DocumentTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LcpResourceLoadTimingsDataView {
 public:
  LcpResourceLoadTimingsDataView() = default;

  LcpResourceLoadTimingsDataView(
      internal::LcpResourceLoadTimings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDiscoveryTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDiscoveryTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `discovery_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDiscoveryTime` instead "
    "of `ReadDiscoveryTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->discovery_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLoadStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `load_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadStart` instead "
    "of `ReadLoadStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->load_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLoadEndDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `load_end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadEnd` instead "
    "of `ReadLoadEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->load_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::LcpResourceLoadTimings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LargestContentfulPaintTimingDataView {
 public:
  LargestContentfulPaintTimingDataView() = default;

  LargestContentfulPaintTimingDataView(
      internal::LargestContentfulPaintTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLargestImagePaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargestImagePaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `largest_image_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargestImagePaint` instead "
    "of `ReadLargestImagePaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->largest_image_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t largest_image_paint_size() const {
    return data_->largest_image_paint_size;
  }
  inline void GetLargestTextPaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargestTextPaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `largest_text_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargestTextPaint` instead "
    "of `ReadLargestTextPaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->largest_text_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t largest_text_paint_size() const {
    return data_->largest_text_paint_size;
  }
  inline void GetResourceLoadTimingsDataView(
      LcpResourceLoadTimingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceLoadTimings(UserType* output) {
    
    auto* pointer = data_->resource_load_timings.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::LcpResourceLoadTimingsDataView>(
        pointer, output, message_);
  }
  uint64_t type() const {
    return data_->type;
  }
  double image_bpp() const {
    return data_->image_bpp;
  }
  bool image_request_priority_valid() const {
    return data_->image_request_priority_valid;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadImageRequestPriorityValue(UserType* output) const {
    auto data_value = data_->image_request_priority_value;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority image_request_priority_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->image_request_priority_value));
  }
 private:
  internal::LargestContentfulPaintTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintTimingDataView {
 public:
  PaintTimingDataView() = default;

  PaintTimingDataView(
      internal::PaintTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFirstPaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstPaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstPaint` instead "
    "of `ReadFirstPaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstImagePaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstImagePaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_image_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstImagePaint` instead "
    "of `ReadFirstImagePaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_image_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstContentfulPaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstContentfulPaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_contentful_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstContentfulPaint` instead "
    "of `ReadFirstContentfulPaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_contentful_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstMeaningfulPaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstMeaningfulPaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_meaningful_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstMeaningfulPaint` instead "
    "of `ReadFirstMeaningfulPaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_meaningful_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLargestContentfulPaintDataView(
      LargestContentfulPaintTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargestContentfulPaint(UserType* output) {
    
    auto* pointer = data_->largest_contentful_paint.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView>(
        pointer, output, message_);
  }
  inline void GetExperimentalLargestContentfulPaintDataView(
      LargestContentfulPaintTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExperimentalLargestContentfulPaint(UserType* output) {
    
    auto* pointer = data_->experimental_largest_contentful_paint.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView>(
        pointer, output, message_);
  }
  inline void GetFirstEligibleToPaintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstEligibleToPaint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_eligible_to_paint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstEligibleToPaint` instead "
    "of `ReadFirstEligibleToPaint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_eligible_to_paint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstInputOrScrollNotifiedTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstInputOrScrollNotifiedTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_input_or_scroll_notified_timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstInputOrScrollNotifiedTimestamp` instead "
    "of `ReadFirstInputOrScrollNotifiedTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_input_or_scroll_notified_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::PaintTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParseTimingDataView {
 public:
  ParseTimingDataView() = default;

  ParseTimingDataView(
      internal::ParseTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParseStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseStart` instead "
    "of `ReadParseStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetParseStopDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseStop(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_stop` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseStop` instead "
    "of `ReadParseStop if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_stop.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetParseBlockedOnScriptLoadDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseBlockedOnScriptLoadDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_blocked_on_script_load_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseBlockedOnScriptLoadDuration` instead "
    "of `ReadParseBlockedOnScriptLoadDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_blocked_on_script_load_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetParseBlockedOnScriptLoadFromDocumentWriteDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseBlockedOnScriptLoadFromDocumentWriteDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_blocked_on_script_load_from_document_write_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseBlockedOnScriptLoadFromDocumentWriteDuration` instead "
    "of `ReadParseBlockedOnScriptLoadFromDocumentWriteDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_blocked_on_script_load_from_document_write_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetParseBlockedOnScriptExecutionDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseBlockedOnScriptExecutionDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_blocked_on_script_execution_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseBlockedOnScriptExecutionDuration` instead "
    "of `ReadParseBlockedOnScriptExecutionDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_blocked_on_script_execution_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetParseBlockedOnScriptExecutionFromDocumentWriteDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseBlockedOnScriptExecutionFromDocumentWriteDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `parse_blocked_on_script_execution_from_document_write_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParseBlockedOnScriptExecutionFromDocumentWriteDuration` instead "
    "of `ReadParseBlockedOnScriptExecutionFromDocumentWriteDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parse_blocked_on_script_execution_from_document_write_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParseTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InteractiveTimingDataView {
 public:
  InteractiveTimingDataView() = default;

  InteractiveTimingDataView(
      internal::InteractiveTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFirstInputDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstInputDelay(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_input_delay` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstInputDelay` instead "
    "of `ReadFirstInputDelay if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_input_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstInputTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstInputTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_input_timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstInputTimestamp` instead "
    "of `ReadFirstInputTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_input_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstScrollDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstScrollDelay(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_scroll_delay` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstScrollDelay` instead "
    "of `ReadFirstScrollDelay if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_scroll_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFirstScrollTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstScrollTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_scroll_timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstScrollTimestamp` instead "
    "of `ReadFirstScrollTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_scroll_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::InteractiveTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CustomUserTimingMarkDataView {
 public:
  CustomUserTimingMarkDataView() = default;

  CustomUserTimingMarkDataView(
      internal::CustomUserTimingMark_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMarkNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMarkName(UserType* output) {
    
    auto* pointer = data_->mark_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::CustomUserTimingMark_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DomainLookupTimingDataView {
 public:
  DomainLookupTimingDataView() = default;

  DomainLookupTimingDataView(
      internal::DomainLookupTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDomainLookupStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainLookupStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `domain_lookup_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomainLookupStart` instead "
    "of `ReadDomainLookupStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->domain_lookup_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDomainLookupEndDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainLookupEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `domain_lookup_end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomainLookupEnd` instead "
    "of `ReadDomainLookupEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->domain_lookup_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::DomainLookupTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageLoadTimingDataView {
 public:
  PageLoadTimingDataView() = default;

  PageLoadTimingDataView(
      internal::PageLoadTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetConnectStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `connect_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConnectStart` instead "
    "of `ReadConnectStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->connect_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetConnectEndDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectEnd(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `connect_end` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConnectEnd` instead "
    "of `ReadConnectEnd if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->connect_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetResponseStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `response_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponseStart` instead "
    "of `ReadResponseStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentTimingDataView(
      DocumentTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentTiming(UserType* output) {
    
    auto* pointer = data_->document_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::DocumentTimingDataView>(
        pointer, output, message_);
  }
  inline void GetInteractiveTimingDataView(
      InteractiveTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInteractiveTiming(UserType* output) {
    
    auto* pointer = data_->interactive_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::InteractiveTimingDataView>(
        pointer, output, message_);
  }
  inline void GetPaintTimingDataView(
      PaintTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaintTiming(UserType* output) {
    
    auto* pointer = data_->paint_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::PaintTimingDataView>(
        pointer, output, message_);
  }
  inline void GetParseTimingDataView(
      ParseTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParseTiming(UserType* output) {
    
    auto* pointer = data_->parse_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::ParseTimingDataView>(
        pointer, output, message_);
  }
  inline void GetDomainLookupTimingDataView(
      DomainLookupTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainLookupTiming(UserType* output) {
    
    auto* pointer = data_->domain_lookup_timing.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::DomainLookupTimingDataView>(
        pointer, output, message_);
  }
  inline void GetBackForwardCacheTimingsDataView(
      mojo::ArrayDataView<BackForwardCacheTimingDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackForwardCacheTimings(UserType* output) {
    
    auto* pointer = data_->back_forward_cache_timings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::page_load_metrics::mojom::BackForwardCacheTimingDataView>>(
        pointer, output, message_);
  }
  inline void GetActivationStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivationStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `activation_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActivationStart` instead "
    "of `ReadActivationStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->activation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetInputToNavigationStartDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputToNavigationStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `input_to_navigation_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputToNavigationStart` instead "
    "of `ReadInputToNavigationStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_to_navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetUserTimingMarkFullyLoadedDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserTimingMarkFullyLoaded(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `user_timing_mark_fully_loaded` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserTimingMarkFullyLoaded` instead "
    "of `ReadUserTimingMarkFullyLoaded if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_timing_mark_fully_loaded.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetUserTimingMarkFullyVisibleDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserTimingMarkFullyVisible(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `user_timing_mark_fully_visible` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserTimingMarkFullyVisible` instead "
    "of `ReadUserTimingMarkFullyVisible if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_timing_mark_fully_visible.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetUserTimingMarkInteractiveDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserTimingMarkInteractive(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `user_timing_mark_interactive` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserTimingMarkInteractive` instead "
    "of `ReadUserTimingMarkInteractive if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_timing_mark_interactive.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageLoadTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameMetadataDataView {
 public:
  FrameMetadataDataView() = default;

  FrameMetadataDataView(
      internal::FrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t behavior_flags() const {
    return data_->behavior_flags;
  }
  inline void GetMainFrameIntersectionRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameIntersectionRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `main_frame_intersection_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMainFrameIntersectionRect` instead "
    "of `ReadMainFrameIntersectionRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->main_frame_intersection_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameViewportRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameViewportRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `main_frame_viewport_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMainFrameViewportRect` instead "
    "of `ReadMainFrameViewportRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->main_frame_viewport_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameAdRectsDataView(
      mojo::MapDataView<int32_t, ::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameAdRects(UserType* output) {
    
    auto* pointer = data_->main_frame_ad_rects.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, ::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  inline void GetFrameworkDetectionResultDataView(
      ::blink::mojom::JavaScriptFrameworkDetectionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameworkDetectionResult(UserType* output) {
    
    auto* pointer = data_->framework_detection_result.Get();
    return mojo::internal::Deserialize<::blink::mojom::JavaScriptFrameworkDetectionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SubresourceLoadMetricsDataView {
 public:
  SubresourceLoadMetricsDataView() = default;

  SubresourceLoadMetricsDataView(
      internal::SubresourceLoadMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t number_of_subresources_loaded() const {
    return data_->number_of_subresources_loaded;
  }
  uint32_t number_of_subresource_loads_handled_by_service_worker() const {
    return data_->number_of_subresource_loads_handled_by_service_worker;
  }
  inline void GetServiceWorkerSubresourceLoadMetricsDataView(
      ServiceWorkerSubresourceLoadMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerSubresourceLoadMetrics(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView, UserType>(),
    "Attempting to read the optional `service_worker_subresource_load_metrics` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerSubresourceLoadMetrics` instead "
    "of `ReadServiceWorkerSubresourceLoadMetrics if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_subresource_load_metrics.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::ServiceWorkerSubresourceLoadMetricsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SubresourceLoadMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerSubresourceLoadMetricsDataView {
 public:
  ServiceWorkerSubresourceLoadMetricsDataView() = default;

  ServiceWorkerSubresourceLoadMetricsDataView(
      internal::ServiceWorkerSubresourceLoadMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool image_handled() const {
    return data_->image_handled;
  }
  bool image_fallback() const {
    return data_->image_fallback;
  }
  bool css_handled() const {
    return data_->css_handled;
  }
  bool css_fallback() const {
    return data_->css_fallback;
  }
  bool script_handled() const {
    return data_->script_handled;
  }
  bool script_fallback() const {
    return data_->script_fallback;
  }
  bool font_handled() const {
    return data_->font_handled;
  }
  bool font_fallback() const {
    return data_->font_fallback;
  }
  bool raw_handled() const {
    return data_->raw_handled;
  }
  bool raw_fallback() const {
    return data_->raw_fallback;
  }
  bool svg_handled() const {
    return data_->svg_handled;
  }
  bool svg_fallback() const {
    return data_->svg_fallback;
  }
  bool xsl_handled() const {
    return data_->xsl_handled;
  }
  bool xsl_fallback() const {
    return data_->xsl_fallback;
  }
  bool link_prefetch_handled() const {
    return data_->link_prefetch_handled;
  }
  bool link_prefetch_fallback() const {
    return data_->link_prefetch_fallback;
  }
  bool text_track_handled() const {
    return data_->text_track_handled;
  }
  bool text_track_fallback() const {
    return data_->text_track_fallback;
  }
  bool audio_handled() const {
    return data_->audio_handled;
  }
  bool audio_fallback() const {
    return data_->audio_fallback;
  }
  bool video_handled() const {
    return data_->video_handled;
  }
  bool video_fallback() const {
    return data_->video_fallback;
  }
  bool manifest_handled() const {
    return data_->manifest_handled;
  }
  bool manifest_fallback() const {
    return data_->manifest_fallback;
  }
  bool speculation_rules_handled() const {
    return data_->speculation_rules_handled;
  }
  bool speculation_rules_fallback() const {
    return data_->speculation_rules_fallback;
  }
  bool mock_handled() const {
    return data_->mock_handled;
  }
  bool mock_fallback() const {
    return data_->mock_fallback;
  }
  bool dictionary_handled() const {
    return data_->dictionary_handled;
  }
  bool dictionary_fallback() const {
    return data_->dictionary_fallback;
  }
  uint32_t matched_cache_router_source_count() const {
    return data_->matched_cache_router_source_count;
  }
  uint32_t matched_fetch_event_router_source_count() const {
    return data_->matched_fetch_event_router_source_count;
  }
  uint32_t matched_network_router_source_count() const {
    return data_->matched_network_router_source_count;
  }
  uint32_t matched_race_network_and_fetch_router_source_count() const {
    return data_->matched_race_network_and_fetch_router_source_count;
  }
  uint32_t matched_race_network_and_cache_router_source_count() const {
    return data_->matched_race_network_and_cache_router_source_count;
  }
  inline void GetTotalRouterEvaluationTimeForSubresourcesDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalRouterEvaluationTimeForSubresources(UserType* output) {
    
    auto* pointer = data_->total_router_evaluation_time_for_subresources.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTotalCacheLookupTimeForSubresourcesDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTotalCacheLookupTimeForSubresources(UserType* output) {
    
    auto* pointer = data_->total_cache_lookup_time_for_subresources.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerSubresourceLoadMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceDataUpdateDataView {
 public:
  ResourceDataUpdateDataView() = default;

  ResourceDataUpdateDataView(
      internal::ResourceDataUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  inline void GetDeltaBytesDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeltaBytes(UserType* output) {
    
    auto* pointer = data_->delta_bytes.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetReceivedDataLengthDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceivedDataLength(UserType* output) {
    
    auto* pointer = data_->received_data_length.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetEncodedBodyLengthDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedBodyLength(UserType* output) {
    
    auto* pointer = data_->encoded_body_length.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  inline void GetDecodedBodyLengthDataView(
      ::mojo_base::mojom::ByteCountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodedBodyLength(UserType* output) {
    
    auto* pointer = data_->decoded_body_length.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteCountDataView>(
        pointer, output, message_);
  }
  bool is_complete() const {
    return data_->is_complete;
  }
  bool reported_as_ad_resource() const {
    return data_->reported_as_ad_resource;
  }
  bool is_main_frame_resource() const {
    return data_->is_main_frame_resource;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCacheType(UserType* output) const {
    auto data_value = data_->cache_type;
    return mojo::internal::Deserialize<::page_load_metrics::mojom::CacheType>(
        data_value, output);
  }
  CacheType cache_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::page_load_metrics::mojom::CacheType>(data_->cache_type));
  }
  bool is_primary_frame_resource() const {
    return data_->is_primary_frame_resource;
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_secure_scheme() const {
    return data_->is_secure_scheme;
  }
  bool proxy_used() const {
    return data_->proxy_used;
  }
 private:
  internal::ResourceDataUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayoutShiftDataView {
 public:
  LayoutShiftDataView() = default;

  LayoutShiftDataView(
      internal::LayoutShift_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayoutShiftTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayoutShiftTime(UserType* output) {
    
    auto* pointer = data_->layout_shift_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  double layout_shift_score() const {
    return data_->layout_shift_score;
  }
 private:
  internal::LayoutShift_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameRenderDataUpdateDataView {
 public:
  FrameRenderDataUpdateDataView() = default;

  FrameRenderDataUpdateDataView(
      internal::FrameRenderDataUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float layout_shift_delta() const {
    return data_->layout_shift_delta;
  }
  float layout_shift_delta_before_input_or_scroll() const {
    return data_->layout_shift_delta_before_input_or_scroll;
  }
  inline void GetNewLayoutShiftsDataView(
      mojo::ArrayDataView<LayoutShiftDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewLayoutShifts(UserType* output) {
    
    auto* pointer = data_->new_layout_shifts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::page_load_metrics::mojom::LayoutShiftDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FrameRenderDataUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CpuTimingDataView {
 public:
  CpuTimingDataView() = default;

  CpuTimingDataView(
      internal::CpuTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTaskTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTaskTime(UserType* output) {
    
    auto* pointer = data_->task_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::CpuTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InputTimingDataView {
 public:
  InputTimingDataView() = default;

  InputTimingDataView(
      internal::InputTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserInteractionLatenciesDataView(
      mojo::ArrayDataView<UserInteractionLatencyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserInteractionLatencies(UserType* output) {
    
    auto* pointer = data_->user_interaction_latencies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::page_load_metrics::mojom::UserInteractionLatencyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::InputTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserInteractionLatencyDataView {
 public:
  UserInteractionLatencyDataView() = default;

  UserInteractionLatencyDataView(
      internal::UserInteractionLatency_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInteractionLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInteractionLatency(UserType* output) {
    
    auto* pointer = data_->interaction_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t interaction_offset() const {
    return data_->interaction_offset;
  }
  inline void GetInteractionTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInteractionTime(UserType* output) {
    
    auto* pointer = data_->interaction_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserInteractionLatency_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackForwardCacheTimingDataView {
 public:
  BackForwardCacheTimingDataView() = default;

  BackForwardCacheTimingDataView(
      internal::BackForwardCacheTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFirstPaintAfterBackForwardCacheRestoreDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstPaintAfterBackForwardCacheRestore(UserType* output) {
    
    auto* pointer = data_->first_paint_after_back_forward_cache_restore.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetRequestAnimationFramesAfterBackForwardCacheRestoreDataView(
      mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestAnimationFramesAfterBackForwardCacheRestore(UserType* output) {
    
    auto* pointer = data_->request_animation_frames_after_back_forward_cache_restore.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>>(
        pointer, output, message_);
  }
  inline void GetFirstInputDelayAfterBackForwardCacheRestoreDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstInputDelayAfterBackForwardCacheRestore(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `first_input_delay_after_back_forward_cache_restore` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstInputDelayAfterBackForwardCacheRestore` instead "
    "of `ReadFirstInputDelayAfterBackForwardCacheRestore if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_input_delay_after_back_forward_cache_restore.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackForwardCacheTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SoftNavigationMetricsDataView {
 public:
  SoftNavigationMetricsDataView() = default;

  SoftNavigationMetricsDataView(
      internal::SoftNavigationMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t count() const {
    return data_->count;
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t navigation_id() const {
    return data_->navigation_id;
  }
  inline void GetLargestContentfulPaintDataView(
      LargestContentfulPaintTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargestContentfulPaint(UserType* output) {
    
    auto* pointer = data_->largest_contentful_paint.Get();
    return mojo::internal::Deserialize<::page_load_metrics::mojom::LargestContentfulPaintTimingDataView>(
        pointer, output, message_);
  }
 private:
  internal::SoftNavigationMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // page_load_metrics::mojom

#endif  // COMPONENTS_PAGE_LOAD_METRICS_COMMON_PAGE_LOAD_METRICS_MOJOM_DATA_VIEW_H_