// components/page_image_service/mojom/page_image_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/page_image_service/mojom/page_image_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/page_image_service/mojom/page_image_service.mojom-params-data.h"
#include "components/page_image_service/mojom/page_image_service.mojom-shared-message-ids.h"

#include "components/page_image_service/mojom/page_image_service.mojom-import-headers.h"
#include "components/page_image_service/mojom/page_image_service.mojom-test-utils.h"


namespace page_image_service::mojom {
Options::Options()
    : suggest_images(true),
      optimization_guide_images(true) {}

Options::Options(
    bool suggest_images_in,
    bool optimization_guide_images_in)
    : suggest_images(std::move(suggest_images_in)),
      optimization_guide_images(std::move(optimization_guide_images_in)) {}

Options::~Options() = default;
size_t Options::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->suggest_images);
  seed = mojo::internal::Hash(seed, this->optimization_guide_images);
  return seed;
}

void Options::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggest_images"), this->suggest_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimization_guide_images"), this->optimization_guide_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Options::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ImageResult::ImageResult()
    : image_url() {}

ImageResult::ImageResult(
    const ::GURL& image_url_in)
    : image_url(std::move(image_url_in)) {}

ImageResult::~ImageResult() = default;

void ImageResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImageResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageImageServiceHandler::IPCStableHashFunction PageImageServiceHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageImageServiceHandler>(message.name())) {
    case messages::PageImageServiceHandler::kGetPageImageUrl: {
      return &PageImageServiceHandler::GetPageImageUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageImageServiceHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageImageServiceHandler>(message.name())) {
      case messages::PageImageServiceHandler::kGetPageImageUrl:
            return "Receive page_image_service::mojom::PageImageServiceHandler::GetPageImageUrl";
    }
  } else {
    switch (static_cast<messages::PageImageServiceHandler>(message.name())) {
      case messages::PageImageServiceHandler::kGetPageImageUrl:
            return "Receive reply page_image_service::mojom::PageImageServiceHandler::GetPageImageUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageImageServiceHandler::GetPageImageUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3046c3d8;  // IPCStableHash for page_image_service::mojom::PageImageServiceHandler::GetPageImageUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageImageServiceHandler_GetPageImageUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageImageServiceHandler_GetPageImageUrl_ForwardToCallback(
      PageImageServiceHandler::GetPageImageUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageImageServiceHandler_GetPageImageUrl_ForwardToCallback(const PageImageServiceHandler_GetPageImageUrl_ForwardToCallback&) = delete;
  PageImageServiceHandler_GetPageImageUrl_ForwardToCallback& operator=(const PageImageServiceHandler_GetPageImageUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageImageServiceHandler::GetPageImageUrlCallback callback_;
};

PageImageServiceHandlerProxy::PageImageServiceHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageImageServiceHandlerProxy::GetPageImageUrl(
    ClientId in_client_id, const ::GURL& in_page_url, OptionsPtr in_options, GetPageImageUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send page_image_service::mojom::PageImageServiceHandler::GetPageImageUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type ClientId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_url"), in_page_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type OptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageImageServiceHandler::kGetPageImageUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::page_image_service::mojom::internal::PageImageServiceHandler_GetPageImageUrl_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::page_image_service::mojom::ClientId>(
    in_client_id,
    &params->client_id);
  mojo::internal::MessageFragment<
      typename decltype(params->page_url)::BaseType> page_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_page_url,
    page_url_fragment);

  params->page_url.Set(
      page_url_fragment.is_null() ? nullptr : page_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_url in PageImageServiceHandler.GetPageImageUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_image_service::mojom::OptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in PageImageServiceHandler.GetPageImageUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageImageServiceHandler::Name_);
  message.set_method_name("GetPageImageUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageImageServiceHandler_GetPageImageUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageImageServiceHandler_GetPageImageUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageImageServiceHandler::GetPageImageUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageImageServiceHandler_GetPageImageUrl_ProxyToResponder> proxy(
        new PageImageServiceHandler_GetPageImageUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageImageServiceHandler_GetPageImageUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageImageServiceHandler_GetPageImageUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageImageServiceHandler_GetPageImageUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageImageServiceHandler::GetPageImageUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ImageResultPtr in_result);
};

bool PageImageServiceHandler_GetPageImageUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageImageServiceHandler.0
  bool success = true;
  ImageResultPtr p_result{};
  PageImageServiceHandler_GetPageImageUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageImageServiceHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageImageServiceHandler_GetPageImageUrl_ProxyToResponder::Run(
    ImageResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply page_image_service::mojom::PageImageServiceHandler::GetPageImageUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ImageResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageImageServiceHandler::kGetPageImageUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::page_image_service::mojom::internal::PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::page_image_service::mojom::ImageResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageImageServiceHandler::Name_);
  message.set_method_name("GetPageImageUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageImageServiceHandlerStubDispatch::Accept(
    PageImageServiceHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageImageServiceHandler>(message->header()->name)) {
    case messages::PageImageServiceHandler::kGetPageImageUrl: {
      break;
    }
  }
  return false;
}

// static
bool PageImageServiceHandlerStubDispatch::AcceptWithResponder(
    PageImageServiceHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageImageServiceHandler>(message->header()->name)) {
    case messages::PageImageServiceHandler::kGetPageImageUrl: {
      internal::PageImageServiceHandler_GetPageImageUrl_Params_Data* params =
          reinterpret_cast<
              internal::PageImageServiceHandler_GetPageImageUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageImageServiceHandler.0
      bool success = true;
      ClientId p_client_id{};
      ::GURL p_page_url{};
      OptionsPtr p_options{};
      PageImageServiceHandler_GetPageImageUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientId(&p_client_id))
        success = false;
      if (success && !input_data_view.ReadPageUrl(&p_page_url))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageImageServiceHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageImageServiceHandler_GetPageImageUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPageImageUrl(        
        std::move(p_client_id), 
        std::move(p_page_url), 
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageImageServiceHandlerValidationInfo[] = {
    { &internal::PageImageServiceHandler_GetPageImageUrl_Params_Data::Validate,
     &internal::PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data::Validate},
};

bool PageImageServiceHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::page_image_service::mojom::PageImageServiceHandler::Name_,
    kPageImageServiceHandlerValidationInfo);
}

bool PageImageServiceHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::page_image_service::mojom::PageImageServiceHandler::Name_,
    kPageImageServiceHandlerValidationInfo);
}


}  // page_image_service::mojom


namespace mojo {


// static
bool StructTraits<::page_image_service::mojom::Options::DataView, ::page_image_service::mojom::OptionsPtr>::Read(
    ::page_image_service::mojom::Options::DataView input,
    ::page_image_service::mojom::OptionsPtr* output) {
  bool success = true;
  ::page_image_service::mojom::OptionsPtr result(::page_image_service::mojom::Options::New());
  
      if (success)
        result->suggest_images = input.suggest_images();
      if (success)
        result->optimization_guide_images = input.optimization_guide_images();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::page_image_service::mojom::ImageResult::DataView, ::page_image_service::mojom::ImageResultPtr>::Read(
    ::page_image_service::mojom::ImageResult::DataView input,
    ::page_image_service::mojom::ImageResultPtr* output) {
  bool success = true;
  ::page_image_service::mojom::ImageResultPtr result(::page_image_service::mojom::ImageResult::New());
  
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace page_image_service::mojom {


void PageImageServiceHandlerInterceptorForTesting::GetPageImageUrl(ClientId client_id, const ::GURL& page_url, OptionsPtr options, GetPageImageUrlCallback callback) {
  GetForwardingInterface()->GetPageImageUrl(
    std::move(client_id)
    , 
    std::move(page_url)
    , 
    std::move(options)
    , std::move(callback));
}
PageImageServiceHandlerAsyncWaiter::PageImageServiceHandlerAsyncWaiter(
    PageImageServiceHandler* proxy) : proxy_(proxy) {}

PageImageServiceHandlerAsyncWaiter::~PageImageServiceHandlerAsyncWaiter() = default;


void PageImageServiceHandlerAsyncWaiter::GetPageImageUrl(
    ClientId client_id, const ::GURL& page_url, OptionsPtr options, ImageResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetPageImageUrl(
      std::move(client_id),
      std::move(page_url),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ImageResultPtr* out_result
,
             ImageResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ImageResultPtr PageImageServiceHandlerAsyncWaiter::GetPageImageUrl(
    ClientId client_id, const ::GURL& page_url, OptionsPtr options) {
  ImageResultPtr async_wait_result;
  GetPageImageUrl(std::move(client_id),std::move(page_url),std::move(options),&async_wait_result);
  return async_wait_result;
}






}  // page_image_service::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif