// components/optimization_guide/public/mojom/model_broker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/optimization_guide/public/mojom/model_broker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-params-data.h"
#include "components/optimization_guide/public/mojom/model_broker.mojom-shared-message-ids.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-import-headers.h"
#include "components/optimization_guide/public/mojom/model_broker.mojom-test-utils.h"


namespace optimization_guide::mojom {
ModelSolutionConfig::ModelSolutionConfig()
    : feature_config(mojo::internal::DefaultConstructTag()),
      text_safety_config(mojo::internal::DefaultConstructTag()),
      model_versions(mojo::internal::DefaultConstructTag()),
      max_tokens() {}

ModelSolutionConfig::ModelSolutionConfig(
    ::mojo_base::ProtoWrapper feature_config_in,
    ::mojo_base::ProtoWrapper text_safety_config_in,
    ::mojo_base::ProtoWrapper model_versions_in,
    int32_t max_tokens_in)
    : feature_config(std::move(feature_config_in)),
      text_safety_config(std::move(text_safety_config_in)),
      model_versions(std::move(model_versions_in)),
      max_tokens(std::move(max_tokens_in)) {}

ModelSolutionConfig::~ModelSolutionConfig() = default;

void ModelSolutionConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_config"), this->feature_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::ProtoWrapper>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_safety_config"), this->text_safety_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::ProtoWrapper>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_versions"), this->model_versions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::ProtoWrapper>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_tokens"), this->max_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModelSolutionConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ModelSubscriptionOptions::ModelSubscriptionOptions()
    : id(),
      mark_used() {}

ModelSubscriptionOptions::ModelSubscriptionOptions(
    ModelBasedCapabilityKey id_in,
    bool mark_used_in)
    : id(std::move(id_in)),
      mark_used(std::move(mark_used_in)) {}

ModelSubscriptionOptions::~ModelSubscriptionOptions() = default;
size_t ModelSubscriptionOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->mark_used);
  return seed;
}

void ModelSubscriptionOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ModelBasedCapabilityKey>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mark_used"), this->mark_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModelSubscriptionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ModelSolution::IPCStableHashFunction ModelSolution::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ModelSolution>(message.name())) {
    case messages::ModelSolution::kCreateSession: {
      return &ModelSolution::CreateSession_Sym::IPCStableHash;
    }
    case messages::ModelSolution::kCreateTextSafetySession: {
      return &ModelSolution::CreateTextSafetySession_Sym::IPCStableHash;
    }
    case messages::ModelSolution::kReportHealthyCompletion: {
      return &ModelSolution::ReportHealthyCompletion_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ModelSolution::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ModelSolution>(message.name())) {
      case messages::ModelSolution::kCreateSession:
            return "Receive optimization_guide::mojom::ModelSolution::CreateSession";
      case messages::ModelSolution::kCreateTextSafetySession:
            return "Receive optimization_guide::mojom::ModelSolution::CreateTextSafetySession";
      case messages::ModelSolution::kReportHealthyCompletion:
            return "Receive optimization_guide::mojom::ModelSolution::ReportHealthyCompletion";
    }
  } else {
    switch (static_cast<messages::ModelSolution>(message.name())) {
      case messages::ModelSolution::kCreateSession:
            return "Receive reply optimization_guide::mojom::ModelSolution::CreateSession";
      case messages::ModelSolution::kCreateTextSafetySession:
            return "Receive reply optimization_guide::mojom::ModelSolution::CreateTextSafetySession";
      case messages::ModelSolution::kReportHealthyCompletion:
            return "Receive reply optimization_guide::mojom::ModelSolution::ReportHealthyCompletion";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ModelSolution::CreateSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19572c16;  // IPCStableHash for optimization_guide::mojom::ModelSolution::CreateSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelSolution::CreateTextSafetySession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x599d9812;  // IPCStableHash for optimization_guide::mojom::ModelSolution::CreateTextSafetySession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelSolution::ReportHealthyCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x227d315f;  // IPCStableHash for optimization_guide::mojom::ModelSolution::ReportHealthyCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ModelSolutionProxy::ModelSolutionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ModelSolutionProxy::CreateSession(
    ::mojo::PendingReceiver<::on_device_model::mojom::Session> in_session, ::on_device_model::mojom::SessionParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide::mojom::ModelSolution::CreateSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::Session>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::on_device_model::mojom::SessionParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelSolution::kCreateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelSolution_CreateSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::SessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in ModelSolution.CreateSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::SessionParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ModelSolution.CreateSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelSolution::Name_);
  message.set_method_name("CreateSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelSolutionProxy::CreateTextSafetySession(
    ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession> in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide::mojom::ModelSolution::CreateTextSafetySession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelSolution::kCreateTextSafetySession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelSolution_CreateTextSafetySession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::TextSafetySessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in ModelSolution.CreateTextSafetySession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelSolution::Name_);
  message.set_method_name("CreateTextSafetySession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelSolutionProxy::ReportHealthyCompletion(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send optimization_guide::mojom::ModelSolution::ReportHealthyCompletion");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelSolution::kReportHealthyCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelSolution_ReportHealthyCompletion_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelSolution::Name_);
  message.set_method_name("ReportHealthyCompletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ModelSolutionStubDispatch::Accept(
    ModelSolution* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ModelSolution>(message->header()->name)) {
    case messages::ModelSolution::kCreateSession: {
      DCHECK(message->is_serialized());
      internal::ModelSolution_CreateSession_Params_Data* params =
          reinterpret_cast<internal::ModelSolution_CreateSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelSolution.0
      bool success = true;
      ::mojo::PendingReceiver<::on_device_model::mojom::Session> p_session{};
      ::on_device_model::mojom::SessionParamsPtr p_params{};
      ModelSolution_CreateSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelSolution::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSession(        
        std::move(p_session), 
        std::move(p_params));
      return true;
    }
    case messages::ModelSolution::kCreateTextSafetySession: {
      DCHECK(message->is_serialized());
      internal::ModelSolution_CreateTextSafetySession_Params_Data* params =
          reinterpret_cast<internal::ModelSolution_CreateTextSafetySession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelSolution.1
      bool success = true;
      ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession> p_session{};
      ModelSolution_CreateTextSafetySession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelSolution::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTextSafetySession(        
        std::move(p_session));
      return true;
    }
    case messages::ModelSolution::kReportHealthyCompletion: {
      DCHECK(message->is_serialized());
      internal::ModelSolution_ReportHealthyCompletion_Params_Data* params =
          reinterpret_cast<internal::ModelSolution_ReportHealthyCompletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelSolution.2
      bool success = true;
      ModelSolution_ReportHealthyCompletion_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelSolution::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportHealthyCompletion(        );
      return true;
    }
  }
  return false;
}

// static
bool ModelSolutionStubDispatch::AcceptWithResponder(
    ModelSolution* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ModelSolution>(message->header()->name)) {
    case messages::ModelSolution::kCreateSession: {
      break;
    }
    case messages::ModelSolution::kCreateTextSafetySession: {
      break;
    }
    case messages::ModelSolution::kReportHealthyCompletion: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kModelSolutionValidationInfo[] = {
    { &internal::ModelSolution_CreateSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelSolution_CreateTextSafetySession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelSolution_ReportHealthyCompletion_Params_Data::Validate,
     nullptr /* no response */},
};

bool ModelSolutionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::optimization_guide::mojom::ModelSolution::Name_,
    kModelSolutionValidationInfo);
}

// The declaration includes the definition on other builds.

ModelSubscriber::IPCStableHashFunction ModelSubscriber::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ModelSubscriber>(message.name())) {
    case messages::ModelSubscriber::kUnavailable: {
      return &ModelSubscriber::Unavailable_Sym::IPCStableHash;
    }
    case messages::ModelSubscriber::kAvailable: {
      return &ModelSubscriber::Available_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ModelSubscriber::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ModelSubscriber>(message.name())) {
      case messages::ModelSubscriber::kUnavailable:
            return "Receive optimization_guide::mojom::ModelSubscriber::Unavailable";
      case messages::ModelSubscriber::kAvailable:
            return "Receive optimization_guide::mojom::ModelSubscriber::Available";
    }
  } else {
    switch (static_cast<messages::ModelSubscriber>(message.name())) {
      case messages::ModelSubscriber::kUnavailable:
            return "Receive reply optimization_guide::mojom::ModelSubscriber::Unavailable";
      case messages::ModelSubscriber::kAvailable:
            return "Receive reply optimization_guide::mojom::ModelSubscriber::Available";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ModelSubscriber::Unavailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf32c79a4;  // IPCStableHash for optimization_guide::mojom::ModelSubscriber::Unavailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelSubscriber::Available_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb56efdf;  // IPCStableHash for optimization_guide::mojom::ModelSubscriber::Available
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ModelSubscriberProxy::ModelSubscriberProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ModelSubscriberProxy::Unavailable(
    ModelUnavailableReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide::mojom::ModelSubscriber::Unavailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ModelUnavailableReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelSubscriber::kUnavailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelSubscriber_Unavailable_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::optimization_guide::mojom::ModelUnavailableReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelSubscriber::Name_);
  message.set_method_name("Unavailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelSubscriberProxy::Available(
    ModelSolutionConfigPtr in_config, ::mojo::PendingRemote<ModelSolution> in_capability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide::mojom::ModelSubscriber::Available", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ModelSolutionConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capability"), in_capability,
                        "<value of type ::mojo::PendingRemote<ModelSolution>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelSubscriber::kAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelSubscriber_Available_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::optimization_guide::mojom::ModelSolutionConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ModelSubscriber.Available request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::optimization_guide::mojom::ModelSolutionInterfaceBase>>(
    in_capability,
    &params->capability,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->capability)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid capability in ModelSubscriber.Available request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelSubscriber::Name_);
  message.set_method_name("Available");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ModelSubscriberStubDispatch::Accept(
    ModelSubscriber* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ModelSubscriber>(message->header()->name)) {
    case messages::ModelSubscriber::kUnavailable: {
      DCHECK(message->is_serialized());
      internal::ModelSubscriber_Unavailable_Params_Data* params =
          reinterpret_cast<internal::ModelSubscriber_Unavailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelSubscriber.0
      bool success = true;
      ModelUnavailableReason p_reason{};
      ModelSubscriber_Unavailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelSubscriber::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unavailable(        
        std::move(p_reason));
      return true;
    }
    case messages::ModelSubscriber::kAvailable: {
      DCHECK(message->is_serialized());
      internal::ModelSubscriber_Available_Params_Data* params =
          reinterpret_cast<internal::ModelSubscriber_Available_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelSubscriber.1
      bool success = true;
      ModelSolutionConfigPtr p_config{};
      ::mojo::PendingRemote<ModelSolution> p_capability{};
      ModelSubscriber_Available_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success) {
        p_capability =
            input_data_view.TakeCapability<decltype(p_capability)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelSubscriber::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Available(        
        std::move(p_config), 
        std::move(p_capability));
      return true;
    }
  }
  return false;
}

// static
bool ModelSubscriberStubDispatch::AcceptWithResponder(
    ModelSubscriber* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ModelSubscriber>(message->header()->name)) {
    case messages::ModelSubscriber::kUnavailable: {
      break;
    }
    case messages::ModelSubscriber::kAvailable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kModelSubscriberValidationInfo[] = {
    { &internal::ModelSubscriber_Unavailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelSubscriber_Available_Params_Data::Validate,
     nullptr /* no response */},
};

bool ModelSubscriberRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::optimization_guide::mojom::ModelSubscriber::Name_,
    kModelSubscriberValidationInfo);
}

// The declaration includes the definition on other builds.

ModelBroker::IPCStableHashFunction ModelBroker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ModelBroker>(message.name())) {
    case messages::ModelBroker::kSubscribe: {
      return &ModelBroker::Subscribe_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ModelBroker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ModelBroker>(message.name())) {
      case messages::ModelBroker::kSubscribe:
            return "Receive optimization_guide::mojom::ModelBroker::Subscribe";
    }
  } else {
    switch (static_cast<messages::ModelBroker>(message.name())) {
      case messages::ModelBroker::kSubscribe:
            return "Receive reply optimization_guide::mojom::ModelBroker::Subscribe";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ModelBroker::Subscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12c24d9c;  // IPCStableHash for optimization_guide::mojom::ModelBroker::Subscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ModelBrokerProxy::ModelBrokerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ModelBrokerProxy::Subscribe(
    ModelSubscriptionOptionsPtr in_opts, ::mojo::PendingRemote<ModelSubscriber> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide::mojom::ModelBroker::Subscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opts"), in_opts,
                        "<value of type ModelSubscriptionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ModelSubscriber>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelBroker::kSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide::mojom::internal::ModelBroker_Subscribe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opts)::BaseType> opts_fragment(
          params.message());
  
  mojo::internal::Serialize<::optimization_guide::mojom::ModelSubscriptionOptionsDataView>(
    in_opts,
    opts_fragment);

  params->opts.Set(
      opts_fragment.is_null() ? nullptr : opts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->opts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null opts in ModelBroker.Subscribe request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::optimization_guide::mojom::ModelSubscriberInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in ModelBroker.Subscribe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelBroker::Name_);
  message.set_method_name("Subscribe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ModelBrokerStubDispatch::Accept(
    ModelBroker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ModelBroker>(message->header()->name)) {
    case messages::ModelBroker::kSubscribe: {
      DCHECK(message->is_serialized());
      internal::ModelBroker_Subscribe_Params_Data* params =
          reinterpret_cast<internal::ModelBroker_Subscribe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelBroker.0
      bool success = true;
      ModelSubscriptionOptionsPtr p_opts{};
      ::mojo::PendingRemote<ModelSubscriber> p_client{};
      ModelBroker_Subscribe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpts(&p_opts))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelBroker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Subscribe(        
        std::move(p_opts), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ModelBrokerStubDispatch::AcceptWithResponder(
    ModelBroker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ModelBroker>(message->header()->name)) {
    case messages::ModelBroker::kSubscribe: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kModelBrokerValidationInfo[] = {
    { &internal::ModelBroker_Subscribe_Params_Data::Validate,
     nullptr /* no response */},
};

bool ModelBrokerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::optimization_guide::mojom::ModelBroker::Name_,
    kModelBrokerValidationInfo);
}



}  // optimization_guide::mojom


namespace mojo {


// static
bool StructTraits<::optimization_guide::mojom::ModelSolutionConfig::DataView, ::optimization_guide::mojom::ModelSolutionConfigPtr>::Read(
    ::optimization_guide::mojom::ModelSolutionConfig::DataView input,
    ::optimization_guide::mojom::ModelSolutionConfigPtr* output) {
  bool success = true;
  ::optimization_guide::mojom::ModelSolutionConfigPtr result(::optimization_guide::mojom::ModelSolutionConfig::New());
  
      if (success && !input.ReadFeatureConfig(&result->feature_config))
        success = false;
      if (success && !input.ReadTextSafetyConfig(&result->text_safety_config))
        success = false;
      if (success && !input.ReadModelVersions(&result->model_versions))
        success = false;
      if (success)
        result->max_tokens = input.max_tokens();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::optimization_guide::mojom::ModelSubscriptionOptions::DataView, ::optimization_guide::mojom::ModelSubscriptionOptionsPtr>::Read(
    ::optimization_guide::mojom::ModelSubscriptionOptions::DataView input,
    ::optimization_guide::mojom::ModelSubscriptionOptionsPtr* output) {
  bool success = true;
  ::optimization_guide::mojom::ModelSubscriptionOptionsPtr result(::optimization_guide::mojom::ModelSubscriptionOptions::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->mark_used = input.mark_used();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace optimization_guide::mojom {


void ModelSolutionInterceptorForTesting::CreateSession(::mojo::PendingReceiver<::on_device_model::mojom::Session> session, ::on_device_model::mojom::SessionParamsPtr params) {
  GetForwardingInterface()->CreateSession(
    std::move(session)
    , 
    std::move(params)
    );
}
void ModelSolutionInterceptorForTesting::CreateTextSafetySession(::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession> session) {
  GetForwardingInterface()->CreateTextSafetySession(
    std::move(session)
    );
}
void ModelSolutionInterceptorForTesting::ReportHealthyCompletion() {
  GetForwardingInterface()->ReportHealthyCompletion();
}
ModelSolutionAsyncWaiter::ModelSolutionAsyncWaiter(
    ModelSolution* proxy) : proxy_(proxy) {}

ModelSolutionAsyncWaiter::~ModelSolutionAsyncWaiter() = default;





void ModelSubscriberInterceptorForTesting::Unavailable(ModelUnavailableReason reason) {
  GetForwardingInterface()->Unavailable(
    std::move(reason)
    );
}
void ModelSubscriberInterceptorForTesting::Available(ModelSolutionConfigPtr config, ::mojo::PendingRemote<ModelSolution> capability) {
  GetForwardingInterface()->Available(
    std::move(config)
    , 
    std::move(capability)
    );
}
ModelSubscriberAsyncWaiter::ModelSubscriberAsyncWaiter(
    ModelSubscriber* proxy) : proxy_(proxy) {}

ModelSubscriberAsyncWaiter::~ModelSubscriberAsyncWaiter() = default;





void ModelBrokerInterceptorForTesting::Subscribe(ModelSubscriptionOptionsPtr opts, ::mojo::PendingRemote<ModelSubscriber> client) {
  GetForwardingInterface()->Subscribe(
    std::move(opts)
    , 
    std::move(client)
    );
}
ModelBrokerAsyncWaiter::ModelBrokerAsyncWaiter(
    ModelBroker* proxy) : proxy_(proxy) {}

ModelBrokerAsyncWaiter::~ModelBrokerAsyncWaiter() = default;







}  // optimization_guide::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif