// components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-params-data.h"
#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-shared-message-ids.h"

#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-import-headers.h"
#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-test-utils.h"


namespace optimization_guide_internals::mojom {
DownloadedModelInfo::DownloadedModelInfo()
    : optimization_target(),
      version(),
      file_path() {}

DownloadedModelInfo::DownloadedModelInfo(
    const std::string& optimization_target_in,
    int64_t version_in,
    const std::string& file_path_in)
    : optimization_target(std::move(optimization_target_in)),
      version(std::move(version_in)),
      file_path(std::move(file_path_in)) {}

DownloadedModelInfo::~DownloadedModelInfo() = default;
size_t DownloadedModelInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->optimization_target);
  seed = mojo::internal::Hash(seed, this->version);
  seed = mojo::internal::Hash(seed, this->file_path);
  return seed;
}

void DownloadedModelInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimization_target"), this->optimization_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DownloadedModelInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoggedClientIds::LoggedClientIds()
    : client_id() {}

LoggedClientIds::LoggedClientIds(
    int64_t client_id_in)
    : client_id(std::move(client_id_in)) {}

LoggedClientIds::~LoggedClientIds() = default;
size_t LoggedClientIds::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->client_id);
  return seed;
}

void LoggedClientIds::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoggedClientIds::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MqlsLog::MqlsLog()
    : feature(),
      proto(),
      status() {}

MqlsLog::MqlsLog(
    const std::string& feature_in,
    const std::string& proto_in,
    const std::string& status_in)
    : feature(std::move(feature_in)),
      proto(std::move(proto_in)),
      status(std::move(status_in)) {}

MqlsLog::~MqlsLog() = default;
size_t MqlsLog::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->feature);
  seed = mojo::internal::Hash(seed, this->proto);
  seed = mojo::internal::Hash(seed, this->status);
  return seed;
}

void MqlsLog::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature"), this->feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proto"), this->proto,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MqlsLog::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
    case messages::PageHandlerFactory::kRequestDownloadedModelsInfo: {
      return &PageHandlerFactory::RequestDownloadedModelsInfo_Sym::IPCStableHash;
    }
    case messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds: {
      return &PageHandlerFactory::RequestLoggedModelQualityClientIds_Sym::IPCStableHash;
    }
    case messages::PageHandlerFactory::kRequestMqlsLogs: {
      return &PageHandlerFactory::RequestMqlsLogs_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive optimization_guide_internals::mojom::PageHandlerFactory::CreatePageHandler";
      case messages::PageHandlerFactory::kRequestDownloadedModelsInfo:
            return "Receive optimization_guide_internals::mojom::PageHandlerFactory::RequestDownloadedModelsInfo";
      case messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds:
            return "Receive optimization_guide_internals::mojom::PageHandlerFactory::RequestLoggedModelQualityClientIds";
      case messages::PageHandlerFactory::kRequestMqlsLogs:
            return "Receive optimization_guide_internals::mojom::PageHandlerFactory::RequestMqlsLogs";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply optimization_guide_internals::mojom::PageHandlerFactory::CreatePageHandler";
      case messages::PageHandlerFactory::kRequestDownloadedModelsInfo:
            return "Receive reply optimization_guide_internals::mojom::PageHandlerFactory::RequestDownloadedModelsInfo";
      case messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds:
            return "Receive reply optimization_guide_internals::mojom::PageHandlerFactory::RequestLoggedModelQualityClientIds";
      case messages::PageHandlerFactory::kRequestMqlsLogs:
            return "Receive reply optimization_guide_internals::mojom::PageHandlerFactory::RequestMqlsLogs";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe54652da;  // IPCStableHash for optimization_guide_internals::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandlerFactory::RequestDownloadedModelsInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe89235d8;  // IPCStableHash for optimization_guide_internals::mojom::PageHandlerFactory::RequestDownloadedModelsInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandlerFactory::RequestLoggedModelQualityClientIds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08c9cced;  // IPCStableHash for optimization_guide_internals::mojom::PageHandlerFactory::RequestLoggedModelQualityClientIds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandlerFactory::RequestMqlsLogs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb931f2e;  // IPCStableHash for optimization_guide_internals::mojom::PageHandlerFactory::RequestMqlsLogs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback(
      PageHandlerFactory::RequestDownloadedModelsInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback(const PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback&) = delete;
  PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback& operator=(const PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandlerFactory::RequestDownloadedModelsInfoCallback callback_;
};

class PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback(
      PageHandlerFactory::RequestLoggedModelQualityClientIdsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback(const PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback&) = delete;
  PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback& operator=(const PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandlerFactory::RequestLoggedModelQualityClientIdsCallback callback_;
};

class PageHandlerFactory_RequestMqlsLogs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandlerFactory_RequestMqlsLogs_ForwardToCallback(
      PageHandlerFactory::RequestMqlsLogsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandlerFactory_RequestMqlsLogs_ForwardToCallback(const PageHandlerFactory_RequestMqlsLogs_ForwardToCallback&) = delete;
  PageHandlerFactory_RequestMqlsLogs_ForwardToCallback& operator=(const PageHandlerFactory_RequestMqlsLogs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandlerFactory::RequestMqlsLogsCallback callback_;
};

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide_internals::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::optimization_guide_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerFactoryProxy::RequestDownloadedModelsInfo(
    RequestDownloadedModelsInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send optimization_guide_internals::mojom::PageHandlerFactory::RequestDownloadedModelsInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestDownloadedModelsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestDownloadedModelsInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestDownloadedModelsInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerFactoryProxy::RequestLoggedModelQualityClientIds(
    RequestLoggedModelQualityClientIdsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send optimization_guide_internals::mojom::PageHandlerFactory::RequestLoggedModelQualityClientIds");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestLoggedModelQualityClientIds");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerFactoryProxy::RequestMqlsLogs(
    RequestMqlsLogsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send optimization_guide_internals::mojom::PageHandlerFactory::RequestMqlsLogs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestMqlsLogs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestMqlsLogs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestMqlsLogs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandlerFactory_RequestMqlsLogs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandlerFactory::RequestDownloadedModelsInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder> proxy(
        new PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandlerFactory::RequestDownloadedModelsInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<DownloadedModelInfoPtr> in_downloaded_models_info);
};

bool PageHandlerFactory_RequestDownloadedModelsInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandlerFactory.1
  bool success = true;
  std::vector<DownloadedModelInfoPtr> p_downloaded_models_info{};
  PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDownloadedModelsInfo(&p_downloaded_models_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandlerFactory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_downloaded_models_info));
  }
  return true;
}

void PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder::Run(
    std::vector<DownloadedModelInfoPtr> in_downloaded_models_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply optimization_guide_internals::mojom::PageHandlerFactory::RequestDownloadedModelsInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downloaded_models_info"), in_downloaded_models_info,
                        "<value of type std::vector<DownloadedModelInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestDownloadedModelsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->downloaded_models_info)::BaseType>
      downloaded_models_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& downloaded_models_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::optimization_guide_internals::mojom::DownloadedModelInfoDataView>>(
    in_downloaded_models_info,
    downloaded_models_info_fragment,
    &downloaded_models_info_validate_params);

  params->downloaded_models_info.Set(
      downloaded_models_info_fragment.is_null() ? nullptr : downloaded_models_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->downloaded_models_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null downloaded_models_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestDownloadedModelsInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandlerFactory::RequestLoggedModelQualityClientIdsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder> proxy(
        new PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandlerFactory::RequestLoggedModelQualityClientIdsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<LoggedClientIdsPtr> in_logged_client_ids);
};

bool PageHandlerFactory_RequestLoggedModelQualityClientIds_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandlerFactory.2
  bool success = true;
  std::vector<LoggedClientIdsPtr> p_logged_client_ids{};
  PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLoggedClientIds(&p_logged_client_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandlerFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_logged_client_ids));
  }
  return true;
}

void PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder::Run(
    std::vector<LoggedClientIdsPtr> in_logged_client_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply optimization_guide_internals::mojom::PageHandlerFactory::RequestLoggedModelQualityClientIds", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("logged_client_ids"), in_logged_client_ids,
                        "<value of type std::vector<LoggedClientIdsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->logged_client_ids)::BaseType>
      logged_client_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& logged_client_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::optimization_guide_internals::mojom::LoggedClientIdsDataView>>(
    in_logged_client_ids,
    logged_client_ids_fragment,
    &logged_client_ids_validate_params);

  params->logged_client_ids.Set(
      logged_client_ids_fragment.is_null() ? nullptr : logged_client_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->logged_client_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null logged_client_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestLoggedModelQualityClientIds");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandlerFactory_RequestMqlsLogs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandlerFactory::RequestMqlsLogsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandlerFactory_RequestMqlsLogs_ProxyToResponder> proxy(
        new PageHandlerFactory_RequestMqlsLogs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandlerFactory_RequestMqlsLogs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandlerFactory_RequestMqlsLogs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandlerFactory_RequestMqlsLogs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandlerFactory::RequestMqlsLogsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<MqlsLogPtr> in_mqls_logs);
};

bool PageHandlerFactory_RequestMqlsLogs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandlerFactory_RequestMqlsLogs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandlerFactory_RequestMqlsLogs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandlerFactory.3
  bool success = true;
  std::vector<MqlsLogPtr> p_mqls_logs{};
  PageHandlerFactory_RequestMqlsLogs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMqlsLogs(&p_mqls_logs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandlerFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_mqls_logs));
  }
  return true;
}

void PageHandlerFactory_RequestMqlsLogs_ProxyToResponder::Run(
    std::vector<MqlsLogPtr> in_mqls_logs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply optimization_guide_internals::mojom::PageHandlerFactory::RequestMqlsLogs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mqls_logs"), in_mqls_logs,
                        "<value of type std::vector<MqlsLogPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kRequestMqlsLogs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::PageHandlerFactory_RequestMqlsLogs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mqls_logs)::BaseType>
      mqls_logs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& mqls_logs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::optimization_guide_internals::mojom::MqlsLogDataView>>(
    in_mqls_logs,
    mqls_logs_fragment,
    &mqls_logs_validate_params);

  params->mqls_logs.Set(
      mqls_logs_fragment.is_null() ? nullptr : mqls_logs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mqls_logs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mqls_logs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("RequestMqlsLogs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page));
      return true;
    }
    case messages::PageHandlerFactory::kRequestDownloadedModelsInfo: {
      break;
    }
    case messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds: {
      break;
    }
    case messages::PageHandlerFactory::kRequestMqlsLogs: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
    case messages::PageHandlerFactory::kRequestDownloadedModelsInfo: {
      internal::PageHandlerFactory_RequestDownloadedModelsInfo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandlerFactory_RequestDownloadedModelsInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandlerFactory.1
      bool success = true;
      PageHandlerFactory_RequestDownloadedModelsInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandlerFactory_RequestDownloadedModelsInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDownloadedModelsInfo(std::move(callback));
      return true;
    }
    case messages::PageHandlerFactory::kRequestLoggedModelQualityClientIds: {
      internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_Params_Data* params =
          reinterpret_cast<
              internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandlerFactory.2
      bool success = true;
      PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandlerFactory_RequestLoggedModelQualityClientIds_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestLoggedModelQualityClientIds(std::move(callback));
      return true;
    }
    case messages::PageHandlerFactory::kRequestMqlsLogs: {
      internal::PageHandlerFactory_RequestMqlsLogs_Params_Data* params =
          reinterpret_cast<
              internal::PageHandlerFactory_RequestMqlsLogs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandlerFactory.3
      bool success = true;
      PageHandlerFactory_RequestMqlsLogs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandlerFactory_RequestMqlsLogs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMqlsLogs(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandlerFactory_RequestDownloadedModelsInfo_Params_Data::Validate,
     &internal::PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams_Data::Validate},
    { &internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_Params_Data::Validate,
     &internal::PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams_Data::Validate},
    { &internal::PageHandlerFactory_RequestMqlsLogs_Params_Data::Validate,
     &internal::PageHandlerFactory_RequestMqlsLogs_ResponseParams_Data::Validate},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::optimization_guide_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

bool PageHandlerFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::optimization_guide_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnLogMessageAdded: {
      return &Page::OnLogMessageAdded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive optimization_guide_internals::mojom::Page::OnLogMessageAdded";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive reply optimization_guide_internals::mojom::Page::OnLogMessageAdded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnLogMessageAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93c20b31;  // IPCStableHash for optimization_guide_internals::mojom::Page::OnLogMessageAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnLogMessageAdded(
    ::base::Time in_event_time, ::optimization_guide_common::mojom::LogSource in_log_source, const std::string& in_source_file, int64_t in_source_line, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send optimization_guide_internals::mojom::Page::OnLogMessageAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_time"), in_event_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_source"), in_log_source,
                        "<value of type ::optimization_guide_common::mojom::LogSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_line"), in_source_line,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnLogMessageAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::optimization_guide_internals::mojom::internal::Page_OnLogMessageAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_time)::BaseType> event_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_event_time,
    event_time_fragment);

  params->event_time.Set(
      event_time_fragment.is_null() ? nullptr : event_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_time in Page.OnLogMessageAdded request");

  
  mojo::internal::Serialize<::optimization_guide_common::mojom::LogSource>(
    in_log_source,
    &params->log_source);
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_file in Page.OnLogMessageAdded request");

  params->source_line = in_source_line;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Page.OnLogMessageAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnLogMessageAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      DCHECK(message->is_serialized());
      internal::Page_OnLogMessageAdded_Params_Data* params =
          reinterpret_cast<internal::Page_OnLogMessageAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::base::Time p_event_time{};
      ::optimization_guide_common::mojom::LogSource p_log_source{};
      std::string p_source_file{};
      int64_t p_source_line{};
      std::string p_message{};
      Page_OnLogMessageAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventTime(&p_event_time))
        success = false;
      if (success && !input_data_view.ReadLogSource(&p_log_source))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_source_line = input_data_view.source_line();
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLogMessageAdded(        
        std::move(p_event_time), 
        std::move(p_log_source), 
        std::move(p_source_file), 
        std::move(p_source_line), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnLogMessageAdded_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::optimization_guide_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // optimization_guide_internals::mojom


namespace mojo {


// static
bool StructTraits<::optimization_guide_internals::mojom::DownloadedModelInfo::DataView, ::optimization_guide_internals::mojom::DownloadedModelInfoPtr>::Read(
    ::optimization_guide_internals::mojom::DownloadedModelInfo::DataView input,
    ::optimization_guide_internals::mojom::DownloadedModelInfoPtr* output) {
  bool success = true;
  ::optimization_guide_internals::mojom::DownloadedModelInfoPtr result(::optimization_guide_internals::mojom::DownloadedModelInfo::New());
  
      if (success && !input.ReadOptimizationTarget(&result->optimization_target))
        success = false;
      if (success)
        result->version = input.version();
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::optimization_guide_internals::mojom::LoggedClientIds::DataView, ::optimization_guide_internals::mojom::LoggedClientIdsPtr>::Read(
    ::optimization_guide_internals::mojom::LoggedClientIds::DataView input,
    ::optimization_guide_internals::mojom::LoggedClientIdsPtr* output) {
  bool success = true;
  ::optimization_guide_internals::mojom::LoggedClientIdsPtr result(::optimization_guide_internals::mojom::LoggedClientIds::New());
  
      if (success)
        result->client_id = input.client_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::optimization_guide_internals::mojom::MqlsLog::DataView, ::optimization_guide_internals::mojom::MqlsLogPtr>::Read(
    ::optimization_guide_internals::mojom::MqlsLog::DataView input,
    ::optimization_guide_internals::mojom::MqlsLogPtr* output) {
  bool success = true;
  ::optimization_guide_internals::mojom::MqlsLogPtr result(::optimization_guide_internals::mojom::MqlsLog::New());
  
      if (success && !input.ReadFeature(&result->feature))
        success = false;
      if (success && !input.ReadProto(&result->proto))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace optimization_guide_internals::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    );
}
void PageHandlerFactoryInterceptorForTesting::RequestDownloadedModelsInfo(RequestDownloadedModelsInfoCallback callback) {
  GetForwardingInterface()->RequestDownloadedModelsInfo(std::move(callback));
}
void PageHandlerFactoryInterceptorForTesting::RequestLoggedModelQualityClientIds(RequestLoggedModelQualityClientIdsCallback callback) {
  GetForwardingInterface()->RequestLoggedModelQualityClientIds(std::move(callback));
}
void PageHandlerFactoryInterceptorForTesting::RequestMqlsLogs(RequestMqlsLogsCallback callback) {
  GetForwardingInterface()->RequestMqlsLogs(std::move(callback));
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;


void PageHandlerFactoryAsyncWaiter::RequestDownloadedModelsInfo(
    std::vector<DownloadedModelInfoPtr>* out_downloaded_models_info) {
  base::RunLoop loop;
  proxy_->RequestDownloadedModelsInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<DownloadedModelInfoPtr>* out_downloaded_models_info
,
             std::vector<DownloadedModelInfoPtr> downloaded_models_info) {*out_downloaded_models_info = std::move(downloaded_models_info);
            loop->Quit();
          },
          &loop,
          out_downloaded_models_info));
  loop.Run();
}

std::vector<DownloadedModelInfoPtr> PageHandlerFactoryAsyncWaiter::RequestDownloadedModelsInfo(
    ) {
  std::vector<DownloadedModelInfoPtr> async_wait_result;
  RequestDownloadedModelsInfo(&async_wait_result);
  return async_wait_result;
}

void PageHandlerFactoryAsyncWaiter::RequestLoggedModelQualityClientIds(
    std::vector<LoggedClientIdsPtr>* out_logged_client_ids) {
  base::RunLoop loop;
  proxy_->RequestLoggedModelQualityClientIds(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<LoggedClientIdsPtr>* out_logged_client_ids
,
             std::vector<LoggedClientIdsPtr> logged_client_ids) {*out_logged_client_ids = std::move(logged_client_ids);
            loop->Quit();
          },
          &loop,
          out_logged_client_ids));
  loop.Run();
}

std::vector<LoggedClientIdsPtr> PageHandlerFactoryAsyncWaiter::RequestLoggedModelQualityClientIds(
    ) {
  std::vector<LoggedClientIdsPtr> async_wait_result;
  RequestLoggedModelQualityClientIds(&async_wait_result);
  return async_wait_result;
}

void PageHandlerFactoryAsyncWaiter::RequestMqlsLogs(
    std::vector<MqlsLogPtr>* out_mqls_logs) {
  base::RunLoop loop;
  proxy_->RequestMqlsLogs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<MqlsLogPtr>* out_mqls_logs
,
             std::vector<MqlsLogPtr> mqls_logs) {*out_mqls_logs = std::move(mqls_logs);
            loop->Quit();
          },
          &loop,
          out_mqls_logs));
  loop.Run();
}

std::vector<MqlsLogPtr> PageHandlerFactoryAsyncWaiter::RequestMqlsLogs(
    ) {
  std::vector<MqlsLogPtr> async_wait_result;
  RequestMqlsLogs(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnLogMessageAdded(::base::Time event_time, ::optimization_guide_common::mojom::LogSource log_source, const std::string& source_file, int64_t source_line, const std::string& message) {
  GetForwardingInterface()->OnLogMessageAdded(
    std::move(event_time)
    , 
    std::move(log_source)
    , 
    std::move(source_file)
    , 
    std::move(source_line)
    , 
    std::move(message)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // optimization_guide_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif