// components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  LogSourceSpec as optimizationGuideCommon_mojom_LogSourceSpec,
  LogSource as optimizationGuideCommon_mojom_LogSource
} from './optimization_guide_common.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'optimization_guide_internals.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote): void;
  requestDownloadedModelsInfo(): Promise<{
        downloadedModelsInfo: DownloadedModelInfo[], }>;
  requestLoggedModelQualityClientIds(): Promise<{
        loggedClientIds: LoggedClientIds[], }>;
  requestMqlsLogs(): Promise<{
        mqlsLogs: MqlsLog[], }>;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  requestDownloadedModelsInfo(): Promise<{
        downloadedModelsInfo: DownloadedModelInfo[], }> {
    return this.proxy.sendMessage(
        1,
        PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$,
        PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  requestLoggedModelQualityClientIds(): Promise<{
        loggedClientIds: LoggedClientIds[], }> {
    return this.proxy.sendMessage(
        2,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  requestMqlsLogs(): Promise<{
        mqlsLogs: MqlsLog[], }> {
    return this.proxy.sendMessage(
        3,
        PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$,
        PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$,
        PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$,
        impl.requestDownloadedModelsInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$,
        impl.requestLoggedModelQualityClientIds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$,
        PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$,
        impl.requestMqlsLogs.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "optimization_guide_internals.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestDownloadedModelsInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestLoggedModelQualityClientIds: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestMqlsLogs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestDownloadedModelsInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$,
        PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$,
        this.requestDownloadedModelsInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestLoggedModelQualityClientIds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$,
        PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$,
        this.requestLoggedModelQualityClientIds.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestMqlsLogs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$,
        PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$,
        this.requestMqlsLogs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'optimization_guide_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onLogMessageAdded(eventTime: mojoBase_mojom_Time, logSource: optimizationGuideCommon_mojom_LogSource, sourceFile: string, sourceLine: bigint, message: string): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onLogMessageAdded(
      eventTime: mojoBase_mojom_Time,
      logSource: optimizationGuideCommon_mojom_LogSource,
      sourceFile: string,
      sourceLine: bigint,
      message: string): void {
    this.proxy.sendMessage(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        [
          eventTime,
          logSource,
          sourceFile,
          sourceLine,
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        impl.onLogMessageAdded.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "optimization_guide_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onLogMessageAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onLogMessageAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        this.onLogMessageAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const DownloadedModelInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LoggedClientIdsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MqlsLogSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestMqlsLogs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnLogMessageAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface DownloadedModelInfoMojoType {
  optimizationTarget: string;
  version: bigint;
  filePath: string;
}


export type DownloadedModelInfo = DownloadedModelInfoMojoType;
mojo.internal.Struct<DownloadedModelInfoMojoType>(
    DownloadedModelInfoSpec.$,
    'DownloadedModelInfo',
    [
      mojo.internal.StructField<DownloadedModelInfoMojoType, string>(
        'optimizationTarget', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DownloadedModelInfoMojoType, bigint>(
        'version', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DownloadedModelInfoMojoType, string>(
        'filePath', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface LoggedClientIdsMojoType {
  clientId: bigint;
}


export type LoggedClientIds = LoggedClientIdsMojoType;
mojo.internal.Struct<LoggedClientIdsMojoType>(
    LoggedClientIdsSpec.$,
    'LoggedClientIds',
    [
      mojo.internal.StructField<LoggedClientIdsMojoType, bigint>(
        'clientId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MqlsLogMojoType {
  feature: string;
  proto: string;
  status: string;
}


export type MqlsLog = MqlsLogMojoType;
mojo.internal.Struct<MqlsLogMojoType>(
    MqlsLogSpec.$,
    'MqlsLog',
    [
      mojo.internal.StructField<MqlsLogMojoType, string>(
        'feature', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MqlsLogMojoType, string>(
        'proto', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MqlsLogMojoType, string>(
        'status', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_RequestDownloadedModelsInfo_ParamsMojoType {
}


export type PageHandlerFactory_RequestDownloadedModelsInfo_Params = PageHandlerFactory_RequestDownloadedModelsInfo_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestDownloadedModelsInfo_ParamsMojoType>(
    PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$,
    'PageHandlerFactory_RequestDownloadedModelsInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsMojoType {
  downloadedModelsInfo: DownloadedModelInfo[];
}


export type PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams = PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsMojoType>(
    PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$,
    'PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams',
    [
      mojo.internal.StructField<PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsMojoType, DownloadedModelInfo[]>(
        'downloadedModelsInfo', 0,
        0,
        mojo.internal.Array(DownloadedModelInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsMojoType {
}


export type PageHandlerFactory_RequestLoggedModelQualityClientIds_Params = PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsMojoType>(
    PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$,
    'PageHandlerFactory_RequestLoggedModelQualityClientIds_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsMojoType {
  loggedClientIds: LoggedClientIds[];
}


export type PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams = PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsMojoType>(
    PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$,
    'PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams',
    [
      mojo.internal.StructField<PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsMojoType, LoggedClientIds[]>(
        'loggedClientIds', 0,
        0,
        mojo.internal.Array(LoggedClientIdsSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_RequestMqlsLogs_ParamsMojoType {
}


export type PageHandlerFactory_RequestMqlsLogs_Params = PageHandlerFactory_RequestMqlsLogs_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestMqlsLogs_ParamsMojoType>(
    PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$,
    'PageHandlerFactory_RequestMqlsLogs_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandlerFactory_RequestMqlsLogs_ResponseParamsMojoType {
  mqlsLogs: MqlsLog[];
}


export type PageHandlerFactory_RequestMqlsLogs_ResponseParams = PageHandlerFactory_RequestMqlsLogs_ResponseParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_RequestMqlsLogs_ResponseParamsMojoType>(
    PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$,
    'PageHandlerFactory_RequestMqlsLogs_ResponseParams',
    [
      mojo.internal.StructField<PageHandlerFactory_RequestMqlsLogs_ResponseParamsMojoType, MqlsLog[]>(
        'mqlsLogs', 0,
        0,
        mojo.internal.Array(MqlsLogSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnLogMessageAdded_ParamsMojoType {
  eventTime: mojoBase_mojom_Time;
  logSource: optimizationGuideCommon_mojom_LogSource;
  sourceFile: string;
  sourceLine: bigint;
  message: string;
}


export type Page_OnLogMessageAdded_Params = Page_OnLogMessageAdded_ParamsMojoType;
mojo.internal.Struct<Page_OnLogMessageAdded_ParamsMojoType>(
    Page_OnLogMessageAdded_ParamsSpec.$,
    'Page_OnLogMessageAdded_Params',
    [
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, mojoBase_mojom_Time>(
        'eventTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, optimizationGuideCommon_mojom_LogSource>(
        'logSource', 8,
        0,
        optimizationGuideCommon_mojom_LogSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, string>(
        'sourceFile', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, bigint>(
        'sourceLine', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, string>(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);



