// components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { LogSourceSpec as optimizationGuideCommon_mojom_LogSourceSpec } from './optimization_guide_common.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'optimization_guide_internals.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page
        ], false);
    }
    requestDownloadedModelsInfo() {
        return this.proxy.sendMessage(1, PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$, PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$, [], false);
    }
    requestLoggedModelQualityClientIds() {
        return this.proxy.sendMessage(2, PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$, PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$, [], false);
    }
    requestMqlsLogs() {
        return this.proxy.sendMessage(3, PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$, PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$, PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$, impl.requestDownloadedModelsInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$, PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$, impl.requestLoggedModelQualityClientIds.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$, PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$, impl.requestMqlsLogs.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "optimization_guide_internals.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    requestDownloadedModelsInfo;
    requestLoggedModelQualityClientIds;
    requestMqlsLogs;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.requestDownloadedModelsInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$, PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$, this.requestDownloadedModelsInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.requestLoggedModelQualityClientIds =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$, PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$, this.requestLoggedModelQualityClientIds.createReceiverHandler(true /* expectsResponse */), false);
        this.requestMqlsLogs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$, PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$, this.requestMqlsLogs.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'optimization_guide_internals.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLogMessageAdded(eventTime, logSource, sourceFile, sourceLine, message) {
        this.proxy.sendMessage(0, Page_OnLogMessageAdded_ParamsSpec.$, null, [
            eventTime,
            logSource,
            sourceFile,
            sourceLine,
            message
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnLogMessageAdded_ParamsSpec.$, null, impl.onLogMessageAdded.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "optimization_guide_internals.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onLogMessageAdded;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onLogMessageAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnLogMessageAdded_ParamsSpec.$, null, this.onLogMessageAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DownloadedModelInfoSpec = { $: {} };
export const LoggedClientIdsSpec = { $: {} };
export const MqlsLogSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec = { $: {} };
export const PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec = { $: {} };
export const PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec = { $: {} };
export const PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec = { $: {} };
export const PageHandlerFactory_RequestMqlsLogs_ParamsSpec = { $: {} };
export const PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec = { $: {} };
export const Page_OnLogMessageAdded_ParamsSpec = { $: {} };
mojo.internal.Struct(DownloadedModelInfoSpec.$, 'DownloadedModelInfo', [
    mojo.internal.StructField('optimizationTarget', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('version', 8, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('filePath', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(LoggedClientIdsSpec.$, 'LoggedClientIds', [
    mojo.internal.StructField('clientId', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MqlsLogSpec.$, 'MqlsLog', [
    mojo.internal.StructField('feature', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('proto', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('status', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_RequestDownloadedModelsInfo_ParamsSpec.$, 'PageHandlerFactory_RequestDownloadedModelsInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParamsSpec.$, 'PageHandlerFactory_RequestDownloadedModelsInfo_ResponseParams', [
    mojo.internal.StructField('downloadedModelsInfo', 0, 0, mojo.internal.Array(DownloadedModelInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_RequestLoggedModelQualityClientIds_ParamsSpec.$, 'PageHandlerFactory_RequestLoggedModelQualityClientIds_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParamsSpec.$, 'PageHandlerFactory_RequestLoggedModelQualityClientIds_ResponseParams', [
    mojo.internal.StructField('loggedClientIds', 0, 0, mojo.internal.Array(LoggedClientIdsSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_RequestMqlsLogs_ParamsSpec.$, 'PageHandlerFactory_RequestMqlsLogs_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandlerFactory_RequestMqlsLogs_ResponseParamsSpec.$, 'PageHandlerFactory_RequestMqlsLogs_ResponseParams', [
    mojo.internal.StructField('mqlsLogs', 0, 0, mojo.internal.Array(MqlsLogSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnLogMessageAdded_ParamsSpec.$, 'Page_OnLogMessageAdded_Params', [
    mojo.internal.StructField('eventTime', 0, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('logSource', 8, 0, optimizationGuideCommon_mojom_LogSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceFile', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceLine', 24, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('message', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
