// components/optimization_guide/content/mojom/page_text_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/optimization_guide/content/mojom/page_text_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/optimization_guide/content/mojom/page_text_service.mojom-params-data.h"
namespace optimization_guide {
namespace mojom {

NOINLINE static const char* TextDumpEventToStringHelper(TextDumpEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextDumpEvent::kFirstLayout:
      return "kFirstLayout";
    case TextDumpEvent::kFinishedLoad:
      return "kFinishedLoad";
    default:
      return nullptr;
  }
}

std::string TextDumpEventToString(TextDumpEvent value) {
  const char *str = TextDumpEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextDumpEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextDumpEvent value) {
  return os << TextDumpEventToString(value);
}

namespace internal {


// static
bool PageTextDumpRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageTextDumpRequest_Data* object =
      static_cast<const PageTextDumpRequest_Data*>(data);


  if (!::optimization_guide::mojom::internal::TextDumpEvent_Data
        ::Validate(object->event, validation_context))
    return false;

  return true;
}

PageTextDumpRequest_Data::PageTextDumpRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageTextConsumer_OnTextDumpChunk_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageTextConsumer_OnTextDumpChunk_Params_Data* object =
      static_cast<const PageTextConsumer_OnTextDumpChunk_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chunk, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->chunk, validation_context))
    return false;

  return true;
}

PageTextConsumer_OnTextDumpChunk_Params_Data::PageTextConsumer_OnTextDumpChunk_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageTextConsumer_OnChunksEnd_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageTextConsumer_OnChunksEnd_Params_Data* object =
      static_cast<const PageTextConsumer_OnChunksEnd_Params_Data*>(data);

  return true;
}

PageTextConsumer_OnChunksEnd_Params_Data::PageTextConsumer_OnChunksEnd_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageTextService_RequestPageTextDump_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageTextService_RequestPageTextDump_Params_Data* object =
      static_cast<const PageTextService_RequestPageTextDump_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->consumer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->consumer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageTextService_RequestPageTextDump_Params_Data::PageTextService_RequestPageTextDump_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace optimization_guide

namespace perfetto {

// static
void TraceFormatTraits<::optimization_guide::mojom::TextDumpEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::optimization_guide::mojom::TextDumpEvent value) {
  return std::move(context).WriteString(::optimization_guide::mojom::TextDumpEventToString(value));
}

} // namespace perfetto