// components/omnibox/browser/searchbox.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace searchbox::mojom {
namespace internal {
class  PageHandler_SetPage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SetPage_Params_Data>;

  PageHandler_SetPage_Params_Data();
  ~PageHandler_SetPage_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SetPage_Params_Data) == 16,
              "Bad sizeof(PageHandler_SetPage_Params_Data)");
class  PageHandler_OnFocusChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t focused : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OnFocusChanged_Params_Data>;

  PageHandler_OnFocusChanged_Params_Data();
  ~PageHandler_OnFocusChanged_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OnFocusChanged_Params_Data) == 16,
              "Bad sizeof(PageHandler_OnFocusChanged_Params_Data)");
class  PageHandler_QueryAutocomplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> input;
  uint8_t prevent_inline_autocomplete : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_QueryAutocomplete_Params_Data>;

  PageHandler_QueryAutocomplete_Params_Data();
  ~PageHandler_QueryAutocomplete_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_QueryAutocomplete_Params_Data) == 24,
              "Bad sizeof(PageHandler_QueryAutocomplete_Params_Data)");
class  PageHandler_StopAutocomplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t clear_result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_StopAutocomplete_Params_Data>;

  PageHandler_StopAutocomplete_Params_Data();
  ~PageHandler_StopAutocomplete_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_StopAutocomplete_Params_Data) == 16,
              "Bad sizeof(PageHandler_StopAutocomplete_Params_Data)");
class  PageHandler_OpenAutocompleteMatch_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t are_matches_showing : 1;
  uint8_t alt_key : 1;
  uint8_t ctrl_key : 1;
  uint8_t meta_key : 1;
  uint8_t shift_key : 1;
  uint8_t mouse_button;
  uint8_t pad6_[5];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OpenAutocompleteMatch_Params_Data>;

  PageHandler_OpenAutocompleteMatch_Params_Data();
  ~PageHandler_OpenAutocompleteMatch_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OpenAutocompleteMatch_Params_Data) == 24,
              "Bad sizeof(PageHandler_OpenAutocompleteMatch_Params_Data)");
class  PageHandler_OnNavigationLikely_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t pad0_[3];
  int32_t navigation_predictor;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OnNavigationLikely_Params_Data>;

  PageHandler_OnNavigationLikely_Params_Data();
  ~PageHandler_OnNavigationLikely_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OnNavigationLikely_Params_Data) == 24,
              "Bad sizeof(PageHandler_OnNavigationLikely_Params_Data)");
class  PageHandler_DeleteAutocompleteMatch_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t pad0_[7];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DeleteAutocompleteMatch_Params_Data>;

  PageHandler_DeleteAutocompleteMatch_Params_Data();
  ~PageHandler_DeleteAutocompleteMatch_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_DeleteAutocompleteMatch_Params_Data) == 24,
              "Bad sizeof(PageHandler_DeleteAutocompleteMatch_Params_Data)");
class  PageHandler_ActivateKeyword_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t is_mouse_event : 1;
  uint8_t pad1_[6];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> match_selection_timestamp;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ActivateKeyword_Params_Data>;

  PageHandler_ActivateKeyword_Params_Data();
  ~PageHandler_ActivateKeyword_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ActivateKeyword_Params_Data) == 32,
              "Bad sizeof(PageHandler_ActivateKeyword_Params_Data)");
class  PageHandler_ExecuteAction_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t line;
  uint8_t action_index;
  uint8_t mouse_button;
  uint8_t alt_key : 1;
  uint8_t ctrl_key : 1;
  uint8_t meta_key : 1;
  uint8_t shift_key : 1;
  uint8_t pad6_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> match_selection_timestamp;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ExecuteAction_Params_Data>;

  PageHandler_ExecuteAction_Params_Data();
  ~PageHandler_ExecuteAction_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ExecuteAction_Params_Data) == 32,
              "Bad sizeof(PageHandler_ExecuteAction_Params_Data)");
class  PageHandler_OnThumbnailRemoved_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OnThumbnailRemoved_Params_Data>;

  PageHandler_OnThumbnailRemoved_Params_Data();
  ~PageHandler_OnThumbnailRemoved_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OnThumbnailRemoved_Params_Data) == 8,
              "Bad sizeof(PageHandler_OnThumbnailRemoved_Params_Data)");
class  PageHandler_GetPlaceholderConfig_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetPlaceholderConfig_Params_Data>;

  PageHandler_GetPlaceholderConfig_Params_Data();
  ~PageHandler_GetPlaceholderConfig_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetPlaceholderConfig_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetPlaceholderConfig_Params_Data)");
class  PageHandler_GetPlaceholderConfig_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PlaceholderConfig_Data> config;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetPlaceholderConfig_ResponseParams_Data>;

  PageHandler_GetPlaceholderConfig_ResponseParams_Data();
  ~PageHandler_GetPlaceholderConfig_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetPlaceholderConfig_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetPlaceholderConfig_ResponseParams_Data)");
class  PageHandler_GetRecentTabs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetRecentTabs_Params_Data>;

  PageHandler_GetRecentTabs_Params_Data();
  ~PageHandler_GetRecentTabs_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetRecentTabs_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetRecentTabs_Params_Data)");
class  PageHandler_GetRecentTabs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::TabInfo_Data>>> tabs;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetRecentTabs_ResponseParams_Data>;

  PageHandler_GetRecentTabs_ResponseParams_Data();
  ~PageHandler_GetRecentTabs_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetRecentTabs_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetRecentTabs_ResponseParams_Data)");
class  PageHandler_GetTabPreview_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t tab_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetTabPreview_Params_Data>;

  PageHandler_GetTabPreview_Params_Data();
  ~PageHandler_GetTabPreview_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetTabPreview_Params_Data) == 16,
              "Bad sizeof(PageHandler_GetTabPreview_Params_Data)");
class  PageHandler_GetTabPreview_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> preview_data_url;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetTabPreview_ResponseParams_Data>;

  PageHandler_GetTabPreview_ResponseParams_Data();
  ~PageHandler_GetTabPreview_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetTabPreview_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetTabPreview_ResponseParams_Data)");
class  PageHandler_NotifySessionStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_NotifySessionStarted_Params_Data>;

  PageHandler_NotifySessionStarted_Params_Data();
  ~PageHandler_NotifySessionStarted_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_NotifySessionStarted_Params_Data) == 8,
              "Bad sizeof(PageHandler_NotifySessionStarted_Params_Data)");
class  PageHandler_NotifySessionAbandoned_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_NotifySessionAbandoned_Params_Data>;

  PageHandler_NotifySessionAbandoned_Params_Data();
  ~PageHandler_NotifySessionAbandoned_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_NotifySessionAbandoned_Params_Data) == 8,
              "Bad sizeof(PageHandler_NotifySessionAbandoned_Params_Data)");
class  PageHandler_AddFileContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::SelectedFileInfo_Data> file_info;
  ::mojo_base::mojom::internal::BigBuffer_Data file_bytes;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddFileContext_Params_Data>;

  PageHandler_AddFileContext_Params_Data();
  ~PageHandler_AddFileContext_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_AddFileContext_Params_Data) == 32,
              "Bad sizeof(PageHandler_AddFileContext_Params_Data)");
class  PageHandler_AddFileContext_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> token;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddFileContext_ResponseParams_Data>;

  PageHandler_AddFileContext_ResponseParams_Data();
  ~PageHandler_AddFileContext_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_AddFileContext_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_AddFileContext_ResponseParams_Data)");
class  PageHandler_AddTabContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t tab_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddTabContext_Params_Data>;

  PageHandler_AddTabContext_Params_Data();
  ~PageHandler_AddTabContext_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_AddTabContext_Params_Data) == 16,
              "Bad sizeof(PageHandler_AddTabContext_Params_Data)");
class  PageHandler_AddTabContext_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> token;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_AddTabContext_ResponseParams_Data>;

  PageHandler_AddTabContext_ResponseParams_Data();
  ~PageHandler_AddTabContext_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_AddTabContext_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_AddTabContext_ResponseParams_Data)");
class  PageHandler_DeleteContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> token;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DeleteContext_Params_Data>;

  PageHandler_DeleteContext_Params_Data();
  ~PageHandler_DeleteContext_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_DeleteContext_Params_Data) == 16,
              "Bad sizeof(PageHandler_DeleteContext_Params_Data)");
class  PageHandler_ClearFiles_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ClearFiles_Params_Data>;

  PageHandler_ClearFiles_Params_Data();
  ~PageHandler_ClearFiles_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ClearFiles_Params_Data) == 8,
              "Bad sizeof(PageHandler_ClearFiles_Params_Data)");
class  PageHandler_SubmitQuery_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> query_text;
  uint8_t mouse_button;
  uint8_t alt_key : 1;
  uint8_t ctrl_key : 1;
  uint8_t meta_key : 1;
  uint8_t shift_key : 1;
  uint8_t padfinal_[6];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SubmitQuery_Params_Data>;

  PageHandler_SubmitQuery_Params_Data();
  ~PageHandler_SubmitQuery_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SubmitQuery_Params_Data) == 24,
              "Bad sizeof(PageHandler_SubmitQuery_Params_Data)");
class  Page_AutocompleteResultChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::AutocompleteResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<Page_AutocompleteResultChanged_Params_Data>;

  Page_AutocompleteResultChanged_Params_Data();
  ~Page_AutocompleteResultChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_AutocompleteResultChanged_Params_Data) == 16,
              "Bad sizeof(Page_AutocompleteResultChanged_Params_Data)");
class  Page_UpdateSelection_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OmniboxPopupSelection_Data> old_selection;
  mojo::internal::Pointer<internal::OmniboxPopupSelection_Data> selection;

 private:
  friend class mojo::internal::MessageFragment<Page_UpdateSelection_Params_Data>;

  Page_UpdateSelection_Params_Data();
  ~Page_UpdateSelection_Params_Data() = delete;
};
static_assert(sizeof(Page_UpdateSelection_Params_Data) == 24,
              "Bad sizeof(Page_UpdateSelection_Params_Data)");
class  Page_SetInputText_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> input;

 private:
  friend class mojo::internal::MessageFragment<Page_SetInputText_Params_Data>;

  Page_SetInputText_Params_Data();
  ~Page_SetInputText_Params_Data() = delete;
};
static_assert(sizeof(Page_SetInputText_Params_Data) == 16,
              "Bad sizeof(Page_SetInputText_Params_Data)");
class  Page_SetThumbnail_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> thumbnail_url;
  uint8_t is_deletable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Page_SetThumbnail_Params_Data>;

  Page_SetThumbnail_Params_Data();
  ~Page_SetThumbnail_Params_Data() = delete;
};
static_assert(sizeof(Page_SetThumbnail_Params_Data) == 24,
              "Bad sizeof(Page_SetThumbnail_Params_Data)");
class  Page_OnContextualInputStatusChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> token;
  int32_t status;
  uint8_t error_type_$flag : 1;
  uint8_t pad2_[3];
  int32_t error_type_$value;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Page_OnContextualInputStatusChanged_Params_Data>;

  Page_OnContextualInputStatusChanged_Params_Data();
  ~Page_OnContextualInputStatusChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_OnContextualInputStatusChanged_Params_Data) == 32,
              "Bad sizeof(Page_OnContextualInputStatusChanged_Params_Data)");
class  Page_OnTabStripChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Page_OnTabStripChanged_Params_Data>;

  Page_OnTabStripChanged_Params_Data();
  ~Page_OnTabStripChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_OnTabStripChanged_Params_Data) == 8,
              "Bad sizeof(Page_OnTabStripChanged_Params_Data)");

}  // namespace internal


class PageHandler_SetPage_ParamsDataView {
 public:
  PageHandler_SetPage_ParamsDataView() = default;

  PageHandler_SetPage_ParamsDataView(
      internal::PageHandler_SetPage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::searchbox::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandler_SetPage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_OnFocusChanged_ParamsDataView {
 public:
  PageHandler_OnFocusChanged_ParamsDataView() = default;

  PageHandler_OnFocusChanged_ParamsDataView(
      internal::PageHandler_OnFocusChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool focused() const {
    return data_->focused;
  }
 private:
  internal::PageHandler_OnFocusChanged_Params_Data* data_ = nullptr;
};


class PageHandler_QueryAutocomplete_ParamsDataView {
 public:
  PageHandler_QueryAutocomplete_ParamsDataView() = default;

  PageHandler_QueryAutocomplete_ParamsDataView(
      internal::PageHandler_QueryAutocomplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool prevent_inline_autocomplete() const {
    return data_->prevent_inline_autocomplete;
  }
 private:
  internal::PageHandler_QueryAutocomplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_StopAutocomplete_ParamsDataView {
 public:
  PageHandler_StopAutocomplete_ParamsDataView() = default;

  PageHandler_StopAutocomplete_ParamsDataView(
      internal::PageHandler_StopAutocomplete_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool clear_result() const {
    return data_->clear_result;
  }
 private:
  internal::PageHandler_StopAutocomplete_Params_Data* data_ = nullptr;
};


class PageHandler_OpenAutocompleteMatch_ParamsDataView {
 public:
  PageHandler_OpenAutocompleteMatch_ParamsDataView() = default;

  PageHandler_OpenAutocompleteMatch_ParamsDataView(
      internal::PageHandler_OpenAutocompleteMatch_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool are_matches_showing() const {
    return data_->are_matches_showing;
  }
  uint8_t mouse_button() const {
    return data_->mouse_button;
  }
  bool alt_key() const {
    return data_->alt_key;
  }
  bool ctrl_key() const {
    return data_->ctrl_key;
  }
  bool meta_key() const {
    return data_->meta_key;
  }
  bool shift_key() const {
    return data_->shift_key;
  }
 private:
  internal::PageHandler_OpenAutocompleteMatch_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_OnNavigationLikely_ParamsDataView {
 public:
  PageHandler_OnNavigationLikely_ParamsDataView() = default;

  PageHandler_OnNavigationLikely_ParamsDataView(
      internal::PageHandler_OnNavigationLikely_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationPredictor(UserType* output) const {
    auto data_value = data_->navigation_predictor;
    return mojo::internal::Deserialize<::omnibox::mojom::NavigationPredictor>(
        data_value, output);
  }
  ::omnibox::mojom::NavigationPredictor navigation_predictor() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::omnibox::mojom::NavigationPredictor>(data_->navigation_predictor));
  }
 private:
  internal::PageHandler_OnNavigationLikely_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_DeleteAutocompleteMatch_ParamsDataView {
 public:
  PageHandler_DeleteAutocompleteMatch_ParamsDataView() = default;

  PageHandler_DeleteAutocompleteMatch_ParamsDataView(
      internal::PageHandler_DeleteAutocompleteMatch_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_DeleteAutocompleteMatch_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ActivateKeyword_ParamsDataView {
 public:
  PageHandler_ActivateKeyword_ParamsDataView() = default;

  PageHandler_ActivateKeyword_ParamsDataView(
      internal::PageHandler_ActivateKeyword_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMatchSelectionTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchSelectionTimestamp(UserType* output) {
    
    auto* pointer = data_->match_selection_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool is_mouse_event() const {
    return data_->is_mouse_event;
  }
 private:
  internal::PageHandler_ActivateKeyword_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ExecuteAction_ParamsDataView {
 public:
  PageHandler_ExecuteAction_ParamsDataView() = default;

  PageHandler_ExecuteAction_ParamsDataView(
      internal::PageHandler_ExecuteAction_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  uint8_t action_index() const {
    return data_->action_index;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMatchSelectionTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchSelectionTimestamp(UserType* output) {
    
    auto* pointer = data_->match_selection_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  uint8_t mouse_button() const {
    return data_->mouse_button;
  }
  bool alt_key() const {
    return data_->alt_key;
  }
  bool ctrl_key() const {
    return data_->ctrl_key;
  }
  bool meta_key() const {
    return data_->meta_key;
  }
  bool shift_key() const {
    return data_->shift_key;
  }
 private:
  internal::PageHandler_ExecuteAction_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_OnThumbnailRemoved_ParamsDataView {
 public:
  PageHandler_OnThumbnailRemoved_ParamsDataView() = default;

  PageHandler_OnThumbnailRemoved_ParamsDataView(
      internal::PageHandler_OnThumbnailRemoved_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_OnThumbnailRemoved_Params_Data* data_ = nullptr;
};


class PageHandler_GetPlaceholderConfig_ParamsDataView {
 public:
  PageHandler_GetPlaceholderConfig_ParamsDataView() = default;

  PageHandler_GetPlaceholderConfig_ParamsDataView(
      internal::PageHandler_GetPlaceholderConfig_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetPlaceholderConfig_Params_Data* data_ = nullptr;
};


class PageHandler_GetPlaceholderConfig_ResponseParamsDataView {
 public:
  PageHandler_GetPlaceholderConfig_ResponseParamsDataView() = default;

  PageHandler_GetPlaceholderConfig_ResponseParamsDataView(
      internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      PlaceholderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::PlaceholderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetPlaceholderConfig_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetRecentTabs_ParamsDataView {
 public:
  PageHandler_GetRecentTabs_ParamsDataView() = default;

  PageHandler_GetRecentTabs_ParamsDataView(
      internal::PageHandler_GetRecentTabs_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetRecentTabs_Params_Data* data_ = nullptr;
};


class PageHandler_GetRecentTabs_ResponseParamsDataView {
 public:
  PageHandler_GetRecentTabs_ResponseParamsDataView() = default;

  PageHandler_GetRecentTabs_ResponseParamsDataView(
      internal::PageHandler_GetRecentTabs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabsDataView(
      mojo::ArrayDataView<TabInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::searchbox::mojom::TabInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetRecentTabs_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetTabPreview_ParamsDataView {
 public:
  PageHandler_GetTabPreview_ParamsDataView() = default;

  PageHandler_GetTabPreview_ParamsDataView(
      internal::PageHandler_GetTabPreview_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
 private:
  internal::PageHandler_GetTabPreview_Params_Data* data_ = nullptr;
};


class PageHandler_GetTabPreview_ResponseParamsDataView {
 public:
  PageHandler_GetTabPreview_ResponseParamsDataView() = default;

  PageHandler_GetTabPreview_ResponseParamsDataView(
      internal::PageHandler_GetTabPreview_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPreviewDataUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviewDataUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `preview_data_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviewDataUrl` instead "
    "of `ReadPreviewDataUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->preview_data_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetTabPreview_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_NotifySessionStarted_ParamsDataView {
 public:
  PageHandler_NotifySessionStarted_ParamsDataView() = default;

  PageHandler_NotifySessionStarted_ParamsDataView(
      internal::PageHandler_NotifySessionStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_NotifySessionStarted_Params_Data* data_ = nullptr;
};


class PageHandler_NotifySessionAbandoned_ParamsDataView {
 public:
  PageHandler_NotifySessionAbandoned_ParamsDataView() = default;

  PageHandler_NotifySessionAbandoned_ParamsDataView(
      internal::PageHandler_NotifySessionAbandoned_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_NotifySessionAbandoned_Params_Data* data_ = nullptr;
};


class PageHandler_AddFileContext_ParamsDataView {
 public:
  PageHandler_AddFileContext_ParamsDataView() = default;

  PageHandler_AddFileContext_ParamsDataView(
      internal::PageHandler_AddFileContext_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileInfoDataView(
      SelectedFileInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileInfo(UserType* output) {
    
    auto* pointer = data_->file_info.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::SelectedFileInfoDataView>(
        pointer, output, message_);
  }
  inline void GetFileBytesDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileBytes(UserType* output) {
    
    auto* pointer = !data_->file_bytes.is_null() ? &data_->file_bytes : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_AddFileContext_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_AddFileContext_ResponseParamsDataView {
 public:
  PageHandler_AddFileContext_ResponseParamsDataView() = default;

  PageHandler_AddFileContext_ResponseParamsDataView(
      internal::PageHandler_AddFileContext_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_AddFileContext_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_AddTabContext_ParamsDataView {
 public:
  PageHandler_AddTabContext_ParamsDataView() = default;

  PageHandler_AddTabContext_ParamsDataView(
      internal::PageHandler_AddTabContext_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
 private:
  internal::PageHandler_AddTabContext_Params_Data* data_ = nullptr;
};


class PageHandler_AddTabContext_ResponseParamsDataView {
 public:
  PageHandler_AddTabContext_ResponseParamsDataView() = default;

  PageHandler_AddTabContext_ResponseParamsDataView(
      internal::PageHandler_AddTabContext_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadToken` instead "
    "of `ReadToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_AddTabContext_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_DeleteContext_ParamsDataView {
 public:
  PageHandler_DeleteContext_ParamsDataView() = default;

  PageHandler_DeleteContext_ParamsDataView(
      internal::PageHandler_DeleteContext_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_DeleteContext_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ClearFiles_ParamsDataView {
 public:
  PageHandler_ClearFiles_ParamsDataView() = default;

  PageHandler_ClearFiles_ParamsDataView(
      internal::PageHandler_ClearFiles_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ClearFiles_Params_Data* data_ = nullptr;
};


class PageHandler_SubmitQuery_ParamsDataView {
 public:
  PageHandler_SubmitQuery_ParamsDataView() = default;

  PageHandler_SubmitQuery_ParamsDataView(
      internal::PageHandler_SubmitQuery_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQueryText(UserType* output) {
    
    auto* pointer = data_->query_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint8_t mouse_button() const {
    return data_->mouse_button;
  }
  bool alt_key() const {
    return data_->alt_key;
  }
  bool ctrl_key() const {
    return data_->ctrl_key;
  }
  bool meta_key() const {
    return data_->meta_key;
  }
  bool shift_key() const {
    return data_->shift_key;
  }
 private:
  internal::PageHandler_SubmitQuery_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_AutocompleteResultChanged_ParamsDataView {
 public:
  Page_AutocompleteResultChanged_ParamsDataView() = default;

  Page_AutocompleteResultChanged_ParamsDataView(
      internal::Page_AutocompleteResultChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      AutocompleteResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::AutocompleteResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_AutocompleteResultChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_UpdateSelection_ParamsDataView {
 public:
  Page_UpdateSelection_ParamsDataView() = default;

  Page_UpdateSelection_ParamsDataView(
      internal::Page_UpdateSelection_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOldSelectionDataView(
      OmniboxPopupSelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOldSelection(UserType* output) {
    
    auto* pointer = data_->old_selection.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::OmniboxPopupSelectionDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionDataView(
      OmniboxPopupSelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::OmniboxPopupSelectionDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_UpdateSelection_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_SetInputText_ParamsDataView {
 public:
  Page_SetInputText_ParamsDataView() = default;

  Page_SetInputText_ParamsDataView(
      internal::Page_SetInputText_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_SetInputText_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_SetThumbnail_ParamsDataView {
 public:
  Page_SetThumbnail_ParamsDataView() = default;

  Page_SetThumbnail_ParamsDataView(
      internal::Page_SetThumbnail_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetThumbnailUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThumbnailUrl(UserType* output) {
    
    auto* pointer = data_->thumbnail_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_deletable() const {
    return data_->is_deletable;
  }
 private:
  internal::Page_SetThumbnail_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_OnContextualInputStatusChanged_ParamsDataView {
 public:
  Page_OnContextualInputStatusChanged_ParamsDataView() = default;

  Page_OnContextualInputStatusChanged_ParamsDataView(
      internal::Page_OnContextualInputStatusChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::composebox_query::mojom::FileUploadStatus>(
        data_value, output);
  }
  ::composebox_query::mojom::FileUploadStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::composebox_query::mojom::FileUploadStatus>(data_->status));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorType(UserType* output) const {
    if (!data_->error_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::composebox_query::mojom::FileUploadErrorType>(
        data_->error_type_$value, &output->emplace());
  }
  std::optional<::composebox_query::mojom::FileUploadErrorType> error_type() const {
    if (!data_->error_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::composebox_query::mojom::FileUploadErrorType>(data_->error_type_$value));
  }
 private:
  internal::Page_OnContextualInputStatusChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_OnTabStripChanged_ParamsDataView {
 public:
  Page_OnTabStripChanged_ParamsDataView() = default;

  Page_OnTabStripChanged_ParamsDataView(
      internal::Page_OnTabStripChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Page_OnTabStripChanged_Params_Data* data_ = nullptr;
};





inline void PageHandler_QueryAutocomplete_ParamsDataView::GetInputDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->input.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}




inline void PageHandler_OpenAutocompleteMatch_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PageHandler_OnNavigationLikely_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PageHandler_DeleteAutocompleteMatch_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PageHandler_ActivateKeyword_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PageHandler_ActivateKeyword_ParamsDataView::GetMatchSelectionTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->match_selection_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void PageHandler_ExecuteAction_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PageHandler_ExecuteAction_ParamsDataView::GetMatchSelectionTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->match_selection_timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}






inline void PageHandler_GetPlaceholderConfig_ResponseParamsDataView::GetConfigDataView(
    PlaceholderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = PlaceholderConfigDataView(pointer, message_);
}




inline void PageHandler_GetRecentTabs_ResponseParamsDataView::GetTabsDataView(
    mojo::ArrayDataView<TabInfoDataView>* output) {
  auto pointer = data_->tabs.Get();
  *output = mojo::ArrayDataView<TabInfoDataView>(pointer, message_);
}




inline void PageHandler_GetTabPreview_ResponseParamsDataView::GetPreviewDataUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->preview_data_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void PageHandler_AddFileContext_ParamsDataView::GetFileInfoDataView(
    SelectedFileInfoDataView* output) {
  auto pointer = data_->file_info.Get();
  *output = SelectedFileInfoDataView(pointer, message_);
}
inline void PageHandler_AddFileContext_ParamsDataView::GetFileBytesDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->file_bytes;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void PageHandler_AddFileContext_ResponseParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




inline void PageHandler_AddTabContext_ResponseParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void PageHandler_DeleteContext_ParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




inline void PageHandler_SubmitQuery_ParamsDataView::GetQueryTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Page_AutocompleteResultChanged_ParamsDataView::GetResultDataView(
    AutocompleteResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = AutocompleteResultDataView(pointer, message_);
}


inline void Page_UpdateSelection_ParamsDataView::GetOldSelectionDataView(
    OmniboxPopupSelectionDataView* output) {
  auto pointer = data_->old_selection.Get();
  *output = OmniboxPopupSelectionDataView(pointer, message_);
}
inline void Page_UpdateSelection_ParamsDataView::GetSelectionDataView(
    OmniboxPopupSelectionDataView* output) {
  auto pointer = data_->selection.Get();
  *output = OmniboxPopupSelectionDataView(pointer, message_);
}


inline void Page_SetInputText_ParamsDataView::GetInputDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->input.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Page_SetThumbnail_ParamsDataView::GetThumbnailUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->thumbnail_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Page_OnContextualInputStatusChanged_ParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}





}  // searchbox::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_PARAMS_DATA_H_