// components/omnibox/browser/searchbox.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_DATA_VIEW_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/omnibox/browser/searchbox.mojom-shared-internal.h"
#include "components/omnibox/browser/omnibox.mojom-shared.h"
#include "components/omnibox/composebox/composebox_query.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace searchbox::mojom {
class ACMatchClassificationDataView;

class ActionDataView;

class SuggestionAnswerDataView;

class AutocompleteMatchDataView;

class TabInfoDataView;

class SelectedFileInfoDataView;

class SuggestionGroupDataView;

class AutocompleteResultDataView;

class OmniboxPopupSelectionDataView;

class PlaceholderConfigDataView;



}  // searchbox::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::searchbox::mojom::ACMatchClassificationDataView> {
  using Data = ::searchbox::mojom::internal::ACMatchClassification_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::ActionDataView> {
  using Data = ::searchbox::mojom::internal::Action_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::SuggestionAnswerDataView> {
  using Data = ::searchbox::mojom::internal::SuggestionAnswer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::AutocompleteMatchDataView> {
  using Data = ::searchbox::mojom::internal::AutocompleteMatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::TabInfoDataView> {
  using Data = ::searchbox::mojom::internal::TabInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::SelectedFileInfoDataView> {
  using Data = ::searchbox::mojom::internal::SelectedFileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::SuggestionGroupDataView> {
  using Data = ::searchbox::mojom::internal::SuggestionGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::AutocompleteResultDataView> {
  using Data = ::searchbox::mojom::internal::AutocompleteResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::OmniboxPopupSelectionDataView> {
  using Data = ::searchbox::mojom::internal::OmniboxPopupSelection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::searchbox::mojom::PlaceholderConfigDataView> {
  using Data = ::searchbox::mojom::internal::PlaceholderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace searchbox::mojom {


enum class SideType : int32_t {
  
  kDefaultPrimary = 0,
  
  kSecondary = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SideType value);
inline bool IsKnownEnumValue(SideType value) {
  return internal::SideType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RenderType : int32_t {
  
  kDefaultVertical = 0,
  
  kHorizontal = 1,
  
  kGrid = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RenderType value);
inline bool IsKnownEnumValue(RenderType value) {
  return internal::RenderType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SelectionLineState : int32_t {
  
  kNormal = 1,
  
  kKeywordMode = 2,
  
  kFocusedButtonAction = 3,
  
  kFocusedButtonRemoveSuggestion = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, SelectionLineState value);
inline bool IsKnownEnumValue(SelectionLineState value) {
  return internal::SelectionLineState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ACMatchClassificationDataView {
 public:
  ACMatchClassificationDataView() = default;

  ACMatchClassificationDataView(
      internal::ACMatchClassification_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t offset() const {
    return data_->offset;
  }
  int32_t style() const {
    return data_->style;
  }
 private:
  internal::ACMatchClassification_Data* data_ = nullptr;
};


class ActionDataView {
 public:
  ActionDataView() = default;

  ActionDataView(
      internal::Action_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHint(UserType* output) {
    
    auto* pointer = data_->hint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSuggestionContentsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestionContents(UserType* output) {
    
    auto* pointer = data_->suggestion_contents.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconPath(UserType* output) {
    
    auto* pointer = data_->icon_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetA11yLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadA11yLabel(UserType* output) {
    
    auto* pointer = data_->a11y_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Action_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SuggestionAnswerDataView {
 public:
  SuggestionAnswerDataView() = default;

  SuggestionAnswerDataView(
      internal::SuggestionAnswer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFirstLineDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstLine(UserType* output) {
    
    auto* pointer = data_->first_line.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSecondLineDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecondLine(UserType* output) {
    
    auto* pointer = data_->second_line.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SuggestionAnswer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteMatchDataView {
 public:
  AutocompleteMatchDataView() = default;

  AutocompleteMatchDataView(
      internal::AutocompleteMatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetA11yLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadA11yLabel(UserType* output) {
    
    auto* pointer = data_->a11y_label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool allowed_to_be_default_match() const {
    return data_->allowed_to_be_default_match;
  }
  inline void GetActionsDataView(
      mojo::ArrayDataView<ActionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActions(UserType* output) {
    
    auto* pointer = data_->actions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::searchbox::mojom::ActionDataView>>(
        pointer, output, message_);
  }
  inline void GetAnswerDataView(
      SuggestionAnswerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::searchbox::mojom::SuggestionAnswerDataView, UserType>(),
    "Attempting to read the optional `answer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnswer` instead "
    "of `ReadAnswer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->answer.Get();
    return mojo::internal::Deserialize<::searchbox::mojom::SuggestionAnswerDataView>(
        pointer, output, message_);
  }
  inline void GetContentsDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContents(UserType* output) {
    
    auto* pointer = data_->contents.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetContentsClassDataView(
      mojo::ArrayDataView<ACMatchClassificationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentsClass(UserType* output) {
    
    auto* pointer = data_->contents_class.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::searchbox::mojom::ACMatchClassificationDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionClassDataView(
      mojo::ArrayDataView<ACMatchClassificationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionClass(UserType* output) {
    
    auto* pointer = data_->description_class.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::searchbox::mojom::ACMatchClassificationDataView>>(
        pointer, output, message_);
  }
  inline void GetDestinationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinationUrl(UserType* output) {
    
    auto* pointer = data_->destination_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInlineAutocompletionDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInlineAutocompletion(UserType* output) {
    
    auto* pointer = data_->inline_autocompletion.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFillIntoEditDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFillIntoEdit(UserType* output) {
    
    auto* pointer = data_->fill_into_edit.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  std::optional<bool> is_weather_answer_suggestion() const {

    return data_->is_weather_answer_suggestion_$flag
        ? std::make_optional(!!data_->is_weather_answer_suggestion_$value)
        : std::nullopt;
  }
  inline void GetIconPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconPath(UserType* output) {
    
    auto* pointer = data_->icon_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetImageDominantColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageDominantColor(UserType* output) {
    
    auto* pointer = data_->image_dominant_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImageUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_noncanned_aim_suggestion() const {
    return data_->is_noncanned_aim_suggestion;
  }
  bool is_rich_suggestion() const {
    return data_->is_rich_suggestion;
  }
  bool is_search_type() const {
    return data_->is_search_type;
  }
  bool is_enterprise_search_aggregator_people_type() const {
    return data_->is_enterprise_search_aggregator_people_type;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRemoveButtonA11yLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoveButtonA11yLabel(UserType* output) {
    
    auto* pointer = data_->remove_button_a11y_label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool swap_contents_and_description() const {
    return data_->swap_contents_and_description;
  }
  int32_t suggestion_group_id() const {
    return data_->suggestion_group_id;
  }
  bool supports_deletion() const {
    return data_->supports_deletion;
  }
  inline void GetTailSuggestCommonPrefixDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTailSuggestCommonPrefix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `tail_suggest_common_prefix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTailSuggestCommonPrefix` instead "
    "of `ReadTailSuggestCommonPrefix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tail_suggest_common_prefix.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool has_instant_keyword() const {
    return data_->has_instant_keyword;
  }
  inline void GetKeywordChipHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeywordChipHint(UserType* output) {
    
    auto* pointer = data_->keyword_chip_hint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeywordChipA11yDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeywordChipA11y(UserType* output) {
    
    auto* pointer = data_->keyword_chip_a11y.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteMatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabInfoDataView {
 public:
  TabInfoDataView() = default;

  TabInfoDataView(
      internal::TabInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActive(UserType* output) {
    
    auto* pointer = data_->last_active.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectedFileInfoDataView {
 public:
  SelectedFileInfoDataView() = default;

  SelectedFileInfoDataView(
      internal::SelectedFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileName(UserType* output) {
    
    auto* pointer = data_->file_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionTimeDataView(
      ::mojo_base::mojom::JSTimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionTime(UserType* output) {
    
    auto* pointer = data_->selection_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::JSTimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectedFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SuggestionGroupDataView {
 public:
  SuggestionGroupDataView() = default;

  SuggestionGroupDataView(
      internal::SuggestionGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRenderType(UserType* output) const {
    auto data_value = data_->render_type;
    return mojo::internal::Deserialize<::searchbox::mojom::RenderType>(
        data_value, output);
  }
  RenderType render_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::searchbox::mojom::RenderType>(data_->render_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSideType(UserType* output) const {
    auto data_value = data_->side_type;
    return mojo::internal::Deserialize<::searchbox::mojom::SideType>(
        data_value, output);
  }
  SideType side_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::searchbox::mojom::SideType>(data_->side_type));
  }
 private:
  internal::SuggestionGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteResultDataView {
 public:
  AutocompleteResultDataView() = default;

  AutocompleteResultDataView(
      internal::AutocompleteResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSuggestionGroupsMapDataView(
      mojo::MapDataView<int32_t, SuggestionGroupDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestionGroupsMap(UserType* output) {
    
    auto* pointer = data_->suggestion_groups_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, ::searchbox::mojom::SuggestionGroupDataView>>(
        pointer, output, message_);
  }
  inline void GetMatchesDataView(
      mojo::ArrayDataView<AutocompleteMatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatches(UserType* output) {
    
    auto* pointer = data_->matches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::searchbox::mojom::AutocompleteMatchDataView>>(
        pointer, output, message_);
  }
  inline void GetSmartComposeInlineHintDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSmartComposeInlineHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `smart_compose_inline_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSmartComposeInlineHint` instead "
    "of `ReadSmartComposeInlineHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->smart_compose_inline_hint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OmniboxPopupSelectionDataView {
 public:
  OmniboxPopupSelectionDataView() = default;

  OmniboxPopupSelectionDataView(
      internal::OmniboxPopupSelection_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t line() const {
    return data_->line;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::searchbox::mojom::SelectionLineState>(
        data_value, output);
  }
  SelectionLineState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::searchbox::mojom::SelectionLineState>(data_->state));
  }
  uint8_t action_index() const {
    return data_->action_index;
  }
 private:
  internal::OmniboxPopupSelection_Data* data_ = nullptr;
};


class PlaceholderConfigDataView {
 public:
  PlaceholderConfigDataView() = default;

  PlaceholderConfigDataView(
      internal::PlaceholderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTexts(UserType* output) {
    
    auto* pointer = data_->texts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetChangeTextAnimationIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChangeTextAnimationInterval(UserType* output) {
    
    auto* pointer = data_->change_text_animation_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFadeTextAnimationDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFadeTextAnimationDuration(UserType* output) {
    
    auto* pointer = data_->fade_text_animation_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::PlaceholderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // searchbox::mojom

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_DATA_VIEW_H_